/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.codec;

import com.archimed.codec.a.b;
import com.archimed.codec.jpeg.Jpeg14Decoder;
import com.archimed.codec.jpeg.Jpeg14Encoder;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.log.JdtLogger;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Compression {
    DicomObject dcm;
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(Compression.class);
    private static final String int = "MONOCHROME1";
    private static final String for = "MONOCHROME2";
    private static final String if = "RGB";
    private static final int do = 0;
    private static final int a = 1;

    public Compression() {
        this.dcm = null;
    }

    public Compression(DicomObject dicomObject) throws DicomException {
        this.setDicomObject(dicomObject);
    }

    public void decompress() throws DicomException, IOException {
        int n;
        Object object;
        if (this.dcm == null) {
            throw new DicomException("Use setDicomObject first to specify a DicomObject");
        }
        try {
            object = this.dcm.getFileMetaInformation();
            if (object == null) {
                throw new DicomException("no file meta information");
            }
            n = UID.getUIDEntry((String)object.getS(31)).getConstant();
        }
        catch (UnknownUIDException unknownUIDException) {
            throw new DicomException("Decompression not possible: " + unknownUIDException.getMessage());
        }
        catch (Exception exception) {
            throw new DicomException("Decompression not possible: no transfersyntax found");
        }
        int n2 = this.dcm.getI(467);
        int n3 = this.dcm.getI(466);
        int n4 = this.dcm.getSize(1184) - 1;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.dcm.deleteItem(1184, 0);
        for (int i = 0; i < n4; ++i) {
            object = Compression.decompressFrame(n, (byte[])this.dcm.deleteItem(1184, 0), n2, n3);
            byteArrayOutputStream.write((byte[])object);
        }
        this.dcm.set(1184, (Object)byteArrayOutputStream.toByteArray());
        try {
            this.dcm.getFileMetaInformation().set(31, (Object)UID.getUIDEntry((int)8194).getValue());
        }
        catch (IllegalValueException illegalValueException) {
            // empty catch block
        }
    }

    public static byte[] decompressFrame(int n, byte[] byArray, int n2, int n3) throws DicomException, IOException {
        if (n == 8197) {
            Jpeg14Decoder jpeg14Decoder = new Jpeg14Decoder();
            byte[] byArray2 = jpeg14Decoder.decode(byArray);
            return byArray2;
        }
        if (n == 8198) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            b b2 = new b();
            b2.a(n2, n3);
            return b2.a((InputStream)byteArrayInputStream);
        }
        if (n == 8196) {
            Image image = Toolkit.getDefaultToolkit().createImage(byArray);
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n2, n3, false);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                Jdt.getJdtLoggerFactory().getJdtLogger(Compression.class).error((Object)"", (Throwable)interruptedException);
            }
            try {
                return (byte[])pixelGrabber.getPixels();
            }
            catch (ClassCastException classCastException) {
                return Compression.a((int[])pixelGrabber.getPixels());
            }
        }
        throw new DicomException("unsupported transfer syntax for decompression");
    }

    private static byte[] a(int[] nArray) {
        byte[] byArray = new byte[nArray.length * 3];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[3 * i] = (byte)((nArray[i] & 0xFF0000) >> 16);
            byArray[3 * i + 1] = (byte)((nArray[i] & 0xFF00) >> 8);
            byArray[3 * i + 2] = (byte)(nArray[i] & 0xFF);
        }
        return byArray;
    }

    public void compress(int n) throws IOException, DicomException {
        Integer n2;
        int n3;
        Object object;
        if (this.dcm == null) {
            throw new DicomException("Use setDicomObject first to specify a DicomObject");
        }
        if (n != 8197) {
            throw new DicomException("unsupported transfer syntax for compression");
        }
        try {
            object = this.dcm.getFileMetaInformation();
            n3 = object == null ? 8193 : (object.getSize(31) > 0 ? UID.getUIDEntry((String)object.getS(31)).getConstant() : 8193);
        }
        catch (UnknownUIDException unknownUIDException) {
            throw new DicomException("Decompression not possible: " + unknownUIDException.getMessage());
        }
        if (n3 != 8195 && n3 != 8194 && n3 != 8193) {
            throw new DicomException("associated DicomObject already has a compressed transfer syntax");
        }
        int n4 = this.dcm.getI(467);
        int n5 = this.dcm.getI(466);
        int n6 = 1;
        if (this.dcm.getSize(464) > 0) {
            n6 = this.dcm.getI(464);
        }
        byte[] byArray = (byte[])this.dcm.get(1184);
        int n7 = this.dcm.getI(475);
        String string = (String)this.dcm.get(462);
        if (string == null) {
            throw new DicomException("photometric interpretation tag missing");
        }
        if (!((string = string.trim()).equals(int) || string.equals(for) || string.equals(if))) {
            throw new DicomException("unsupported photometric interpretation: " + string);
        }
        int n8 = 0;
        if (string.equals(if)) {
            n2 = (Integer)this.dcm.get(463);
            if (n2 == null) {
                throw new DicomException("planar configuration tag missing for RGB image");
            }
            n8 = n2;
            if (n8 < 0 || n8 > 1) {
                throw new DicomException("illegal planar configuration tag: " + n8);
            }
            this.dcm.set(463, (Object)new Integer(0));
        }
        this.dcm.deleteItem(1184, 0);
        this.dcm.set(1184, (Object)new byte[0], 0);
        if (n6 == 1) {
            this.dcm.set(1184, (Object)Compression.a(string, n8, n7, byArray, n4, n5), 1);
        } else {
            if (n7 == 8) {
                object = new byte[n4 * n5];
            } else if (n7 == 16) {
                object = new byte[n4 * n5 * 2];
            } else if (n7 == 24) {
                object = new byte[n4 * n5 * 3];
            } else {
                throw new DicomException("unsupported value for Bits Allocated: " + n7 + " (should be 8,16 or 24)");
            }
            for (int i = 0; i < n6; ++i) {
                System.arraycopy(byArray, i * ((DicomObject)object).length, object, 0, ((DicomObject)object).length);
                this.dcm.append(1184, (Object)Compression.a(string, n8, n7, (byte[])object, n4, n5));
            }
        }
        n2 = this.dcm.getFileMetaInformation();
        try {
            if (n2 != null) {
                n2.set(31, UID.getUIDEntry((int)n).getValue());
            }
        }
        catch (IllegalValueException illegalValueException) {
            this.log.debug((Object)("unexpected error: " + (Object)((Object)illegalValueException)));
        }
    }

    private static byte[] a(String string, int n, int n2, byte[] byArray, int n3, int n4) throws IOException, DicomException {
        Jpeg14Encoder jpeg14Encoder = new Jpeg14Encoder();
        if (string.equals(int) || string.equals(for)) {
            if (n2 == 8) {
                if (byArray.length < n3 * n4) {
                    throw new DicomException("not enough pixeldata < " + n3 * n4);
                }
                return jpeg14Encoder.encode8bitGrayscale(byArray, n3, n4);
            }
            if (n2 == 16) {
                if (byArray.length < n3 * n4 * 2) {
                    throw new DicomException("not enough pixeldata < " + n3 * n4 * 2);
                }
                return jpeg14Encoder.encode16bitGrayscale(byArray, n3, n4);
            }
            throw new DicomException("unsupported bitsAllocated value: " + n2);
        }
        if (string.equals(if)) {
            if (byArray.length < n3 * n4 * 3) {
                throw new DicomException("not enough pixeldata < " + n3 * n4 * 3);
            }
            byte[] byArray2 = new byte[n3 * n4];
            byte[] byArray3 = new byte[n3 * n4];
            byte[] byArray4 = new byte[n3 * n4];
            if (n == 0) {
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray2[i] = byArray[3 * i];
                    byArray3[i] = byArray[3 * i + 1];
                    byArray4[i] = byArray[3 * i + 2];
                }
                return jpeg14Encoder.encode24bitColor(byArray2, byArray3, byArray4, n3, n4);
            }
            if (n == 1) {
                System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                System.arraycopy(byArray, n3 * n4, byArray3, 0, byArray3.length);
                System.arraycopy(byArray, 2 * n3 * n4, byArray4, 0, byArray4.length);
                return jpeg14Encoder.encode24bitColor(byArray2, byArray3, byArray4, n3, n4);
            }
            throw new DicomException("illegal planar configuration");
        }
        throw new DicomException("Unsupported photometric interpretation for encoding to lossless jpeg: " + string);
    }

    public static byte[] compressFrame(int n, byte[] byArray, int n2, int n3) throws IOException, DicomException {
        if (n == 8197) {
            if (byArray.length == n2 * n3) {
                return Compression.a(for, 0, 8, byArray, n2, n3);
            }
            if (byArray.length == n2 * n3 * 2) {
                return Compression.a(for, 0, 16, byArray, n2, n3);
            }
            if (byArray.length == n2 * n3 * 3) {
                return Compression.a(if, 0, 24, byArray, n2, n3);
            }
            throw new DicomException("length of frame to compress is not equal to width*height or width*height*2 or width*height*3");
        }
        throw new DicomException("unsupported transfer syntax for compression");
    }

    public void setDicomObject(DicomObject dicomObject) throws DicomException {
        this.dcm = dicomObject;
    }

    public DicomObject getDicomObject() {
        return this.dcm;
    }
}

