/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer;

import com.ge.med.cse.apps.cdviewer.DataSelector;
import com.ge.med.cse.apps.cdviewer.DataSelectorButton;
import com.ge.med.cse.apps.cdviewer.License;
import com.ge.med.cse.apps.cdviewer.MVDMSystem;
import com.ge.med.cse.apps.cdviewer.MVFusionSeriesDisplayer;
import com.ge.med.cse.apps.cdviewer.MVImageValidator;
import com.ge.med.cse.apps.cdviewer.MediaRemovalDetector;
import com.ge.med.cse.apps.cdviewer.MediaViewerHelpPage;
import com.ge.med.cse.apps.cdviewer.MvWinLinkDirector;
import com.ge.med.cse.apps.cdviewer.OnPortCineSlider;
import com.ge.med.cse.apps.cdviewer.RedirectedStream;
import com.ge.med.cse.apps.cdviewer.ThreadExceptionHandler;
import com.ge.med.cse.cvf.base.CvImageLoader;
import com.ge.med.cse.cvf.base.CvSeriesDisplayer;
import com.ge.med.cse.cvf.base.LinkedCursorDirector;
import com.ge.med.cse.cvf.base.PleaseWaitDialog;
import com.ge.med.cse.cvf.base.XPVApp;
import com.ge.med.cse.cvf.base.XpZoomLinkDirector;
import com.ge.med.cse.cvf.idc.XpLinkPortCapable;
import com.ge.med.cse.cvf.util.CPIUtils;
import com.ge.med.cse.cvf.util.CvImageFusionUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.OnPortCapable;
import com.ge.med.idc.XjImage;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpSeriesDisplayer;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportManager;
import com.ge.med.terra.jami.annotation.XpApdAnnotationGenerator;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.base.XPscreenLayout;
import com.ge.med.terra.xpv.ui.OnPortLayoutManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CDViewerAppMain
extends JPanel
implements Runnable,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    Object imageLoaderLock = new Object();
    XPcontrolArea control = null;
    Properties prop = null;
    Thread imageLoader;
    XPVApp app = null;
    XPscreen screen = null;
    DataSelector ds = null;
    DMObject[] objRef;
    XpViewportManager viewportManager = null;
    String strModality = "";
    int viePortCount = 0;
    MediaViewerHelpPage helpPage = null;
    ResourceBundle bundle = null;
    static Properties props = new Properties();
    HashMap<String, KeyStroke> keyStrokeMap = new HashMap();
    HashMap<String, Action> keyActionMap = new HashMap();
    XPscreenLayout fusionLayout = null;
    MVImageValidator validator = new MVImageValidator();
    LinkedCursorDirector linkCursorDirector = new LinkedCursorDirector();
    MvWinLinkDirector winDirector = new MvWinLinkDirector();
    XpZoomLinkDirector zoomDirector = new XpZoomLinkDirector();
    int inputPolicy = 2;
    PleaseWaitDialog waitDialog = null;
    CvSeriesDisplayer serDisp0 = null;
    CvSeriesDisplayer serDisp1 = null;
    MVFusionSeriesDisplayer fusedImageVp = null;
    static String orig = "";
    static XpFrameVisualizer viz;

    public CDViewerAppMain() {
        String language = System.getProperty("user.language");
        if (language.equalsIgnoreCase("ch") || language.equalsIgnoreCase("zh") || language.equalsIgnoreCase("ja") || language.equalsIgnoreCase("ko")) {
            System.setProperty("ptk.sansserifBold", "SimSun");
        }
        this.init();
        this.jbInit();
        System.out.println(CvUtils.getDMSystem().getSystemName());
        this.setLayout(new BorderLayout());
        this.add((Component)this.control.getSelector(), "North");
        this.control.getSelector().setBorder(BorderFactory.createBevelBorder(0));
        JPanel notForClinicals_Screen = new JPanel(new BorderLayout());
        JLabel notForClinicals = new JLabel("", 0);
        notForClinicals.setOpaque(false);
        notForClinicals.setText(this.bundle.getString("NOT_FOR_CLINICAL_USE"));
        notForClinicals.setName("NotForClinicalUseSafetyString");
        notForClinicals.setForeground(Color.RED);
        notForClinicals.setBackground(UIManager.getColor("P8"));
        notForClinicals.setLayout(new BorderLayout());
        notForClinicals_Screen.add((Component)notForClinicals, "North");
        notForClinicals_Screen.add(this.screen);
        notForClinicals_Screen.add((Component)this.ds, "West");
        this.add(notForClinicals_Screen);
        this.screen.setAnnotationGenerator(XpApdAnnotationGenerator.class, props);
        this.initTestMode();
    }

    public static void verifyLocal() {
        System.err.println("System Default Language :" + Locale.getDefault());
        HashSet<Locale> supported = new HashSet<Locale>(Arrays.asList(new Locale("ch", "ZH"), new Locale("da", "DK"), new Locale("de", "DE"), new Locale("en", "US"), new Locale("es", "ES"), new Locale("fi", "FI"), new Locale("fr", "FR"), new Locale("it", "IT"), new Locale("ja", "JP"), new Locale("nl", "NL"), new Locale("no", "NO"), new Locale("pt", "BR"), new Locale("pt", "PT"), new Locale("sv", "SE"), new Locale("zh", "CN")));
        Locale locale = Locale.getDefault();
        if (!supported.contains(locale)) {
            System.err.println("Local " + locale + " not supported using English");
            Locale.setDefault(new Locale("en", "US"));
        }
        System.err.println("After validating the default Language :" + Locale.getDefault());
    }

    private void initTestMode() {
        if (Boolean.getBoolean("IS_TEST")) {
            this.putClientProperty(XpSeriesDisplayer.class.getName(), this.screen.getSelectedPort());
            this.putClientProperty(DataSelector.class.getName(), this.ds);
            this.putClientProperty(XPscreen.class.getName(), this.screen);
        }
    }

    protected void init() {
        this.imageLoader = new Thread(this);
        this.ds = new DataSelector();
        this.prop = new Properties();
        String propToLoad = "MediaViewer.properties";
        CvPropertiesManager.loadPropertyValues(this.getClass().getResourceAsStream(propToLoad));
        this.helpPage = new MediaViewerHelpPage();
        this.bundle = CvUtils.getResourceBundle();
        this.app = new XPVApp();
        this.app.init();
        this.control = this.app.getControlArea();
        this.screen = this.app.getScreen();
        this.app.configureKeyBoardAction();
        this.serDisp0 = new CvSeriesDisplayer();
        this.serDisp1 = new CvSeriesDisplayer();
        this.fusedImageVp = new MVFusionSeriesDisplayer();
        if (this.screen instanceof OnPortCapable) {
            ((OnPortCapable)((Object)this.screen)).setOnPortLayoutManager(OnPortLayoutManager.class);
            ((OnPortCapable)((Object)this.screen)).addPortControl(OnPortCineSlider.class, "North");
        }
        this.screen.addPort(this.serDisp0, 0);
        this.screen.addPort(this.serDisp1, 1);
        this.screen.addPort(this.fusedImageVp, 2);
        this.screen.setLayout(XPscreenLayout.layout1x1());
    }

    private void jbInit() {
        this.screen.putClientProperty("ImageLoad", "off");
        this.ds.addSelectionChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent e) {
                CDViewerAppMain.this.objRef = (DMObject[])e.getSource();
                if (CDViewerAppMain.this.objRef == null || CDViewerAppMain.this.objRef.length == 0) {
                    return;
                }
                CDViewerAppMain.this.screen.putClientProperty("ImageLoad", "on");
                CDViewerAppMain.this.screen.putClientProperty("ImageLoad", "off");
                JFrame parent = (JFrame)SwingUtilities.getWindowAncestor(CDViewerAppMain.this.screen.getSelectedPort());
                if (parent != null) {
                    CDViewerAppMain.this.waitDialog = new PleaseWaitDialog(parent);
                    CDViewerAppMain.this.waitDialog.setVisible(true);
                }
                Object object = CDViewerAppMain.this.imageLoaderLock;
                synchronized (object) {
                    CDViewerAppMain.this.imageLoaderLock.notifyAll();
                }
            }
        });
        XpLinkPortCapable lnkCap = (XpLinkPortCapable)this.screen.getCapable(XpLinkPortCapable.class.getName());
        if (lnkCap != null) {
            lnkCap.setPortsLinked(true);
        }
        this.screen.addPropertyChangeListener("DataSelector", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                CDViewerAppMain.this.ds.setVisible((Boolean)evt.getNewValue());
            }
        });
        this.screen.addPropertyChangeListener("HelpPage", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                CDViewerAppMain.this.helpPage.setVisible(!CDViewerAppMain.this.helpPage.isVisible());
            }
        });
        this.screen.addPropertyChangeListener("ComponentSelection", this);
        this.screen.addPropertyChangeListener("Cine", this);
        this.screen.addPropertyChangeListener("CONTENT_CHANGED", this);
    }

    public void startViewer() {
        this.imageLoader.setName("CDImageLoader");
        this.imageLoader.start();
        Tap.setProperty("tap.dm.ImageMemory", "200");
        this.ds.loadData();
    }

    public JFrame showViewer() {
        this.control.getSelector().setSelectedApplication("MediaViewer");
        this.control.getSelector().setSelectedItem(DataSelectorButton.class.getName());
        JFrame frame = new JFrame(this.bundle.getString("MEDIA_VIEWER_NOT_FOR_CLINICAL_USE_FRAME_TITLE"));
        frame.getContentPane().add(this);
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setExtendedState(6);
        frame.setVisible(true);
        frame.getRootPane().getLayeredPane().add((Component)new License(), JLayeredPane.MODAL_LAYER);
        frame.getRootPane().getLayeredPane().add((Component)new MediaRemovalDetector(), JLayeredPane.POPUP_LAYER);
        this.helpPage.setLocation(400, 200);
        this.helpPage.setVisible(false);
        frame.getRootPane().getLayeredPane().add((Component)this.helpPage, JLayeredPane.MODAL_LAYER);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CDViewerAppMain.this.startViewer();
            }
        });
        return frame;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("Cine") && !this.screen.getCine()) {
            this.enableDisableControlAsPerSelection();
            return;
        }
        if (evt.getPropertyName().equalsIgnoreCase("ComponentSelection")) {
            if (this.screen.getCine()) {
                return;
            }
            if (!(evt.getSource() instanceof XPscreen)) return;
            XPscreen scrn = (XPscreen)evt.getSource();
            if (!(scrn.getSelectedPort() instanceof CvSeriesDisplayer)) {
                return;
            }
            CvSeriesDisplayer serDisp = (CvSeriesDisplayer)scrn.getSelectedPort();
            if (viz == serDisp.getSelectedPort()) return;
            viz = serDisp.getSelectedPort();
            this.enableDisableControlAsPerSelection();
        }
        if (!evt.getPropertyName().equalsIgnoreCase("CONTENT_CHANGED") && !evt.getPropertyName().equalsIgnoreCase("data_changed")) return;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CDViewerAppMain.this.enableDisableControlAsPerSelection();
            }
        });
    }

    public static void main(String[] args) {
        new CDViewerAppMain().showViewer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            block17: {
                block16: {
                    Object object = this.imageLoaderLock;
                    synchronized (object) {
                        try {
                            this.imageLoaderLock.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (this.validator.isValid(this.objRef)) break block16;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JOptionPane.showMessageDialog(CDViewerAppMain.this.getTopLevelAncestor(), CDViewerAppMain.this.bundle.getString("SE_NOT_SUPPORTED"), CDViewerAppMain.this.bundle.getString("MEDIA_VIEWER_TITLE"), 0);
                        }
                    });
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (CDViewerAppMain.this.waitDialog != null) {
                                CDViewerAppMain.this.waitDialog.dispose();
                                CDViewerAppMain.this.waitDialog = null;
                                if (Boolean.getBoolean("IS_TEST")) {
                                    CDViewerAppMain.this.screen.putClientProperty("ImageLoad", "off");
                                    CDViewerAppMain.this.screen.putClientProperty("ImageLoad", "on");
                                }
                            }
                        }
                    });
                    continue;
                }
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            CDViewerAppMain.this.serDisp0.setReportCursorVisible(true);
                            CDViewerAppMain.this.serDisp0.setReportCursorVisible(false);
                            CDViewerAppMain.this.serDisp1.setReportCursorVisible(true);
                            CDViewerAppMain.this.serDisp1.setReportCursorVisible(false);
                            CDViewerAppMain.this.fusedImageVp.setReportCursorVisible(true);
                            CDViewerAppMain.this.fusedImageVp.setReportCursorVisible(false);
                            CDViewerAppMain.this.winDirector.disconnectAllViewports();
                            CDViewerAppMain.this.zoomDirector.disconnectAllViewports();
                            CDViewerAppMain.this.linkCursorDirector.disconnectAllViewports();
                        }
                    });
                    if (this.objRef.length == 1) {
                        this.switchToSingleSeries();
                        break block17;
                    }
                    if (this.objRef.length != 2) break block17;
                    DMObject dmoCT = null;
                    DMObject dmoPT = null;
                    if (this.objRef[0] == null || this.objRef[1] == null) break block17;
                    String modObj0 = this.objRef[0].getValue(8, 96).toString();
                    String modObj1 = this.objRef[1].getValue(8, 96).toString();
                    if (modObj0.equalsIgnoreCase("CT") && modObj1.equalsIgnoreCase("PT")) {
                        dmoCT = this.objRef[0];
                        dmoPT = this.objRef[1];
                    } else if (modObj0.equalsIgnoreCase("PT") && modObj1.equalsIgnoreCase("CT")) {
                        dmoPT = this.objRef[0];
                        dmoCT = this.objRef[1];
                    }
                    if (dmoCT != null && dmoPT != null && CvImageFusionUtils.isValidFusionCombination(dmoCT, dmoPT)) {
                        DMObject ct = dmoCT;
                        DMObject pet = dmoPT;
                        this.switchToFusionMode(ct, pet);
                        break block17;
                    }
                    this.switchToCompareMode();
                }
                catch (Exception ex) {
                    try {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(this.getTopLevelAncestor(), this.bundle.getObject("ERROR_FAILED_TO_LOAD"), this.bundle.getString("MEDIA_VIEWER_TITLE"), 0);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    continue;
                }
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            continue;
            break;
        }
    }

    void loadImages(final CvSeriesDisplayer seriesDisplayer, DMObject series) {
        if (CPIUtils.isGSPS(series)) {
            DMComposite prObj = series.getRelated("image")[0].getComposites()[0];
            CvImageLoader.getInstance().gspsLoader((XpViewport)seriesDisplayer, prObj);
        } else {
            String modality = series.getValue(8, 96).toString();
            String neededTagsCT = CvPropertiesManager.getProperty("TAGS_TO_LOAD_" + modality);
            DMTag[] tags = neededTagsCT != null ? CvUtils.getNeededTags(modality, "") : null;
            Object[] images = series.getImages(tags);
            CvUtils.sortImages(images);
            SwingUtilities.invokeLater(new Runnable((DMImage[])images){
                final /* synthetic */ DMImage[] val$images;
                {
                    this.val$images = dMImageArray;
                }

                public void run() {
                    seriesDisplayer.setImages(XpMedicalDmImage.wrapDMImages(this.val$images));
                }
            });
        }
    }

    void switchToSingleSeries() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CDViewerAppMain.this.screen.setLayout(XPscreenLayout.layout1x1());
                CDViewerAppMain.this.app.configureKeyBoardAction();
                CDViewerAppMain.this.serDisp0.setRowCol(2, 2);
                CDViewerAppMain.this.serDisp0.setSharedRenderAttributes(false);
            }
        });
        this.loadImages(this.serDisp0, this.objRef[0]);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CDViewerAppMain.this.serDisp1.setImages(new XjImage[0]);
                CDViewerAppMain.this.fusedImageVp.setImages(new XjImage[0]);
                CDViewerAppMain.this.fusedImageVp.removeImageLayer(CDViewerAppMain.this.fusedImageVp.getFusionlayer());
                XpLinkPortCapable lnkCap = (XpLinkPortCapable)CDViewerAppMain.this.screen.getCapable(XpLinkPortCapable.class.getName());
                if (lnkCap != null) {
                    lnkCap.setPortsLinked(false);
                }
            }
        });
    }

    void switchToCompareMode() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CDViewerAppMain.this.screen.setLayout(XPscreenLayout.layout2x1());
                CDViewerAppMain.this.serDisp0.setRowCol(2, 1);
                CDViewerAppMain.this.serDisp1.setRowCol(2, 1);
                CDViewerAppMain.this.serDisp0.setSharedRenderAttributes(false);
                CDViewerAppMain.this.serDisp1.setSharedRenderAttributes(false);
                CDViewerAppMain.this.app.configureKeyBoardAction();
            }
        });
        this.loadImages(this.serDisp0, this.objRef[0]);
        this.loadImages(this.serDisp1, this.objRef[1]);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CDViewerAppMain.this.fusedImageVp.setImages(new XjImage[0]);
                CDViewerAppMain.this.fusedImageVp.removeImageLayer(CDViewerAppMain.this.fusedImageVp.getFusionlayer());
                XpLinkPortCapable lnkCap = (XpLinkPortCapable)CDViewerAppMain.this.screen.getCapable(XpLinkPortCapable.class.getName());
                if (lnkCap != null) {
                    lnkCap.setPortsLinked(true);
                }
            }
        });
    }

    void switchToFusionMode(DMObject dmoCT, DMObject dmoPT) {
        try {
            DMObject[][] ctpet = CvImageFusionUtils.filterOutMatchingSlices(dmoCT.getRelated("image"), dmoPT.getRelated("image"));
            if (ctpet == null) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), this.bundle.getObject("ERROR_MATCHING_SLICE_NOT_FOUND"), this.bundle.getString("MEDIA_VIEWER_TITLE"), 0);
                this.switchToCompareMode();
                return;
            }
            DMObject[] ctDMO = ctpet[0];
            DMObject[] ptDMO = ctpet[1];
            if (this.fusionLayout == null) {
                String layoutString = CvPropertiesManager.getProperty("fusionLayout");
                this.fusionLayout = layoutString != null ? new XPscreenLayout(layoutString) : new XPscreenLayout("[0,0,5000,5000][0,5000,5000,5000][5000,0,5000,10000]");
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CDViewerAppMain.this.screen.setLayout(CDViewerAppMain.this.fusionLayout);
                    CDViewerAppMain.this.serDisp0.setSharedRenderAttributes(true);
                    CDViewerAppMain.this.serDisp1.setSharedRenderAttributes(true);
                    CDViewerAppMain.this.serDisp0.setRowCol(1, 1);
                    CDViewerAppMain.this.serDisp1.setRowCol(1, 1);
                    CDViewerAppMain.this.fusedImageVp.setRowCol(1, 1);
                    XpLinkPortCapable lnkCap = (XpLinkPortCapable)CDViewerAppMain.this.screen.getCapable(XpLinkPortCapable.class.getName());
                    if (lnkCap != null) {
                        lnkCap.setPortsLinked(true);
                    }
                }
            });
            String neededTagsCT = CvPropertiesManager.getProperty("TAGS_TO_LOAD_CT");
            DMTag[] tagsCT = neededTagsCT != null ? CvUtils.getNeededTags("CT", "") : null;
            String neededTagsPT = CvPropertiesManager.getProperty("TAGS_TO_LOAD_PT");
            DMTag[] tagsPT = neededTagsPT != null ? CvUtils.getNeededTags("PT", "") : null;
            final XjImage[] imgListCT = new XjImage[ctDMO.length];
            for (int i = 0; i < imgListCT.length; ++i) {
                imgListCT[i] = ctDMO[i].getImages(tagsCT)[0];
            }
            final XjImage[] imgListPT = new XjImage[ptDMO.length];
            for (int i = 0; i < imgListPT.length; ++i) {
                imgListPT[i] = ptDMO[i].getImages(tagsPT)[0];
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CDViewerAppMain.this.app.configureKeyBoardAction();
                    CDViewerAppMain.this.serDisp0.setImages(imgListCT);
                    CDViewerAppMain.this.serDisp1.setImages(imgListPT);
                    CDViewerAppMain.this.fusedImageVp.setImages(imgListPT);
                    CDViewerAppMain.this.fusedImageVp.addImageLayer(imgListCT);
                    CDViewerAppMain.this.zoomDirector.disconnectAllViewports();
                    CDViewerAppMain.this.zoomDirector.connectViewport(CDViewerAppMain.this.serDisp0);
                    CDViewerAppMain.this.zoomDirector.connectViewport(CDViewerAppMain.this.serDisp1);
                    CDViewerAppMain.this.zoomDirector.connectViewport(CDViewerAppMain.this.fusedImageVp);
                    CDViewerAppMain.this.linkCursorDirector.disconnectAllViewports();
                    CDViewerAppMain.this.linkCursorDirector.connectViewport(CDViewerAppMain.this.serDisp0);
                    CDViewerAppMain.this.linkCursorDirector.connectViewport(CDViewerAppMain.this.serDisp1);
                    CDViewerAppMain.this.linkCursorDirector.connectViewport(CDViewerAppMain.this.fusedImageVp);
                    CDViewerAppMain.this.winDirector.disconnectAllViewports();
                    CDViewerAppMain.this.winDirector.connectViewport(CDViewerAppMain.this.serDisp0);
                    CDViewerAppMain.this.winDirector.connectViewport(CDViewerAppMain.this.serDisp1);
                    CDViewerAppMain.this.winDirector.connectViewport(CDViewerAppMain.this.fusedImageVp);
                    CDViewerAppMain.this.screen.updateUI();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getModality() {
        JComponent comp = this.screen.getSelectedPort();
        String modality = null;
        if (comp instanceof XpCompositePort) {
            XpCompositePort port = (XpCompositePort)comp;
            XpImage xi = port.getFrame();
            XpDicomElement elem = new XpDicomElement(8, 96);
            if (xi instanceof XpDicomObject) {
                XpDicomObject dobj = (XpDicomObject)((Object)xi);
                dobj.getValue(elem);
                if (elem.value != null) {
                    modality = elem.value.toString();
                }
                this.app.configureKeyBoardAction();
            }
        }
        return modality;
    }

    private void enableDisableControlAsPerSelection() {
        XpImage img;
        FrameCapable frCap;
        String modality;
        final String str = modality = this.getModality();
        if (!this.screen.getScreenLayout().toString().equalsIgnoreCase("1x1") && !this.screen.getScreenLayout().toString().equalsIgnoreCase("2x1")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (str == null || str.equals("")) {
                        return;
                    }
                    if (CDViewerAppMain.this.screen.getCine()) {
                        return;
                    }
                    CDViewerAppMain.this.screen.putClientProperty("Fusion." + str.toUpperCase(), "on");
                    CDViewerAppMain.this.screen.putClientProperty("Fusion." + str.toUpperCase(), "off");
                    CDViewerAppMain.this.app.configureKeyBoardAction();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (CDViewerAppMain.this.screen.getCine() || str == null) {
                        return;
                    }
                    if (str.equalsIgnoreCase("PT")) {
                        CDViewerAppMain.this.screen.putClientProperty("PETLoad", "on");
                        CDViewerAppMain.this.screen.putClientProperty("PETLoad", "off");
                        CDViewerAppMain.this.app.configureKeyBoardAction();
                    } else {
                        CDViewerAppMain.this.screen.putClientProperty("PETLoad", "off");
                        CDViewerAppMain.this.screen.putClientProperty("PETLoad", "on");
                        CDViewerAppMain.this.app.configureKeyBoardAction();
                    }
                }
            });
        }
        if (modality != null && (modality.equalsIgnoreCase("XA") || modality.equalsIgnoreCase("RF")) && (frCap = (FrameCapable)((Object)this.screen.getCapable(FrameCapable.class.getName()))) != null && (img = frCap.getFrame()) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CDViewerAppMain.this.screen.putClientProperty("OECLoad", "on");
                    CDViewerAppMain.this.screen.putClientProperty("OECLoad", "off");
                    CDViewerAppMain.this.app.configureKeyBoardAction();
                }
            });
        }
    }

    static {
        try {
            System.setProperty("NO_LOCK", "true");
            System.setProperty("cuiPanel.resources", "com.ge.med.cse.apps.cdviewer.MvResource");
            CvPropertiesManager.setProperty("DMSystem", "MV#" + MVDMSystem.class.getName());
            RedirectedStream.initRedirect();
            CDViewerAppMain.verifyLocal();
            String language = System.getProperty("user.language");
            orig = System.getProperty("ptk.sansserifBold");
            if (language.equalsIgnoreCase("ch") || language.equalsIgnoreCase("zh") || language.equalsIgnoreCase("ja") || language.equalsIgnoreCase("ko")) {
                System.setProperty("ptk.sansserifBold", "SimSun");
            }
            System.setProperty("loghandler", "null");
            Thread.setDefaultUncaughtExceptionHandler(new ThreadExceptionHandler());
            UIManager.setLookAndFeel(new CuiLookAndFeel());
            System.err.println("MediaViewer application started");
            props.setProperty("DX", "com.ge.med.cse.apps.cdviewer.DXDisplayApStyle");
            props.setProperty("XA", "com.ge.med.cse.apps.cdviewer.OECApStyle");
            props.setProperty("RF", "com.ge.med.cse.apps.cdviewer.OECApStyle");
            props.setProperty("XR", "com.ge.med.cse.apps.cdviewer.DXDisplayApStyle");
            XpPropertiesManager.setProperty("jami.render", "com.ge.med.terra.jami.render.XpPZWRenderer");
            XpPropertiesManager.setProperty("jami.maximagelayer.renderers", "10");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        viz = null;
    }
}

