/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer;

import com.ge.med.cse.apps.cdviewer.treetable.DMSeriesTableModel;
import com.ge.med.cse.apps.cdviewer.treetable.MultiphaseDMTable;
import com.ge.med.cse.apps.cdviewer.treetable.TableRowObject;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.xpv.ui.TitlePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DataSelector
extends JPanel {
    protected DMSession archiveSess;
    protected Set changeListen;
    protected DataSelectorUI view;
    public static final String SERIES_TABLE = "Series";
    public static final String EXAM_TABLE = "Exam";
    ResourceBundle bundle = CvUtils.getResourceBundle();
    public String modality = "";

    public DMSession getArchiveSess() {
        return this.archiveSess;
    }

    public DataSelector() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        this.changeListen = new HashSet();
        String typeOfRep = System.getProperty("REPOSITORY_TYPE", "archive");
        String repPAth = System.getProperty("REPOSITORY_PATH", System.getProperty("user.dir", "."));
        String[] args = new String[]{typeOfRep, repPAth};
        try {
            this.archiveSess = new DMSession(args);
            DMObject[] ser = this.archiveSess.getRelated("series");
            this.modality = System.getProperty("MODALITY");
        }
        catch (Exception e) {
            System.err.println(e.getStackTrace());
            Object[] options = new Object[]{"OK"};
            int n = JOptionPane.showOptionDialog(null, this.bundle.getString("ERROR_FAILED_TO_LOAD"), this.bundle.getString("MEDIA_VIEWER_TITLE"), 0, 0, null, options, options[0]);
        }
        this.view = new DataSelectorUI();
        this.setPreferredSize(new Dimension(250, 250));
        this.add(this.view);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
            }
        }));
    }

    public void loadData() {
        this.view.loadData();
    }

    public void setSelection(int examIndex) {
        this.view.examTable.setRowSelectionInterval(examIndex, examIndex);
    }

    public void setSeriesSelection(int serIndex) {
        this.view.seriesTable.setRowSelectionInterval(serIndex, serIndex);
    }

    void setPrefferedWidthForColumn(JTable table) {
        int noofCols = table.getColumnCount();
        for (int i = noofCols - 1; i >= 0; --i) {
            TableColumn colForWidthSet = table.getColumnModel().getColumn(i);
            TableCellRenderer renderer = null;
            Component comp = null;
            int widthToSet = 0;
            for (int row = 0; row < table.getRowCount(); ++row) {
                renderer = table.getCellRenderer(row, i);
                comp = renderer.getTableCellRendererComponent(table, table.getValueAt(row, i), false, false, row, i);
                if (comp.getPreferredSize().width <= widthToSet) continue;
                widthToSet = comp.getPreferredSize().width;
            }
            colForWidthSet.setPreferredWidth(widthToSet + 20);
        }
    }

    public void addSelectionChangeListener(ChangeListener list) {
        this.changeListen.add(list);
    }

    public void removeSelectionChangeListener(ChangeListener list) {
        this.changeListen.add(list);
    }

    protected synchronized void fireChange(DMObject[] selected) {
        ChangeListener[] toFire = this.changeListen.toArray(new ChangeListener[this.changeListen.size()]);
        ChangeEvent event = new ChangeEvent(selected);
        for (int i = 0; i < toFire.length; ++i) {
            try {
                toFire[i].stateChanged(event);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class DataSelectorUI
    extends TitlePanel {
        JTable examTable;
        JTable seriesTable;
        ExamTableModel examTableModel;
        DMSeriesTableModel seriesTableModel = new DMSeriesTableModel();
        DMObject[] toNotify = null;
        private Vector content = new Vector();
        private Vector seriesContent = new Vector();
        private DMTag EXAM_NO = new DMTag(32, 16);
        private DMTag EXAM_DESCRIPTION = new DMTag(8, 4144);
        private DMTag SERIES_NO = new DMTag(32, 17);
        private DMTag SERIES_DESCRIPTION = new DMTag(8, 4158);
        int selectionCount = 0;

        public DataSelectorUI() {
            this.setTitle(DataSelector.this.bundle.getString("DATASELECTOR"));
            this.initUI();
        }

        void loadData() {
            DMObject[] patients = DataSelector.this.archiveSess.getRelated("patient");
            Vector<DMObject> examcontainer = new Vector<DMObject>();
            for (int i = 0; i < patients.length; ++i) {
                examcontainer.addAll(Arrays.asList(patients[i].getRelated("study")));
            }
            Object[] exams = examcontainer.toArray(new DMObject[examcontainer.size()]);
            CvUtils.sortExam(exams);
            for (int i = 0; i < exams.length; ++i) {
                this.examTableModel.setValueAt(exams[i], i, 0);
            }
            DMObject firstExam = this.getValueforExam(0);
            if (firstExam != null) {
                this.seriesTableModel.setExamDMObject(firstExam);
            }
            this.seriesTable.getTableHeader().getColumnModel().getColumn(0).setPreferredWidth(20);
            this.seriesTable.getTableHeader().getColumnModel().getColumn(0).setResizable(false);
            this.seriesTable.repaint();
            this.examTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    DMObject exam = DataSelectorUI.this.getValueforExam(DataSelectorUI.this.examTable.getSelectedRow());
                    if (exam != null) {
                        DMObject[] exams = exam.getRelated("study");
                        DataSelectorUI.this.seriesTableModel.setExamDMObject(exams[0]);
                        DataSelectorUI.this.seriesTable.updateUI();
                        DataSelectorUI.this.revalidate();
                        DataSelectorUI.this.repaint();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                DataSelectorUI.this.seriesTable.getTableHeader().getColumnModel().getColumn(0).setPreferredWidth(20);
                                DataSelectorUI.this.seriesTable.getTableHeader().getColumnModel().getColumn(0).setResizable(false);
                            }
                        });
                    }
                }
            });
            this.examTable.getTableHeader().setReorderingAllowed(false);
        }

        private void initUI() {
            this.setLayout(new BorderLayout());
            this.examTableModel = new ExamTableModel();
            this.examTable = new JTable(this.examTableModel);
            this.examTable.setName("MVDataSelectorExamTable");
            JScrollPane scroll1 = new JScrollPane(this.examTable);
            this.add((Component)scroll1, "North");
            this.examTable.setSelectionMode(0);
            this.examTable.setPreferredScrollableViewportSize(new Dimension(400, 150));
            this.seriesTable = new MultiphaseDMTable(this.seriesTableModel);
            this.seriesTable.setName("DataSelectorSeriesTable");
            JScrollPane scroll2 = new JScrollPane(this.seriesTable);
            this.add((Component)scroll2, "Center");
            this.seriesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    ListSelectionEvent event = new ListSelectionEvent(e.getSource(), e.getFirstIndex(), e.getLastIndex(), e.getValueIsAdjusting());
                    if (event.getValueIsAdjusting()) {
                        return;
                    }
                    final int[] rows = DataSelectorUI.this.seriesTable.getSelectedRows();
                    new Thread(){

                        public void run() {
                            ArrayList<DMObject> list = new ArrayList<DMObject>();
                            for (int i = 0; i < rows.length; ++i) {
                                TableRowObject rowObject = DataSelectorUI.this.seriesTableModel.getTableRowObjectAt(rows[i]);
                                if (!rowObject.isChild() && rowObject.hasChild()) continue;
                                list.add(rowObject.getDMObject());
                            }
                            if (list.size() == 0) {
                                return;
                            }
                            DataSelectorUI.this.toNotify = list.size() > 1 ? new DMObject[]{(DMObject)list.get(0), (DMObject)list.get(1)} : new DMObject[]{(DMObject)list.get(0)};
                            if (DataSelectorUI.this.toNotify != null) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        DataSelector.this.fireChange(DataSelectorUI.this.toNotify);
                                    }
                                });
                            }
                        }
                    }.start();
                }
            });
        }

        private Object unmaskNull(Object toUnmask) {
            return toUnmask == null ? "" : (String)toUnmask;
        }

        public DMObject getValueforExam(int row) {
            if (row < 0) {
                return null;
            }
            return (DMObject)this.content.get(row);
        }

        public DMObject[] getValueforSeries(int[] row) {
            if (row.length < 0) {
                return null;
            }
            DMObject[] toret = new DMObject[row.length];
            for (int i = 0; i < row.length; ++i) {
                toret[i] = (DMObject)this.seriesContent.get(row[i]);
            }
            return toret;
        }

        class ExamTableModel
        extends AbstractTableModel {
            private String[] examColNames;

            ExamTableModel() {
                this.examColNames = new String[]{DataSelector.this.bundle.getString("EXAM_COLUMN_TITLE"), DataSelector.this.bundle.getString("DESCRIPTION")};
            }

            public boolean isCellEditable(int row, int column) {
                return false;
            }

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            public Object getValueAt(int row, int column) {
                if (this.getRowCount() == 0) {
                    return "";
                }
                DMObject dmo = (DMObject)DataSelectorUI.this.content.get(row);
                switch (column) {
                    case 0: {
                        return DataSelectorUI.this.unmaskNull(dmo.getValue(DataSelectorUI.this.EXAM_NO));
                    }
                    case 1: {
                        return DataSelectorUI.this.unmaskNull(dmo.getValue(DataSelectorUI.this.EXAM_DESCRIPTION));
                    }
                }
                return "";
            }

            public int getColumnCount() {
                return 2;
            }

            public String getColumnName(int column) {
                return this.examColNames[column];
            }

            public int getRowCount() {
                return DataSelectorUI.this.content.size();
            }

            public void setValueAt(Object value, int rowIndex, int columnIndex) {
                if (value == null && rowIndex == -1) {
                    DataSelectorUI.this.content.clear();
                    this.fireTableDataChanged();
                } else {
                    DataSelectorUI.this.content.add(rowIndex, value);
                    this.fireTableRowsInserted(rowIndex, rowIndex);
                }
            }
        }
    }
}

