/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;

public class RedirectedStream
extends PrintStream {
    static final String LOGPREFIX = "CdViewerLog";
    static final String LOG_DIR = System.getProperty("user.home") + File.separatorChar + "CSECDViewer";
    static final Comparator<File> filetimeComp = new FileTimeComparator();

    public static void initRedirect() {
        RedirectedStream.performCleanup();
        if (!Boolean.getBoolean("sun.misc.URLClassPath.debug")) {
            try {
                System.setErr(new RedirectedStream(LOG_DIR + File.separatorChar + LOGPREFIX + System.currentTimeMillis()));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private static void performCleanup() {
        File dir = new File(LOG_DIR);
        if (dir.exists()) {
            File[] childs = dir.listFiles();
            if (childs.length > 5) {
                Arrays.sort(childs, filetimeComp);
                for (int i = 5; i < childs.length; ++i) {
                    try {
                        childs[i].delete();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            dir.mkdirs();
        }
    }

    public RedirectedStream(String fileName) throws FileNotFoundException {
        super(new File(fileName));
        System.err.println(this.getClass().getName() + " Started redirecting the error stream");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileTimeComparator
    implements Comparator<File> {
        private FileTimeComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            if (f1.lastModified() < f2.lastModified()) {
                return 1;
            }
            if (f1.lastModified() > f2.lastModified()) {
                return -1;
            }
            return 0;
        }
    }
}

