/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.roi.CvUserAnnotationModel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpUserAnnotationVc;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

public class XpUserAnnoAction
extends BaseAction {
    private final String defaultUserText = "Edit";
    private String uatext = null;
    private CPoint target = null;
    private CPoint textanchor = null;

    protected String getName() {
        return "XP_USER_ANNO";
    }

    public void actionPerformed(ActionEvent e) {
        String[] params = this.getParams();
        UserAnnoCapable userAnno = this.getUserAnnotationCapable();
        Object text = null;
        CPoint[] points = new CPoint[2];
        try {
            if (params != null) {
                if (params[0].startsWith("\"")) {
                    points = CvUtils.getROIUtils().getUserAnnotationCoordinates(userAnno);
                    this.textanchor = points[0];
                    this.target = points[1];
                    this.uatext = this.parseUAText(params);
                    if (this.uatext == null) {
                        this.getLogger().log(Level.WARNING, "Parameters passed are not valid");
                        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                        return;
                    }
                } else {
                    points = this.parseParams(params);
                    if (points != null) {
                        this.textanchor = points[0];
                        this.target = points[1];
                    } else {
                        this.getLogger().log(Level.WARNING, "Parameters passed are not valid");
                        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                        return;
                    }
                }
                this.setParams(null);
            } else {
                points = CvUtils.getROIUtils().getUserAnnotationCoordinates(userAnno);
                this.textanchor = points[0];
                this.target = points[1];
                this.uatext = CvUtils.getResourceBundle().getString("USER_ANNOT_DEFAULT_TEXT");
            }
            CvUserAnnotationModel uam = new CvUserAnnotationModel(this.uatext, this.textanchor, this.target);
            userAnno.add(uam);
            final CvUserAnnotationModel ua = uam;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    XpUserAnnotationVc userAnnoVc = ua.getUserAnnotationVc();
                    if (userAnnoVc != null) {
                        SwingUtilities.getWindowAncestor(userAnnoVc).requestFocus();
                        ua.getUserAnnotationVc().requestFocus();
                    }
                }
            });
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during the user annotation add", exp);
        }
    }

    private CPoint[] parseParams(String[] p) {
        String text = null;
        try {
            CPoint[] point = new CPoint[2];
            UserAnnoCapable ucap = this.getUserAnnotationCapable();
            double x1 = 0.0;
            double y1 = 0.0;
            double x2 = 0.0;
            double y2 = 0.0;
            if (p.length == 4) {
                x1 = Double.parseDouble(p[0]);
                y1 = Double.parseDouble(p[1]);
                x2 = Double.parseDouble(p[2]);
                y2 = Double.parseDouble(p[3]);
                this.uatext = "Edit";
            } else if (p.length >= 5) {
                x1 = Double.parseDouble(p[0]);
                y1 = Double.parseDouble(p[1]);
                x2 = Double.parseDouble(p[2]);
                y2 = Double.parseDouble(p[3]);
                String[] dest = new String[p.length - 4];
                System.arraycopy(p, 4, dest, 0, p.length - 4);
                text = this.parseUAText(dest);
                if (text == null) {
                    return null;
                }
                this.uatext = text;
            } else {
                this.getLogger().log(Level.WARNING, "Invalid parameters.");
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                return null;
            }
            XpVisualComponent vc = XpUserAnnoAction.getImageVc(ucap);
            if (vc instanceof XpImage2DVc) {
                int iw = ((XpImage2DVc)vc).getImage().getWidth();
                int ih = ((XpImage2DVc)vc).getImage().getHeight();
                if (x1 < 0.0 || x1 > (double)(iw - 1) || y1 < 0.0 || y1 > (double)(ih - 1) || x2 < 0.0 || x2 > (double)(iw - 1) || y2 < 0.0 || y2 > (double)(ih - 1)) {
                    this.getLogger().log(Level.WARNING, "Incorrect points for posting the User Annotation :[" + x1 + "," + y1 + "] [" + x2 + "," + y2 + "]");
                    return null;
                }
                CPoint ipt = new CPoint(x2, y2, 0.0, 0);
                CPoint dpt = new CPoint();
                vc.transform(ipt, dpt, (byte)1);
                point[0] = new CPoint();
                vc.transform(dpt, point[0], (byte)3);
                point[1] = new CPoint(x1, y1, 0.0, 0);
                return point;
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Exception while parsing parameters", e);
        }
        return null;
    }

    private static XpVisualComponent getImageVc(Capable c) {
        Capable cap = c;
        if (cap instanceof SelectionCapable && (cap = (Capable)((Object)((SelectionCapable)cap).getViewportComponent(((SelectionCapable)cap).getComponentSelection()))) instanceof XpCompositePort) {
            XpCompositePort cp = (XpCompositePort)cap;
            if (cp.getSelectedPort() != null) {
                return cp.getSelectedPort().getMedicalImageVc().getImageVc();
            }
            return null;
        }
        return null;
    }

    private String parseUAText(String[] args) {
        String text = null;
        if (args[0].startsWith("\"")) {
            text = "";
            text = text + args[0].replaceAll("\"", "");
            if (args.length >= 2) {
                for (int i = 1; i <= args.length - 2; ++i) {
                    text = text + " ";
                    text = text + args[i];
                }
                text = text + " ";
                int len = args[args.length - 1].length();
                String laststr = args[args.length - 1].substring(0, len - 1);
                String end = args[args.length - 1].substring(len - 1, len).replaceAll("\"", "");
                text = text + laststr;
                text = text + end;
            }
        } else {
            return null;
        }
        return text;
    }
}

