/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.StdAnno.DefaultApStyle;
import com.ge.med.cse.cvf.annotation.XpCVAnnotation;
import com.ge.med.cse.cvf.annotation.XpCVAnnotationGenerator;
import com.ge.med.cse.cvf.base.CVViewPortManager;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.crossref.XpReferenceImageApp;
import com.ge.med.cse.cvf.idc.XpCPICapable;
import com.ge.med.cse.cvf.idc.XpCineCapable;
import com.ge.med.cse.cvf.idc.XpClipRoiActor;
import com.ge.med.cse.cvf.idc.XpPropagationCapable;
import com.ge.med.cse.cvf.idc.XpReportCursorCapable;
import com.ge.med.cse.cvf.idc.XpRowColCapable;
import com.ge.med.cse.cvf.idc.XpTickMarkCapable;
import com.ge.med.cse.cvf.roi.CvContinuousReporter;
import com.ge.med.cse.cvf.roi.CvImageMatte;
import com.ge.med.cse.cvf.util.CvCPI;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.Selectable;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpCPI;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpImageScene;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.jami.XpSeriesDisplayer;
import com.ge.med.terra.jami.XpTickMarkRuler;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.XpViewportManager;
import com.ge.med.terra.jami.annotation.XpAnnotationGenerator;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.capable.Visible;
import com.ge.med.terra.jami.platform.dm.XpDMgsps;
import com.ge.med.terra.jami.render.XpColorOverlay;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.roi.XpFreeHandRoi;
import com.ge.med.terra.jami.roi.XpRoiEvent;
import com.ge.med.terra.jami.roi.XpRoiEventListener;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import com.ge.med.terra.xpv.mouseController.LeftMouseButtonModeCapable;
import com.ge.med.terra.xpv.ui.ActiveAnnotationControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.awt.image.IndexColorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputListener;

public class CvSeriesDisplayer
extends XpSeriesDisplayer
implements XpPropagationCapable,
XpReportCursorCapable,
XpTickMarkCapable,
XpCPICapable,
XpCineCapable,
XpRowColCapable,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(CvSeriesDisplayer.class.getName());
    private boolean _cineOn = false;
    private int _cineRate = 10;
    private Object prevInterpolationHint = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    private static String cineQuality = "normal";
    private ArrayList<CvContinuousReporter> _cReporters = new ArrayList();
    private ArrayList<XpTickMarkRuler> horTickMarkComps = new ArrayList();
    private ArrayList<XpTickMarkRuler> verTickMarkComps = new ArrayList();
    private XpImageRenderAttributes selectedSceneIRA = new XpImageRenderAttributes();
    public static final String ACTIVEANNOTATION = "ActiveAnnotation";
    public static final String CONTENT_CHANGED = "CONTENT_CHANGED";
    public static final int SERIES_CHANGED = 1;
    public static final int SERIES_UPDATED = 0;
    private static int selPolicy = 2;
    private static int selMode = 1;
    private static String annotGenerator = null;
    private Field imgSceneInit = null;
    private static boolean RESTORE_SHUTTER_ON_ALL = false;
    private static boolean rcShowMarker = false;
    private boolean resetRCToCenter = true;
    private XpRoiEventListener roiListener = new XpRoiEventListener(){

        public void roiReleased(XpRoiEvent re) {
            RoiActor roiactor = re.getRoi();
            int roiContainingPort = 0;
            for (int i = 0; i < CvSeriesDisplayer.this.getRows() * CvSeriesDisplayer.this.getCols(); ++i) {
                XpFrameVisualizer viz = CvSeriesDisplayer.this.getPort(i);
                if (!viz.getRois().contains(roiactor)) continue;
                roiContainingPort = i;
                break;
            }
            if (roiContainingPort >= 0) {
                CvSeriesDisplayer.this.setPortSelection(roiContainingPort, 1, false);
            }
        }

        public void imageChanged(XpRoiEvent re) {
        }

        public void roiDragged(XpRoiEvent re) {
        }

        public void roiPressed(XpRoiEvent re) {
        }
    };
    private PropertyChangeListener graphicListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            block12: {
                Object newVal;
                block13: {
                    XpImageScene scene;
                    List rois;
                    block11: {
                        if (!"ROI_ADDED".equals(evt.getPropertyName())) break block11;
                        Object roiactor = evt.getNewValue();
                        if (roiactor instanceof RoiActor) {
                            ((RoiActor)roiactor).removeRoiEventListener(CvSeriesDisplayer.this.roiListener);
                            ((RoiActor)roiactor).addRoiEventListener(CvSeriesDisplayer.this.roiListener);
                            if (roiactor instanceof XpStatisticsRoi && evt.getPropagationId() instanceof XpImageScene) {
                                XpImageScene scene2 = (XpImageScene)evt.getPropagationId();
                                List rois2 = scene2.getRois();
                                int idx = 0;
                                if (rois2.contains(roiactor)) {
                                    for (int i = 0; i < rois2.size(); ++i) {
                                        Object roi = rois2.get(i);
                                        if (!(roi instanceof XpStatisticsRoi)) continue;
                                        ((XpStatisticsRoi)roiactor).setRoiLabel(Integer.toString(++idx));
                                    }
                                }
                            }
                            ((RoiActor)roiactor).setSelected(true);
                        }
                        CvSeriesDisplayer.this.showGraphics(true);
                        CvSeriesDisplayer.this.putClientProperty("showhide_property", new Boolean(true));
                        break block12;
                    }
                    if (!"ROI_REMOVED".equals(evt.getPropertyName())) break block13;
                    Object roiactor = evt.getNewValue();
                    if (!(roiactor instanceof RoiActor)) break block12;
                    ((RoiActor)roiactor).removeRoiEventListener(CvSeriesDisplayer.this.roiListener);
                    if (evt.getPropagationId() instanceof XpImageScene && (rois = (scene = (XpImageScene)evt.getPropagationId()).getRois()) != null && rois.size() > 0) {
                        int idx = 0;
                        for (int i = 0; i < rois.size(); ++i) {
                            Object roi = rois.get(i);
                            if (!(roi instanceof XpStatisticsRoi)) continue;
                            ((XpStatisticsRoi)roi).setRoiLabel(Integer.toString(++idx));
                        }
                    }
                    break block12;
                }
                if ("USERANNO_ADDED".equals(evt.getPropertyName())) {
                    Object newVal2 = evt.getNewValue();
                    if (newVal2 instanceof XpUserAnnotationModel) {
                        final XpUserAnnotationModel model = (XpUserAnnotationModel)newVal2;
                        model.addFocusListener(new FocusListener(){

                            public void focusGained(FocusEvent e) {
                                int userAnnotContainingPort = 0;
                                for (int i = 0; i < CvSeriesDisplayer.this.getRows() * CvSeriesDisplayer.this.getCols(); ++i) {
                                    XpFrameVisualizer viz = CvSeriesDisplayer.this.getPort(i);
                                    List ulist = null;
                                    if (viz != null) {
                                        ulist = viz.getUserAnnos();
                                    }
                                    if (ulist == null || !ulist.contains(model)) continue;
                                    userAnnotContainingPort = i;
                                    break;
                                }
                                if (userAnnotContainingPort >= 0) {
                                    CvSeriesDisplayer.this.setPortSelection(userAnnotContainingPort, 1, false);
                                }
                            }

                            public void focusLost(FocusEvent e) {
                            }
                        });
                    }
                    CvSeriesDisplayer.this.showGraphics(true);
                    CvSeriesDisplayer.this.putClientProperty("showhide_property", new Boolean(true));
                } else if ("USERANNO_REMOVED".equals(evt.getPropertyName()) && (newVal = evt.getNewValue()) instanceof XpUserAnnotationModel) {
                    XpUserAnnotationModel model = (XpUserAnnotationModel)newVal;
                    List l = model.getFocusListeners();
                    for (int i = 0; i < l.size(); ++i) {
                        model.removeFocusListener((FocusListener)l.get(i));
                    }
                }
            }
        }
    };
    ArrayList<PropertyChangeListener> pclsnrs = new ArrayList();
    private boolean maximized = false;
    private int prevRow = -1;
    private int prevCol = -1;
    private int prevSelPort = 0;
    private String oldPropMode = null;
    private boolean oldRCState = false;
    private boolean retainRCPosition = false;
    private int selIdx = -1;
    private Cursor prevCursor = null;
    private String propagationMode = "PROPAGATION_MODE_NONE";
    private boolean show_ = true;

    private static void configureAnnotations() {
        String[] modalities;
        String mods = CvPropertiesManager.getProperty("cvf.modalities", "mr,ct,pr");
        if (mods != null && (modalities = mods.split(",")) != null && modalities.length > 0) {
            for (int i = 0; i < modalities.length; ++i) {
                String[] imgTypes;
                String imT = CvPropertiesManager.getProperty("cvf.annotation.apstyle." + modalities[i].toLowerCase() + ".imagetype");
                if (imT == null || (imgTypes = imT.split(",")) == null || imgTypes.length <= 0) continue;
                for (int j = 0; j < imgTypes.length; ++j) {
                    String apstyleclass = CvPropertiesManager.getProperty("cvf.annotation.apstyle." + modalities[i].toLowerCase() + "." + imgTypes[j] + ".apstyleclass");
                    String configclass = CvPropertiesManager.getProperty("cvf.annotation.apstyle." + modalities[i].toLowerCase() + "." + imgTypes[j] + ".configclass");
                    if (apstyleclass == null || configclass == null) continue;
                    try {
                        XpCVAnnotation.registerAnnotationConfig(Class.forName(apstyleclass, true, Thread.currentThread().getContextClassLoader()), configclass);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        XpCVAnnotation.registerAnnotationConfig(DefaultApStyle.class, "com.ge.med.cse.cvf.base.XpCvApdAnnotationConfig$Default");
        annotGenerator = CvPropertiesManager.getProperty("cvf.annotation.generator", XpCVAnnotationGenerator.class.getName());
    }

    public CvSeriesDisplayer() {
        super(selPolicy, selMode);
        this.init();
    }

    public CvSeriesDisplayer(String renderType) {
        this(renderType, selPolicy, selMode);
    }

    public CvSeriesDisplayer(int selectionPolicy, int selectionMode) {
        super(selectionPolicy, selectionMode);
        this.init();
    }

    public CvSeriesDisplayer(String renderType, int selectionPolicy, int selectionMode) {
        super(renderType, selectionPolicy, selectionMode);
        this.init();
    }

    private void init() {
        this.setSharedRenderAttributes(false);
        this.setAutoRepaint(true);
        this.setMouseWheelPaging(false);
        try {
            this.setAnnotationGenerator(Class.forName(annotGenerator, true, this.getClass().getClassLoader()), null);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.addPropertyChangeListener("ROI_ADDED", this.graphicListener);
        this.addPropertyChangeListener("ROI_REMOVED", this.graphicListener);
        this.addPropertyChangeListener("USERANNO_ADDED", this.graphicListener);
        this.addPropertyChangeListener("USERANNO_REMOVED", this.graphicListener);
        this.addPropertyChangeListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CvSeriesDisplayer.this.setViewportManager((XpViewportManager)CvSeriesDisplayer.this.createInstance(CvPropertiesManager.getProperty("ViewPortManger", CVViewPortManager.class.getName())));
            }
        });
        try {
            this.imgSceneInit = XpImageScene.class.getDeclaredField("initScene");
            this.imgSceneInit.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void configActiveAnnotations() {
        int activeAnnotationCount = Integer.parseInt(CvPropertiesManager.getProperty(ACTIVEANNOTATION, "0"));
        for (int i = 0; i < activeAnnotationCount; ++i) {
            String[] activeKeyVal = CvPropertiesManager.getProperty("ActiveAnnotation." + i).split(",");
            ActiveAnnotationControl aac = (ActiveAnnotationControl)this.createInstance(activeKeyVal[0]);
            if (aac == null) continue;
            this.setActiveAnnotationListener(activeKeyVal[1], (MouseInputListener)aac, aac.getShortDescription());
            aac.setCapable((Capable)this);
        }
    }

    protected Object createInstance(String className) {
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void initListeners() {
        this.setKeyboardPaging(false);
        this.setMouseWheelPaging(false);
    }

    public void dispose() {
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer vp = this.getPort(i);
            vp.getMouseController().setTarget(null);
            vp.setMouseController(null);
            vp.getAnnotationGenerator().reset();
            ttm.unregisterComponent(vp.getMedicalImageVc().getAnnotationVc());
        }
        this.removePropertyChangeListener("ROI_ADDED", this.graphicListener);
        this.removePropertyChangeListener("ROI_REMOVED", this.graphicListener);
        this.removePropertyChangeListener("USERANNO_ADDED", this.graphicListener);
        this.removePropertyChangeListener("USERANNO_REMOVED", this.graphicListener);
        this.removePropertyChangeListener(this);
        this.clearActiveAnnotationListeners();
        this.roiListener = null;
        this._cReporters.clear();
        this.horTickMarkComps.clear();
        this.verTickMarkComps.clear();
        this.selectedSceneIRA = null;
        super.dispose();
    }

    public void setImages(XpMedicalImage[] images) {
        if (this.getCine()) {
            return;
        }
        if (images == null || images.length == 0) {
            return;
        }
        TransactionLogName tln = new TransactionLogName("TID=CV_setImages");
        this.resetRCToCenter = true;
        int width = images[0].getSlice().width;
        int height = images[0].getSlice().height;
        int selPort = this.getComponentSelection();
        int noImages = images.length;
        logger.log(Level.INFO, "{0} begin , NUMIMAGES=" + noImages + " IMAGESIZE=" + width + " x " + height, tln);
        super.setImages(images);
        if (selPort != -1) {
            this.setPortSelection(selPort, 1, false);
        }
        this.setEndOffset(this.getNumFrames() - 1);
        this.clearActiveAnnotationListeners();
        this.configActiveAnnotations();
        if ("SSAVE".equals(DicomUtils.getImageType(images[0], false))) {
            this.removeTickMark(1);
            this.removeTickMark(0);
        } else {
            this.setReportCursorVisible(XPDisplayPrefsUtils.getReportCursorStatus());
        }
        this.firePropertyChange(CONTENT_CHANGED, -1, 1);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CvSeriesDisplayer.this.getSelectedPort() != null) {
                    CvSeriesDisplayer.this.getSelectedPort().getMedicalImageVc().getImageVc().requestFocusInWindow();
                }
            }
        });
        for (int i = 1; i < this.getNumScenes(); ++i) {
            this.getScene(i).setSelectedState(2);
        }
        this.layoutImages();
        logger.log(Level.INFO, "{0} end ", tln);
        this.doPetStuff();
    }

    private void doPetStuff() {
        XpImage img = this.getFrame();
        if (img != null && img instanceof XpDicomObject) {
            String modality;
            XpDicomElement elem = new XpDicomElement(8, 96);
            ((XpDicomObject)((Object)img)).getValue(elem);
            if (elem.value != null && (modality = elem.value.toString()).toUpperCase().equals("PT")) {
                this.setVideoInverted(true);
                this.repaint();
            }
        }
    }

    public int addImages(XpMedicalImage[] images) {
        XpImage img;
        if (images == null || images.length == 0) {
            return -1;
        }
        if (this.getCine() || this.getMultiImageOp() != null) {
            return -1;
        }
        TransactionLogName tln = new TransactionLogName("TID=CV_addImages");
        logger.log(Level.INFO, "{0} begin", tln);
        int selPort = this.getComponentSelection();
        int index = 0;
        int sn1 = 0;
        if (selPort != -1 && (img = this.getImageAt(index = this.getFrameIndex() + selPort)) instanceof XpMedicalImage) {
            sn1 = DicomUtils.getImageNumber((XpMedicalImage)img);
        }
        int result = super.addImages(images);
        if (selPort != -1) {
            for (int i = index; i < this.getNumFrames(); ++i) {
                XpMedicalImage curImg = (XpMedicalImage)this.getFrame(i);
                int sn2 = DicomUtils.getImageNumber(curImg);
                if (sn1 != sn2) continue;
                index = i;
                break;
            }
            this.setFrameIndex(index - selPort);
            this.setPortSelection(selPort, 1, false);
        }
        this.setEndOffset(this.getNumFrames() - 1);
        this.syncCommonRenderAttributes(null);
        this.firePropertyChange(CONTENT_CHANGED, -1, 0);
        logger.log(Level.INFO, "{0} end", tln);
        return result;
    }

    public int addImage(XpMedicalImage image, int index) {
        int selindex;
        if (image == null) {
            return -1;
        }
        if (this.getCine() || this.getMultiImageOp() != null) {
            return -1;
        }
        TransactionLogName tln = new TransactionLogName("TID=CV_addImageByIndex");
        logger.log(Level.INFO, "{0} begin", tln);
        int selPort = this.getComponentSelection();
        int n = selindex = selPort != -1 ? this.getFrameIndex() + selPort : -1;
        if (selindex != -1 && index <= selindex) {
            ++selindex;
        }
        int result = super.addImage(image, index);
        if (selindex != -1) {
            this.setFrameIndex(selindex - selPort);
            this.setPortSelection(selPort, 1, false);
        }
        this.setEndOffset(this.getNumFrames() - 1);
        this.syncCommonRenderAttributes(null);
        this.firePropertyChange(CONTENT_CHANGED, -1, 0);
        logger.log(Level.INFO, "{0} end", tln);
        return result;
    }

    public int addImages(XpMedicalImage[] images, int index) {
        int selindex;
        if (images == null || images.length == 0) {
            return -1;
        }
        if (this.getCine() || this.getMultiImageOp() != null) {
            return -1;
        }
        TransactionLogName tln = new TransactionLogName("TID=CV_addImagesByIndex");
        logger.log(Level.INFO, "{0} begin", tln);
        int selPort = this.getComponentSelection();
        int n = selindex = selPort != -1 ? this.getFrameIndex() + selPort : -1;
        if (selindex != -1 && index <= selindex) {
            selindex += images.length;
        }
        int result = super.addImages(images, index);
        if (selindex != -1) {
            this.setFrameIndex(selindex - selPort);
            this.setPortSelection(selPort, 1, false);
        }
        this.setEndOffset(this.getNumFrames() - 1);
        this.syncCommonRenderAttributes(null);
        this.firePropertyChange(CONTENT_CHANGED, -1, 0);
        logger.log(Level.INFO, "{0} end", tln);
        return result;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("ComponentSelection".equals(evt.getPropertyName())) {
            XpImageScene scene = null;
            scene = this.getSelectionMode() == 1 ? this.getScene(this.getSelectedSceneIndex()) : this.getSelectedPort().getScene();
            if (scene != null) {
                this.selectedSceneIRA.set(scene.getImageRenderAttributes());
            }
        } else if (("winMax".equals(evt.getPropertyName()) || "winMin".equals(evt.getPropertyName()) || "pan".equals(evt.getPropertyName()) || "zoom".equals(evt.getPropertyName())) && (this.getSelectionPolicy() == 2 || "PROPAGATION_MODE_ALL".equals(this.propagationMode) || "PROPAGATION_MODE_FORWARD".equals(this.propagationMode))) {
            this.updatePropRenderAttributes();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        if (this.pclsnrs != null) {
            this.pclsnrs.add(listener);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        if (this.pclsnrs != null) {
            this.pclsnrs.remove(listener);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue, Object propagationId) {
        int i;
        PropertyChangeListener[] pcls = this.getPropertyChangeListeners(propertyName);
        PropertyChangeEvent pce = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        pce.setPropagationId(propagationId);
        if (pcls != null) {
            for (i = 0; i < pcls.length; ++i) {
                pcls[i].propertyChange(pce);
            }
        }
        if (this.pclsnrs != null && this.pclsnrs.size() > 0) {
            for (i = 0; i < this.pclsnrs.size(); ++i) {
                this.pclsnrs.get(i).propertyChange(pce);
            }
        }
    }

    public void setFrameIndex(int index) {
        int idx = this.getComponentSelection();
        super.setFrameIndex(index);
        if (this.getCine()) {
            return;
        }
        if (this.getSelectionMode() == 1 && idx != -1) {
            this.setPortSelection(0, 1, false);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CvSeriesDisplayer.this.getSelectedPort() != null) {
                    CvSeriesDisplayer.this.getSelectedPort().getMedicalImageVc().getImageVc().requestFocusInWindow();
                }
            }
        });
    }

    public void setRows(int rows) {
        this.setRowCol(rows, this.getCols());
    }

    public void setCols(int columns) {
        this.setRowCol(this.getRows(), columns);
    }

    public void setRowCol(int row, int col) {
        int selIdx;
        super.setRowCol(row, col);
        if (this.horTickMarkComps.size() > 0 && ((Component)this.horTickMarkComps.get(0)).isVisible()) {
            this.addHorTickMark();
        }
        if (this.verTickMarkComps.size() > 0 && ((Component)this.verTickMarkComps.get(0)).isVisible()) {
            this.addVerTickMark();
        }
        if (!this.getCine()) {
            this.setReportCursorVisible(this.isReportCursorVisible());
        }
        if ((selIdx = this.getComponentSelection()) >= 0) {
            int ports = this.getRows() * this.getCols();
            boolean all = true;
            for (int i = 0; i < ports; ++i) {
                if (this.getPort(i).getScene() == null || this.getPort(i).getScene().getSelectedState() > 0) continue;
                all = false;
                break;
            }
            if (all) {
                int size = this.getNumScenes();
                for (int i = 0; i < size; ++i) {
                    this.getScene(i).setSelectedState(2);
                }
            }
            this.setPortSelection(selIdx, 1, false);
        }
        this.revalidate();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CvSeriesDisplayer.this.getSelectedPort() != null) {
                    CvSeriesDisplayer.this.getSelectedPort().getMedicalImageVc().getImageVc().requestFocusInWindow();
                }
            }
        });
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void maximize() {
        if (!this.maximized) {
            this.prevRow = this.getRows();
            this.prevCol = this.getCols();
            this.prevSelPort = this.getComponentSelection();
            if (this.prevSelPort == -1) {
                this.prevSelPort = 0;
            }
            int selIdx = this.getFrameIndex();
            this.setRowCol(1, 1);
            this.setFrameIndex(selIdx + this.prevSelPort);
            this.maximized = true;
            this.firePropertyChange("minmax_property", false, true);
        }
    }

    public void minimize() {
        if (this.maximized) {
            int selIdx = this.getFrameIndex();
            this.setRowCol(this.prevRow, this.prevCol);
            if (this.prevSelPort == -1) {
                this.prevSelPort = 0;
            }
            if (this.getComponentSelection() != -1) {
                this.setComponentSelection(this.prevSelPort);
                this.setFrameIndex(selIdx - this.prevSelPort);
            }
            this.maximized = false;
            this.prevSelPort = 0;
            this.prevCol = -1;
            this.prevRow = -1;
            this.firePropertyChange("minmax_property", true, false);
        }
    }

    public void setCine(boolean cine) {
        int i;
        boolean prevCine = this.getCine();
        if (!prevCine && cine) {
            this.selIdx = this.getComponentSelection();
            this.prevInterpolationHint = this.getInterpolationHint();
            if (cineQuality.equalsIgnoreCase("high")) {
                this.setInterpolationHint(this.getCineQuality());
            } else if (cineQuality.equalsIgnoreCase("normal")) {
                this.setInterpolationHint(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
            this.setBorder(null);
            this.setAutoRepaint(false);
            this.enableDrawBorder(false);
            this.clearActiveAnnotationListeners();
            this.oldPropMode = this.getPropagationMode();
            this.setPropagationMode("PROPAGATION_MODE_ALL");
            this.maximize();
            this.oldRCState = this.isReportCursorVisible();
            if (this.oldRCState && this._cReporters.size() > 0) {
                for (i = 0; i < this._cReporters.size(); ++i) {
                    this._cReporters.get(i).setVisible(false);
                }
                this.setAnnotationItems(new String[]{"Report_Cursor"}, false);
            }
            this._cineOn = cine;
            this.firePropertyChange("Cine", false, true);
        }
        if (!cine) {
            this._cineOn = cine;
            this.setInterpolationHint(this.prevInterpolationHint);
            this.enableDrawBorder(true);
            this.paintImmediately(this.getBounds());
            this.setAutoRepaint(true);
            if (this.oldRCState && this._cReporters.size() > 0) {
                for (i = 0; i < this._cReporters.size(); ++i) {
                    this._cReporters.get(i).setVisible(true);
                }
                this.setAnnotationItems(new String[]{"Report_Cursor"}, true);
            }
            this.minimize();
            this.clearActiveAnnotationListeners();
            this.configActiveAnnotations();
            this.setPropagationMode(this.oldPropMode);
            if (this.getSelectionMode() == 1 && this.selIdx != -1 && this.getComponentSelection() == -1) {
                this.setPortSelection(0, 1, false);
            }
            if (this.getSelectedPort() != null) {
                this.getSelectedPort().getMedicalImageVc().getImageVc().requestFocusInWindow();
            }
            this.firePropertyChange("Cine", true, false);
        }
    }

    public boolean getCine() {
        return this._cineOn;
    }

    public void setCineRate(int rate) {
        int oldRate = this.getCineRate();
        this._cineRate = rate;
        this.firePropertyChange("CineRate", oldRate, rate);
    }

    public int getCineRate() {
        return this._cineRate;
    }

    public void setStartOffset(int offset) {
        int oldVal = this.getStartOffset();
        super.setStartOffset(offset);
        this.firePropertyChange("CineStartOffset", oldVal, this.getStartOffset());
    }

    public void setEndOffset(int offset) {
        int oldVal = this.getEndOffset();
        super.setEndOffset(offset);
        this.firePropertyChange("CineEndOffset", oldVal, this.getEndOffset());
    }

    public void setCineSkip(int cineSkip) {
        int oldVal = this.getCineSkip();
        super.setCineSkip(cineSkip);
        this.firePropertyChange("CineSkip", oldVal, this.getCineSkip());
    }

    public void setOffset(int offset) {
        if (this._cineOn) {
            super.setOffset(offset);
        } else {
            int idx = this.getComponentSelection();
            super.setOffset(offset);
            if (this.getSelectionMode() == 1 && idx != -1) {
                this.setPortSelection(0, 1, false);
            }
        }
    }

    private void enableDrawBorder(boolean drawBorder) {
        int n = this.getNumPorts();
        for (int i = 0; i < n; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            fv.setDrawBorder(drawBorder);
            fv.refreshSelection();
        }
    }

    public void pauseCine() {
        Container c;
        if (this._cineOn && (c = SwingUtilities.getAncestorOfClass(XPscreen.class, this)) != null && c instanceof XpCineCapable) {
            ((XpCineCapable)((Object)c)).pauseCine();
        }
    }

    public void resumeCine() {
        Container c;
        if (this._cineOn && (c = SwingUtilities.getAncestorOfClass(XPscreen.class, this)) != null && c instanceof XpCineCapable) {
            ((XpCineCapable)((Object)c)).resumeCine();
        }
    }

    public boolean isReportCursorVisible() {
        if (this._cReporters != null && this._cReporters.size() > 0) {
            return this._cReporters.get(0).isVisible();
        }
        return false;
    }

    public void setReportCursorVisible(boolean onOff) {
        boolean isvalid = CvUtils.measurementsValid(this.getFrame());
        if (onOff && isvalid) {
            this.addReportCursor();
            if (this.getNumPorts() > 0 && !this.isReportCursorVisible()) {
                this.prevCursor = this.getPort(0).getCursor();
            }
            for (int j = 0; j < this.getNumPorts(); ++j) {
                if (rcShowMarker) continue;
                this.getPort(j).setCursor(new Cursor(1));
            }
            if (this.getNumPorts() > 0 && this.getPort(0).queryAnnotationItem("Graphic_Results")) {
                this.setAnnotationItems(new String[]{"Report_Cursor"}, true);
            }
        } else {
            XpMouseController mc;
            this.removeReportCursor();
            Cursor cursor = this.prevCursor;
            XpFrameVisualizer fv = this.getSelectedPort();
            if (fv != null && (mc = fv.getMouseController()) != null && mc instanceof LeftMouseButtonModeCapable) {
                LeftMouseButtonModeCapable lmbmCapabele = (LeftMouseButtonModeCapable)((Object)mc);
                cursor = (Cursor)lmbmCapabele.getModeProperty(lmbmCapabele.getLeftMouseButtonMode(), "cursor_property");
            }
            for (int j = 0; j < this.getNumPorts(); ++j) {
                this.getPort(j).setCursor(cursor);
            }
            this.setAnnotationItems(new String[]{"Report_Cursor"}, false);
        }
        for (int i = 0; i < this._cReporters.size(); ++i) {
            this._cReporters.get(i).setVisible(onOff);
        }
        boolean visible = XPDisplayPrefsUtils.getReportCursorStatus();
        this.firePropertyChange("report_cursor_property", !visible, visible);
    }

    private void addReportCursor() {
        int numPorts = this.getNumPorts();
        if (this._cReporters.size() == 0) {
            for (int i = 0; i < numPorts; ++i) {
                CvContinuousReporter rc = null;
                if (rcShowMarker) {
                    Point pt = this.getCenterOfVP(this.getPort(i));
                    if (pt == null) continue;
                    rc = new CvContinuousReporter(((Point2D)pt).getX(), ((Point2D)pt).getY());
                    rc.showMarker(true);
                } else {
                    rc = new CvContinuousReporter(-1.0, -1.0);
                }
                this._cReporters.add(rc);
                this.getPort(i).getMedicalImageVc().getImageVc().add(this._cReporters.get(i));
                this._cReporters.get(i).setVisible(false);
            }
        } else if (this._cReporters.size() < numPorts) {
            int i;
            boolean visible = this._cReporters.get(0).isVisible();
            if (this.resetRCToCenter) {
                for (i = 0; i < this._cReporters.size(); ++i) {
                    Point pt = this.getCenterOfVP(this.getPort(i));
                    CPoint cpt = null;
                    if (pt == null) continue;
                    cpt = rcShowMarker ? new CPoint(((Point2D)pt).getX(), ((Point2D)pt).getY(), 0.0, 0) : new CPoint(-1, -1, 0, 0);
                    this._cReporters.get(i).setPoint(cpt);
                }
            }
            for (i = this._cReporters.size(); i < numPorts; ++i) {
                CvContinuousReporter rc = null;
                if (rcShowMarker) {
                    Point pt = this.getCenterOfVP(this.getPort(i));
                    if (pt == null) continue;
                    rc = new CvContinuousReporter(((Point2D)pt).getX(), ((Point2D)pt).getY());
                    rc.showMarker(true);
                } else {
                    rc = new CvContinuousReporter(-1.0, -1.0);
                }
                this._cReporters.add(rc);
                this.getPort(i).getMedicalImageVc().getImageVc().add(this._cReporters.get(i));
                this._cReporters.get(i).setVisible(visible);
            }
        } else if (this._cReporters.size() > numPorts) {
            for (int i = this._cReporters.size() - 1; i >= numPorts; --i) {
                this._cReporters.get(i).setVisible(false);
                this.getPort(i).getMedicalImageVc().getImageVc().remove(this._cReporters.get(i));
                this._cReporters.remove(i);
            }
        } else {
            boolean visible = this._cReporters.get(0).isVisible();
            if (visible && this.resetRCToCenter) {
                for (int i = 0; i < numPorts; ++i) {
                    Point pt = this.getCenterOfVP(this.getPort(i));
                    CPoint cpt = null;
                    if (pt == null) continue;
                    cpt = rcShowMarker ? new CPoint(((Point2D)pt).getX(), ((Point2D)pt).getY(), 0.0, 0) : new CPoint(-1, -1, 0, 0);
                    this._cReporters.get(i).setPoint(cpt);
                }
            }
        }
        this.resetRCToCenter = false;
    }

    private void removeReportCursor() {
        if (this._cReporters.size() > 0) {
            for (int i = 0; i < this._cReporters.size(); ++i) {
                this._cReporters.get(i).setVisible(false);
                this.getPort(i).getMedicalImageVc().getImageVc().remove(this._cReporters.get(i));
            }
            this._cReporters.clear();
        }
    }

    public void addTickMark(int orientation) {
        XpMedicalImage img = (XpMedicalImage)this.getFrame();
        if ("SSAVE".equals(DicomUtils.getImageType(img, false))) {
            return;
        }
        if (orientation == 1) {
            this.addHorTickMark();
        } else {
            this.addVerTickMark();
        }
        this.firePropertyChange("tick_mark_added_property", -1, orientation);
    }

    public void removeTickMark(int orientation) {
        ArrayList<XpTickMarkRuler> list = null;
        list = orientation == 1 ? this.horTickMarkComps : this.verTickMarkComps;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            ((Component)iter.next()).setVisible(false);
        }
        this.firePropertyChange("tick_mark_removed_property", -1, orientation);
    }

    private void addHorTickMark() {
        int np = this.getNumPorts();
        if (this.horTickMarkComps.size() < np) {
            for (int i = this.horTickMarkComps.size(); i < np; ++i) {
                XpFrameVisualizer fv = this.getPort(i);
                XpTickMarkRuler tickM = new XpTickMarkRuler(1);
                fv.getMedicalImageVc().getImageVc().add(tickM);
                fv.getMedicalImageVc().repaint();
                this.horTickMarkComps.add(tickM);
                this.updateUI();
            }
        }
        Iterator<XpTickMarkRuler> iter = this.horTickMarkComps.iterator();
        while (iter.hasNext()) {
            ((Component)iter.next()).setVisible(true);
        }
    }

    private void addVerTickMark() {
        int np = this.getNumPorts();
        if (this.verTickMarkComps.size() < np) {
            for (int i = this.verTickMarkComps.size(); i < np; ++i) {
                XpFrameVisualizer fv = this.getPort(i);
                XpTickMarkRuler tickM = new XpTickMarkRuler(0);
                fv.getMedicalImageVc().getImageVc().add(tickM);
                fv.getMedicalImageVc().repaint();
                this.verTickMarkComps.add(tickM);
                this.updateUI();
            }
        }
        Iterator<XpTickMarkRuler> iter = this.verTickMarkComps.iterator();
        while (iter.hasNext()) {
            ((Component)iter.next()).setVisible(true);
        }
    }

    public void setPropagationMode(String mode) {
        String old = this.propagationMode;
        this.propagationMode = mode;
        this.firePropertyChange("ira_propagtion_mode", old, mode);
    }

    public String getPropagationMode() {
        return this.propagationMode;
    }

    public void propagateROI() {
        this.propagateROI(1, this.getNumFrames());
    }

    public void propagateROI(int fromImgNum, int toImgNum) {
        Selectable selectable;
        int i;
        int totalframes = this.getNumFrames();
        if (fromImgNum > totalframes || fromImgNum < 1) {
            return;
        }
        if (toImgNum > totalframes || toImgNum < 1) {
            return;
        }
        if (fromImgNum > toImgNum) {
            return;
        }
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv == null || fv.getScene() == null) {
            return;
        }
        List roiList = fv.getScene().getRois();
        List uaList = fv.getScene().getUserAnnos();
        ArrayList<RoiActor> selRois = new ArrayList<RoiActor>();
        ArrayList<XpUserAnnotationModel> selUAs = new ArrayList<XpUserAnnotationModel>();
        if (roiList != null) {
            for (i = 0; i < roiList.size(); ++i) {
                RoiActor roi = (RoiActor)roiList.get(i);
                if (!(roi instanceof Visible) || !((Visible)((Object)roi)).isVisible() || !roi.isSelected()) continue;
                selRois.add(roi);
            }
        }
        if (uaList != null) {
            for (i = 0; i < uaList.size(); ++i) {
                XpUserAnnotationModel usm = (XpUserAnnotationModel)uaList.get(i);
                if (!usm.isVisible() || !usm.isSelected()) continue;
                selUAs.add(usm);
            }
        }
        for (i = fromImgNum - 1; i < toImgNum; ++i) {
            Selectable clone;
            XpImageScene scene = this.getScene(i);
            if (scene == fv.getScene()) continue;
            for (int selRoi = 0; selRoi < selRois.size(); ++selRoi) {
                RoiActor ra = (RoiActor)selRois.get(selRoi);
                if (!(ra instanceof Replicable)) continue;
                clone = (RoiActor)((Replicable)((Object)ra)).clone();
                clone.setSelected(false);
                if (clone instanceof XpFreeHandRoi) {
                    ((XpFreeHandRoi)clone).setDragByRoiLabel(true);
                }
                if (clone instanceof CvImageMatte) {
                    List rl = scene.getRois();
                    int size = rl.size();
                    for (int j = 0; j < size; ++j) {
                        RoiActor r = (RoiActor)rl.get(j);
                        if (!(r instanceof CvImageMatte)) continue;
                        scene.remove(r);
                        break;
                    }
                }
                scene.add((RoiActor)clone);
            }
            for (int selUa = 0; selUa < selUAs.size(); ++selUa) {
                XpUserAnnotationModel uam = (XpUserAnnotationModel)selUAs.get(selUa);
                clone = (XpUserAnnotationModel)uam.clone();
                ((XpUserAnnotationModel)clone).setSelected(false);
                scene.add((XpUserAnnotationModel)clone);
            }
        }
        int numports = this.getNumPorts();
        int rcsize = this._cReporters.size();
        for (int i2 = 0; i2 < numports && i2 < rcsize; ++i2) {
            if (!this._cReporters.get(i2).isVisible()) continue;
            XpFrameVisualizer tfv = this.getPort(i2);
            tfv.syncScene();
            CvContinuousReporter cr = this._cReporters.get(i2);
            tfv.getMedicalImageVc().getImageVc().remove(cr);
            tfv.getMedicalImageVc().getImageVc().add(cr);
        }
        this.layoutImages();
        List selectedList = XpAppContext.instance().getSelectionManager().getSelected();
        XpAppContext.instance().getSelectionManager().clearSelection();
        for (int selUa = 0; selUa < selUAs.size(); ++selUa) {
            selectable = (Selectable)selUAs.get(selUa);
            selectable.setSelected(true);
            selectedList.remove(selectable);
            selectedList.add(selectable);
        }
        for (int selRoi = 0; selRoi < selRois.size(); ++selRoi) {
            selectable = (Selectable)selRois.get(selRoi);
            selectable.setSelected(true);
            selectedList.remove(selectable);
            selectedList.add(selectable);
        }
    }

    public void updatePropRenderAttributes() {
        XpImageRenderAttributes ira = null;
        XpImageScene selScene = null;
        int selSceneIndex = -1;
        if (this.getSelectionMode() == 1) {
            selSceneIndex = this.getSelectedSceneIndex();
            selScene = this.getScene(selSceneIndex);
        } else {
            selScene = this.getSelectedPort().getScene();
            selSceneIndex = this.getSceneIndexAtPort(this.getComponentSelection());
        }
        if (selScene != null) {
            ira = selScene.getImageRenderAttributes();
        }
        if (ira != null) {
            boolean multiSelection;
            String mod = DicomUtils.getModality((XpMedicalImage)selScene.getFrame());
            if (ira.getWindowLevel() < CvUtils.getMinWL(mod)) {
                ira.setWindowLevel(CvUtils.getMinWL(mod));
                return;
            }
            if (ira.getWindowLevel() > CvUtils.getMaxWL(mod)) {
                ira.setWindowLevel(CvUtils.getMaxWL(mod));
                return;
            }
            if (ira.getWindowWidth() > CvUtils.getMaxWW(mod)) {
                ira.setWindowWidth(CvUtils.getMaxWW(mod));
                return;
            }
            if (ira.getWindowWidth() < CvUtils.getMinWW(mod)) {
                ira.setWindowWidth(CvUtils.getMinWW(mod));
                return;
            }
            double zoomFactor = ira.getZoom();
            if (zoomFactor < CvUtils.getMinZoom()) {
                this.setZoom(CvUtils.getMinZoom());
                return;
            }
            if (zoomFactor > CvUtils.getMaxZoom()) {
                this.setZoom(CvUtils.getMaxZoom());
                return;
            }
            this.syncCommonRenderAttributes(selScene);
            boolean propwwwl = false;
            boolean proppan = false;
            boolean propzoom = false;
            boolean propModeSet = "PROPAGATION_MODE_ALL".equals(this.propagationMode) || "PROPAGATION_MODE_FORWARD".equals(this.propagationMode);
            boolean bl = multiSelection = this.getSelectionPolicy() == 2;
            if (!(!multiSelection && !propModeSet || ira.equals(this.selectedSceneIRA) && ((Object)ira.getImageOperations()).equals(this.selectedSceneIRA.getImageOperations()))) {
                if (ira.getWindowMax() != this.selectedSceneIRA.getWindowMax() || ira.getWindowMin() != this.selectedSceneIRA.getWindowMin()) {
                    propwwwl = true;
                }
                if ((ira.getPanX() != this.selectedSceneIRA.getPanX() || ira.getPanY() != this.selectedSceneIRA.getPanY()) && ira.getImageOrientation().getFlip() == this.selectedSceneIRA.getImageOrientation().getFlip() && ira.getImageOrientation().getAngle() == this.selectedSceneIRA.getImageOrientation().getAngle()) {
                    proppan = true;
                }
                if (ira.getZoom() != this.selectedSceneIRA.getZoom()) {
                    propzoom = true;
                }
                if (propwwwl || proppan || propzoom) {
                    int start;
                    for (int i = start = !multiSelection && "PROPAGATION_MODE_FORWARD".equals(this.propagationMode) ? selSceneIndex : 0; i < this.getNumScenes(); ++i) {
                        XpImageRenderAttributes attr;
                        XpImageScene is = this.getScene(i);
                        if (is == selScene || !this._cineOn && (!multiSelection || is.getSelectedState() <= 0) && (multiSelection || !propModeSet) || !proppan && !propwwwl && !propzoom || (attr = this.getRenderingAttrFor(is, propwwwl)) == null) continue;
                        if (propwwwl) {
                            attr.setWindowMinMax(ira.getWindowMin(), ira.getWindowMax());
                        }
                        if (proppan) {
                            attr.setPan(ira.getPanX(), ira.getPanY());
                        }
                        if (propzoom) {
                            attr.setZoom(ira.getZoom());
                        }
                        is.setImageRenderAttributes(attr);
                    }
                }
            }
            double oldWMAX = this.selectedSceneIRA.getWindowMax();
            double oldWMIN = this.selectedSceneIRA.getWindowMin();
            boolean oldInv = this.selectedSceneIRA.isVideoInverted();
            Point2D oldPan = this.selectedSceneIRA.getPan();
            double oldZoom = this.selectedSceneIRA.getZoom();
            ira = selScene.getImageRenderAttributes();
            this.selectedSceneIRA.set(ira);
            double newWMAX = ira.getWindowMax();
            double newWMIN = ira.getWindowMin();
            boolean newInv = ira.isVideoInverted();
            Point2D newPan = ira.getPan();
            double newZoom = ira.getZoom();
            if (oldPan.getX() != newPan.getX() || oldPan.getY() != newPan.getY()) {
                this.firePropertyChange("pan", oldPan, newPan);
            }
            if (oldZoom != newZoom) {
                this.firePropertyChange("zoom", oldZoom, newZoom);
            }
            if (oldWMAX != newWMAX) {
                this.firePropertyChange("winMax", oldWMAX, newWMAX);
            }
            if (oldWMIN != newWMIN) {
                this.firePropertyChange("winMin", oldWMIN, newWMIN);
            }
            if (oldInv != newInv) {
                this.firePropertyChange("videoInverted", oldInv, newInv);
            }
        }
        this.refreshImageRenderAttributes();
        if (this.isAutoRepaint()) {
            this.callRepaint();
        }
    }

    protected XpImageRenderAttributes getRenderingAttrFor(XpImageScene is, boolean isWWWL) {
        XpImageRenderAttributes attr = null;
        try {
            boolean isAlreadyNotInited = (Boolean)this.imgSceneInit.get(is);
            if (isAlreadyNotInited) {
                this.imgSceneInit.set(is, Boolean.FALSE);
                attr = is.getImageRenderAttributes();
                if (!isWWWL) {
                    this.imgSceneInit.set(is, Boolean.TRUE);
                }
                return attr;
            }
            return is.getImageRenderAttributes();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.WARNING, "Exception during get attr , {0}", new Object[]{e});
            return attr;
        }
    }

    private void syncCommonRenderAttributes(XpImageScene selectedScene) {
        XpImageRenderAttributes ira = null;
        XpImageScene selScene = selectedScene;
        if (selScene == null) {
            if (this.getSelectionMode() == 1) {
                int idx = this.getSelectedSceneIndex();
                selScene = this.getScene(idx);
            } else {
                selScene = this.getSelectedPort().getScene();
            }
        }
        if (selScene != null) {
            ira = selScene.getImageRenderAttributes();
        }
        if (ira != null) {
            int slen = this.getNumScenes();
            for (int i = 0; i < slen; ++i) {
                XpImageRenderAttributes attr;
                XpImageScene is = this.getScene(i);
                if (is == selScene || (attr = this.getRenderingAttrFor(is, false)) == null) continue;
                attr.setVideoInverted(ira.isVideoInverted());
                XpImageOrientation ior = attr.getImageOrientation();
                if (ior.getFlip() != ira.getImageOrientation().getFlip()) {
                    ior.flipHorizontal();
                }
                ior.setAngle(ira.getAngle());
                attr.setImageOrientation(ior);
                attr.setColormap(ira.getColormap());
                attr.setImageOperationList(ira.getImageOperations());
                is.setImageRenderAttributes(attr);
            }
            this.refreshImageRenderAttributes();
            if (this.isAutoRepaint()) {
                this.callRepaint();
            }
        }
    }

    public void resetIRA() {
        super.resetIRA();
        if (this.getSelectedPort() != null) {
            this.selectedSceneIRA.set(this.getSelectedPort().getImageRenderAttributes());
        }
    }

    public XpFrameVisualizer getSelectedPortWithReference() {
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv == null && XpReferenceImageApp.isRefPortOn(this)) {
            int portIdx = XpReferenceImageApp.getSelectedRefPortIndex(this);
            fv = this.getPort(portIdx);
        }
        return fv;
    }

    public boolean isGraphicsShowing() {
        return this.show_;
    }

    public void showGraphics(boolean show) {
        if (this.show_ == show) {
            return;
        }
        for (int i = 0; i < this.getNumScenes(); ++i) {
            List rois = this.getScene(i).getRois();
            for (int j = 0; j < rois.size(); ++j) {
                RoiActor ra = (RoiActor)rois.get(j);
                if (!(ra instanceof Visible)) continue;
                ((Visible)((Object)ra)).setVisible(show);
            }
            List annoList = this.getScene(i).getUserAnnos();
            if (annoList == null) continue;
            int size = annoList.size();
            for (int j = 0; j < size; ++j) {
                XpUserAnnotationModel am = (XpUserAnnotationModel)annoList.get(j);
                am.setVisible(show);
            }
        }
        boolean old = this.show_;
        this.show_ = show;
        this.firePropertyChange("showhide_property", old, show);
    }

    public void setCvCPI(XpCPI cpi) {
        this.clearGraphics();
        this.resetIRA();
        CvCPI.applyCPI(cpi, this.getSceneList());
        XpCPI.BitmapDisplayShutter bds = cpi.getBitmapDisplayShutter();
        if (bds != null) {
            XpImageRenderAttributes ira = this.getImageRenderAttributes();
            CvCPI.applyBitmapDisplayShutter(bds, ira);
        }
        if (RESTORE_SHUTTER_ON_ALL) {
            CvCPI.applyDisplayShutter(cpi, this.getSceneList());
        } else {
            CvCPI.applyDisplayShutter(cpi, this);
        }
        this.layoutImages();
    }

    private List getSceneList() {
        ArrayList<XpImageScene> sceneList = new ArrayList<XpImageScene>();
        for (int iCount = 0; iCount < this.getNumFrames(); ++iCount) {
            sceneList.add(this.getScene(iCount));
        }
        return sceneList;
    }

    public XpCPI getCPI() {
        XpFrameVisualizer fv = this.getPort(0);
        Dimension d = fv.getMedicalImageVc().getImageVc().getSize();
        XpCPI cpi = XpCPI.createCPI(this.getSceneList(), d, false);
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        XpColorOverlay co = ira.getColorOverlay();
        if (co != null) {
            XpCPI.setBitmapDisplayShutter(co, 0, cpi);
        }
        List[] rois = new List[1];
        fv = this.getSelectedPortWithReference();
        if (fv != null) {
            rois[0] = fv.getRois();
            Shape ics = null;
            for (RoiActor ra : rois[0]) {
                if (!(ra instanceof XpClipRoiActor)) continue;
                ics = ((XpClipRoiActor)ra).getImageClip();
                break;
            }
            if (ics != null) {
                XpCPI.addDisplayShutter(ics, 0, 0, cpi);
            }
        }
        return cpi;
    }

    public void add(RoiActor ra) {
        if (this.getCine()) {
            return;
        }
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv != null) {
            if (ra instanceof Visible && this.isGraphicsShowing()) {
                ((Visible)((Object)ra)).setVisible(true);
            }
            fv.add(ra);
            int index = this.getPrimarySelectedIndex();
            int crsize = this._cReporters.size();
            if (crsize > 0 && index < crsize && this._cReporters.get(index).isVisible()) {
                CvContinuousReporter cr = this._cReporters.get(index);
                fv.getMedicalImageVc().getImageVc().remove(cr);
                fv.getMedicalImageVc().getImageVc().add(cr);
            }
            fv.repaint();
            fv.requestFocus();
        }
    }

    public void add(XpUserAnnotationModel m) {
        if (this.getCine()) {
            return;
        }
        if (m == null) {
            return;
        }
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv != null) {
            if (this.isGraphicsShowing()) {
                m.setVisible(true);
            }
            fv.add(m);
            m.setSelected(true);
            fv.repaint();
            final XpUserAnnotationModel finalVar = m;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (finalVar.getUserAnnotationVc() != null) {
                        finalVar.getUserAnnotationVc().getTextArea().requestFocusInWindow();
                    }
                }
            });
        }
    }

    public boolean remove(XpUserAnnotationModel m) {
        if (super.remove(m)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (CvSeriesDisplayer.this.getSelectedPort() != null) {
                        CvSeriesDisplayer.this.getSelectedPort().getMedicalImageVc().getImageVc().requestFocusInWindow();
                    }
                }
            });
            return true;
        }
        return false;
    }

    public void resetWindowing() {
        IndexColorModel colormap = null;
        XpImageRenderAttributes attr = this.getImageRenderAttributes();
        if (attr != null) {
            colormap = attr.getColormap();
        }
        super.resetWindowing();
        if (colormap != null) {
            attr.setColormap(colormap);
            this.setImageRenderAttributes(attr);
        }
        this.doPetStuff();
    }

    public Color getAnnotationColor() {
        XpFrameVisualizer fv = this.getSelectedPortWithReference();
        if (fv != null) {
            return fv.getAnnotationColor();
        }
        return this.getPort(0).getAnnotationColor();
    }

    public XpAnnotationGenerator getAnnotationGenerator() {
        XpFrameVisualizer fv = this.getSelectedPortWithReference();
        if (fv != null) {
            return fv.getAnnotationGenerator();
        }
        return this.getPort(0).getAnnotationGenerator();
    }

    public String[] getAnnotationGroups() {
        XpFrameVisualizer fv = this.getSelectedPortWithReference();
        if (fv != null) {
            return fv.getAnnotationGroups();
        }
        return this.getPort(0).getAnnotationGroups();
    }

    public String[] getAnnotationItems() {
        XpFrameVisualizer fv = this.getSelectedPortWithReference();
        if (fv != null) {
            return fv.getAnnotationItems();
        }
        return this.getPort(0).getAnnotationItems();
    }

    public String[] getAnnotationItems(String agName) {
        XpFrameVisualizer fv = this.getSelectedPortWithReference();
        if (fv != null) {
            return fv.getAnnotationItems(agName);
        }
        return this.getPort(0).getAnnotationItems(agName);
    }

    public boolean queryAnnotationItem(String aiName) {
        XpFrameVisualizer fv = this.getSelectedPortWithReference();
        if (fv != null) {
            return fv.queryAnnotationItem(aiName);
        }
        return this.getPort(0).queryAnnotationItem(aiName);
    }

    public final InputStream getGSPS(XpDicomElement[] overrides) {
        XpDMgsps gspsFactory = new XpDMgsps(this);
        return gspsFactory.getGSPS(overrides);
    }

    private XpCPI getCPI(List scenes) {
        XpFrameVisualizer fv = this.getPort(0);
        Dimension d = fv.getMedicalImageVc().getImageVc().getSize();
        XpCPI cpi = XpCPI.createCPI(scenes, d, false);
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        XpColorOverlay co = ira.getColorOverlay();
        if (co != null) {
            XpCPI.setBitmapDisplayShutter(co, 0, cpi);
        }
        fv = this.getSelectedPort();
        List[] rois = new List[]{fv.getRois()};
        Shape cs = null;
        Shape ics = null;
        for (RoiActor ra : rois[0]) {
            if (!(ra instanceof XpClipRoiActor)) continue;
            ics = ((XpClipRoiActor)ra).getImageClip();
            break;
        }
        for (RoiActor ra : rois[0]) {
            if (!(ra instanceof XpClipRoiActor)) continue;
            ics = ((XpClipRoiActor)ra).getImageClip();
            break;
        }
        if (cs != null) {
            XpCPI.addDisplayShutter(cs, 1, 0, cpi);
        }
        if (ics != null) {
            XpCPI.addDisplayShutter(ics, 0, 0, cpi);
        }
        return cpi;
    }

    public final InputStream getGSPS(int startImg, int endImg, XpDicomElement[] overrides) {
        int num = this.getMaxFrame();
        if (startImg < 1 || startImg > num) {
            startImg = 1;
        }
        if (endImg > num || endImg < 1) {
            endImg = num;
        }
        int ni = endImg - startImg + 1;
        ArrayList<XpImageScene> scenes = new ArrayList<XpImageScene>();
        XpMedicalImage[] imgs = new XpMedicalImage[ni];
        int index = -1;
        for (int i = startImg; i <= endImg; ++i) {
            XpImageScene sc = this.getScene(i - 1);
            scenes.add(sc);
            imgs[++index] = (XpMedicalImage)sc.getFrame();
        }
        XpCPI cpi = this.getCPI(scenes);
        XpDMgsps gspsFactory = new XpDMgsps(imgs, cpi, null);
        return gspsFactory.getGSPS(overrides);
    }

    private Point getCenterOfVP(XpFrameVisualizer port) {
        if (port != null && port.getFrame() != null) {
            int y = 0;
            int height = port.getFrame().getSlice().getSliceColumns();
            int width = port.getFrame().getSlice().getSliceRows();
            int x = width / 2;
            y = height / 2;
            return new Point(x, y);
        }
        return null;
    }

    protected MouseListener getSelectionHandler(int portIdx) {
        return new XpFrameVizSelector(this, portIdx);
    }

    static {
        CvSeriesDisplayer.configureAnnotations();
        selPolicy = CvPropertiesManager.getBoolean("cvf.multiselection", true) ? 2 : 1;
        selMode = CvPropertiesManager.getBoolean("cvf.portselection", false) ? 2 : 1;
        cineQuality = CvPropertiesManager.getProperty("cvf.cine.quality", "normal");
        RESTORE_SHUTTER_ON_ALL = CvPropertiesManager.getBoolean("cvf.shutter.mode.all", true);
        rcShowMarker = CvPropertiesManager.getBoolean("cvf.reportcursor.showMarker", true);
    }

    protected static class XpFrameVizSelector
    implements MouseListener {
        private XpSeriesDisplayer sd_ = null;
        private int portIdx_ = 0;
        private Point mousePoint = new Point();
        boolean pressed = false;

        public XpFrameVizSelector(XpSeriesDisplayer sd, int portIdx) {
            this.sd_ = sd;
            this.portIdx_ = portIdx;
        }

        public void mouseClicked(MouseEvent me) {
            int clickCount = me.getClickCount();
            if (clickCount == 3) {
                int size = this.sd_.getNumScenes();
                for (int i = 0; i < size; ++i) {
                    XpImageScene fs = this.sd_.getScene(i);
                    fs.setSelectedState(2);
                }
                this.sd_.setPortSelection(this.portIdx_, 1, false);
            } else if (clickCount == 2) {
                this.sd_.setPortSelection(-1, 0, true);
                this.sd_.setPortSelection(this.portIdx_, 1, true);
            }
        }

        public void mousePressed(MouseEvent me) {
            this.pressed = true;
            this.mousePoint = me.getPoint();
            if (this.sd_.getCine() && this.sd_ instanceof XpCineCapable) {
                ((XpCineCapable)((Object)this.sd_)).pauseCine();
            }
            boolean all = true;
            if (this.sd_.getComponentSelection() == -1) {
                all = true;
            } else {
                int ports = this.sd_.getRows() * this.sd_.getCols();
                for (int i = 0; i < ports; ++i) {
                    if (i == this.portIdx_ || this.sd_.getPort(i).getScene() == null || this.sd_.getPort(i).getScene().getSelectedState() > 0) continue;
                    all = false;
                    break;
                }
            }
            if (all) {
                XpImageScene sc = this.sd_.getPort(this.portIdx_).getScene();
                int size = this.sd_.getNumScenes();
                for (int i = 0; i < size; ++i) {
                    XpImageScene fs = this.sd_.getScene(i);
                    if (sc == fs) continue;
                    fs.setSelectedState(2);
                }
            }
            this.sd_.setPortSelection(this.portIdx_, 1, false);
        }

        public void mouseReleased(MouseEvent me) {
            boolean isSamePoint = me.getPoint().equals(this.mousePoint);
            this.mousePoint.setLocation(0, 0);
            if (this.pressed && !isSamePoint) {
                this.sd_.updatePropRenderAttributes();
            }
            if (this.sd_.getCine() && this.sd_ instanceof XpCineCapable) {
                ((XpCineCapable)((Object)this.sd_)).resumeCine();
            }
            this.pressed = false;
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
        }
    }
}

