/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.cse.cvf.base.LinkedCursorVc;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LinkedCursorDirector
implements XpViewportDirector,
ChangeListener,
PropertyChangeListener {
    private ArrayList<XpCompositePort> portList = new ArrayList();
    private ArrayList<LinkedCursorVc> cursorList = new ArrayList();
    boolean isVisble = false;
    boolean attached = false;

    public void connectViewport(XpViewport viewport) {
        if (viewport == null || !(viewport instanceof XpCompositePort) || this.portList.contains(viewport)) {
            return;
        }
        XpCompositePort imageVp = (XpCompositePort)viewport;
        this.portList.add(imageVp);
        LinkedCursorVc cursor = new LinkedCursorVc();
        imageVp.getPort(0).getMedicalImageVc().getImageVc().add(cursor);
        imageVp.addPropertyChangeListener("Cine", this);
        cursor.addChangeListener(this);
        this.cursorList.add(cursor);
        imageVp.updateUI();
        if (this.portList.size() > 0 && !this.attached) {
            this.attached = true;
        }
    }

    public void disconnectAllViewports() {
        for (int index = 0; index < this.portList.size(); ++index) {
            this.portList.get(index).getPort(0).getMedicalImageVc().getImageVc().remove(this.cursorList.get(index));
            this.portList.get(index).removePropertyChangeListener("Cine", this);
            this.cursorList.get(0).removeChangeListener(this);
            this.attached = false;
        }
        this.cursorList.clear();
        this.portList.clear();
    }

    public void disconnectViewport(XpViewport viewport) {
        if (viewport == null || !(viewport instanceof XpCompositePort) || !this.portList.contains(viewport)) {
            return;
        }
        int index = this.cursorList.indexOf(viewport);
        this.portList.get(index).getPort(0).getMedicalImageVc().getImageVc().remove(this.cursorList.get(index));
        this.cursorList.get(index).removeChangeListener(this);
        this.cursorList.remove(index);
        this.portList.remove(index);
        viewport.removePropertyChangeListener("Cine", this);
        this.attached = false;
    }

    public void stateChanged(ChangeEvent e) {
        LinkedCursorVc cursor = (LinkedCursorVc)e.getSource();
        CPoint newRasPt = cursor.getRASPoint();
        for (LinkedCursorVc linkedCursor : this.cursorList) {
            linkedCursor.setRASPoint(newRasPt);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        int size = this.cursorList.size();
        if (size == 0) {
            return;
        }
        LinkedCursorVc cvctemp = this.cursorList.get(0);
        XpCompositePort imageVp = this.portList.get(0);
        if (imageVp.getCine()) {
            this.isVisble = cvctemp.isVisible();
            for (int i = 0; i < size; ++i) {
                LinkedCursorVc cvc = this.cursorList.get(i);
                cvc.setVisible(false);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                this.cursorList.get(i).setVisible(true);
                this.cursorList.get(i).revalidate();
            }
        }
    }
}

