/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import java.util.StringTokenizer;

public class DicomUtils {
    private static XpDicomElement pixtype = new XpDicomElement(40, 4);
    private static XpDicomElement pixballoc = new XpDicomElement(40, 256);

    public static int getBitsPerPix(XpMedicalImage img) {
        int bitsPerPix = 0;
        img.getValue(pixtype);
        img.getValue(pixballoc);
        String imgType = ((String)DicomUtils.pixtype.value).trim();
        if (imgType.equals("MONOCHROME2") || imgType.equals("MONOCHROME1")) {
            bitsPerPix = (Integer)DicomUtils.pixballoc.value == 16 ? 16 : 8;
        } else if (imgType.equals("RGB")) {
            bitsPerPix = 24;
        } else if (imgType.equals("PALETTE COLOR")) {
            bitsPerPix = (Integer)DicomUtils.pixballoc.value == 16 ? 16 : 8;
        }
        return bitsPerPix;
    }

    public static int getImageNumber(XpMedicalImage img) {
        if (img == null) {
            return -1;
        }
        XpDicomElement dicmElem = new XpDicomElement(32, 19);
        img.getValue(dicmElem);
        return dicmElem.getIntValue();
    }

    public static int getImageNumber(DMObject img) {
        if (img == null) {
            return -1;
        }
        if (img.getType().equalsIgnoreCase("image")) {
            Integer im_no = (Integer)img.getValue(32, 19);
            return im_no;
        }
        return -1;
    }

    public static String getModality(DMTagValueInterface dmObject) {
        String modality = (String)dmObject.getValue(new DMTag(8, 96));
        return DicomUtils.getModality(modality);
    }

    public static String getModality(DMImage image) {
        if (image == null) {
            return null;
        }
        String modality = (String)image.getValue(8, 96);
        return DicomUtils.getModality(modality);
    }

    public static String getModality(XpDicomObject image) {
        if (image == null) {
            return null;
        }
        XpDicomElement el = new XpDicomElement(8, 96);
        image.getValue(el);
        return DicomUtils.getModality(el.getStringValue());
    }

    public static String getModality(String modality) {
        if (modality == null) {
            return " ";
        }
        if (modality.equalsIgnoreCase("CT")) {
            return "CT";
        }
        if (modality.equalsIgnoreCase("MR")) {
            return "MR";
        }
        if (modality.equalsIgnoreCase("GEMS PET RAW")) {
            return "Raw";
        }
        if (modality.equalsIgnoreCase("PT")) {
            return "PT";
        }
        if (modality.equalsIgnoreCase("PR")) {
            return "PR";
        }
        if (modality.equalsIgnoreCase("SR")) {
            return "SR";
        }
        return modality;
    }

    public static String getImageType(DMTagValueInterface dmobj, boolean actualType) {
        if (dmobj == null) {
            return null;
        }
        String imageType = (String)dmobj.getValue(new DMTag(8, 8));
        String sopClassUid = (String)dmobj.getValue(new DMTag(8, 22));
        String modality = DicomUtils.getModality(dmobj);
        if (modality.equalsIgnoreCase("ct")) {
            return DicomUtils.getCTImageType(imageType, sopClassUid, actualType);
        }
        if (modality.equalsIgnoreCase("mr")) {
            return DicomUtils.getMRImageType(imageType, sopClassUid, actualType);
        }
        if (modality.equalsIgnoreCase("pt")) {
            String PETSeriesType = (String)dmobj.getValue(new DMTag(84, 4096));
            return DicomUtils.getPTImageType(imageType, sopClassUid, PETSeriesType, actualType);
        }
        if (modality.equalsIgnoreCase("pr") && sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.11.1")) {
            return "GSPS";
        }
        if (modality.equalsIgnoreCase("sr") && sopClassUid != null && (sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.11") || sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.22") || sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.33"))) {
            return "SR";
        }
        return null;
    }

    public static String getImageType(DMImage image, boolean actualType) {
        if (image == null) {
            return null;
        }
        String imageType = (String)image.getValue(8, 8);
        String sopClassUid = (String)image.getValue(8, 22);
        String modality = DicomUtils.getModality(image);
        if (modality.equalsIgnoreCase("ct")) {
            return DicomUtils.getCTImageType(imageType, sopClassUid, actualType);
        }
        if (modality.equalsIgnoreCase("mr")) {
            return DicomUtils.getMRImageType(imageType, sopClassUid, actualType);
        }
        if (modality.equalsIgnoreCase("pt")) {
            String PETSeriesType = (String)image.getValue(84, 4096);
            return DicomUtils.getPTImageType(imageType, sopClassUid, PETSeriesType, actualType);
        }
        if (modality.equalsIgnoreCase("pr") && sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.11.1")) {
            return "GSPS";
        }
        if (modality.equalsIgnoreCase("sr") && sopClassUid != null && (sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.11") || sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.22") || sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.33"))) {
            return "SR";
        }
        return null;
    }

    public static String getImageType(XpMedicalImage image, boolean actualType) {
        if (image == null) {
            return null;
        }
        XpDicomElement imgType = new XpDicomElement(8, 8);
        XpDicomElement sopuid = new XpDicomElement(8, 22);
        image.getValue(imgType);
        image.getValue(sopuid);
        String modality = DicomUtils.getModality(image);
        if (modality.equalsIgnoreCase("ct")) {
            return DicomUtils.getCTImageType(imgType.getStringValue(), sopuid.getStringValue(), actualType);
        }
        if (modality.equalsIgnoreCase("mr")) {
            return DicomUtils.getMRImageType(imgType.getStringValue(), sopuid.getStringValue(), actualType);
        }
        if (modality.equalsIgnoreCase("pt")) {
            XpDicomElement ptstype = new XpDicomElement(84, 4096);
            image.getValue(ptstype);
            return DicomUtils.getPTImageType(imgType.getStringValue(), sopuid.getStringValue(), ptstype.getStringValue(), actualType);
        }
        if (modality.equalsIgnoreCase("pr") && sopuid.getStringValue() != null && sopuid.getStringValue().equals("1.2.840.10008.5.1.4.1.1.11.1")) {
            return "GSPS";
        }
        if (modality.equalsIgnoreCase("sr") && sopuid.getStringValue() != null && (sopuid.getStringValue().equals("1.2.840.10008.5.1.4.1.1.88.11") || sopuid.getStringValue().equals("1.2.840.10008.5.1.4.1.1.88.22") || sopuid.getStringValue().equals("1.2.840.10008.5.1.4.1.1.88.33"))) {
            return "SR";
        }
        return null;
    }

    public static String getCTImageType(DMObject seriesObj, boolean actualType) {
        if (seriesObj == null) {
            return null;
        }
        String imageType = (String)seriesObj.getValue(8, 8);
        String sopClassUid = (String)seriesObj.getValue(8, 22);
        return DicomUtils.getCTImageType(imageType, sopClassUid, actualType);
    }

    public static String getCTImageType(String imageType, String sopClassUid, boolean actualType) {
        int i;
        String[] imgTypeStr = new String[4];
        if (imageType != null) {
            StringTokenizer st = new StringTokenizer(imageType, "\\");
            for (i = 0; st.hasMoreTokens() && i < 4; ++i) {
                imgTypeStr[i] = st.nextToken();
            }
        }
        while (i < 4) {
            imgTypeStr[i] = "";
            ++i;
        }
        if (imgTypeStr[0].equals("") && imgTypeStr[1].equals("") && imgTypeStr[2].equals("")) {
            if (sopClassUid != null && sopClassUid.equals("1.2.840.113619.4.26")) {
                return "3DMOD";
            }
            if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.11.1")) {
                return "GSPS";
            }
            if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.11")) {
                return "SR";
            }
            if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.22")) {
                return "SR";
            }
            if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.33")) {
                return "SR";
            }
            return "SSAVE";
        }
        if (imgTypeStr[0].equals("ORIGINAL")) {
            if (imgTypeStr[1].equals("PRIMARY")) {
                if (imgTypeStr[2].equals("AXIAL")) {
                    return "PROSP";
                }
                if (imgTypeStr[2].equals("LOCALIZER")) {
                    return "SCOUT";
                }
                if (imgTypeStr[2].equals("CTINTERVENTION")) {
                    if (imgTypeStr[3].equals("")) {
                        return "CTINT";
                    }
                    return "UNKNOWN";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.7")) {
                    return "SSAVE";
                }
                return "UNKNOWN";
            }
            if (imgTypeStr[1].equals("SECONDARY")) {
                if (imgTypeStr[2].equals("AXIAL") || imgTypeStr[2].equals("SEGMENTED")) {
                    return "RETRO";
                }
                if (imgTypeStr[2].equals("CTINTERVENTION")) {
                    if (imgTypeStr[3].equals("")) {
                        return "CTINT";
                    }
                    return "UNKNOWN";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.7")) {
                    return "SSAVE";
                }
                return "UNKNOWN";
            }
        }
        if (imgTypeStr[0].equals("DERIVED")) {
            if (imgTypeStr[1].equals("PRIMARY")) {
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.7")) {
                    return "SSAVE";
                }
                if (imgTypeStr[2].equals("AXIAL")) {
                    return "PROSP";
                }
                if (imgTypeStr[2].equals("LOCALIZER")) {
                    return "SCOUT";
                }
                return "UNKNOWN";
            }
            if (imgTypeStr[1].equals("SECONDARY")) {
                if (imgTypeStr[2].equals("REFORMATTED")) {
                    return "REFMT";
                }
                if (imgTypeStr[2].equals("PROCESSED")) {
                    return "PROC";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.113619.4.26")) {
                    return "3DMOD";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.11.1")) {
                    return "GSPS";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.11")) {
                    return "SR";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.22")) {
                    return "SR";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.33")) {
                    return "SR";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.7")) {
                    if (imgTypeStr[2].equals("3D")) {
                        return "3D";
                    }
                    if (imgTypeStr[2].equals("COMBINED")) {
                        return "COMB";
                    }
                    return "SSAVE";
                }
            }
        }
        return "UNKNOWN";
    }

    public static String getMRImageType(DMObject seriesObj, boolean actualType) {
        if (seriesObj == null) {
            return null;
        }
        String imageType = (String)seriesObj.getValue(8, 8);
        String sopClassUid = (String)seriesObj.getValue(8, 22);
        return DicomUtils.getMRImageType(imageType, sopClassUid, actualType);
    }

    public static String getMRImageType(String imageType, String sopClassUid, boolean actualType) {
        boolean secondaryCapture;
        int i;
        String[] imgTypeStr = new String[4];
        if (imageType != null) {
            StringTokenizer st = new StringTokenizer(imageType, "\\");
            for (i = 0; st.hasMoreTokens() && i < 4; ++i) {
                imgTypeStr[i] = st.nextToken();
            }
        }
        while (i < 4) {
            imgTypeStr[i] = "";
            ++i;
        }
        if (imgTypeStr[0].equals("") && imgTypeStr[1].equals("") && imgTypeStr[2].equals("") && imgTypeStr[3].equals("")) {
            if (sopClassUid != null && sopClassUid.equals("1.2.840.113619.4.26")) {
                return "3DMOD";
            }
            if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.11.1")) {
                return "GSPS";
            }
            if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.11")) {
                return "SR";
            }
            if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.22")) {
                return "SR";
            }
            if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.33")) {
                return "SR";
            }
            return "SSAVE";
        }
        boolean bl = secondaryCapture = sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.7");
        if (imgTypeStr[0].equals("ORIGINAL")) {
            if (imgTypeStr[1].equals("PRIMARY")) {
                if (secondaryCapture) {
                    return "SSAVE";
                }
                if (actualType) {
                    if (imgTypeStr[2].equals("OTHER")) {
                        return "PROSP";
                    }
                    return imgTypeStr[2].trim();
                }
                return "PROSP";
            }
            if (imgTypeStr[1].equals("SECONDARY")) {
                if (secondaryCapture) {
                    return "SSAVE";
                }
                if (actualType) {
                    return imgTypeStr[2].trim();
                }
                return "PROSP";
            }
            return "UNKNOWN";
        }
        if (imgTypeStr[0].equals("DERIVED")) {
            if (imgTypeStr[1].equals("PRIMARY")) {
                if (imgTypeStr[2].equals("PROJECTION IMAGE") || imgTypeStr[2].equals("PJN")) {
                    if (imgTypeStr[3].equals("IVI")) {
                        return "PJN";
                    }
                    if (imgTypeStr[3].equals("COLLAPSE") || imgTypeStr[3].equals("VASCULAR")) {
                        return "PROSP";
                    }
                    return "SSAVE";
                }
                if (secondaryCapture) {
                    return "SSAVE";
                }
                if (actualType) {
                    return imgTypeStr[2].trim();
                }
                if (imgTypeStr[2].equals("CMB")) {
                    return "PROSP";
                }
                return "PROC";
            }
            if (imgTypeStr[1].equals("SECONDARY")) {
                if (imgTypeStr[2].equals("REFORMATTED") || imgTypeStr[2].equals("MPR")) {
                    return "REFMT";
                }
                if (imgTypeStr[2].equals("PROCESSED") || imgTypeStr[2].equals("PROC")) {
                    return "PROC";
                }
                if (imgTypeStr[2].equals("PROJECTION IMAGE") || imgTypeStr[2].equals("PJN")) {
                    return "PJN";
                }
                if (imgTypeStr[2].equals("COMBINED") || imgTypeStr[2].equals("COMB")) {
                    return "COMB";
                }
                if (secondaryCapture) {
                    if (imgTypeStr[2].equals("3D")) {
                        return "3D";
                    }
                    if (actualType) {
                        return "SSAVE";
                    }
                    if (imgTypeStr[2].equals("COMBINED") || imgTypeStr[2].equals("COMB")) {
                        return "COMB";
                    }
                    return "SSAVE";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.113619.4.26")) {
                    return "3DMOD";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.11.1")) {
                    return "GSPS";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.11")) {
                    return "SR";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.22")) {
                    return "SR";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.33")) {
                    return "SR";
                }
                return "UNKNOWN";
            }
        }
        return "UNKNOWN";
    }

    public static String getPTImageType(DMObject seriesObj, boolean actualType) {
        if (seriesObj == null) {
            return null;
        }
        String imageType = (String)seriesObj.getValue(8, 8);
        String sopClassUid = (String)seriesObj.getValue(8, 22);
        String PETSeriesType = (String)seriesObj.getValue(84, 4096);
        return DicomUtils.getPTImageType(imageType, sopClassUid, PETSeriesType, actualType);
    }

    public static String getPTImageType(String imageType, String sopClassUid, String PETSeriesType, boolean actualType) {
        String[] ptSeriesTypeStr;
        int i;
        if (imageType == null) {
            return "";
        }
        String[] imgTypeStr = new String[4];
        if (imageType != null) {
            StringTokenizer st = new StringTokenizer(imageType, "\\");
            for (i = 0; st.hasMoreTokens() && i < 4; ++i) {
                imgTypeStr[i] = st.nextToken();
            }
        }
        while (i < 4) {
            imgTypeStr[i] = "";
            ++i;
        }
        if (PETSeriesType != null) {
            StringTokenizer ptSeriesTypeTok = new StringTokenizer(PETSeriesType, "\\");
            ptSeriesTypeStr = new String[ptSeriesTypeTok.countTokens()];
            i = 0;
            while (ptSeriesTypeTok.hasMoreTokens()) {
                ptSeriesTypeStr[i] = ptSeriesTypeTok.nextToken();
                ++i;
            }
        } else {
            ptSeriesTypeStr = new String[]{""};
        }
        if (imgTypeStr[0].equals("") && imgTypeStr[1].equals("") && imgTypeStr[2].equals("")) {
            if (sopClassUid != null && sopClassUid.equals("1.2.840.113619.4.26")) {
                return "3DMOD";
            }
            return "SSAVE";
        }
        if (imgTypeStr[0].equals("ORIGINAL") && (imgTypeStr[1].equals("PRIMARY") || imgTypeStr[1].equals("SECONDARY"))) {
            if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.7")) {
                return "SSAVE";
            }
            if (imgTypeStr[2].equals("")) {
                return ptSeriesTypeStr[0].trim();
            }
            return imgTypeStr[2].trim();
        }
        if (imgTypeStr[0].equals("DERIVED")) {
            if (imgTypeStr[1].equals("PRIMARY")) {
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.7")) {
                    return "SSAVE";
                }
                if (imgTypeStr[2].equals("AXIAL")) {
                    return "PROSP";
                }
                if (imgTypeStr[2].equals("LOCALIZER")) {
                    return "SCOUT";
                }
                if (imgTypeStr[2].equals("REFORMATTED") || imgTypeStr[2].equals("")) {
                    return "REFMT";
                }
                return imgTypeStr[2].trim();
            }
            if (imgTypeStr[1].equals("SECONDARY")) {
                if (imgTypeStr[2].equals("REFORMATTED")) {
                    return "REFMT";
                }
                if (imgTypeStr[2].equals("PROCESSED")) {
                    return "PROC";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.7")) {
                    if (imgTypeStr[2].equals("3D")) {
                        return "3D";
                    }
                    if (imgTypeStr[2].equals("COMBINED")) {
                        return "COMB";
                    }
                    return "SSAVE";
                }
                if (imgTypeStr[2].equals("")) {
                    return "REFMT";
                }
                return imgTypeStr[2].trim();
            }
            return "REFMT";
        }
        return "";
    }

    public static boolean isMRProbeQImage(XpDicomObject dobj) {
        boolean probeQ = false;
        XpDicomElement swVersion = new XpDicomElement(24, 4128);
        XpDicomElement Manufacturer = new XpDicomElement(8, 112);
        XpDicomElement usage_tag = new XpDicomElement(67, 4149);
        XpDicomElement signature_43 = new XpDicomElement(67, 16);
        XpDicomElement GEMS_spectro_quantitations = new XpDicomElement(67, 4243);
        dobj.getValue(swVersion);
        dobj.getValue(Manufacturer);
        dobj.getValue(usage_tag);
        dobj.getValue(signature_43);
        dobj.getValue(GEMS_spectro_quantitations);
        boolean mfgByGE = false;
        mfgByGE = Manufacturer.value != null && ((String)Manufacturer.value).trim().equals("GE MEDICAL SYSTEMS");
        String sw_version = (String)swVersion.value;
        Integer ex_verscre = null;
        try {
            ex_verscre = mfgByGE && sw_version != null ? new Integer(sw_version.split("\\\\")[0]) : new Integer(0);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean GEMS_signature_43 = false;
        GEMS_signature_43 = signature_43.value != null && ((String)signature_43.value).trim().equals("GEMS_PARM_01");
        Long GEMS_usage_tag = null;
        if (usage_tag.value instanceof Integer) {
            GEMS_usage_tag = GEMS_signature_43 && usage_tag != null ? new Long(((Integer)usage_tag.value).intValue()) : null;
        } else {
            Long l = GEMS_usage_tag = GEMS_signature_43 && usage_tag != null ? (Long)usage_tag.value : null;
        }
        if (ex_verscre != null && ex_verscre < 14) {
            if (GEMS_usage_tag != null && GEMS_usage_tag.intValue() == 1) {
                probeQ = true;
            }
        } else if (GEMS_spectro_quantitations.value != null) {
            probeQ = true;
        }
        return probeQ;
    }
}

