/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.graphics.HlsCuiColorSpace;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Font;
import java.awt.color.ColorSpace;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

class CuiContext
extends HashMap {
    protected static Logger logger_ = Logger.getLogger((class$com$ge$med$ptk$laf$CuiContext == null ? (class$com$ge$med$ptk$laf$CuiContext = CuiContext.class$("com.ge.med.ptk.laf.CuiContext")) : class$com$ge$med$ptk$laf$CuiContext).getName());
    static /* synthetic */ Class class$com$ge$med$ptk$laf$CuiContext;

    CuiContext() {
    }

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery((String[])argv, (String)"@(#)ptk2 2.7 200609011020 (Sun Microsystems Inc.|1.4.2_05|48.0|Linux|2.6.7-2.2smp|i386|batbuild)");
    }

    public static Map getSystemProperties() {
        float[] hls;
        float[] rgb;
        Color color;
        String key;
        HlsCuiColorSpace hlsColorSpace;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("P1", new Color(255, 255, 255));
        properties.put("P2", new Color(240, 242, 247));
        properties.put("P2.2", new Color(200, 206, 226));
        properties.put("P3", new Color(186, 190, 204));
        properties.put("P4", new Color(134, 140, 161));
        properties.put("P5", new Color(228, 231, 241));
        properties.put("P7", new Color(186, 193, 218));
        properties.put("P8", new Color(141, 152, 190));
        properties.put("P9", new Color(104, 117, 163));
        properties.put("P10", new Color(47, 61, 110));
        properties.put("P10.4", new Color(16, 28, 73));
        properties.put("P11", new Color(0, 0, 0));
        properties.put("P12", new Color(238, 229, 186));
        properties.put("P13", new Color(255, 241, 171));
        properties.put("Red", new Color(237, 28, 39));
        properties.put("Yellow", new Color(255, 229, 6));
        properties.put("Green", new Color(0, 171, 89));
        properties.put("Orange", new Color(255, 141, 0));
        try {
            String palette = System.getProperty("ptk.palette");
            if (palette != null) {
                StringTokenizer colors = new StringTokenizer(palette, " ,");
                while (colors.hasMoreTokens()) {
                    try {
                        StringTokenizer keyValue = new StringTokenizer(colors.nextToken(), ":");
                        properties.put(keyValue.nextToken(), new Color(Integer.parseInt(keyValue.nextToken(), 16)));
                    }
                    catch (Exception ex) {}
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (Boolean.getBoolean("ptk.grayscale")) {
                Iterator i = properties.keySet().iterator();
                while (i.hasNext()) {
                    String key2 = (String)i.next();
                    if (!(properties.get(key2) instanceof Color)) continue;
                    Color color2 = (Color)properties.get(key2);
                    int gs = (30 * color2.getRed() + 59 * color2.getGreen() + 11 * color2.getBlue()) / 100;
                    properties.put(key2, new Color(gs, gs, gs));
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (System.getProperty("ptk.gamma") != null) {
                hlsColorSpace = new HlsCuiColorSpace();
                double gamma = Double.parseDouble(System.getProperty("ptk.gamma")) / 2.0;
                Iterator i = properties.keySet().iterator();
                while (i.hasNext()) {
                    key = (String)i.next();
                    if (!(properties.get(key) instanceof Color)) continue;
                    color = (Color)properties.get(key);
                    rgb = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
                    hls = ((ColorSpace)hlsColorSpace).fromRGB(rgb);
                    hls[1] = (float)Math.pow(hls[1], 1.0 / gamma);
                    properties.put(key, new Color(hlsColorSpace, hls, 1.0f));
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (System.getProperty("ptk.contrast") != null) {
                hlsColorSpace = new HlsCuiColorSpace();
                double contrast = (double)Integer.getInteger("ptk.contrast", 100).intValue() / 100.0;
                contrast = Math.min(Math.max(contrast, 0.0), 1.0);
                double lightness = (double)Integer.getInteger("ptk.lightness", 50).intValue() / 100.0;
                lightness = Math.min(Math.max(lightness, 0.0), 1.0);
                Iterator i = properties.keySet().iterator();
                while (i.hasNext()) {
                    String key3 = (String)i.next();
                    if (!(properties.get(key3) instanceof Color)) continue;
                    Color color3 = (Color)properties.get(key3);
                    float[] rgb2 = new float[]{(float)color3.getRed() / 255.0f, (float)color3.getGreen() / 255.0f, (float)color3.getBlue() / 255.0f};
                    float[] hls2 = ((ColorSpace)hlsColorSpace).fromRGB(rgb2);
                    hls2[1] = (float)((double)hls2[1] * contrast + lightness * (1.0 - contrast));
                    properties.put(key3, new Color(hlsColorSpace, hls2, 1.0f));
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (System.getProperty("ptk.saturation") != null) {
                hlsColorSpace = new HlsCuiColorSpace();
                double saturation = (double)Integer.getInteger("ptk.saturation", 50).intValue() / 50.0;
                Iterator i = properties.keySet().iterator();
                while (i.hasNext()) {
                    key = (String)i.next();
                    if (!(properties.get(key) instanceof Color)) continue;
                    color = (Color)properties.get(key);
                    rgb = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
                    hls = ((ColorSpace)hlsColorSpace).fromRGB(rgb);
                    hls[2] = (float)Math.max(0.0, Math.min(1.0, (double)hls[2] * saturation));
                    properties.put(key, new Color(hlsColorSpace, hls, 1.0f));
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            String secondary3 = System.getProperty("ptk.defaultBackground", "P3");
            if (secondary3.equals("P3") || secondary3.equals("P7") || secondary3.equals("P9")) {
                properties.put("defaultBackground", secondary3);
            }
        }
        catch (Exception ex) {
            properties.put("defaultBackground", "P3");
        }
        try {
            String listBackground = System.getProperty("ptk.listBackground", "P2");
            if (listBackground.equals("P2") || listBackground.equals("P2.2")) {
                properties.put("listBackground", listBackground);
            }
        }
        catch (Exception ex) {
            properties.put("listBackground", "P2");
        }
        try {
            StringTokenizer tk = new StringTokenizer(System.getProperty("ptk.scale", "100"), ",");
            double[] scale = new double[tk.countTokens()];
            for (int i = 0; i < scale.length; ++i) {
                scale[i] = (double)Integer.parseInt(tk.nextToken()) / 100.0;
            }
            properties.put("scale", scale);
        }
        catch (Exception ex) {
            properties.put("scale", new double[]{1.0});
        }
        String fontPlainName = "Albany AMT";
        String fontBoldName = "Albany AMT Bold";
        try {
            fontPlainName = System.getProperty("ptk.sansserifPlain", fontPlainName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            fontBoldName = System.getProperty("ptk.sansserifBold", fontBoldName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        Font fontPlain = CuiContext.Font_decode(fontPlainName);
        Font fontBold = CuiContext.Font_decode(fontBoldName);
        try {
            if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                if (fontPlainName.equals("Albany AMT") && fontPlain.getFamily().equalsIgnoreCase("dialog")) {
                    fontPlain = CuiContext.Font_decode("Arial");
                }
                if (fontBoldName.equals("Albany AMT Bold") && fontBold.getFamily().equalsIgnoreCase("dialog")) {
                    fontBold = CuiContext.Font_decode("Arial Bold");
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        int fontSize = 12;
        try {
            fontSize = Integer.getInteger("ptk.fontSize", 12);
        }
        catch (Exception ex) {
            // empty catch block
        }
        properties.put("sansserifPlain", fontPlain.deriveFont((float)fontSize));
        properties.put("sansserifBold", fontBold.deriveFont((float)fontSize));
        int textAntialiasing = 12;
        try {
            String taa = System.getProperty("ptk.textAntialiasing", "12");
            textAntialiasing = taa.equalsIgnoreCase("false") ? Short.MAX_VALUE : (taa.equalsIgnoreCase("true") ? 0 : Integer.parseInt(taa));
        }
        catch (Exception ex) {
            // empty catch block
        }
        properties.put("textAntialiasing", new Integer(textAntialiasing));
        properties.put("interiorEdge", new Double(1.6));
        properties.put("exteriorEdge", new Double(1.0));
        properties.put("cornerRadius", new Double(4.0));
        properties.put("roundoverSlope", new Double(1.0));
        properties.put("bevelSlope", new Double(0.2));
        try {
            if (System.getProperty("ptk.properties") != null) {
                properties.put("properties", ResourceBundle.getBundle(System.getProperty("ptk.properties")));
            }
        }
        catch (Exception ex) {
            logger_.log(Level.WARNING, "" + ex, ex);
        }
        return properties;
    }

    public static Font Font_decode(String str) {
        int lastDash;
        if (str == null) {
            return new Font("dialog", 0, 12);
        }
        int lastSpace = str.lastIndexOf(32);
        int lastSeparator = Math.max(lastSpace, lastDash = str.lastIndexOf(45));
        if (lastSeparator == -1) {
            return new Font(str, 0, 12);
        }
        int separator = lastSpace > lastDash ? 32 : 45;
        int fontSize = 12;
        try {
            fontSize = Integer.parseInt(str.substring(lastSeparator + 1));
            str = str.substring(0, lastSeparator);
            lastSeparator = str.lastIndexOf(separator);
            if (lastSeparator == -1) {
                return new Font(str, 0, fontSize);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        String fontStyle = str.substring(lastSeparator + 1).toLowerCase();
        if (fontStyle.equals("bold")) {
            return new Font(str.substring(0, lastSeparator), 1, fontSize);
        }
        if (fontStyle.equals("italic")) {
            return new Font(str.substring(0, lastSeparator), 2, fontSize);
        }
        if (fontStyle.equals("bolditalic")) {
            return new Font(str.substring(0, lastSeparator), 3, fontSize);
        }
        return new Font(str, 0, fontSize);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

