/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class CuiTreeControlIcon
implements Icon,
UIResource,
Serializable {
    protected int size_;
    protected boolean open_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery((String[])argv, (String)"@(#)ptk2 2.7 200609011020 (Sun Microsystems Inc.|1.4.2_05|48.0|Linux|2.6.7-2.2smp|i386|batbuild)");
    }

    public CuiTreeControlIcon() {
        this(11, false);
    }

    public CuiTreeControlIcon(int size, boolean open) {
        this.size_ = (int)Math.round((double)size * CuiLookAndFeel.getScale());
        this.open_ = open;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color background;
        int weight = Math.max(1, this.size_ / 10);
        if (this.size_ > 25 && weight % 2 != this.size_ % 2) {
            ++weight;
        }
        if ((background = UIManager.getColor("P7")) == null) {
            background = c.getBackground();
        }
        g.setColor(background);
        g.fillRect(x, y, this.size_, this.size_);
        Color foreground = UIManager.getColor("P11");
        if (foreground == null) {
            foreground = c.getForeground();
        }
        g.setColor(foreground);
        for (int i = 0; i < weight; ++i) {
            g.drawRect(x + i, y + i, this.size_ - 2 * i - 1, this.size_ - 2 * i - 1);
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)g).fill(new Rectangle2D.Double(x + 2 * weight, (double)y + (double)(this.size_ - weight) / 2.0, this.size_ - 4 * weight, weight));
        if (!this.open_) {
            ((Graphics2D)g).fill(new Rectangle2D.Double((double)x + (double)(this.size_ - weight) / 2.0, y + 2 * weight, weight, this.size_ - 4 * weight));
        }
    }

    public int getIconWidth() {
        return this.size_;
    }

    public int getIconHeight() {
        return this.size_;
    }
}

