/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.PaintStatCapable;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.annotation.XpAnnotationConfig;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpAnnotationPolicy;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputListener;

public class XpAnnotationVc
extends XpVisualComponent
implements PaintStatCapable {
    public static final int MAX_ACTIVE_ANNOTATIONS = 128;
    private static boolean swingTooltips = true;
    private XpAnnotationModel xpa = null;
    private Color annotationColor = null;
    private boolean annotTooltip = true;
    private ActiveAnnotationDispatcher aad = new ActiveAnnotationDispatcher();
    private boolean aaDispatch = true;
    private int annotationKey = -999;
    private long totalPaintTime = 0L;
    private long paintCount = 0L;
    private boolean loadDirty = true;
    private boolean eventEnable = true;
    private boolean dirtyActive = false;
    private ActiveAnnotationSettings aas = new ActiveAnnotationSettings();
    private int curr_x = -1;
    private int curr_y = -1;
    private boolean curr_contains = false;

    public XpAnnotationVc() {
        this.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent e) {
                ((JComponent)e.getSource()).requestFocus();
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        this.configActiveAnnotation();
    }

    public XpAnnotationVc(XpAnnotationModel annotModel) {
        this();
        this.setAnnotationModel(annotModel);
    }

    public final void setEventEnable(boolean enable) {
        this.eventEnable = enable;
    }

    public final boolean isEventEnable() {
        return this.eventEnable;
    }

    public final void setActiveAnnotation(boolean aa) {
        this.aaDispatch = aa;
        this.configActiveAnnotation();
    }

    public final boolean isActiveAnnotation() {
        return this.aaDispatch;
    }

    protected final void configActiveAnnotation() {
        if (this.aaDispatch) {
            this.addMouseListener(this.aad);
            this.addMouseMotionListener(this.aad);
        } else {
            this.removeMouseListener(this.aad);
            this.removeMouseMotionListener(this.aad);
        }
    }

    public final XpAnnotationModel getAnnotationModel() {
        return this.xpa;
    }

    public final boolean contains(int x, int y) {
        if (this.eventEnable) {
            XpAnnotationModel annotModel;
            if (this.curr_x == x && this.curr_y == y) {
                return this.curr_contains;
            }
            this.curr_x = x;
            this.curr_y = y;
            this.curr_contains = false;
            if (!swingTooltips) {
                AnnotationToolTipManager.newmousePosition(x, y);
            }
            if ((annotModel = this.xpa) == null) {
                return false;
            }
            int cKey = annotModel.insideAnnotation(x, y);
            if (cKey < 0) {
                this.annotationKey = -1;
                return false;
            }
            if (this.isAnnotationTooltip()) {
                if (this.annotationKey != cKey) {
                    String tipString = this.aas.tooltips[cKey];
                    if (tipString == null) {
                        tipString = annotModel.getTooltip(cKey);
                    }
                    this.setToolTipText(tipString);
                }
                this.annotationKey = cKey;
                if (swingTooltips) {
                    this.curr_contains = true;
                    return true;
                }
                boolean isactive = this.aas.isActiveAnnotation(this.annotationKey);
                if (!isactive && this.annotationKey != -1) {
                    AnnotationToolTipManager.start(this, this.annotationKey, this.getToolTipText(), x, y);
                }
                this.curr_contains = isactive;
                return isactive;
            }
            this.annotationKey = -1;
        }
        return false;
    }

    private final void loadAnnotation() {
        XpAnnotationModel annotModel = this.xpa;
        if (annotModel != null) {
            annotModel.loadDicomTags();
            if (this.annotationColor != null) {
                annotModel.setForeground(this.annotationColor);
            }
        }
    }

    public final void setAnnotationModel(XpAnnotationModel annotModel) {
        this.xpa = annotModel;
        this.loadDirty = true;
    }

    public static void setAnnotationPolicy(XpAnnotationPolicy xap) {
        XpAnnotationModel.setAnnotationPolicy(xap);
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this.annotationColor = c;
        XpAnnotationModel annotModel = this.xpa;
        if (annotModel != null) {
            annotModel.setForeground(c);
        }
    }

    public void setMargin(int m) {
        XpAnnotationModel annotModel = this.xpa;
        if (annotModel != null) {
            annotModel.setMargin(m);
        }
    }

    public final long getPaintCount() {
        return this.paintCount;
    }

    public final long getTotalPaintTime() {
        return this.totalPaintTime;
    }

    public void paintComponent(Graphics g) {
        long t1 = System.currentTimeMillis();
        XpAnnotationModel annotModel = this.xpa;
        if (annotModel != null) {
            XpAnnotationConfig aConfig;
            if (this.dirtyActive) {
                this.aas.reload();
                this.dirtyActive = false;
            }
            if (this.loadDirty) {
                this.loadAnnotation();
                this.loadDirty = false;
            }
            if ((aConfig = annotModel.getAnnotationConfig()) != null) {
                aConfig.configAnnotation(this, (JComponent)this.getParent());
            }
            Rectangle vp = this.getBounds();
            annotModel.setProperty("ACTIVE_ANNOT_MAP", this.aas.actItems);
            annotModel.drawAnnotation(g, vp);
        }
        long ptime = System.currentTimeMillis() - t1;
        this.totalPaintTime += ptime;
        ++this.paintCount;
    }

    public boolean isAnnotationTooltip() {
        return this.annotTooltip;
    }

    public void setAnnotationTooltip(boolean annotTooltip) {
        this.annotTooltip = annotTooltip;
        if (!annotTooltip) {
            this.setToolTipText("");
        }
    }

    public String[] getAnnotationSegments() {
        if (this.xpa != null) {
            return this.xpa.getAnnotationSegments();
        }
        return null;
    }

    public void setActiveAnnotationListener(String annotSegment, MouseInputListener mil, String tooltip) {
        if (annotSegment != null) {
            this.aas.put(annotSegment, mil, tooltip);
            this.dirtyActive = true;
        }
    }

    public void setActiveAnnotationListener(String annotSegment, MouseInputListener mil) {
        this.setActiveAnnotationListener(annotSegment, mil, null);
    }

    public void clearActiveAnnotationListener(String annotSegment) {
        this.aas.remove(annotSegment);
        this.dirtyActive = true;
    }

    public void clearActiveAnnotationListeners() {
        this.aas.clear();
        this.dirtyActive = true;
    }

    static {
        String val = XpPropertiesManager.getProperty("jami.annotation.swingtooltips", "true");
        swingTooltips = true;
        if (val.toLowerCase().equals("false")) {
            swingTooltips = false;
        }
        XpLog.logger().config("JAMI Annotation, using Swing tooltips: " + swingTooltips);
    }

    private static class AnnotationToolTipManager {
        private static int INITIAL_DELAY = ToolTipManager.sharedInstance().getInitialDelay();
        private static int DISMISS_DELAY = ToolTipManager.sharedInstance().getDismissDelay();
        private static Popup tipWindow = null;
        private static JToolTip tip = null;
        private static XpAnnotationVc activeAVC = null;
        private static final int VIEWPAD = 1;
        private static Timer timer = new Timer(INITIAL_DELAY, new TTDrawer());
        private static Timer timererase = new Timer(DISMISS_DELAY, new TTEraser());
        private static boolean showtooltip = false;
        private static int text_x = 0;
        private static int text_y = 0;
        private static String text = "";
        private static int key = -1;
        private static int drawnKey;

        private AnnotationToolTipManager() {
        }

        public static void newmousePosition(int x, int y) {
            AnnotationToolTipManager.stop();
            AnnotationToolTipManager.eraseit();
        }

        public static void start(XpAnnotationVc avc, int annotkey, String msg, int x, int y) {
            activeAVC = avc;
            text = msg;
            text_x = x;
            text_y = y;
            int delay = ToolTipManager.sharedInstance().getInitialDelay();
            timer.setInitialDelay(delay);
            timer.setDelay(delay);
            key = annotkey;
            if (text != null && text.length() > 0) {
                timer.start();
            }
        }

        public static void eraseit() {
            if (tipWindow != null) {
                tipWindow.hide();
            }
            tipWindow = null;
        }

        public static void showit() {
            XpAnnotationVc c;
            if (tipWindow != null) {
                tipWindow.hide();
            }
            if ((c = activeAVC) != null && c.isShowing() && key != drawnKey) {
                Point screenLocation = c.getLocationOnScreen();
                tip = c.createToolTip();
                tip.setTipText(text);
                Dimension tipDim = tip.getPreferredSize();
                int x = screenLocation.x + text_x;
                int y = screenLocation.y + text_y - tipDim.height - 1;
                PopupFactory popupFactory = PopupFactory.getSharedInstance();
                tipWindow = popupFactory.getPopup(c, tip, x, y);
                tipWindow.show();
                drawnKey = key;
                timererase.start();
            }
        }

        public static void stop() {
            timer.stop();
            timererase.stop();
            showtooltip = false;
        }

        static {
            timer.setRepeats(false);
            timererase.setRepeats(false);
            drawnKey = -1;
        }

        private static class TTEraser
        implements ActionListener {
            private TTEraser() {
            }

            public void actionPerformed(ActionEvent e) {
                showtooltip = false;
                AnnotationToolTipManager.eraseit();
            }
        }

        private static class TTDrawer
        implements ActionListener {
            private TTDrawer() {
            }

            public void actionPerformed(ActionEvent e) {
                showtooltip = true;
                AnnotationToolTipManager.showit();
            }
        }
    }

    private class ActiveAnnotationDispatcher
    implements MouseInputListener {
        private int mouseAAKey = -1;
        private int motionAAKey = -1;

        private ActiveAnnotationDispatcher() {
        }

        public final void mouseClicked(MouseEvent e) {
            MouseInputListener mil;
            if (XpAnnotationVc.this.annotationKey >= 0 && XpAnnotationVc.this.annotationKey < ((XpAnnotationVc)XpAnnotationVc.this).aas.activeAnno.length && (mil = ((XpAnnotationVc)XpAnnotationVc.this).aas.activeAnno[XpAnnotationVc.this.annotationKey]) != null) {
                mil.mouseClicked(e);
            }
        }

        public final void mousePressed(MouseEvent e) {
            MouseInputListener mil;
            this.mouseAAKey = XpAnnotationVc.this.annotationKey;
            if (this.mouseAAKey >= 0 && this.mouseAAKey < ((XpAnnotationVc)XpAnnotationVc.this).aas.activeAnno.length && (mil = ((XpAnnotationVc)XpAnnotationVc.this).aas.activeAnno[this.mouseAAKey]) != null) {
                mil.mousePressed(e);
            }
        }

        public final void mouseReleased(MouseEvent e) {
            MouseInputListener mil;
            if (this.mouseAAKey >= 0 && this.mouseAAKey < ((XpAnnotationVc)XpAnnotationVc.this).aas.activeAnno.length && (mil = ((XpAnnotationVc)XpAnnotationVc.this).aas.activeAnno[this.mouseAAKey]) != null) {
                mil.mouseReleased(e);
            }
            this.mouseAAKey = -1;
        }

        public final void mouseEntered(MouseEvent e) {
            MouseInputListener mil;
            this.motionAAKey = XpAnnotationVc.this.annotationKey;
            if (this.motionAAKey >= 0 && this.motionAAKey < ((XpAnnotationVc)XpAnnotationVc.this).aas.activeAnno.length && (mil = ((XpAnnotationVc)XpAnnotationVc.this).aas.activeAnno[this.motionAAKey]) != null) {
                mil.mouseEntered(e);
            }
        }

        public final void mouseExited(MouseEvent e) {
            MouseInputListener mil;
            if (this.motionAAKey >= 0 && this.motionAAKey < ((XpAnnotationVc)XpAnnotationVc.this).aas.activeAnno.length && (mil = ((XpAnnotationVc)XpAnnotationVc.this).aas.activeAnno[this.motionAAKey]) != null) {
                mil.mouseExited(e);
            }
            this.motionAAKey = -1;
        }

        public final void mouseDragged(MouseEvent e) {
            MouseInputListener mil;
            if (this.mouseAAKey >= 0 && this.mouseAAKey < ((XpAnnotationVc)XpAnnotationVc.this).aas.activeAnno.length && (mil = ((XpAnnotationVc)XpAnnotationVc.this).aas.activeAnno[this.mouseAAKey]) != null) {
                mil.mouseDragged(e);
            }
        }

        public final void mouseMoved(MouseEvent e) {
            MouseInputListener mil;
            if (this.motionAAKey != XpAnnotationVc.this.annotationKey) {
                if (this.motionAAKey >= 0 && this.motionAAKey < ((XpAnnotationVc)XpAnnotationVc.this).aas.activeAnno.length && (mil = ((XpAnnotationVc)XpAnnotationVc.this).aas.activeAnno[this.motionAAKey]) != null) {
                    mil.mouseExited(e);
                }
                this.motionAAKey = XpAnnotationVc.this.annotationKey;
                if (this.motionAAKey >= 0 && this.motionAAKey < ((XpAnnotationVc)XpAnnotationVc.this).aas.activeAnno.length && (mil = ((XpAnnotationVc)XpAnnotationVc.this).aas.activeAnno[this.motionAAKey]) != null) {
                    mil.mouseEntered(e);
                }
            }
            if (this.motionAAKey >= 0 && this.mouseAAKey < ((XpAnnotationVc)XpAnnotationVc.this).aas.activeAnno.length && (mil = ((XpAnnotationVc)XpAnnotationVc.this).aas.activeAnno[this.motionAAKey]) != null) {
                mil.mouseMoved(e);
            }
        }
    }

    private class ActiveAnnotationSettings {
        public boolean[] actItems = new boolean[128];
        public String[] tooltips = new String[128];
        public MouseInputListener[] activeAnno = new MouseInputListener[128];
        private Map aaListeners = new HashMap();

        private ActiveAnnotationSettings() {
        }

        public void put(String segmentName, MouseInputListener mil, String tooltip) {
            Object[] oinfo = new Object[]{mil, tooltip};
            this.aaListeners.put(segmentName, oinfo);
        }

        public void reload() {
            for (int i = 0; i < this.activeAnno.length; ++i) {
                this.activeAnno[i] = null;
                this.actItems[i] = false;
                this.tooltips[i] = null;
            }
            for (Map.Entry me : this.aaListeners.entrySet()) {
                String segment = (String)me.getKey();
                Object[] l = (Object[])me.getValue();
                MouseInputListener mil = (MouseInputListener)l[0];
                String tooltip = (String)l[1];
                int key = XpAnnotationVc.this.xpa.getAnnotationKey(segment);
                if (key < 0 || key >= this.activeAnno.length) continue;
                this.activeAnno[key] = mil;
                this.actItems[key] = mil != null;
                this.tooltips[key] = tooltip;
            }
        }

        public final boolean isActiveAnnotation(int key) {
            if (key >= 0 && key < this.actItems.length) {
                return this.actItems[key];
            }
            return false;
        }

        public void remove(String segmentName) {
            this.aaListeners.remove(segmentName);
        }

        public void clear() {
            this.aaListeners.clear();
        }
    }
}

