/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.Selectable;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpSelectableOwner;
import com.ge.med.terra.jami.XpSelectionManager;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.XpUserAnnotationVc;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;

public class XpAppContext {
    private static Color SELECTED_COLOR = Color.yellow;
    private static Color UNSELECTED_COLOR = Color.cyan;
    private static boolean shadowed = false;
    private static XpAppContext app = null;
    private XpSelectionManager sm = null;

    private XpAppContext() {
        String smClass = XpPropertiesManager.getProperty("jami.selectionmanager", null);
        this.sm = smClass != null ? this.createSelectionManager(smClass) : new DSelectionManager();
    }

    private XpSelectionManager createSelectionManager(String implType) {
        XpSelectionManager implementation = (XpSelectionManager)XpPropertiesManager.create(implType);
        if (implementation == null) {
            XpLog.logger().warning("Cannot create implementation " + implType + ",  will use default selection manager.");
            implementation = new DSelectionManager();
        }
        return implementation;
    }

    public final XpSelectionManager getSelectionManager() {
        return this.sm;
    }

    public static XpAppContext instance() {
        if (app == null) {
            app = new XpAppContext();
        }
        return app;
    }

    public static final Color getSelectedColor() {
        return SELECTED_COLOR;
    }

    public static final Color getUnSelectedColor() {
        return UNSELECTED_COLOR;
    }

    public static final void setSelectedColor(Color scolor) {
        SELECTED_COLOR = scolor;
    }

    public static final void setUnSelectedColor(Color uscolor) {
        UNSELECTED_COLOR = uscolor;
    }

    public static final void setShadowed(boolean shadow) {
        shadowed = shadow;
    }

    public static final boolean isShadowed() {
        return shadowed;
    }

    private static class AWTRecorder
    implements AWTEventListener {
        private AWTRecorder() {
        }

        private int buttonMask(int mod) {
            boolean b3;
            int bmask = 0;
            boolean b1 = 0 != (mod & 0x10);
            boolean b2 = 0 != (mod & 8);
            boolean bl = b3 = 0 != (mod & 4);
            if (b1) {
                bmask |= 0x10;
            }
            if (b2) {
                bmask |= 8;
            }
            if (b3) {
                bmask |= 4;
            }
            return bmask;
        }

        public void eventDispatched(AWTEvent e) {
            if (e instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)e;
                Component c = (Component)me.getSource();
                int mod = me.getModifiers();
                if (e instanceof MouseWheelEvent) {
                    MouseWheelEvent mwe = (MouseWheelEvent)e;
                } else if (me.getID() != 502 && me.getID() != 501 && (me.getID() == 503 || me.getID() == 506)) {
                    Point p = c.getLocationOnScreen();
                }
            } else if (e instanceof KeyEvent) {
                KeyEvent ke = (KeyEvent)e;
                System.err.println("-- KeyEvent[" + ke.getSource() + "]");
            } else if (e instanceof FocusEvent) {
                FocusEvent fe = (FocusEvent)e;
                String name0 = fe.getComponent().toString().substring(0, fe.getComponent().toString().indexOf("["));
                String name1 = "" + fe.getOppositeComponent();
                System.err.println("-- FocusEvent: " + name0 + "   " + name1);
            }
        }
    }

    private static class DSelectionManager
    extends KeyAdapter
    implements XpSelectionManager,
    MouseListener {
        private List selected = new ArrayList();
        PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        private DSelectionManager() {
        }

        public final List getSelected() {
            return this.selected;
        }

        public final void addComponent(Component c) {
            if (c instanceof XpSelectableOwner) {
                XpSelectableOwner so = (XpSelectableOwner)((Object)c);
                Selectable[] s = so.getSelectable();
                if (s != null) {
                    for (int i = 0; i < s.length; ++i) {
                        this.addSelectable(s[i]);
                    }
                }
            } else if (c instanceof Selectable) {
                this.addSelectable((Selectable)((Object)c));
            }
            c.addKeyListener(this);
            c.addMouseListener(this);
        }

        public final void removeComponent(Component c) {
            if (c instanceof XpSelectableOwner) {
                XpSelectableOwner so = (XpSelectableOwner)((Object)c);
                Selectable[] s = so.getSelectable();
                if (s != null) {
                    for (int i = 0; i < s.length; ++i) {
                        this.removeSelectable(s[i]);
                    }
                }
            } else if (c instanceof Selectable) {
                this.removeSelectable((Selectable)((Object)c));
            }
            c.removeKeyListener(this);
            c.removeMouseListener(this);
        }

        public final void addSelectable(Selectable s) {
            if (s != null) {
                this.clear();
                this.select(s);
            }
        }

        public final void removeSelectable(Selectable s) {
            if (s != null) {
                this.selected.remove(s);
                s.setSelected(false);
                this.pcs.firePropertyChange("ComponentSelection", s, null);
            }
        }

        private void deleteTheSelectable(Selectable s, Object source) {
            if (s instanceof RoiActor) {
                ROICapable rc;
                RoiActor ra = (RoiActor)s;
                XpImageRoiVc roivc = (XpImageRoiVc)source;
                if (roivc != null && (rc = (ROICapable)((Object)roivc.findParentByClass(roivc, ROICapable.class))) != null) {
                    XpImage2DVc ivc = (XpImage2DVc)roivc.findParentByClass(roivc, XpImage2DVc.class);
                    if (ivc != null) {
                        ivc.requestFocus();
                    }
                    rc.remove(ra);
                }
            } else if (s instanceof XpUserAnnotationModel) {
                UserAnnoCapable uac;
                XpUserAnnotationModel uam = (XpUserAnnotationModel)s;
                XpUserAnnotationVc uavc = (XpUserAnnotationVc)source;
                if (uavc != null && (uac = (UserAnnoCapable)((Object)uavc.findParentByClass(uavc, UserAnnoCapable.class))) != null) {
                    XpImage2DVc ivc = (XpImage2DVc)uavc.findParentByClass(uavc, XpImage2DVc.class);
                    if (ivc != null) {
                        ivc.requestFocus();
                    }
                    uac.remove(uam);
                }
            }
        }

        public void keyPressed(KeyEvent ke) {
            int key = ke.getKeyCode();
            Object source = ke.getSource();
            if (key == 127) {
                int len = this.selected.size();
                if (len > 0) {
                    for (int i = 0; i < len; ++i) {
                        Selectable s = (Selectable)this.selected.get(0);
                        this.deleteTheSelectable(s, source);
                    }
                } else if (source instanceof XpSelectableOwner) {
                    XpSelectableOwner so = (XpSelectableOwner)source;
                    Selectable[] s = so.getSelectable();
                    this.deleteTheSelectable(s[0], so);
                }
            }
        }

        public void mouseClicked(MouseEvent me) {
        }

        private void select(Selectable s) {
            s.setSelected(true);
            if (s.isSelected()) {
                this.selected.add(s);
                this.pcs.firePropertyChange("ComponentSelection", null, s);
            }
        }

        private void doSelect(MouseEvent me) {
            boolean multi = 0 != (me.getModifiers() & 1);
            Object source = me.getSource();
            if (source instanceof XpSelectableOwner) {
                int ncleared = 0;
                if (!multi) {
                    ncleared = this.clear();
                }
                XpSelectableOwner so = (XpSelectableOwner)source;
                Selectable[] sel = so.getSelectable();
                int nselected = 0;
                if (sel != null) {
                    for (int i = 0; i < sel.length; ++i) {
                        this.select(sel[i]);
                        ++nselected;
                    }
                }
                if (nselected == 0 && ncleared > 0) {
                    this.pcs.firePropertyChange("ComponentSelection", null, null);
                }
            } else {
                this.clearSelection();
            }
            Component c = (Component)source;
            c.repaint();
        }

        public void mouseReleased(MouseEvent me) {
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            Object o = me.getSource();
            if (o instanceof Component) {
                ((Component)o).requestFocus();
            }
            this.doSelect(me);
        }

        private int clear() {
            int len = this.selected.size();
            int ncleared = 0;
            for (int i = 0; i < len; ++i) {
                Selectable s = (Selectable)this.selected.get(i);
                if (!s.isSelected()) continue;
                s.setSelected(false);
                ++ncleared;
            }
            this.selected.clear();
            return ncleared;
        }

        public final void clearSelection() {
            if (this.clear() > 0) {
                this.pcs.firePropertyChange("ComponentSelection", null, null);
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public void addPropertyChangeListener(String name, PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(name, l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        public void removePropertyChangeListener(String name, PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(name, l);
        }
    }
}

