/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageUtils;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class XpPixelStatistics {
    public double min = 0.0;
    public double max = 0.0;
    public double sum = 0.0;
    public double sumSq = 0.0;
    public double diffsumSq = 0.0;
    public double mean = 0.0;
    public double variance = 0.0;
    public int npixels = -1;
    public Rectangle bounds = new Rectangle();
    private Map stats = new Hashtable();
    public static final byte[] bitmasks = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};

    public XpPixelStatistics() {
        this.resetStatistics();
    }

    public XpPixelStatistics(short[] data, int idx0, int idx1) {
        int i;
        this.sum = 0.0;
        this.npixels = 0;
        this.min = this.max = (double)data[idx0];
        for (i = idx0; i <= idx1; ++i) {
            this.sum += (double)data[i];
            this.sumSq += (double)(data[i] * data[i]);
            ++this.npixels;
            this.min = this.min > (double)data[i] ? (double)data[i] : this.min;
            this.max = this.max < (double)data[i] ? (double)data[i] : this.max;
        }
        this.mean = this.sum / (double)this.npixels;
        for (i = idx0; i <= idx1; ++i) {
            this.diffsumSq += (this.mean - (double)data[i]) * (this.mean - (double)data[i]);
        }
        this.variance = this.diffsumSq / (double)(this.npixels - 1);
    }

    public XpPixelStatistics(XpImage img) {
        this();
        int pixelRepresentation = XpImageUtils.getPixelRepresentation(img);
        XpImageUtils.calcStats(img.getPixelData(), img.getRescaleSlope(), img.getRescaleIntercept(), pixelRepresentation, 1, this);
    }

    public XpPixelStatistics(XpImage img, BufferedImage bitmap) {
        this();
        int w = img.getSlice().width;
        int h = img.getSlice().height;
        RenderedImage ri = img.getPixelData();
        int pixelRepresentation = XpImageUtils.getPixelRepresentation(img);
        XpImageUtils.calcStats(ri, bitmap, img.getRescaleSlope(), img.getRescaleIntercept(), pixelRepresentation, 0, 0, w - 1, h - 1, this);
    }

    public XpPixelStatistics(XpImage img, int subsample) {
        this();
        int pixelRepresentation = XpImageUtils.getPixelRepresentation(img);
        XpImageUtils.calcStats(img.getPixelData(), img.getRescaleSlope(), img.getRescaleIntercept(), pixelRepresentation, subsample, this);
    }

    public final Object getStatistic(String statisticName) {
        return this.stats.get(statisticName);
    }

    public final void setStatistic(String statisticsName, Object statValue) {
        this.stats.put(statisticsName, statValue);
    }

    public final void printStatistics() {
        System.out.println("  #Pixels  = " + this.npixels);
        System.out.println("  Max      = " + this.max);
        System.out.println("  Min      = " + this.min);
        System.out.println("  Sum      = " + this.sum);
        System.out.println("  Mean     = " + this.mean);
        System.out.println("  Std. Dev = " + this.getStdDev());
        Set entries = this.stats.entrySet();
        for (Map.Entry entry : entries) {
            System.out.println("  " + entry.getKey() + "  :  " + entry.getValue() + "  :  " + entry.getValue().getClass());
        }
        System.out.println("------------------------------------------");
    }

    public final void resetStatistics() {
        this.min = 0.0;
        this.max = 0.0;
        this.mean = 0.0;
        this.variance = 0.0;
        this.sum = 0.0;
        this.sumSq = 0.0;
        this.npixels = 0;
        this.diffsumSq = 0.0;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getMean() {
        return this.mean;
    }

    public double getVariance() {
        return this.variance;
    }

    public final double getStdDev() {
        return Math.sqrt(this.variance);
    }

    public double getSum() {
        return this.sum;
    }

    public double getSumSq() {
        return this.sumSq;
    }

    public int getNumPixels() {
        return this.npixels;
    }
}

