/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.annotation;

import com.ge.med.StdAnno.ApAppearance;
import com.ge.med.StdAnno.ApDicomAccessor;
import com.ge.med.StdAnno.ApDicomElement;
import com.ge.med.StdAnno.ApGroup;
import com.ge.med.StdAnno.ApLocation;
import com.ge.med.StdAnno.ApSeg;
import com.ge.med.StdAnno.ApStyle;
import com.ge.med.StdAnno.ApTextDrawer;
import com.ge.med.StdAnno.CTApStyle;
import com.ge.med.StdAnno.MRApStyle;
import com.ge.med.StdAnno.PETApStyle;
import com.ge.med.StdAnno.SCApStyle;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.annotation.XpAnnotationConfig;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpAnnotationPolicy;
import com.ge.med.terra.jami.annotation.XpAnnotationPolicyManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class XpApdAnnotation
extends XpAnnotationModel {
    private static final int MAX_LINES = 64;
    private static final int LINE_OFFSET = 32;
    private static Map groupMap = new HashMap();
    private ApStyle _apStyle = null;
    private ApDicomAccessor _accesor = null;
    private AnnotationDrawer _ad = null;
    private int language = 3;
    private boolean doToolTip = true;
    private boolean apdEnabled = true;
    private boolean debug = false;
    private APDAnnotationGroups groups = null;
    private String[] segnames = new String[128];
    private int[] segnumber = new int[128];
    private ArrayList segments = null;
    private static Map configMap;
    private static XpAnnotationPolicyManager apm;

    public XpApdAnnotation(XpDicomObject mi, ApStyle apStyle) {
        super(mi);
        this._apStyle = apStyle;
        this._accesor = new StdDicomAccesor();
        this._apStyle.setValueAccessor(this._accesor);
        this._ad = this.createAnnotationDrawer();
        this._apStyle.setTextDrawer(this._ad);
        this._apStyle.reset();
        this._apStyle.setAllGroupsOn();
        this._apStyle.setCurrentPriority(0);
        Class<?> apStyleClass = this._apStyle.getClass();
        XpAnnotationConfig aConfig = this.getAnnotationConfig(apStyleClass);
        this.setAnnotationConfig(aConfig);
        this.groups = (APDAnnotationGroups)groupMap.get(apStyleClass);
        if (this.groups == null) {
            this.groups = new APDAnnotationGroups();
            XpApdAnnotation.parseGroups(this._apStyle, this.groups);
            groupMap.put(apStyleClass, this.groups);
        }
        this.buildSegments();
    }

    private static int apd2jamiSize(int apSize) {
        switch (apSize) {
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 1;
    }

    private static int apd2jamiStyle(int apStyle) {
        switch (apStyle) {
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    protected AnnotationDrawer createAnnotationDrawer() {
        return new AnnotationDrawer(this);
    }

    public void setTestRendering(boolean testRendering) {
        this._ad = testRendering ? new DebugAnnotationDrawer(this) : new AnnotationDrawer(this);
        this._apStyle.setTextDrawer(this._ad);
        this._apStyle.reset();
    }

    public int getAnnotationKey(String annotationItem) {
        for (int i = 0; i < this.segnames.length; ++i) {
            String s = this.segnames[i];
            if (s == null || !s.equals(annotationItem)) continue;
            return i;
        }
        return -1;
    }

    public String[] getAnnotationSegmentItems(int gnum) {
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < this.segnumber.length; ++i) {
            if (this.segnumber[i] == -1 || this.segnumber[i] != gnum) continue;
            al.add(this.segnames[i]);
        }
        String[] sa = new String[al.size()];
        System.arraycopy(al.toArray(), 0, sa, 0, al.size());
        return sa;
    }

    public String getSegmentName(int annotationKey) {
        return this.segnames[annotationKey];
    }

    private void updatePriority(int priority) {
        if (this._apStyle.getCurrentPriority() != priority) {
            this._apStyle.setCurrentPriority(priority);
        }
    }

    protected void buildSegments() {
        for (int i = 0; i < 128; ++i) {
            this.segnumber[i] = -1;
        }
        int nquads = this._apStyle.getNumQuads();
        for (int q = 0; q < nquads; ++q) {
            int startLine = this._apStyle.getStartLine(q);
            int endLine = this._apStyle.getLastLine(q);
            for (int l = startLine; l <= endLine; ++l) {
                int nsegs = this._apStyle.getNumSegments(q, l);
                for (int s = 0; s < nsegs; ++s) {
                    ApSeg seg = this._apStyle.getSegAt(q, l, s);
                    if (seg == null) continue;
                    this.segnames[seg.annotationKey] = seg.name;
                    this.segnumber[seg.annotationKey] = seg.groupNumber;
                }
            }
        }
    }

    public String[] getAnnotationSegments() {
        if (this.segments == null) {
            this.segments = new ArrayList();
            int nquads = this._apStyle.getNumQuads();
            for (int q = 0; q < nquads; ++q) {
                int startLine = this._apStyle.getStartLine(q);
                int endLine = this._apStyle.getLastLine(q);
                for (int l = startLine; l <= endLine; ++l) {
                    int nsegs = this._apStyle.getNumSegments(q, l);
                    for (int s = 0; s < nsegs; ++s) {
                        ApSeg seg = this._apStyle.getSegAt(q, l, s);
                        this.segments.add(seg != null ? seg.name : "");
                    }
                }
            }
        }
        String[] segs = new String[this.segments.size()];
        for (int i = 0; i < segs.length; ++i) {
            segs[i] = (String)this.segments.get(i);
        }
        return segs;
    }

    private static void parseGroups(ApStyle aps, APDAnnotationGroups groups) {
        ApGroup g = aps.getFirstGroup();
        while (g != null) {
            XpApdAnnotation.parseChildren(g, groups);
            g = aps.getNextGroup();
        }
    }

    public final ApStyle getApStyle() {
        return this._apStyle;
    }

    private static void parseChildren(ApGroup g, APDAnnotationGroups groups) {
        ApGroup c = g.getFirstChildGroup();
        if (c != null) {
            if (!groups.groupContainers.contains(g)) {
                groups.groupContainers.add(g);
            }
            while (c != null) {
                XpApdAnnotation.parseChildren(c, groups);
                c = g.getNextChildGroup();
            }
        } else if (!groups.groupLeaves.contains(g)) {
            groups.groupLeaves.add(g);
            groups.groupNumberMap.put(g.getGroupName(), new Integer(g.getGroupNumber()));
        }
    }

    private static void getChildGroups(ApGroup g, List l) {
        ApGroup child = g.getFirstChildGroup();
        while (child != null) {
            String gName = child.getGroupName();
            if (gName != null) {
                l.add(gName);
            }
            XpApdAnnotation.getChildGroups(child, l);
            child = g.getNextChildGroup();
        }
    }

    public String[] getAnnotationGroups() {
        int len = this.groups.groupContainers.size();
        String[] agNames = null;
        if (len > 0) {
            agNames = new String[len];
            for (int i = 0; i < len; ++i) {
                ApGroup ag = (ApGroup)this.groups.groupContainers.get(i);
                agNames[i] = ag.getGroupName();
            }
        }
        return agNames;
    }

    public String[] getAnnotationItems() {
        int len = this.groups.groupLeaves.size();
        String[] agNames = null;
        if (len > 0) {
            agNames = new String[len];
            for (int i = 0; i < len; ++i) {
                ApGroup ag = (ApGroup)this.groups.groupLeaves.get(i);
                agNames[i] = ag.getGroupName();
            }
        }
        return agNames;
    }

    public void setAnnotationGroup(String agName, boolean activate) {
        this._apStyle.setAllGroupsOff();
        ApGroup ag = this._apStyle.getGroup(agName);
        if (ag != null) {
            ag.setGroupState(activate);
        }
    }

    public String[] getAnnotationItems(String agName) {
        int len;
        String[] gnames = null;
        ArrayList l = (ArrayList)this.groups.groupMap.get(agName);
        if (l == null) {
            ApGroup g = this._apStyle.getGroup(agName);
            l = new ArrayList();
            XpApdAnnotation.getChildGroups(g, l);
        }
        if ((len = l.size()) > 0) {
            gnames = new String[len];
            for (int i = 0; i < len; ++i) {
                gnames[i] = (String)l.get(i);
            }
        }
        return gnames;
    }

    public void queryAnnotationItems(String[] annoItems, boolean[] queryRes) {
        int len = Math.min(queryRes.length, annoItems.length);
        for (int i = 0; i < len; ++i) {
            ApGroup ag = this._apStyle.getGroup(annoItems[i]);
            boolean sval = false;
            if (ag != null) {
                sval = ag.getGroupState();
            }
            queryRes[i] = sval;
        }
    }

    public boolean queryAnnotationItem(String aiName) {
        ApGroup ag = this._apStyle.getGroup(aiName);
        boolean sval = false;
        if (ag != null) {
            sval = ag.getGroupState();
        }
        return sval;
    }

    public void setAnnotationItems(String[] annoItems, boolean activate) {
        for (int i = 0; i < annoItems.length; ++i) {
            ApGroup ag = this._apStyle.getGroup(annoItems[i]);
            if (ag == null) continue;
            ag.setGroupState(activate);
        }
    }

    public int queryAnnoGroupNumber(String gname) {
        Integer num = (Integer)this.groups.groupNumberMap.get(gname);
        if (num != null) {
            return num;
        }
        return -1;
    }

    public static boolean registerAnnotationConfig(Class apStyle, String annotConfigClass) {
        if (ApStyle.class.isAssignableFrom(apStyle)) {
            configMap.put(apStyle, annotConfigClass);
            return true;
        }
        return false;
    }

    protected XpAnnotationConfig getAnnotationConfig(Class apStyle) {
        String className = (String)configMap.get(apStyle);
        if (className != null) {
            XpAnnotationConfig ac = XpApdAnnotation.createAnnotationConfig(className);
            return ac;
        }
        return null;
    }

    private static XpAnnotationConfig createAnnotationConfig(String className) {
        XpAnnotationConfig ac = null;
        Class<?> cl = null;
        try {
            cl = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            XpLog.logger().warning("XpAnnotationConfig class not found : " + className);
        }
        if (cl != null) {
            try {
                Class<?>[] paramType = null;
                Constructor<?> c = cl.getConstructor(paramType);
                if (c != null) {
                    Object[] args = null;
                    ac = (XpAnnotationConfig)c.newInstance(args);
                }
            }
            catch (NoSuchMethodException nsme) {
                nsme.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
            catch (InstantiationException ie) {
                ie.printStackTrace();
            }
        } else {
            XpLog.logger().warning("XpAnnotationConfig does not exist: " + className);
        }
        return ac;
    }

    public static ApStyle createApStyle(String className) {
        ApStyle as;
        block11: {
            as = null;
            try {
                Class<?> cl = Class.forName(className);
                if (cl == null) break block11;
                try {
                    Class<?>[] paramType = null;
                    Constructor<?> c = cl.getConstructor(paramType);
                    if (c != null) {
                        Object[] args = null;
                        as = (ApStyle)c.newInstance(args);
                    }
                }
                catch (NoSuchMethodException nsme) {
                    nsme.printStackTrace();
                }
                catch (InvocationTargetException ite) {
                    ite.printStackTrace();
                }
                catch (IllegalAccessException iae) {
                    iae.printStackTrace();
                }
                catch (InstantiationException ie) {
                    ie.printStackTrace();
                }
            }
            catch (IllegalArgumentException ex) {
            }
            catch (SecurityException ex) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (as == null) {
            XpLog.logger().warning("Error loading ApStyle " + className);
        }
        return as;
    }

    public void loadDicomTags() {
        String[] strTags = this._apStyle.getDicomTags();
        int len = strTags.length;
        XpDicomElement[] de = new XpDicomElement[len];
        for (int i = 0; i < len; ++i) {
            StringTokenizer st = new StringTokenizer(strTags[i], ",");
            int group = Integer.parseInt(st.nextToken());
            int element = Integer.parseInt(st.nextToken());
            de[i] = new XpDicomElement(group, element);
        }
        this.getDicomObject().getValues(de);
        this.setTagsLoaded(true);
    }

    public final int getNumLanguages() {
        return 10;
    }

    public final void setLanguage(int languageIdx) {
        if (languageIdx >= 0 && languageIdx < 10) {
            this.language = languageIdx;
        }
    }

    public final int getLanguage() {
        return this.language;
    }

    public int insideAnnotation(int x, int y) {
        if (this.apdEnabled && this.doToolTip) {
            return this._ad.insideAnnotation(x, y);
        }
        return -1;
    }

    public String getTooltip(int key) {
        String tooltip = this._apStyle.getTooltip(this.language, key);
        if (tooltip != null) {
            return tooltip;
        }
        return "";
    }

    public final void setProperty(String propName, String value) {
        this._apStyle.setRTVar(propName, value);
    }

    public final void setProperty(String propName, double value) {
        this._apStyle.setRTVar(propName, value);
    }

    public final void setProperty(String propName, long value) {
        this._apStyle.setRTVar(propName, value);
    }

    public final void setProperty(String propName, int value) {
        this._apStyle.setRTVar(propName, value);
    }

    public final void setProperty(String propName, boolean value) {
        this._apStyle.setRTVar(propName, value);
    }

    public void setProperty(String propName, Object value) {
        if (propName.equals("ACTIVE_ANNOT_MAP")) {
            this._ad.setActiveAnnotationMap((boolean[])value);
        }
    }

    public void drawAnnotation(Graphics g, Rectangle bounds) {
        if (!this.isTagsLoaded()) {
            return;
        }
        int w = (int)bounds.getWidth();
        int h = (int)bounds.getHeight();
        if (w > 100 && h > 100) {
            XpAnnotationPolicyManager apm = XpApdAnnotation.getAnnotationPolicyManager();
            Font f = apm.getAnnotationFont(w, h);
            g.setFont(f);
            this._ad.setGraphicBounds(g, bounds);
            this._apStyle.paintAnnotation();
            this.apdEnabled = true;
        } else {
            this.apdEnabled = false;
        }
    }

    private static XpAnnotationPolicyManager getAnnotationPolicyManager() {
        XpAnnotationPolicy ap = XpApdAnnotation.getAnnotationPolicy();
        if (ap instanceof XpAnnotationPolicyManager) {
            apm = (XpAnnotationPolicyManager)ap;
        } else if (apm == null) {
            apm = new AnnotationPolicyManager(ap);
        }
        return apm;
    }

    static {
        XpLog.logger().fine("JAMI APD: Configured with 10 languages.");
        configMap = new HashMap();
        configMap.put(CTApStyle.class, "com.ge.med.terra.jami.annotation.XpMRCTApdAnnotationConfig$CT");
        configMap.put(SCApStyle.class, "com.ge.med.terra.jami.annotation.XpMRCTApdAnnotationConfig$CTScout");
        configMap.put(MRApStyle.class, "com.ge.med.terra.jami.annotation.XpMRCTApdAnnotationConfig$MR");
        configMap.put(PETApStyle.class, "com.ge.med.terra.jami.annotation.XpMRCTApdAnnotationConfig$PETFull");
        apm = null;
    }

    private static class APDAnnotationGroups {
        public List groupContainers = new ArrayList();
        public List groupLeaves = new ArrayList();
        public Map groupMap = new HashMap();
        public Map groupNumberMap = new HashMap();

        private APDAnnotationGroups() {
        }
    }

    private static class DebugAnnotationDrawer
    extends AnnotationDrawer {
        private boolean nwlarge = true;
        private int nwline = -99;
        private boolean swlarge = true;
        private int swline = -99;

        public DebugAnnotationDrawer(XpApdAnnotation apdAnnot) {
            super(apdAnnot);
        }

        public void draw(StringBuffer stringBuff, ApLocation location, ApAppearance appearance, int annotKey) {
            ApAppearance ap = new ApAppearance(appearance.fontSize, appearance.fontStyle, appearance.direction, appearance.color);
            if (location.quadrant == 3) {
                if (location.line != this.nwline) {
                    this.nwlarge = !this.nwlarge;
                    this.nwline = location.line;
                }
                ap.fontSize = this.nwlarge ? 2 : 0;
            } else if (location.quadrant == 5) {
                if (location.line != this.swline) {
                    this.swlarge = !this.swlarge;
                    this.swline = location.line;
                }
                if (this.swlarge) {
                    ap.fontSize = 2;
                    ap.fontStyle = 1;
                } else {
                    ap.fontSize = 0;
                }
            } else if (location.quadrant == 1 && location.line == 0) {
                ap.fontSize = 3;
            }
            super.draw(stringBuff, location, ap, annotKey);
        }
    }

    private static class LineDrawBuffer {
        private final int BUFF_LEN = 16;
        private AnnotationDrawer ad = null;
        private XpApdAnnotation apdAnnot = null;
        private int[][] line_heights = new int[9][64];
        private int lenDB = 0;
        private Point p = new Point();
        private String[] strings = new String[16];
        private boolean[] active = new boolean[16];
        private Point[] pts = new Point[16];
        private double[] width = new double[16];
        private double[] height = new double[16];
        private int[] annotKey = new int[16];
        private double twidth = 0.0;
        private double theight = 0.0;
        private int NORMALSIZE_LINEHEIGHT = 0;

        public LineDrawBuffer(XpApdAnnotation apdAnnot, AnnotationDrawer ad) {
            this.apdAnnot = apdAnnot;
            this.ad = ad;
            for (int i = 0; i < this.pts.length; ++i) {
                this.pts[i] = new Point();
            }
        }

        public final void addString(String str, Rectangle viewport, int fontSize, int fontStyle, int key, FontRenderContext frc, boolean isActive) {
            this.strings[this.lenDB] = str;
            Rectangle2D r = this.getStringBounds(str, viewport, fontSize, fontStyle, frc);
            double w = r.getWidth();
            double h = r.getHeight();
            this.width[this.lenDB] = w;
            this.height[this.lenDB] = h;
            this.annotKey[this.lenDB] = key;
            this.active[this.lenDB] = isActive;
            this.twidth += w;
            this.theight = h;
            ++this.lenDB;
        }

        private Rectangle2D getStringBounds(String s, Rectangle viewport, int fontSize, int fontStyle, FontRenderContext frc) {
            int style;
            int size;
            int len = s.length();
            XpAnnotationPolicyManager apm = XpApdAnnotation.getAnnotationPolicyManager();
            Font f = apm.getAnnotationFont(viewport.width, viewport.height, size = XpApdAnnotation.apd2jamiSize(fontSize), style = XpApdAnnotation.apd2jamiStyle(fontStyle));
            Rectangle2D b2 = f.getStringBounds(s, frc);
            if (b2.getHeight() < 5.0) {
                b2 = f.createGlyphVector(frc, s).getLogicalBounds();
            }
            if (fontSize == 1) {
                this.NORMALSIZE_LINEHEIGHT = (int)b2.getHeight();
            }
            return b2;
        }

        private int calcPixelLineOffset(int quadrant, int lineno, int itemHeight) {
            this.line_heights[quadrant][32 + lineno] = itemHeight;
            int pixline = 0;
            int nlines = Math.abs(lineno);
            if (lineno < 0) {
                for (int i = 0; i < nlines; ++i) {
                    int lh = this.line_heights[quadrant][32 - i];
                    if (lh == 0) {
                        int n = this.NORMALSIZE_LINEHEIGHT;
                        this.line_heights[quadrant][32 - i] = n;
                        lh = n;
                    }
                    pixline -= lh;
                }
            } else {
                for (int i = 0; i < nlines; ++i) {
                    int lh = this.line_heights[quadrant][32 + i];
                    if (lh == 0) {
                        int n = this.NORMALSIZE_LINEHEIGHT;
                        this.line_heights[quadrant][32 - i] = n;
                        lh = n;
                    }
                    pixline += lh;
                }
            }
            return pixline;
        }

        private void mapLocation(ApLocation l, Rectangle viewport, int w, int h, Point p) {
            int quadrant = l.quadrant;
            int lineno = l.line;
            int pixline = this.calcPixelLineOffset(quadrant, lineno, h);
            int pixmargin = this.apdAnnot.getMargin();
            int midHeight = (int)(viewport.getHeight() * 0.5);
            int midWidth = (int)(viewport.getWidth() * 0.5);
            int x = pixmargin;
            int y = 20;
            switch (quadrant) {
                case 8: {
                    y = midHeight + pixline;
                    x = midWidth;
                    break;
                }
                case 0: {
                    y = midHeight + pixline;
                    x = (int)(viewport.getWidth() - 3.0 - (double)w);
                    break;
                }
                case 4: {
                    y = midHeight + pixline;
                    x = pixmargin;
                    break;
                }
                case 6: {
                    x = midWidth - (w >> 1);
                    y = (int)(viewport.getHeight() + (double)pixline - 4.0);
                    break;
                }
                case 2: {
                    x = midWidth - (w >> 1);
                    y = pixline + h;
                    break;
                }
                case 3: {
                    y = pixline + h;
                    x = pixmargin;
                    break;
                }
                case 5: {
                    y = (int)(viewport.getHeight() + (double)pixline - 4.0);
                    x = pixmargin;
                    break;
                }
                case 1: {
                    y = pixline + h;
                    x = (int)(viewport.getWidth() - 3.0 - (double)w);
                    break;
                }
                case 7: {
                    y = (int)(viewport.getHeight() + (double)pixline - 4.0);
                    x = (int)(viewport.getWidth() - 3.0 - (double)w);
                }
            }
            p.x = x;
            p.y = y;
        }

        public final void drawIt(Graphics2D g, Rectangle viewport, ApLocation l, ApAppearance appearance) {
            if (this.lenDB <= 0) {
                return;
            }
            int w = 0;
            int h = 0;
            String outStr = "";
            Color col = Color.white;
            try {
                col = Color.decode(appearance.color);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (appearance.direction == 0) {
                w = (int)this.twidth;
                h = (int)this.theight;
                this.mapLocation(l, viewport, w, h, this.p);
                int offset = 0;
                for (int i = 0; i < this.lenDB; ++i) {
                    int lw = (int)this.width[i];
                    boolean isActive = this.active[i];
                    if (appearance.fontSize == 1) {
                        this.apdAnnot.line(g, this.strings[i], this.p.x + offset, this.p.y, isActive, col);
                    } else {
                        XpAnnotationPolicyManager apm = XpApdAnnotation.getAnnotationPolicyManager();
                        int size = XpApdAnnotation.apd2jamiSize(appearance.fontSize);
                        int style = XpApdAnnotation.apd2jamiStyle(appearance.fontStyle);
                        Font f = apm.getAnnotationFont(viewport.width, viewport.height, size, style);
                        this.apdAnnot.line(g, this.strings[i], this.p.x + offset, this.p.y, isActive, f, col);
                    }
                    offset += lw;
                }
                int x = this.p.x;
                int y = this.p.y - h;
                for (int i = 0; i < this.lenDB; ++i) {
                    int lh = (int)this.height[i];
                    int lw = (int)this.width[i];
                    this.ad.updateTooltipDB(l, this.annotKey[i], x, y, lw, lh);
                    x += lw;
                }
            } else {
                int dh = 1;
                boolean isActive = false;
                for (int i = 0; i < this.lenDB; ++i) {
                    isActive = this.active[i];
                    int lh = (int)this.height[i];
                    int lw = (int)this.width[i];
                    w += lw;
                    dh = lh;
                    String str = this.strings[i];
                    outStr = outStr + str;
                    int len = str.length();
                    this.height[i] = len * dh;
                    this.width[i] = this.width[i] / (double)len;
                }
                int len = outStr.length();
                h = len * dh;
                w = (int)((double)w / (double)len);
                this.mapLocation(l, viewport, w, h, this.p);
                if (appearance.fontSize == 1 && appearance.fontStyle == 0) {
                    this.apdAnnot.lineVertical(g, outStr, this.p.x, this.p.y, dh, isActive, col);
                } else {
                    XpAnnotationPolicyManager apm = XpApdAnnotation.getAnnotationPolicyManager();
                    int size = XpApdAnnotation.apd2jamiSize(appearance.fontSize);
                    int style = XpApdAnnotation.apd2jamiStyle(appearance.fontStyle);
                    Font f = apm.getAnnotationFont(viewport.width, viewport.height, size, style);
                    this.apdAnnot.lineVertical(g, outStr, this.p.x, this.p.y, dh, isActive, f, col);
                }
                int x = this.p.x;
                int y = this.p.y - dh;
                for (int i = 0; i < this.lenDB; ++i) {
                    int lh = (int)this.height[i];
                    int lw = (int)this.width[i];
                    this.ad.updateTooltipDB(l, this.annotKey[i], x, y, lw, lh);
                    y += lh;
                }
            }
        }

        public final void reset() {
            this.lenDB = 0;
            this.theight = 0.0;
            this.twidth = 0.0;
        }

        public final void resetLineHeights() {
            for (int i = 0; i < this.line_heights.length; ++i) {
                for (int j = 0; j < this.line_heights[i].length; ++j) {
                    this.line_heights[i][j] = 0;
                }
            }
        }
    }

    protected static class AnnotationDrawer
    implements ApTextDrawer {
        private XpApdAnnotation apdAnnot = null;
        private boolean[] actAnnotMap = null;
        private Graphics2D g = null;
        private Rectangle viewport = new Rectangle();
        private FontRenderContext frc = null;
        private StringBuffer outputBuffer = new StringBuffer();
        private LineDrawBuffer ldBuffer = null;
        private boolean flushIt = false;
        private boolean toFlush = false;
        private ApLocation prevLocation = new ApLocation();
        private ApAppearance prevAppearance = new ApAppearance();
        private Map[] locationMap = new Map[10];
        private List annotList = new ArrayList(75);

        public AnnotationDrawer(XpApdAnnotation apdAnnot) {
            this.apdAnnot = apdAnnot;
            this.ldBuffer = new LineDrawBuffer(apdAnnot, this);
        }

        public void open() {
            this.flushIt = false;
            this.outputBuffer.setLength(0);
            this.toFlush = false;
            int len = this.annotList.size();
            for (int i = 0; i < len; ++i) {
                AnnotationItem ai = (AnnotationItem)this.annotList.get(i);
                if (ai == null) continue;
                ai.visible = false;
            }
        }

        public void close() {
            if (this.toFlush) {
                this.ldBuffer.drawIt(this.g, this.viewport, this.prevLocation, this.prevAppearance);
                this.ldBuffer.reset();
                this.flushIt = true;
                this.toFlush = false;
            }
        }

        public int insideAnnotation(int x, int y) {
            int len = this.annotList.size();
            for (int i = 0; i < len; ++i) {
                AnnotationItem ai = (AnnotationItem)this.annotList.get(i);
                if (ai == null || !ai.visible) continue;
                int x2 = ai.x + ai.w;
                int y2 = ai.y + ai.h;
                if (x < ai.x || y < ai.y || x > x2 || y > y2) continue;
                return ai.key;
            }
            return -1;
        }

        public final void setGraphicBounds(Graphics gr, Rectangle b2) {
            this.g = (Graphics2D)gr;
            this.viewport.setBounds(b2);
            int w = (int)b2.getWidth();
            int h = (int)b2.getHeight();
            this.ldBuffer.resetLineHeights();
            this.frc = this.g.getFontRenderContext();
            int priority = 1;
            XpAnnotationPolicy policy = XpAnnotationModel.getAnnotationPolicy();
            if (policy != null) {
                priority = policy.getAnnotationPriority(w, h);
            }
            this.apdAnnot.updatePriority(priority);
        }

        public void updateTooltipDB(ApLocation l, int annotKey, int x, int y, int w, int h) {
            int quadrant = l.quadrant;
            int lineno = l.line;
            HashMap m = this.locationMap[quadrant];
            if (m == null) {
                this.locationMap[quadrant] = m = new HashMap(32);
            }
            Integer lineKey = new Integer(lineno);
            Integer keyAnnot = new Integer(annotKey);
            HashMap<Integer, AnnotationItem> aline = (HashMap<Integer, AnnotationItem>)m.get(lineKey);
            AnnotationItem ai = null;
            if (aline == null) {
                aline = new HashMap<Integer, AnnotationItem>();
                ai = new AnnotationItem();
                String sname = this.apdAnnot.getSegmentName(annotKey);
                ai.name = sname != null ? sname : "";
                ai.key = annotKey;
                aline.put(keyAnnot, ai);
                m.put(lineKey, aline);
                this.annotList.add(ai);
            } else {
                ai = (AnnotationItem)aline.get(keyAnnot);
                if (ai == null) {
                    ai = new AnnotationItem();
                    ai.key = annotKey;
                    String sname = this.apdAnnot.getSegmentName(annotKey);
                    ai.name = sname != null ? sname : "";
                    aline.put(keyAnnot, ai);
                    this.annotList.add(ai);
                }
            }
            ai.w = w;
            ai.h = h;
            ai.x = x;
            ai.y = y;
            ai.visible = true;
        }

        public void setActiveAnnotationMap(boolean[] actmap) {
            this.actAnnotMap = actmap;
        }

        public void draw(StringBuffer stringBuff, ApLocation location, ApAppearance appearance, int annotKey) {
            long t0 = System.currentTimeMillis();
            boolean appearanceChange = false;
            if (this.prevAppearance.fontSize != appearance.fontSize || this.prevAppearance.fontStyle != appearance.fontStyle) {
                appearanceChange = true;
            }
            if ((this.prevLocation.quadrant != location.quadrant || this.prevLocation.line != location.line || appearanceChange) && this.toFlush) {
                this.flushIt = true;
            }
            if (this.flushIt) {
                this.ldBuffer.drawIt(this.g, this.viewport, this.prevLocation, this.prevAppearance);
                this.flushIt = false;
                this.toFlush = false;
                this.ldBuffer.reset();
            }
            if (stringBuff != null) {
                boolean notspaces;
                String str = stringBuff.toString();
                boolean bl = notspaces = str.trim().length() > 0;
                if (notspaces) {
                    boolean isActive = this.actAnnotMap != null ? this.actAnnotMap[annotKey] : false;
                    this.ldBuffer.addString(str, this.viewport, appearance.fontSize, appearance.fontStyle, annotKey, this.frc, isActive);
                    this.toFlush = true;
                }
            }
            this.prevLocation.quadrant = location.quadrant;
            this.prevLocation.line = location.line;
            this.prevAppearance.color = appearance.color;
            this.prevAppearance.direction = appearance.direction;
            this.prevAppearance.fontSize = appearance.fontSize;
            this.prevAppearance.fontStyle = appearance.fontStyle;
        }
    }

    private static class AnnotationPolicyManager
    implements XpAnnotationPolicyManager {
        private XpAnnotationPolicy ap = null;

        public AnnotationPolicyManager(XpAnnotationPolicy ap) {
            this.ap = ap;
        }

        public Font getAnnotationFont(int vp_width, int vp_height, int annotationSize, int annotationStyle) {
            return this.ap.getAnnotationFont(vp_width, vp_height);
        }

        public Font getAnnotationFont(int vp_width, int vp_height) {
            return this.ap.getAnnotationFont(vp_width, vp_height);
        }

        public int getAnnotationPriority(int vp_width, int vp_height) {
            return this.ap.getAnnotationPriority(vp_width, vp_height);
        }
    }

    private static class AnnotationItem {
        public int key;
        public String name = "";
        public int x;
        public int y;
        public int w;
        public int h;
        public boolean visible = false;

        private AnnotationItem() {
        }
    }

    private class StdDicomAccesor
    implements ApDicomAccessor {
        private XpDicomElement de = new XpDicomElement();
        private ApDicomElement val = new ApDicomElement();

        private StdDicomAccesor() {
        }

        public ApDicomElement getValue(int group, int element, int index, int vrDataType) {
            Object obj = null;
            double d = 0.0;
            this.de.group = group;
            this.de.element = element;
            int result = XpApdAnnotation.this.getDicomObject().getValue(this.de);
            if (result == 1) {
                this.val.isValued = false;
                this.val.apdString = "0";
                this.val.apdFloat = 0.0;
                this.val.apdInteger = 0;
                return this.val;
            }
            obj = this.de.value;
            if (obj instanceof Object[]) {
                Object[] arr = (Object[])obj;
                obj = index >= 0 && index < arr.length ? arr[index] : "XXXX";
            }
            if (obj instanceof String) {
                this.val.isValued = true;
                String str = (String)obj;
                try {
                    switch (vrDataType) {
                        case 0: {
                            d = Double.parseDouble(str);
                            this.val.apdInteger = (int)d;
                            if (XpApdAnnotation.this.debug) {
                                System.out.println("DicomAccesor: Integer   - " + d);
                            }
                            break;
                        }
                        case 1: {
                            this.val.apdFloat = d = Double.parseDouble(str);
                            if (XpApdAnnotation.this.debug) {
                                System.out.println("DicomAccesor: Float     - " + d);
                            }
                            break;
                        }
                        default: {
                            this.val.apdString = (String)obj;
                            if (XpApdAnnotation.this.debug) {
                                System.out.println("DicomAccesor: String    - " + obj);
                            }
                            break;
                        }
                    }
                }
                catch (NumberFormatException ex) {
                    this.val.apdFloat = 0.0;
                    this.val.apdInteger = 0;
                    this.val.apdString = "";
                }
            } else if (obj instanceof Integer) {
                this.val.isValued = true;
                Integer i = (Integer)obj;
                if (XpApdAnnotation.this.debug) {
                    System.out.println("DicomAccesor: Integer   - " + i);
                }
                this.val.apdInteger = i;
            } else if (obj instanceof Double) {
                this.val.isValued = true;
                Double dd = (Double)obj;
                if (XpApdAnnotation.this.debug) {
                    System.out.println("DicomAccesor: Float     - " + dd);
                }
                this.val.apdFloat = dd.floatValue();
            } else if (obj instanceof Float) {
                this.val.isValued = true;
                Float ff = (Float)obj;
                if (XpApdAnnotation.this.debug) {
                    System.out.println("DicomAccesor: Float     - " + ff);
                }
                this.val.apdFloat = ff.floatValue();
            } else if (obj instanceof Long) {
                this.val.isValued = true;
                Long ll = (Long)obj;
                if (XpApdAnnotation.this.debug) {
                    System.out.println("DicomAccesor: Integer   - " + ll);
                }
                this.val.apdInteger = ll.intValue();
            } else {
                this.val.isValued = false;
                this.val.apdString = "XXXXXXXXXXX";
            }
            return this.val;
        }
    }
}

