/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.XjFusionPixelCombiner;
import com.ge.med.idc.XjMemVolume;
import com.ge.med.idc.XjMultiChannelVolume;
import com.ge.med.idc.XjTagValue;
import com.ge.med.idc.XjVolume;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.T3DComponent;
import com.ge.med.terra.jami.j3d.T3DCompositePort;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JDataLoader {
    private XjVolume vol = null;

    public JDataLoader(XjVolume vol) {
        this.vol = vol;
    }

    public J3DVolumeModel[] loadVolumeModels() {
        int[] channels = new int[]{0};
        if (this.vol instanceof XjMultiChannelVolume) {
            XjMultiChannelVolume mvol = (XjMultiChannelVolume)this.vol;
            channels = new int[mvol.getNumChannels()];
            for (int i = 0; i < channels.length; ++i) {
                channels[i] = i;
            }
        }
        return this.loadVolumeModels(channels);
    }

    public J3DVolumeModel[] loadVolumeModels(int[] channels) {
        J3DVolumeModel[] vm = new J3DVolumeModel[channels.length];
        if (channels.length == 1 && channels[0] == 0) {
            vm[0] = new J3DVolumeModel(this.vol);
        } else {
            XjMultiChannelVolume mvol = (XjMultiChannelVolume)this.vol;
            int nchannels = channels.length;
            short[][] data = new short[nchannels][];
            int PAD = this.loadVoxelData(channels, data);
            for (int k = 0; k < nchannels; ++k) {
                ChannelShortVolume memvolume = new ChannelShortVolume(mvol, channels[k], PAD, data[k]);
                vm[k] = new J3DVolumeModel(memvolume);
            }
        }
        return vm;
    }

    private int loadVoxelData(int[] channels, short[][] data) {
        XjMultiChannelVolume mvol = (XjMultiChannelVolume)this.vol;
        int[] dims = mvol.getVolumeDimensions(null);
        int sliceLen = dims[0] * dims[1];
        int PAD = 2 * sliceLen;
        int nchannels = channels.length;
        for (int i = 0; i < nchannels; ++i) {
            data[i] = new short[2 * PAD + dims[0] * dims[1] * dims[2]];
        }
        boolean[] normalize = new boolean[nchannels];
        double[] rSlope = new double[nchannels];
        double[] sliceRSlope = new double[nchannels];
        for (int k = 0; k < nchannels; ++k) {
            normalize[k] = false;
            sliceRSlope[k] = Double.parseDouble("" + mvol.getVSliceValue(channels[k], 0, 40, 4179));
        }
        for (int i = 0; i < dims[2]; ++i) {
            for (int k = 0; k < nchannels; ++k) {
                rSlope[k] = Double.parseDouble("" + mvol.getVSliceValue(channels[k], i, 40, 4179));
            }
            JVolume.fillVolumeSlice(mvol, data, channels, sliceLen, PAD + i * sliceLen, i, rSlope, sliceRSlope, normalize);
        }
        return PAD;
    }

    public J3DVolumeModel loadMultiChannelVolumeModel() {
        int[] channels = new int[]{0};
        if (this.vol instanceof XjMultiChannelVolume) {
            XjMultiChannelVolume mvol = (XjMultiChannelVolume)this.vol;
            channels = new int[mvol.getNumChannels()];
            for (int i = 0; i < channels.length; ++i) {
                channels[i] = i;
            }
        }
        return this.loadMultiChannelVolumeModel(channels);
    }

    public J3DVolumeModel loadMultiChannelVolumeModel(int[] channels) {
        if (this.vol instanceof XjMultiChannelVolume) {
            XjMultiChannelVolume mvol = (XjMultiChannelVolume)this.vol;
            int nchannels = channels.length;
            short[][] data = new short[nchannels][];
            int PAD = this.loadVoxelData(channels, data);
            int pixelType = mvol.getPixelType();
            int bpp = mvol.getBitsPerVoxel();
            ChannelShortVolume memvol = new ChannelShortVolume(mvol, channels[0], PAD, data[0]);
            J3DVolumeModel jvm = new J3DVolumeModel(memvol);
            JVolume.LinearVolume[] jvols = new JVolume.LinearVolume[nchannels - 1];
            System.err.println(">>> Channel[0] : " + jvm.j_vol.rescaleSlope + "  " + jvm.j_vol.rescaleIntercept);
            for (int k = 1; k < nchannels; ++k) {
                ChannelShortVolume mv = new ChannelShortVolume(mvol, channels[k], PAD, data[k]);
                JVolume.LinearVolume j_vol = null;
                j_vol = pixelType != 2 && bpp == 8 ? new JVolume.LinearByte(mv) : new JVolume.LinearShort(mv);
                jvols[k - 1] = j_vol;
                System.err.println(">>> Channel[" + k + "] : " + j_vol.rescaleSlope + "  " + j_vol.rescaleIntercept);
            }
            if (jvols.length > 0) {
                jvm.attachAuxiliaryVolumes(jvols);
            }
            return jvm;
        }
        return new J3DVolumeModel(this.vol);
    }

    public static void main(String[] args) {
        DMSession dms = new DMSession(new String[]{"file", args[0]});
        DMObject[] dmo = dms.getRelated("series");
        DMVolume vol = DMVolume.buildVolume((String)"DMObjectVolume", (Object[])new Object[]{dmo[0]});
        int nchannels = vol.getNumChannels();
        JDataLoader loader = new JDataLoader((XjVolume)vol);
        int[] toLoad = new int[]{0};
        if (nchannels > 1) {
            toLoad = new int[nchannels - 1];
            for (int i = 1; i < nchannels; ++i) {
                toLoad[i - 1] = i;
            }
        }
        final J3DVolumeModel[] vm = loader.loadVolumeModels(toLoad);
        JFrame jf = new JFrame("JDataLoader: " + vol.getMultiChannelType());
        final T3DCompositePort port = new T3DCompositePort();
        final T3DViewport mergeport = new T3DViewport();
        port.setRowCol(1, 2);
        port.setPreferredSize(new Dimension(1200, 1200));
        port.setVolumeModel(vm[0]);
        mergeport.setVolumeModel(vm[0]);
        final PixelCombiner fpc = new PixelCombiner(mergeport);
        mergeport.getT3DComponent().setPixelCombiner(fpc);
        JPanel uiPanel = new JPanel();
        JPanel mainPanel = new JPanel();
        JPanel portPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        uiPanel.setLayout(new GridLayout(9, 1));
        mainPanel.add((Component)portPanel, "Center");
        mainPanel.add((Component)uiPanel, "West");
        port.setPreferredSize(new Dimension(1300, 512));
        JSplitPane sp = new JSplitPane(0, port, mergeport);
        sp.setDividerLocation(0.5);
        portPanel.setLayout(new GridLayout(1, 1));
        portPanel.add(sp);
        String[] labels = new String[toLoad.length];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = vol.getChannelName(toLoad[i]);
        }
        JScrollPane listscroll = new JScrollPane();
        final JList<String> listChannels = new JList<String>(labels);
        listChannels.setSelectedIndex(0);
        listscroll.setViewportView(listChannels);
        JButton applyButton = new JButton("Apply Fusion");
        final JComboBox<String> cb = new JComboBox<String>(labels);
        JPanel channelPanel = new JPanel();
        JPanel fusionPanel = new JPanel();
        fusionPanel.setLayout(new BorderLayout());
        fusionPanel.add((Component)listscroll, "Center");
        JPanel fuiPanel = new JPanel();
        fuiPanel.add(applyButton);
        fusionPanel.add((Component)fuiPanel, "South");
        fusionPanel.setBorder(BorderFactory.createEtchedBorder());
        channelPanel.setBorder(BorderFactory.createEtchedBorder());
        channelPanel.setLayout(new GridLayout(3, 2));
        channelPanel.add(new JLabel("Channel: "));
        channelPanel.add(cb);
        channelPanel.add(new JLabel("Combiner Alpha: "));
        final JSlider alphaSlider = new JSlider();
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("0"));
        labelTable.put(new Integer(100), new JLabel("1"));
        alphaSlider.setLabelTable(labelTable);
        alphaSlider.setPaintLabels(true);
        channelPanel.add(alphaSlider);
        uiPanel.add(fusionPanel);
        uiPanel.add(channelPanel);
        listChannels.setSelectionMode(2);
        listChannels.setBorder(BorderFactory.createEtchedBorder());
        cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int idx = cb.getSelectedIndex();
                port.setVolumeModel(vm[idx]);
                port.refreshContents();
            }
        });
        applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] sels = listChannels.getSelectedIndices();
                if (sels != null) {
                    int i;
                    System.err.println(">>>> Merging....");
                    mergeport.setVolumeModel(vm[sels[0]]);
                    T3DComponent t3d = mergeport.getT3DComponent();
                    int volLayers = t3d.getNumVolumeLayers();
                    for (i = volLayers - 1; i >= 1; --i) {
                        t3d.removeVolumeLayer(i);
                    }
                    for (i = 1; i < sels.length; ++i) {
                        t3d.addVolumeLayer(vm[sels[i]]);
                    }
                }
                mergeport.refreshContents();
            }
        });
        alphaSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int val = alphaSlider.getValue();
                double dval = (double)val / (double)alphaSlider.getMaximum();
                fpc.setAlpha(dval);
            }
        });
        jf.setContentPane(mainPanel);
        jf.pack();
        jf.setVisible(true);
        jf.setDefaultCloseOperation(3);
    }

    private static class PixelCombiner
    implements XjFusionPixelCombiner {
        private static final int SHIFT = 12;
        private static final int SCALE = 4096;
        private double alpha = 0.5;
        private boolean color = false;
        private T3DViewport iv = null;

        public PixelCombiner(T3DViewport iv) {
            this.iv = iv;
        }

        public void setColor(boolean color) {
            this.color = color;
        }

        public void setAlpha(double alpha) {
            this.alpha = alpha;
            this.iv.refreshContents();
            this.iv.repaint();
        }

        public void blendRGB(int[][] pixels, int width, int height, int[] result) {
            int ialpha = (int)(this.alpha * 4096.0);
            int len = width * height;
            int D = 4096 - ialpha;
            if (this.color) {
                for (int i = 0; i < len; ++i) {
                    int pixel1 = pixels[0][i];
                    int bval1 = pixel1 & 0xFF;
                    int gval1 = (pixel1 & 0xFF00) >> 8;
                    int rval1 = (pixel1 & 0xFF0000) >> 16;
                    int pixel2 = pixels[1][i];
                    int bval2 = pixel2 & 0xFF;
                    int gval2 = (pixel2 & 0xFF00) >> 8;
                    int rval2 = (pixel2 & 0xFF0000) >> 16;
                    int rval = rval1 * ialpha + rval2 * D >> 12;
                    int gval = gval1 * ialpha + gval2 * D >> 12;
                    int bval = bval1 * ialpha + bval2 * D >> 12;
                    result[i] = 0xFF000000 | rval << 16 | gval << 8 | bval;
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    int pixel1 = pixels[0][i] & 0xFF;
                    int pixel2 = pixels[1][i] & 0xFF;
                    int val = pixel1 * ialpha + pixel2 * D >> 12;
                    result[i] = 0xFF000000 | val << 16 | val << 8 | val;
                }
            }
        }
    }

    private static class ChannelShortVolume
    implements XjMemVolume {
        private int channelNo = -1;
        private XjMultiChannelVolume mvol = null;
        private short[] volData = null;
        private int PAD = 0;
        private int sliceLen = 0;

        public ChannelShortVolume(XjMultiChannelVolume mvol, int channelNo, int PAD, short[] volData) {
            this.mvol = mvol;
            this.channelNo = channelNo;
            this.PAD = PAD;
            this.volData = volData;
            int[] dims = this.mvol.getVolumeDimensions(null);
            this.sliceLen = dims[0] * dims[1];
        }

        public Object getSliceData(int sliceNo) {
            return this.volData;
        }

        public int getSliceOffset(int sliceNo) {
            return this.PAD + sliceNo * this.sliceLen;
        }

        public boolean isContiguous() {
            return true;
        }

        public int getBitsPerVoxel() {
            return this.mvol.getBitsPerVoxel();
        }

        public int getPixelType() {
            return this.mvol.getPixelType();
        }

        public Object getVSliceValue(int sliceNo, int group, int element) {
            return this.mvol.getVSliceValue(this.channelNo, sliceNo, group, element);
        }

        public String getRelatedComposite() {
            return this.mvol.getVSlicePath(this.channelNo, 0);
        }

        public Object getValue(int group, int element) {
            return this.getVSliceValue(0, group, element);
        }

        public int getValues(XjTagValue[] tv) {
            int nvals = 0;
            for (int i = 0; i < tv.length; ++i) {
                tv[i].value = this.getValue(tv[i].group, tv[i].element);
                if (tv[i].value == null) continue;
                ++nvals;
            }
            return nvals;
        }

        public int[] getVolumeDimensions(int[] dims) {
            return this.mvol.getVolumeDimensions(dims);
        }

        public double[] getRASOfOrigin(double[] ras_ulc) {
            return this.mvol.getRASOfOrigin(ras_ulc);
        }

        public double[] getXDirectionRAS(double[] ras_dx) {
            return this.mvol.getXDirectionRAS(ras_dx);
        }

        public double[] getYDirectionRAS(double[] ras_dy) {
            return this.mvol.getYDirectionRAS(ras_dy);
        }

        public double[] getZDirectionRAS(double[] ras_dz) {
            return this.mvol.getZDirectionRAS(ras_dz);
        }
    }
}

