/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DCapable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class T3DCapableEditor
extends JDialog {
    protected T3DCapable t3d_;
    protected JTextField eyexField_ = new JTextField();
    protected JTextField eyeyField_ = new JTextField();
    protected JTextField eyezField_ = new JTextField();
    protected JTextField lookxField_ = new JTextField();
    protected JTextField lookyField_ = new JTextField();
    protected JTextField lookzField_ = new JTextField();
    protected JTextField upxField_ = new JTextField();
    protected JTextField upyField_ = new JTextField();
    protected JTextField upzField_ = new JTextField();
    protected JTextField vhField_ = new JTextField();
    private JTextField vclipeFieldMinus_ = new JTextField();
    private JTextField vclipeFieldPlus_ = new JTextField();
    private static final NumberFormat nf_ = new DecimalFormat("####0.0#####");
    protected double[] up = new double[3];
    protected double[] look = new double[3];
    protected double[] eye = new double[3];
    protected double vh;
    protected double[] viewClip_ = new double[2];
    protected double[] orig = new double[3];
    protected double[] rasx = new double[3];
    protected double[] rasy = new double[3];
    protected double[] rasz = new double[3];
    static T3DCapableEditor editor_;

    public T3DCapableEditor(T3DCapable t3d, Frame parent) {
        super(parent);
        this.t3d_ = t3d;
        this.jbInit();
    }

    private void jbInit() {
        JPanel t3dEditPane = new JPanel(new BorderLayout());
        JPanel labelPane_ = new JPanel(new GridLayout(0, 1));
        labelPane_.add(new JLabel("Eye"));
        labelPane_.add(new JLabel("Look"));
        labelPane_.add(new JLabel("Up"));
        labelPane_.add(new JLabel("View Height"));
        labelPane_.add(new JLabel("View Clip"));
        JPanel valuePane = new JPanel(new GridLayout(0, 3));
        valuePane.add(this.eyexField_);
        valuePane.add(this.eyeyField_);
        valuePane.add(this.eyezField_);
        valuePane.add(this.lookxField_);
        valuePane.add(this.lookyField_);
        valuePane.add(this.lookzField_);
        valuePane.add(this.upxField_);
        valuePane.add(this.upyField_);
        valuePane.add(this.upzField_);
        valuePane.add(this.vhField_);
        valuePane.add(new JLabel());
        valuePane.add(new JLabel());
        valuePane.add(this.vclipeFieldMinus_);
        valuePane.add(this.vclipeFieldPlus_);
        t3dEditPane.add((Component)labelPane_, "Before");
        t3dEditPane.add(valuePane);
        this.populateFields();
    }

    public void setT3DCapable(T3DCapable t3d) {
        this.t3d_ = t3d;
        this.populateFields();
    }

    private void populateFields() {
        if (this.t3d_ != null) {
            this.t3d_.getUp(this.up);
            this.t3d_.getEyePoint(this.eye);
            this.t3d_.getLookPoint(this.look);
            this.vh = this.t3d_.getViewHeight();
            this.t3d_.getViewClip(this.viewClip_);
            this.t3d_.getWorldBounds(this.orig, this.rasx, this.rasy, this.rasz);
            this.lookxField_.setText(nf_.format(this.look[0]));
            this.lookyField_.setText(nf_.format(this.look[1]));
            this.lookzField_.setText(nf_.format(this.look[2]));
            this.upxField_.setText(nf_.format(this.up[0]));
            this.upyField_.setText(nf_.format(this.up[1]));
            this.upzField_.setText(nf_.format(this.up[2]));
            this.eyexField_.setText(nf_.format(this.eye[0]));
            this.eyeyField_.setText(nf_.format(this.eye[1]));
            this.eyezField_.setText(nf_.format(this.eye[2]));
            this.vclipeFieldMinus_.setText(nf_.format(this.viewClip_[0]));
            this.vclipeFieldPlus_.setText(nf_.format(this.viewClip_[1]));
        }
    }

    private void updateT3d() {
        this.eye[0] = Double.parseDouble(this.eyexField_.getText());
        this.eye[1] = Double.parseDouble(this.eyeyField_.getText());
        this.eye[2] = Double.parseDouble(this.eyezField_.getText());
        this.look[0] = Double.parseDouble(this.lookxField_.getText());
        this.look[1] = Double.parseDouble(this.lookyField_.getText());
        this.look[2] = Double.parseDouble(this.lookzField_.getText());
        this.up[0] = Double.parseDouble(this.lookxField_.getText());
        this.up[1] = Double.parseDouble(this.lookyField_.getText());
        this.up[2] = Double.parseDouble(this.lookzField_.getText());
        if (this.t3d_ != null) {
            // empty if block
        }
    }

    public static void main() {
        final JFrame f = new JFrame();
        JPanel p = new JPanel();
        JButton b2 = new JButton("Edit...");
        p.add(b2);
        b2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (editor_ == null) {
                    editor_ = new T3DCapableEditor(null, f);
                }
                editor_.setVisible(true);
            }
        });
        f.setContentPane(p);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }
}

