/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.marker;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.capable.SliceControlledCapable;
import com.ge.med.terra.jami.capable.SliceSourceCapable;
import com.ge.med.terra.jami.marker.XpSliceControlledMarker;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class XpSliceMarker
extends XpSliceControlledMarker {
    private SliceControlledCapable scc = null;
    private SliceSourceCapable ssc = null;
    private CPoint imgPt = new CPoint(0);
    private CPoint dispPt = new CPoint(1);
    private Point2D p1 = new Point2D.Double();
    private Point2D p2 = new Point2D.Double();
    private Point dp1 = new Point();
    private Point dp2 = new Point();
    private Point2D[] pts = new Point2D[2];

    public XpSliceMarker(double x, double y) {
        this.pts[0] = new Point2D.Double();
        this.pts[1] = new Point2D.Double();
        this.setForeground(Color.red);
    }

    public void setImage(XpImage img) {
        super.setImage(img);
        this.computeIntersection();
    }

    public void updateDisplayCoordinates() {
        CTransform ctc = this.getTransform((byte)0, (byte)1);
        if (ctc != null) {
            this.imgPt.setPoint(this.p1.getX(), this.p1.getY(), 0.0, (byte)0);
            ctc.transform(this.imgPt, this.dispPt);
            this.dp1.setLocation(this.dispPt.x, this.dispPt.y);
            this.imgPt.setPoint(this.p2.getX(), this.p2.getY(), 0.0, (byte)0);
            ctc.transform(this.imgPt, this.dispPt);
            this.dp2.setLocation(this.dispPt.x, this.dispPt.y);
        }
    }

    public boolean contains(int x, int y) {
        int y2;
        int x2;
        int y1;
        int x1;
        return (this.dp1.x != this.dp2.x || this.dp1.y != this.dp2.y) && XpSliceMarker.intersects(x1 = x - 6, y1 = y - 6, x2 = x + 6, y2 = y + 6, this.dp1.x, this.dp1.y, this.dp2.x, this.dp2.y);
    }

    public void mouseDragged(MouseEvent me) {
        if (this.scc != null) {
            boolean processDrag = true;
            Point p = me.getPoint();
            if (processDrag) {
                int csliceIdx = this.scc.getActiveSliceIndex();
                int idx = this.getNearestSliceIndex(this.scc, p);
                if (idx != -1 && idx != csliceIdx) {
                    this.scc.setActiveSliceIndex(idx);
                }
                this.repaint();
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        Stroke st = g.getStroke();
        this.updateDisplayCoordinates();
        Stroke str = this.getMarkerStroke();
        g.setStroke(str);
        Color c = this.getForeground();
        g.setColor(c);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.dp1.x != this.dp2.x || this.dp1.y != this.dp2.y) {
            g.drawLine((int)this.dp1.getX(), (int)this.dp1.getY(), (int)this.dp2.getX(), (int)this.dp2.getY());
        }
        g.setStroke(st);
    }

    private void computeIntersection() {
        Point2D[] intPts = null;
        if (this.scc != null) {
            int sliceIdx = this.scc.getActiveSliceIndex();
            intPts = this.getImageIntersectionPoints(this.scc, sliceIdx);
        } else {
            this.getImageIntersectionPoints(this.ssc, this.pts);
            intPts = this.pts;
        }
        this.p1.setLocation(intPts[0]);
        this.p2.setLocation(intPts[1]);
    }

    public void setSliceSourceCapable(SliceSourceCapable ssc) {
        if (this.ssc != null) {
            this.ssc.removeSliceListener(this);
        }
        this.ssc = ssc;
        this.scc = null;
        if (ssc instanceof SliceControlledCapable) {
            this.scc = (SliceControlledCapable)ssc;
            this.resetSliceControlledCapable(this.scc);
        }
        ssc.addSliceListener(this);
        this.computeIntersection();
    }

    public void setActiveSlice(Object source, XpSlice slice) {
        this.computeIntersection();
        this.repaint();
    }

    protected static boolean intersects(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        int x43 = x4 - x3;
        int y13 = y1 - y3;
        int y43 = y4 - y3;
        int x13 = x1 - x3;
        int x21 = x2 - x1;
        int y21 = y2 - y1;
        int denom = y43 * x21 - x43 * y21;
        int n1 = x43 * y13 - y43 * x13;
        int n2 = x21 * y13 - y21 * x13;
        if (denom == 0 && (n1 == 0 || n2 == 0)) {
            return true;
        }
        if (denom == 0) {
            return false;
        }
        double ua = (double)n1 / (double)denom;
        double ub = (double)n2 / (double)denom;
        return ua >= 0.0 && ua <= 1.0 && ub >= 0.0 && ub <= 1.0;
    }
}

