/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.platform.dm;

import com.ge.med.idc.XjTagValue;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.platform.dm.DmImageCreator;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.JFrame;

public class DmVolumeCreator
extends DmImageCreator {
    private String fileName = "";
    private int framesAdded = 0;
    private int pixelDataLen = 0;
    private XjVolumeInfo vol = null;
    private String newSeriesUid = null;
    private String examUid = null;
    private byte[] cacheFrame = null;

    public DmVolumeCreator(XjVolumeInfo vol, XjTagValue[] tags, String fileName) {
        this(vol, tags, false, fileName);
    }

    public DmVolumeCreator(XjVolumeInfo vol, XjTagValue[] tags, boolean newStudy, String fileName) {
        super(vol, tags);
        this.fileName = fileName;
        this.vol = vol;
        this.newSeriesUid = UidGenerator.newInstanceUID();
        this.examUid = newStudy ? UidGenerator.newInstanceUID() : "" + vol.getValue(32, 13);
    }

    private void initTags(DicomComposite dcmComp, int frameNo) {
        this.setValues(dcmComp, this.getTags());
        int[] dims = this.vol.getVolumeDimensions(null);
        double[] ulc = this.vol.getRASOfOrigin(null);
        double[] xdir = this.vol.getXDirectionRAS(null);
        double[] ydir = this.vol.getYDirectionRAS(null);
        double[] zdir = this.vol.getZDirectionRAS(null);
        double[] pos = new double[3];
        JnVector3d.scaleAdd(ulc, zdir, frameNo, pos);
        dcmComp.setValue(32, 50, "" + -pos[0] + "\\" + -pos[1] + "\\" + pos[2]);
        dcmComp.setValue(8, 24, UidGenerator.newInstanceUID());
        dcmComp.setValue(32, 13, this.examUid);
        dcmComp.setValue(32, 14, this.newSeriesUid);
        dcmComp.setValue(8, 4158, "GEHC volume");
        dcmComp.setValue(32, 17, DmVolumeCreator.getSeriesNo(this.vol));
        dcmComp.setDateValue(8, 18, this.getCreationDate());
        dcmComp.setTimeValue(8, 19, this.getCreationDate());
        dcmComp.setValue(2, 16, "1.2.840.10008.1.2.1");
        dcmComp.setValue(40, 8, new Integer(1));
        double thickness = JnVector3d.length(zdir);
        dcmComp.setValue(24, 80, "" + thickness);
        int bpp = this.vol.getBitsPerVoxel();
        int bytesPerVoxel = bpp / 8;
        this.pixelDataLen = dims[0] * dims[1] * bytesPerVoxel;
        dcmComp.setValue(32736, 0, new Long(this.pixelDataLen));
        XjTagValue[] userTags = this.getOverrides();
        if (userTags != null) {
            for (int i = 0; i < userTags.length; ++i) {
                XjTagValue t = userTags[i];
                try {
                    dcmComp.setValue(t.group, t.element, t.value);
                    continue;
                }
                catch (DMException e) {
                    System.err.println("ERROR: Setting user tag (" + Integer.toHexString(t.group) + "," + Integer.toHexString(t.element) + ") : " + t.value);
                    System.err.println("       " + e.getMessage());
                }
            }
        }
    }

    public int getNumberOfFrames() {
        int[] dims = this.vol.getVolumeDimensions(null);
        return dims[2];
    }

    public void addFrame(Object data, int offset) throws IOException {
        ByteBuffer bbuff;
        DicomComposite dcmComp = new DicomComposite();
        int[] dims = this.vol.getVolumeDimensions(null);
        int len = dims[0] * dims[1];
        String fname = this.fileName + this.framesAdded + ".dcm";
        this.initTags(dcmComp, this.framesAdded);
        if (data instanceof short[]) {
            dcmComp.setVR(32736, 16, 20311);
            if (this.cacheFrame == null) {
                this.cacheFrame = new byte[len * 2];
            }
            bbuff = ByteBuffer.wrap(this.cacheFrame);
            bbuff.order(ByteOrder.LITTLE_ENDIAN);
            bbuff.asShortBuffer().put((short[])data, offset, len);
        } else if (data instanceof byte[]) {
            dcmComp.setVR(32736, 16, 20290);
            if (this.cacheFrame == null) {
                this.cacheFrame = new byte[len];
            }
            bbuff = ByteBuffer.wrap(this.cacheFrame);
            bbuff.put((byte[])data, offset, len);
        }
        dcmComp.setValue(32736, 16, this.cacheFrame);
        FileOutputStream fos = new FileOutputStream(fname);
        dcmComp.write(fos, true);
        fos.close();
        ++this.framesAdded;
    }

    public static void main(String[] args) {
        DMSession dms = new DMSession(new String[]{"file", args[0]});
        DMObject[] dmo = dms.getRelated("series");
        DMVolume vol = DMVolume.buildVolume((String)"DMObjectVolume", (Object[])new Object[]{dmo[0]});
        String mfpath = args[1];
        DmVolumeCreator dmf = new DmVolumeCreator((XjVolumeInfo)vol, null, true, mfpath + File.separator + args[2]);
        JVolume.LinearShort jls = new JVolume.LinearShort((XjVolumeInfo)vol);
        try {
            for (int idx = 0; idx < jls.dz; ++idx) {
                dmf.addFrame(jls.volume, jls.PAD + idx * jls.dx * jls.dy);
            }
            System.err.println("%%% Wrote volume: " + mfpath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DMSession dms_v = new DMSession(new String[]{"file", mfpath});
        DMObject[] dmo_v = dms_v.getRelated("series");
        DMVolume volmf = DMVolume.buildVolume((String)"DMObjectVolume", (Object[])new Object[]{dmo_v[0]});
        JFrame jf = new JFrame("DmVolume");
        T3DViewport iv = new T3DViewport();
        iv.setVolume((XjVolumeInfo)volmf);
        iv.setRenderStyle("VOLUME");
        jf.setContentPane(iv);
        iv.setPreferredSize(new Dimension(512, 512));
        jf.pack();
        jf.setVisible(true);
        jf.setDefaultCloseOperation(3);
    }
}

