/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi;

import com.ge.med.jnu.statistics.JnHistogram;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.GraphicEditable;
import com.ge.med.terra.jami.capable.InfoLabelReporter;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.remote.XpRemoteMedicalImage;
import com.ge.med.terra.jami.render.remote.RemoteRoiStatistics;
import com.ge.med.terra.jami.roi.JamiRoiStatistics;
import com.ge.med.terra.jami.roi.RoiShapeModel;
import com.ge.med.terra.jami.roi.RoiStatistics;
import com.ge.med.terra.jami.roi.RoiStatisticsCreator;
import com.ge.med.terra.jami.roi.XpRoiEvent;
import com.ge.med.terra.jami.roi.XpRoiEventListener;
import com.ge.med.terra.jami.roi.XpRoiHandleContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class XpStatisticsRoi
extends XpRoiHandleContainer
implements Comparable,
GraphicEditable,
Serializable,
InfoLabelReporter,
Replicable,
PropertyChangeListener {
    private static RoiStatisticsCreator rsc = null;
    private static final DecimalFormat df = new DecimalFormat("###0.00");
    private static final DecimalFormat df0 = new DecimalFormat("###0");
    private static final Cursor SELECTION_CURSOR = new Cursor(1);
    private static final Cursor PRESELECT_CURSOR = new Cursor(12);
    private static boolean showStatistics = true;
    private static Color selRoiIdColor = null;
    private static Color unselRoiIdColor = null;
    private transient RoiStatisticsCreator instance_rsc = null;
    private transient XpImage theImage = null;
    private transient RoiStatistics rStats = null;
    private transient XpGeomUtils gu = new XpGeomUtils();
    private CPoint img_ptPrev = new CPoint(0);
    private CPoint img_pt = new CPoint(0);
    private CPoint dragV = new CPoint(0);
    private CPoint tempImgPt = new CPoint(0);
    private CPoint disp_pt = new CPoint(1);
    private transient Point2D tmpPoint1 = new Point2D.Double();
    private transient Point2D tmpPoint2 = new Point2D.Double();
    private AffineTransform at = new AffineTransform();
    private CTransform imgToDisplay = null;
    private CTransform displayToImg = null;
    private Point screenLocation = new Point();
    private Rectangle componentBounds = new Rectangle();
    private transient Point2D[] boundPoint = new Point2D[4];
    private transient Rectangle2D accumRect = new Rectangle2D.Double();
    private transient Point2D effRectPt = new Point2D.Double();
    private boolean graphicDebug = false;
    private transient JFrame debugFrame = null;
    private boolean initDebug = false;
    private boolean dragPress = false;
    private transient XpPixelStatistics pixelStatistics = null;
    private boolean dirtyStatistics = true;
    private String roiLabel = null;
    private boolean customLabel = false;
    private String roiStatLabel = "";
    private boolean autoStatLabel = true;
    private boolean clipRoi = true;
    private Map properties = new HashMap();
    private List roiListener = new ArrayList();
    private XpRoiEvent roiEvent = new XpRoiEvent(this);
    private int displayWidth = 0;
    private int displayHeight = 0;
    private boolean calcPixStats = true;
    private Color color = null;
    private RoiShapeModel rsModel = null;
    private transient Font roiLabelFont = null;
    private transient Rectangle2D roiLabelBounds = null;
    private boolean dragByRoiLabel = false;
    private AffineTransform display_tx = new AffineTransform();
    private BufferedImage display_bitimg = null;
    private Rectangle2D domain = null;
    private Cursor prevCursor = null;
    private Cursor old_cursor = null;

    public XpStatisticsRoi(Shape modelShape) {
        this.init(new RoiShapeModel(modelShape));
    }

    public XpStatisticsRoi(RoiShapeModel shapemodel) {
        this.init(shapemodel);
    }

    public static void setRoiStatisticsCreator(RoiStatisticsCreator rstatCreator) {
        rsc = rstatCreator;
    }

    public RoiStatisticsCreator getRoiStatisticsCreator() {
        return rsc;
    }

    public void setInstanceRoiStatisticsCreator(RoiStatisticsCreator rstatCreator) {
        this.instance_rsc = rstatCreator;
        this.rStats = null;
    }

    private final void init(RoiShapeModel shapemodel) {
        this.setRoiShapeModel(shapemodel);
        for (int i = 0; i < this.boundPoint.length; ++i) {
            this.boundPoint[i] = new Point2D.Double();
        }
        this.roiLabel = "" + this.rsModel.getShapeId();
    }

    public RoiStatistics getRoiStatistics() {
        if (this.rStats == null && this.theImage != null) {
            this.rStats = this.instance_rsc != null ? this.instance_rsc.createRoiStatistics(this.theImage) : this.getRoiStatisticsCreator().createRoiStatistics(this.theImage);
            this.rStats.setImage(this.theImage);
        }
        return this.rStats;
    }

    public final Shape getModelShape() {
        return this.rsModel.getShape();
    }

    public Object clone() {
        return null;
    }

    protected void copyObject(Object o) {
        super.copyObject(o);
        XpStatisticsRoi sr = (XpStatisticsRoi)o;
        if (this.boundPoint != null) {
            sr.boundPoint = new Point2D[this.boundPoint.length];
            for (int i = 0; i < this.boundPoint.length; ++i) {
                sr.boundPoint[i] = (Point2D)this.boundPoint[i].clone();
            }
        }
        sr.graphicDebug = this.graphicDebug;
        sr.roiLabel = this.roiLabel;
        sr.roiStatLabel = this.roiStatLabel;
        sr.clipRoi = this.clipRoi;
        sr.calcPixStats = this.calcPixStats;
        sr.color = this.color;
        sr.setAngle(this.getAngle());
    }

    public void setRoiLabel(String roiLabel) {
        this.roiLabel = roiLabel;
        this.customLabel = true;
        this.dirtyStatistics = true;
    }

    public final String getRoiLabel() {
        return this.roiLabel;
    }

    public final int getRoiId() {
        return this.rsModel.getShapeId();
    }

    public final void setToolTipText(String text) {
        this.rsModel.setToolTipText(text);
    }

    public final String getToolTipText() {
        return this.rsModel.getToolTipText();
    }

    public String createRoiStatLabel(XpPixelStatistics ps) {
        double length = this.getLength();
        String roiStat = this.getRoiLabel() + ": distance " + df.format(length) + " mm";
        return roiStat;
    }

    public String getRoiStatLabel() {
        if (this.autoStatLabel && this.dirtyStatistics) {
            this.syncStatistics();
        }
        return this.roiStatLabel;
    }

    public final String getInfoLabel() {
        return this.getRoiStatLabel();
    }

    public final void setRoiStatLabel(String roiStatLabel) {
        this.roiStatLabel = roiStatLabel;
    }

    public final void setAutoStatLabel(boolean autoStatLabel) {
        this.autoStatLabel = autoStatLabel;
    }

    public final boolean isAutoStatLabel() {
        return this.autoStatLabel;
    }

    public Rectangle2D getBounds2D() {
        return this.rsModel.getBounds2D();
    }

    public final boolean isClipRoi() {
        return this.clipRoi;
    }

    public final void setClipRoi(boolean clipRoi) {
        this.clipRoi = clipRoi;
    }

    public abstract Shape getDrawShape();

    public final void sync() {
        this.syncModel();
    }

    protected final void syncModel() {
        this.rsModel.syncModel();
        this.updateHandles();
    }

    protected final void setDirtyStatistics(boolean dirtyStatistics) {
        this.dirtyStatistics = dirtyStatistics;
    }

    private void updateModel() {
        this.dirtyStatistics = true;
        this.updateHandles();
        this.firePropertyChange("ROI_MODEL", this);
    }

    public void calcStatistics() {
        if (this.theImage != null) {
            this.pixelStatistics = this.getRoiStatistics().getPixelStatistics(this.getModelShape(), this.getAngle());
        }
        this.roiStatLabel = this.createRoiStatLabel(this.pixelStatistics);
        this.dirtyStatistics = false;
    }

    protected void syncStatistics() {
        this.calcStatistics();
    }

    public double getLength() {
        if (this.theImage != null) {
            return this.getRoiStatistics().getLength(this.getModelShape(), this.getAngle());
        }
        return 0.0;
    }

    public double getArea() {
        if (this.theImage != null) {
            return this.getRoiStatistics().getArea(this.getModelShape(), this.getAngle());
        }
        return 0.0;
    }

    public XpPixelStatistics getPixelStatistics() {
        if (this.dirtyStatistics) {
            this.syncStatistics();
        }
        return this.pixelStatistics;
    }

    public JnHistogram calcHistogram(JnHistogram histogram) {
        if (this.dirtyStatistics) {
            this.syncStatistics();
        }
        if (this.theImage != null) {
            return this.getRoiStatistics().calcHistogram(this.getModelShape(), this.getAngle(), histogram);
        }
        return null;
    }

    protected void render(XpVisualComponent vc, Graphics2D g) {
        Color saveColor = g.getColor();
        this.displayWidth = vc.getWidth();
        this.displayHeight = vc.getHeight();
        Shape ds = this.getDrawShape();
        if (XpAppContext.isShadowed()) {
            g.setColor(Color.black);
            g.translate(1, 1);
            g.draw(ds);
            g.translate(-1, -1);
        }
        if (this.color != null) {
            g.setColor(this.color);
        } else if (this.rsModel.isSelected() && this.rsModel.isEditable()) {
            g.setColor(XpAppContext.getSelectedColor());
        } else {
            g.setColor(XpAppContext.getUnSelectedColor());
        }
        this.display_tx.setTransform(g.getTransform());
        g.draw(ds);
        g.setColor(saveColor);
        if (this.graphicDebug) {
            if (!this.initDebug) {
                this.initDebug = true;
                this.displayBitImage("Roi");
            }
            if (this.debugFrame != null) {
                this.debugFrame.repaint();
            }
        }
    }

    public final void paintShape(XpVisualComponent vc, Graphics2D g) {
        this.syncVc(vc);
        this.render(vc, g);
    }

    public void getCenter(Point2D center) {
        Rectangle2D bounds = this.rsModel.getBounds2D();
        double cx = bounds.getX() + bounds.getWidth() / 2.0;
        double cy = bounds.getY() + bounds.getHeight() / 2.0;
        center.setLocation(cx, cy);
    }

    public boolean containsROI(XpVisualComponent vc, int x, int y) {
        if (vc != null) {
            Rectangle2D bounds;
            if (this.isDragByRoiLabel() && (bounds = this.getRoiLabelBounds()) != null && bounds.contains(x, y)) {
                return true;
            }
            this.disp_pt.x = x;
            this.disp_pt.y = y;
            vc.transform(this.disp_pt, this.img_pt, (byte)0);
            return this.getBounds2D().contains(this.img_pt.x, this.img_pt.y);
        }
        return false;
    }

    private void syncVc(XpVisualComponent vc) {
        XpImageRoiVc roiVc = (XpImageRoiVc)vc;
        if (roiVc != null) {
            roiVc.setToolTipText(this.rsModel.getToolTipText());
            this.displayToImg = roiVc.getTransform((byte)1, (byte)0);
            this.imgToDisplay = roiVc.getTransform((byte)0, (byte)1);
            if (roiVc.isShowing()) {
                this.screenLocation = roiVc.getLocationOnScreen();
            }
            roiVc.getBounds(this.componentBounds);
        } else if (!this.customLabel) {
            this.setRoiLabel("" + this.getRoiId());
        }
    }

    public final void addRoiEventListener(XpRoiEventListener rel) {
        this.roiListener.add(rel);
    }

    public final void removeRoiEventListener(XpRoiEventListener rel) {
        this.roiListener.remove(rel);
    }

    public final int getImageWidth() {
        return this.getImage().getSlice().width;
    }

    public final int getImageHeight() {
        return this.getImage().getSlice().height;
    }

    protected final void clipPoint(double x, double y, Point2D p) {
        if (this.clipRoi) {
            double X1 = 0.0;
            double Y1 = 0.0;
            double X2 = this.getImageWidth();
            double Y2 = this.getImageHeight();
            if (this.domain != null) {
                X1 = this.domain.getX();
                Y1 = this.domain.getY();
                X2 = X1 + this.domain.getWidth();
                Y2 = Y1 + this.domain.getHeight();
            }
            if (x < X1) {
                x = X1;
            }
            if (x >= X2) {
                x = X2 - 1.0;
            }
            if (y < Y1) {
                y = Y1;
            }
            if (y >= Y2) {
                y = Y2 - 1.0;
            }
            p.setLocation(x, y);
        }
    }

    protected final void clipPoint(Point2D p) {
        this.clipPoint(p.getX(), p.getY(), p);
    }

    public BufferedImage getDisplayBitmap() {
        if (this.displayWidth > 0 && this.displayHeight > 0) {
            if (this.display_bitimg == null || this.display_bitimg.getWidth() != this.displayWidth || this.display_bitimg.getHeight() != this.displayHeight) {
                this.display_bitimg = new BufferedImage(this.displayWidth, this.displayHeight, 12);
            }
            byte[] data = ((DataBufferByte)this.display_bitimg.getRaster().getDataBuffer()).getData();
            Arrays.fill(data, (byte)0);
            Graphics2D g = (Graphics2D)this.display_bitimg.getGraphics();
            g.transform(this.display_tx);
            g.fill(this.getDrawShape());
        }
        return this.display_bitimg;
    }

    public final BufferedImage getBitmap() {
        return this.getRoiStatistics().getPixels(this.getModelShape(), this.getAngle());
    }

    public void setImage(XpImage image) {
        this.theImage = image;
        this.rStats = null;
        this.syncModel();
        if (this.roiListener != null && this.roiEvent != null) {
            this.roiEvent.setHintMask(4);
            Object[] listeners = this.roiListener.toArray();
            if (listeners != null) {
                for (int i = 0; i < listeners.length; ++i) {
                    XpRoiEventListener rel = (XpRoiEventListener)listeners[i];
                    if (rel == null) continue;
                    rel.imageChanged(this.roiEvent);
                }
            }
        }
    }

    public final boolean isCalcPixelStats() {
        return this.calcPixStats;
    }

    protected final void setCalcPixelStats(boolean calcPixStats) {
        this.calcPixStats = calcPixStats;
    }

    public final XpImage getImage() {
        return this.theImage;
    }

    protected void drawRoiId(XpVisualComponent vc, Graphics2D g, XpHandle h) {
        h.getDisplayLocation(vc, this.tmpPoint1);
        Color c = h.getForeground();
        if (this.isSelected()) {
            if (selRoiIdColor != null) {
                c = selRoiIdColor;
            }
        } else if (unselRoiIdColor != null) {
            c = unselRoiIdColor;
        }
        double sx = this.tmpPoint1.getX() + 7.0;
        double sy = this.tmpPoint1.getY() - 5.0;
        g.setColor(c);
        this.drawRoiId(g, sx, sy);
    }

    public void setDragByRoiLabel(boolean dragByRoiLabel) {
        this.dragByRoiLabel = dragByRoiLabel;
    }

    public boolean isDragByRoiLabel() {
        return this.dragByRoiLabel;
    }

    protected Rectangle2D getRoiLabelBounds() {
        return this.roiLabelBounds;
    }

    protected void drawRoiId(Graphics2D g, double x, double y) {
        float sx = (float)x;
        float sy = (float)y;
        String label = this.getRoiLabel();
        if (label == null) {
            label = "" + this.getRoiId();
        }
        Font oldFont = g.getFont();
        if (this.roiLabelFont != null) {
            g.setFont(this.roiLabelFont);
        } else {
            this.roiLabelFont = oldFont;
        }
        g.drawString(label, sx, sy);
        this.roiLabelBounds = this.roiLabelFont.getStringBounds(label, g.getFontRenderContext());
        this.roiLabelBounds.setRect((double)sx + this.roiLabelBounds.getX(), (double)sy + this.roiLabelBounds.getY(), this.roiLabelBounds.getWidth(), this.roiLabelBounds.getHeight());
        g.setFont(oldFont);
    }

    public final void setSelected(boolean selection) {
        this.rsModel.setSelected(selection);
    }

    public final boolean isSelected() {
        return this.rsModel.isSelected();
    }

    public final double getAngle() {
        return this.rsModel.getAngle();
    }

    public final void setAngle(double angle) {
        this.rsModel.setAngle(angle);
    }

    public void anchorDragged(MouseEvent e, CPoint drag, Object jc) {
        int len = this.roiListener.size();
        this.roiEvent.setHintMask(7);
        for (int i = 0; i < len; ++i) {
            XpRoiEventListener rel = (XpRoiEventListener)this.roiListener.get(i);
            rel.roiDragged(this.roiEvent);
        }
    }

    public void anchorPressed(MouseEvent e, Object jc) {
        int len = this.roiListener.size();
        this.roiEvent.setHintMask(0);
        for (int i = 0; i < len; ++i) {
            XpRoiEventListener rel = (XpRoiEventListener)this.roiListener.get(i);
            rel.roiPressed(this.roiEvent);
        }
    }

    public void anchorReleased(MouseEvent e, Object jc) {
        int len = this.roiListener.size();
        this.roiEvent.setHintMask(0);
        for (int i = 0; i < len; ++i) {
            XpRoiEventListener rel = (XpRoiEventListener)this.roiListener.get(i);
            rel.roiReleased(this.roiEvent);
        }
    }

    protected void updateHandles() {
    }

    protected final void getImagePoint(double dispX, double dispY, Point2D image_point) {
        this.disp_pt.x = dispX;
        this.disp_pt.y = dispY;
        if (this.displayToImg != null) {
            this.displayToImg.transform(this.disp_pt, this.tempImgPt);
            this.getCenter(this.tmpPoint1);
            double cx = this.tmpPoint1.getX();
            double cy = this.tmpPoint1.getY();
            this.at.setToIdentity();
            this.at.rotate(this.getAngle(), cx, cy);
            this.tmpPoint1.setLocation(this.tempImgPt.x, this.tempImgPt.y);
            this.at.transform(this.tmpPoint1, this.tmpPoint2);
            image_point.setLocation(this.tmpPoint2);
        }
    }

    protected final void getImagePoint(Point2D p, Point2D image_point) {
        this.getImagePoint(p.getX(), p.getY(), image_point);
    }

    protected final void imageToDisplay(CPoint img_pt, CPoint display_pt) {
        if (this.imgToDisplay != null) {
            this.imgToDisplay.transform(img_pt, display_pt);
        }
    }

    protected final void displayToImage(CPoint display_pt, CPoint img_pt) {
        if (this.displayToImg != null) {
            this.displayToImg.transform(display_pt, img_pt);
        }
    }

    public final Rectangle getComponentBounds() {
        return this.componentBounds;
    }

    protected final void getDisplayPoint(double imgX, double imgY, Point2D disp_point) {
        this.getCenter(this.tmpPoint1);
        double cx = this.tmpPoint1.getX();
        double cy = this.tmpPoint1.getY();
        double angle = this.getAngle();
        this.at.setToIdentity();
        this.at.rotate(-angle, cx, cy);
        this.tmpPoint1.setLocation(imgX, imgY);
        this.at.transform(this.tmpPoint1, this.tmpPoint2);
        this.tempImgPt.x = this.tmpPoint2.getX();
        this.tempImgPt.y = this.tmpPoint2.getY();
        this.tempImgPt.z = 0.0;
        if (this.imgToDisplay != null) {
            this.imgToDisplay.transform(this.tempImgPt, this.disp_pt);
            disp_point.setLocation(this.disp_pt.x, this.disp_pt.y);
        }
    }

    protected final void getDisplayPoint(Point2D p, Point2D disp_point) {
        this.getDisplayPoint(p.getX(), p.getY(), disp_point);
    }

    protected void getRotatedPoint(double x, double y, Point2D p) {
        this.getCenter(this.tmpPoint1);
        double cx = this.tmpPoint1.getX();
        double cy = this.tmpPoint1.getY();
        this.getRotatedPoint(x, y, -this.getAngle(), cx, cy, p);
    }

    protected final void getRotatedPoint(double x, double y, XpHandle p) {
        this.getCenter(this.tmpPoint1);
        double cx = this.tmpPoint1.getX();
        double cy = this.tmpPoint1.getY();
        this.getRotatedPoint(x, y, -this.getAngle(), cx, cy, this.tmpPoint1);
        p.setLocation(this.tmpPoint1.getX(), this.tmpPoint1.getY());
    }

    protected final void getRotatedPoint(double x, double y, double ang, double cx, double cy, Point2D p) {
        this.gu.getRotatedPoint(x, y, ang, cx, cy, p);
    }

    protected void dragMouse(CPoint dragV) {
    }

    public void setDomain(Rectangle2D domain) {
        this.domain = null;
        if (domain != null) {
            this.domain = (Rectangle2D)domain.clone();
        }
    }

    public Rectangle2D getDomain() {
        return this.domain;
    }

    public void roiClicked(MouseEvent e) {
    }

    public void roiPressed(MouseEvent e) {
        XpImageRoiVc roiVc = (XpImageRoiVc)e.getSource();
        int modifiers = e.getModifiers();
        Point p = e.getPoint();
        int mbutton1 = modifiers & 0x10;
        if (mbutton1 != 0) {
            if (roiVc != null && this.rsModel.isEditable()) {
                this.prevCursor = roiVc.getCursor();
                roiVc.setCursor(PRESELECT_CURSOR);
            }
            this.dragPress = true;
        }
        Rectangle2D bounds = this.getBounds2D();
        this.accumRect.setFrame(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        this.effRectPt.setLocation(bounds.getX(), bounds.getY());
        this.disp_pt.setLocation(p.x, p.y, 0.0);
        if (roiVc != null) {
            roiVc.transform(this.disp_pt, this.img_ptPrev, (byte)0);
        }
        this.notifyPressed();
    }

    protected void notifyPressed() {
        int len = this.roiListener.size();
        this.roiEvent.setHintMask(0);
        for (int i = 0; i < len; ++i) {
            XpRoiEventListener rel = (XpRoiEventListener)this.roiListener.get(i);
            rel.roiPressed(this.roiEvent);
        }
    }

    protected void notifyReleased() {
        int len = this.roiListener.size();
        this.roiEvent.setHintMask(0);
        for (int i = 0; i < len; ++i) {
            XpRoiEventListener rel = (XpRoiEventListener)this.roiListener.get(i);
            rel.roiReleased(this.roiEvent);
        }
    }

    public void roiReleased(MouseEvent e) {
        XpImageRoiVc roiVc = (XpImageRoiVc)e.getSource();
        int modifiers = e.getModifiers();
        int mbutton1 = modifiers & 0x10;
        if (roiVc != null) {
            if (this.prevCursor != null) {
                roiVc.setCursor(this.prevCursor);
            } else {
                roiVc.setCursor(Cursor.getDefaultCursor());
            }
        }
        this.dragPress = false;
        this.notifyReleased();
    }

    public void roiEntered(MouseEvent e) {
        XpImageRoiVc roiVc = (XpImageRoiVc)e.getSource();
        if (!this.dragPress && roiVc != null && this.rsModel.isEditable()) {
            this.old_cursor = roiVc.getCursor();
            roiVc.setCursor(PRESELECT_CURSOR);
        }
    }

    public void roiExited(MouseEvent e) {
        XpImageRoiVc roiVc = (XpImageRoiVc)e.getSource();
        if (!this.dragPress && roiVc != null) {
            roiVc.setCursor(this.old_cursor != null ? this.old_cursor : Cursor.getDefaultCursor());
            this.old_cursor = null;
        }
    }

    public void roiDragged(MouseEvent e) {
        XpImage img;
        if (!this.isSelected()) {
            return;
        }
        XpImageRoiVc roiVc = (XpImageRoiVc)e.getSource();
        int modifiers = e.getModifiers();
        Point p = e.getPoint();
        int mbutton1 = modifiers & 0x10;
        if (mbutton1 != 0 && (img = this.getImage()) != null) {
            int w = img.getSlice().width;
            int h = img.getSlice().height;
            double X1 = 0.0;
            double Y1 = 0.0;
            double X2 = w;
            double Y2 = h;
            if (this.domain != null) {
                X1 = this.domain.getX();
                Y1 = this.domain.getY();
                X2 = X1 + this.domain.getWidth();
                Y2 = Y1 + this.domain.getHeight();
            }
            this.disp_pt.setLocation(p.x, p.y, 0.0);
            roiVc.transform(this.disp_pt, this.img_pt, (byte)0);
            double x = this.accumRect.getX();
            double y = this.accumRect.getY();
            double cumW = this.accumRect.getWidth();
            double cumH = this.accumRect.getHeight();
            this.dragV.setPoint(this.img_ptPrev, this.img_pt);
            this.accumRect.setFrame(x + this.dragV.x, y + this.dragV.y, cumW, cumH);
            double x1 = this.accumRect.getX();
            double y1 = this.accumRect.getY();
            double x2 = x1 + cumW;
            double y2 = y1 + cumH;
            double xx = this.effRectPt.getX();
            double yy = this.effRectPt.getY();
            if (this.isClipRoi()) {
                if (x1 >= X1 && x1 < X2 && x2 >= X1 && x2 < X2) {
                    this.effRectPt.setLocation(x1, this.effRectPt.getY());
                }
                if (y1 >= Y1 && y1 < Y2 && y2 >= Y1 && y2 < Y2) {
                    this.effRectPt.setLocation(this.effRectPt.getX(), y1);
                }
            } else {
                this.effRectPt.setLocation(x1, y1);
            }
            this.dragV.x = this.effRectPt.getX() - xx;
            this.dragV.y = this.effRectPt.getY() - yy;
            if (this.dragV.x != 0.0 || this.dragV.y != 0.0) {
                this.dragMouse(this.dragV);
                roiVc.repaint();
            }
            this.img_ptPrev.setPoint(this.img_pt);
        }
        this.notifyDragged();
    }

    protected void notifyDragged() {
        int len = this.roiListener.size();
        this.roiEvent.setHintMask(4);
        for (int i = 0; i < len; ++i) {
            XpRoiEventListener rel = (XpRoiEventListener)this.roiListener.get(i);
            rel.roiDragged(this.roiEvent);
        }
    }

    public final boolean isGraphicDebug() {
        return this.graphicDebug;
    }

    public final void setGraphicDebug(boolean graphicDebug) {
        this.graphicDebug = graphicDebug;
        if (!this.graphicDebug) {
            if (this.debugFrame != null) {
                this.debugFrame.setVisible(false);
            }
            this.initDebug = false;
        }
    }

    public void displayBitImage(String title) {
        if (!this.calcPixStats) {
            return;
        }
        if (this.debugFrame == null) {
            this.debugFrame = new JFrame(title);
            BufferedImage bmap = this.getRoiStatistics().getPixels(this.getModelShape(), this.getAngle());
            int w = bmap.getWidth();
            int h = bmap.getHeight();
            ImgPanel panel1 = new ImgPanel(bmap);
            Dimension d = new Dimension(w, h);
            panel1.setBackground(Color.white);
            panel1.setMinimumSize(d);
            panel1.setPreferredSize(d);
            this.debugFrame.getContentPane().add((Component)panel1, "Center");
            this.debugFrame.pack();
        }
        this.debugFrame.setVisible(true);
    }

    public final Point getLocationOnScreen() {
        return this.screenLocation;
    }

    public final int compareTo(Object o) {
        if (o instanceof XpStatisticsRoi) {
            XpStatisticsRoi r = (XpStatisticsRoi)o;
            if (r.getRoiId() > this.getRoiId()) {
                return -1;
            }
            if (r.getRoiId() < this.getRoiId()) {
                return 1;
            }
            return 0;
        }
        return 1;
    }

    protected final String statFormat(double num) {
        return df.format(num);
    }

    protected final String statFormat0(double num) {
        return df0.format(num);
    }

    public final void setEditable(boolean editable) {
        this.rsModel.setEditable(editable);
    }

    public final boolean isEditable() {
        return this.rsModel.isEditable();
    }

    public final Color getColor() {
        return this.color;
    }

    public final void setColor(Color c) {
        this.color = c;
    }

    public static boolean isShowStatistics() {
        return showStatistics;
    }

    public static void setShowStatistics(boolean showStats) {
        showStatistics = showStats;
    }

    public void propertyChange(PropertyChangeEvent e) {
        String pName = e.getPropertyName();
        if (pName.equals("ROI_SHAPE_MODEL")) {
            this.updateModel();
        } else {
            Object src = e.getSource();
            if (src instanceof RoiShapeModel) {
                this.firePropertyChange(e.getPropertyName(), e.getNewValue());
            }
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        try {
            s.defaultWriteObject();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException {
        try {
            s.defaultReadObject();
            this.tmpPoint1 = new Point2D.Double();
            this.tmpPoint2 = new Point2D.Double();
            Point2D[] boundPoint = new Point2D[4];
            this.boundPoint = boundPoint;
            this.gu = new XpGeomUtils();
            this.accumRect = new Rectangle2D.Double();
            this.effRectPt = new Point2D.Double();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void setRoiShapeModel(RoiShapeModel shapemodel) {
        this.rsModel = shapemodel;
        this.rsModel.addPropertyChangeListener("ROI_SHAPE_MODEL", this);
        this.rsModel.addPropertyChangeListener("COMPONENT_SELECTED", this);
        this.rsModel.addPropertyChangeListener("COMPONENT_UNSELECTED", this);
    }

    private static RoiStatisticsCreator roiStatisticsCreator(String className) {
        RoiStatisticsCreator rscreator = null;
        Class<Object> cl = null;
        try {
            cl = Class.forName(className);
            XpLog.logger().config("Using ROI Statistics Creator = " + className);
        }
        catch (ClassNotFoundException ex) {
            cl = DefaultRoiStatisticsCreator.class;
            XpLog.logger().severe("RoiStatisticsCreator class not found : " + className);
            XpLog.logger().severe("Will use default creator             : " + cl);
        }
        if (cl != null) {
            try {
                Class<?>[] paramType = null;
                Constructor<Object> c = cl.getConstructor(paramType);
                if (c != null) {
                    Object[] args = null;
                    rscreator = (RoiStatisticsCreator)c.newInstance(args);
                }
            }
            catch (NoSuchMethodException nsme) {
                nsme.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
            catch (InstantiationException ie) {
                ie.printStackTrace();
            }
        } else {
            XpLog.logger().severe("This should not happen !!!  No RoiStatisticsCreator !!!");
        }
        return rscreator;
    }

    public void setClientProperty(String propName, Object value) {
        this.properties.put(propName, value);
    }

    public Object getClientProperty(String propName) {
        return this.properties.get(propName);
    }

    public Object removeClientProperty(String propName) {
        return this.properties.remove(propName);
    }

    public void printClientProperties() {
        int len = this.properties.size();
        if (len > 0) {
            System.out.println("------------------------------");
            System.out.println("Roi: " + this.getRoiLabel());
            System.out.println("------------------------------");
            int ii = 0;
            for (Map.Entry me : this.properties.entrySet()) {
                System.out.println(" [" + ii + "] " + me.getKey() + " --- " + me.getValue());
                ++ii;
            }
        }
    }

    public static void setSelectedRoiIdColor(Color c) {
        selRoiIdColor = c;
    }

    public static Color getSelectedRoiIdColor() {
        return selRoiIdColor;
    }

    public static void setUnselectedRoiIdColor(Color c) {
        unselRoiIdColor = c;
    }

    public static Color getUnselectedRoiIdColor() {
        return unselRoiIdColor;
    }

    static {
        String rscName = XpPropertiesManager.getProperty("jami.roistatistics.creator", "com.ge.med.terra.jami.roi.XpStatisticsRoi$DefaultRoiStatisticsCreator");
        rsc = XpStatisticsRoi.roiStatisticsCreator(rscName);
    }

    public static class DefaultRoiStatisticsCreator
    implements RoiStatisticsCreator {
        public RoiStatistics createRoiStatistics(XpImage img) {
            if (img instanceof XpRemoteMedicalImage) {
                return new RemoteRoiStatistics();
            }
            return new JamiRoiStatistics();
        }
    }

    private class ImgPanel
    extends JPanel {
        private BufferedImage img = null;
        private AffineTransform at = null;

        public ImgPanel(BufferedImage img) {
            this.img = img;
            this.at = new AffineTransform();
        }

        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2.drawImage(this.img, this.at, null);
        }
    }
}

