/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm;

import com.ge.med.idc.XjImage;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiSequence;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.swing.Icon;

public class DMImage
implements Icon,
XjImage {
    private DMiImage peer;
    private DMSession session;

    public DMImage(DMiImage peer, DMSession s) {
        this.peer = peer;
        this.session = s;
    }

    public BufferedImage getPixelData() {
        return this.peer.getPixelData();
    }

    public Object getProperty(Object key) {
        return this.peer.getProperty(key);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.peer.paintIcon(c, g, x, y);
    }

    public int getIconWidth() {
        return this.peer.getIconWidth();
    }

    public int getWidth() {
        return this.peer.getIconWidth();
    }

    public int getIconHeight() {
        return this.peer.getIconHeight();
    }

    public int getHeight() {
        return this.peer.getIconHeight();
    }

    public void preLoad() {
        this.peer.preLoad();
    }

    public void preUnload() {
        this.peer.preUnload();
    }

    public void refresh() {
        this.peer.refresh();
    }

    public Object getValue(DMTag tag2) {
        if (tag2.getGroup() == 0 && tag2.getElement() == 1) {
            return new Integer(this.peer.getFrameNumber());
        }
        Object o = this.peer.getValue(tag2);
        if (o instanceof DMiSequence) {
            return new DMSequence((DMiSequence)o);
        }
        return o;
    }

    public Object getValue(int group, int elem) {
        return this.getValue(new DMTag(group, elem));
    }

    public DMiImage getPeer() {
        return this.peer;
    }

    public DMComposite getComposite() {
        return new DMComposite(this.peer.getComposite(), this.session);
    }

    public RenderedImage getImageData() {
        return this.peer.getPixelData();
    }

    public int getValues(XjTagValue[] xjTagValueArray) {
        DMElement[] elements = DMElement.genDMelements(xjTagValueArray);
        this.peer.getComposite().getValues(elements);
        for (int i = 0; i < elements.length; ++i) {
            if (!(elements[i].value instanceof DMiSequence)) continue;
            elements[i].value = new DMSequence((DMiSequence)elements[i].value);
        }
        return DMElement.getXjTagValue(elements, xjTagValueArray);
    }

    public String getFilePath() {
        return this.getComposite().getFilePath();
    }

    public long getPixelOffset() {
        DMElement dme = new DMElement(32736, 16);
        dme.setFillValue(false);
        this.getComposite().getValues(new DMElement[]{dme});
        return dme.getOffset();
    }

    public int getFrameNumber() {
        return this.peer.getFrameNumber();
    }
}

