/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm;

import com.ge.med.idc.XjVolume;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMUtils;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class DMUtils {
    public static String PROPERTY_SESSION_NAME = "SessionName";
    public static String PROPERTY_SESSION_TYPE = "session type";
    public static String PROPERTY_SESSION_REP = "session rep";
    public static String PROPERTY_SESSION_ARGS = "session args";
    public static String MSG_REUSE_NETWORK_ASSOCIATION = "reuse association";
    public static String MSG_CLOSE_NETWORK_ASSOCIATION = "close association";
    public static String MSG_NETWORK_ASSOCIATION_TYPE = "get association type";
    public static String MSG_MAKE_NETWORK_ASSOCIATION = "make association";
    public static String MSG_CSTORE_DIR = "scp_db";
    public static String MSG_SCP_PORT = "scp_port";
    public static String MSG_PING_REMOTE_SCP = "ping remote scp";
    public static String MSG_NETWORK_STOP_SERVER = "stop_server";
    public static String MSG_RESERVE_SPACE = "reserve";
    public static String MSG_RELEASE_SPACE = "release";
    public static String NW_INIT_CALLED_AE = "calledAE";
    public static String NW_INIT_CALLED_HOST = "calledHost";
    public static String NW_INIT_CALLED_PORT = "calledPort";
    public static String NW_INIT_CALLING_AE = "callingAE";
    public static String NW_INIT_IMPL_CLASS_UID = "implClassUID";
    public static String TS_EBE = "1.2.840.10008.1.2.2";
    public static String TS_ELE = "1.2.840.10008.1.2.1";
    public static String TS_ILE = "1.2.840.10008.1.2";
    public static String TS_GEBE = "1.2.840.113619.5.2";
    public static String TS_JPEGLossless = "1.2.840.10008.1.2.4.70";
    public static String TS_RLELossless = "1.2.840.10008.1.2.5";
    public static String TS_JPEGBaseline = "1.2.840.10008.1.2.4.50";
    public static String TS_UNKOWN = "";
    public static Comparator patSort = new Comparator(){

        public int compare(Object object, Object object1) {
            DMObject dmo1 = (DMObject)object;
            DMObject dmo2 = (DMObject)object1;
            Object obj = dmo1.getValue(16, 16);
            String str1 = obj == null ? "" : (String)obj;
            obj = dmo2.getValue(16, 16);
            String str2 = obj == null ? "" : (String)obj;
            return str1.compareTo(str2);
        }
    };
    public static Comparator stuSort = new Comparator(){

        public int compare(Object object, Object object1) {
            DMObject dmo1 = (DMObject)object;
            DMObject dmo2 = (DMObject)object1;
            Object obj = dmo1.getValue(32, 16);
            String str1 = obj == null ? "" : (String)obj;
            obj = dmo2.getValue(32, 16);
            String str2 = obj == null ? "" : (String)obj;
            return str1.compareTo(str2);
        }
    };
    public static Comparator serSort = new Comparator(){

        public int compare(Object object, Object object1) {
            DMObject dmo1 = (DMObject)object;
            DMObject dmo2 = (DMObject)object1;
            Object obj = dmo1.getValue(32, 17);
            String str1 = obj == null ? "" : (String)obj;
            obj = dmo2.getValue(32, 17);
            String str2 = obj == null ? "" : (String)obj;
            return str1.compareTo(str2);
        }
    };
    public static Comparator imgSort = new Comparator(){

        public int compare(Object object, Object object1) {
            DMObject dmo1 = (DMObject)object;
            DMObject dmo2 = (DMObject)object1;
            Object obj = dmo1.getValue(32, 19);
            String str1 = obj == null ? "" : (String)obj;
            obj = dmo2.getValue(32, 19);
            String str2 = obj == null ? "" : (String)obj;
            return str1.compareTo(str2);
        }
    };

    public static DMObject[] filter(DMObject[] objs, DMQuery q) {
        ArrayList<DMObject> list = new ArrayList<DMObject>();
        for (int i = 0; i < objs.length; ++i) {
            if (!q.valid(objs[i])) continue;
            list.add(objs[i]);
        }
        DMObject[] filteredObjs = new DMObject[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            filteredObjs[i] = (DMObject)list.get(i);
        }
        return filteredObjs;
    }

    public static void displaySequence(DMSequence seq) {
        DMUtils.displaySequence(seq, 0);
    }

    private static void displaySequence(DMSequence seq, int level) {
        int x;
        int numItems = seq.getNumberOfItems();
        for (x = 0; x < level; ++x) {
            System.out.print("\t");
        }
        System.out.println("BEGIN_SEQUENCE");
        for (int i = 0; i < seq.getNumberOfItems(); ++i) {
            int x2;
            for (x2 = 0; x2 < level; ++x2) {
                System.out.print("\t");
            }
            System.out.println("BEGIN_ITEM");
            for (int j = 0; j < seq.getItem(i).getNumberOfTags(); ++j) {
                if (seq.getItem(i).getValue(seq.getItem(i).getTags()[j]) instanceof DMSequence) {
                    DMUtils.displaySequence((DMSequence)seq.getItem(i).getValue(seq.getItem(i).getTags()[j]), level + 1);
                    continue;
                }
                for (int x3 = 0; x3 < level + 1; ++x3) {
                    System.out.print("\t");
                }
                System.out.println(seq.getItem(i).getTags()[j] + "= " + seq.getItem(i).getValue(seq.getItem(i).getTags()[j]));
            }
            for (x2 = 0; x2 < level; ++x2) {
                System.out.print("\t");
            }
            System.out.println("END_ITEM");
        }
        for (x = 0; x < level; ++x) {
            System.out.print("\t");
        }
        System.out.println("END_SEQUENCE");
    }

    public static void printChildren(DMSession dms) {
        DMUtils.printChildren(dms, System.out);
    }

    public static void printChildren(DMSession dms, PrintStream fout) {
        DMObject[] pats = dms.getChildren();
        System.out.println("# of patients= " + pats.length);
        Arrays.sort(pats, patSort);
        for (int i = 0; i < pats.length; ++i) {
            DMUtils.printChildren(pats[i], fout);
        }
    }

    public static void printChildren(DMObject obj) {
        DMUtils.printChildren(obj, System.out);
    }

    public static void printChildren(DMObject obj, PrintStream out) {
        if (obj.getType().equalsIgnoreCase("patient")) {
            DMObject[] kids = obj.getRelated("study");
            Arrays.sort(kids, stuSort);
            out.println("");
            out.println("-Patient: " + obj.getValue(16, 16));
            for (int i = 0; i < kids.length; ++i) {
                DMUtils.printChildren(kids[i], out);
            }
        } else if (obj.getType().equalsIgnoreCase("study")) {
            DMObject[] kids = obj.getRelated("series");
            Arrays.sort(kids, serSort);
            out.println("\t-Study: " + obj.getValue(32, 13));
            for (int i = 0; i < kids.length; ++i) {
                DMUtils.printChildren(kids[i], out);
            }
        } else if (obj.getType().equalsIgnoreCase("series")) {
            DMObject[] kids = obj.getRelated("image");
            Arrays.sort(kids, imgSort);
            out.println("\t\t-Series: " + obj.getValue(32, 14));
            for (int i = 0; i < kids.length; ++i) {
                DMUtils.printChildren(kids[i], out);
            }
        } else if (obj.getType().equalsIgnoreCase("image")) {
            out.println("\t\t\t+Image: " + obj.getValue(8, 24));
        }
    }

    public static tagValue findtag(tagValue[] t, int g, int e) {
        for (int i = 0; i < t.length; ++i) {
            if (!t[i].is(g, e)) continue;
            return t[i];
        }
        return null;
    }

    public static XjVolume buildVolume(DMObject series, DMTag[] neededtags) {
        return new DMVolume(series, neededtags);
    }

    public static void main(String[] args) {
        DMSession dms = new DMSession("file", "D:\\dev\\dicom\\direct3d", null);
        DMVolume xjv = new DMVolume(dms.getRelated("series")[0], null);
        System.out.println("xjv.getBitsPerVoxel()=" + xjv.getBitsPerVoxel());
        System.out.println("xjv.getPixelType()=" + xjv.getPixelType());
        System.out.println("=" + xjv.isVolumeLittleEndian());
        int[] dim = xjv.getVolumeDimensions(null);
        System.out.println("dim=" + dim[0] + "," + dim[1] + "," + dim[2]);
        double[] v = xjv.getRASOfOrigin(null);
        System.out.println("xjv.getRASOfOrigin()=" + v[0] + "," + v[1] + "," + v[2]);
        v = xjv.getXDirectionRAS(null);
        System.out.println("xjv.getXDirectionRAS()=" + v[0] + "," + v[1] + "," + v[2]);
        v = xjv.getYDirectionRAS(null);
        System.out.println("xjv.getYDirectionRAS()=" + v[0] + "," + v[1] + "," + v[2]);
        v = xjv.getZDirectionRAS(null);
        System.out.println("xjv.getZDirectionRAS()=" + v[0] + "," + v[1] + "," + v[2]);
        System.out.println("=" + xjv);
    }
}

