/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.archive;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.codec.Compression;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.archive.ArchiveComposite;
import com.ge.med.terra.tap.dm.archive.ArchiveObject;
import com.ge.med.terra.tap.dm.archive.ArchiveTagValue;
import com.ge.med.terra.tap.dm.archive.DicomCompositeArchive;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiJob;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.peer.DMiSession;
import com.ge.med.terra.tap.dm.sessionFile.peerToPeerComm;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tag;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveSession
implements DMiSession {
    static final String REMOVE_FILES_DIR = "REMOVE";
    private static final int PAD = 10000000;
    private static final boolean READ_ONLY_DEFAULT = true;
    private static final int NON_COMPRESSION = 0;
    private static final int JPEGLossless = 1;
    private static final String JPEG = "JPEG";
    private static final String NEW_FILES_DIR = "new";
    private static final String PATIENT = "patient";
    private static final String STUDY = "study";
    private static final String SERIES = "series";
    private static final String IMAGE = "image";
    private static final String[] PATIENT_TYPES_STR = new String[]{"patient", "HANGING PROTOCOL"};
    private static final String[] STUDY_TYPES_STR = new String[]{"study", "HL7 STRUC DOC"};
    private static final String[] SERIES_TYPES_STR = new String[]{"series"};
    private static final String[] IMAGE_TYPES_STR = new String[]{"image", "RT DOSE", "RT STRUCTURE SET", "RT PLAN", "RT TREAT RECORD", "PRESENTATION", "WAVEFORM", "SR DOCUMENT", "KEY OBJECT DOC", "SPECTROSCOPY", "RAW DATA", "REGISTRATION", "FIDUCIAL", "ENCAP DOC", "VALUE MAP", "STEREOMETRIC"};
    private static final Set<String> PATIENT_TYPES = new HashSet<String>(PATIENT_TYPES_STR.length);
    private static final Set<String> STUDY_TYPES = new HashSet<String>(STUDY_TYPES_STR.length);
    private static final Set<String> SERIES_TYPES = new HashSet<String>(SERIES_TYPES_STR.length);
    private static final Set<String> IMAGE_TYPES = new HashSet<String>(IMAGE_TYPES_STR.length);
    File dir;
    boolean readOnlyArchive;
    int initFileLength;
    long actualFileLength;
    MappedByteBuffer mb;
    private String mount;
    private int dicomEncodingScheme;
    private String session;
    private dicomParser parser;
    private String[] levels;
    private tag[][] requiredIETags;
    private RandomAccessFile out;
    private boolean littleEndian;
    private Properties dicomdirProps;
    private Properties sessionProps;
    private int firstPatientOffset;
    private int lastPatientOffset;
    private byte[] bbuff;
    private String path;
    private Vector[] listenerList;
    protected peerToPeerComm p2pcomm;

    public ArchiveSession() {
        for (String type : PATIENT_TYPES_STR) {
            PATIENT_TYPES.add(type.toUpperCase());
        }
        for (String type : STUDY_TYPES_STR) {
            STUDY_TYPES.add(type.toUpperCase());
        }
        for (String type : SERIES_TYPES_STR) {
            SERIES_TYPES.add(type.toUpperCase());
        }
        for (String type : IMAGE_TYPES_STR) {
            IMAGE_TYPES.add(type.toUpperCase());
        }
        this.readOnlyArchive = true;
        this.initFileLength = 0;
        this.actualFileLength = 0L;
        this.mb = null;
        this.dicomEncodingScheme = 0;
        this.levels = new String[]{PATIENT, STUDY, SERIES, IMAGE};
        this.requiredIETags = new tag[4][];
        this.out = null;
        this.littleEndian = true;
        this.dicomdirProps = new Properties();
        this.sessionProps = new Properties();
        this.firstPatientOffset = -1;
        this.lastPatientOffset = -1;
        this.bbuff = new byte[32768];
        this.path = null;
        this.listenerList = new Vector[10];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(String sessionType, String[] args) {
        String compressionType;
        String session = sessionType;
        if (args != null && args.length > 0 && args[0].indexOf("=") != -1) {
            this.parseNamedParams(args);
        }
        if ((compressionType = this.sessionProps.getProperty("encoding")) != null) {
            if (compressionType.equalsIgnoreCase(JPEG)) {
                this.dicomEncodingScheme = 1;
            } else {
                if (!compressionType.equalsIgnoreCase("NONE")) throw new IllegalArgumentException("Compression scheme not supported: " + compressionType);
                this.dicomEncodingScheme = 0;
            }
        } else {
            this.dicomEncodingScheme = 0;
        }
        this.readOnlyArchive = this.sessionProps.getProperty("readonly", String.valueOf(true)).equalsIgnoreCase("true");
        if (Tap.logLevel >= Tap.LEVEL_FINE) {
            Tap.log.fine("in session init");
            Tap.log.fine("session===" + session);
        }
        String ddir = null;
        String string = session = File.separatorChar == '/' ? session.replace('\\', '/') : session.replace('/', '\\');
        if (session.indexOf(File.separatorChar) == -1) {
            this.mount = session;
        } else {
            int l = session.lastIndexOf(File.separatorChar);
            this.mount = session.substring(0, l);
            String string2 = ddir = l >= session.length() - 1 ? null : session.substring(l + 1);
            if (ddir != null && !ddir.equalsIgnoreCase("DICOMDIR")) {
                this.mount = this.mount + File.separatorChar + ddir;
                ddir = null;
            }
        }
        Tap.log.log(Level.INFO, "Mount = {0}", this.mount);
        Tap.log.log(Level.INFO, "DICOMDIR File = {0}", ddir);
        this.dir = new File(this.mount);
        if (ddir == null) {
            ddir = "DICOMDIR";
        }
        session = this.mount + File.separator + ddir;
        Tap.log.log(Level.INFO, "Session File = {0}", session);
        File sesFile = new File(session);
        boolean newFile = false;
        if (!sesFile.isFile()) {
            if (this.readOnlyArchive) {
                throw new IllegalStateException("Need to create \"" + sesFile + "\", but session is READ-ONLY");
            }
            try {
                File parentFile = sesFile.getParentFile();
                if (null != parentFile && !parentFile.exists()) {
                    parentFile.mkdirs();
                }
                sesFile.createNewFile();
                this.out = new RandomAccessFile(sesFile.getAbsolutePath(), "rw");
                this.mb = this.out.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.out.length() + 10000000L);
                this.loadProperties();
                this.mb.order(ByteOrder.LITTLE_ENDIAN);
                this.littleEndian = true;
                this.mb.put(new byte[128], 0, 128);
                this.mb.put(new String("DICM").getBytes());
                this.constructHeader(this.mb);
                this.initFileLength = this.mb.position();
                this.actualFileLength = this.mb.position();
                this.loadRequiredIETags();
            }
            catch (IOException ioex) {
                throw new IllegalStateException("Error while creating \"" + sesFile + "\": ", ioex);
            }
            newFile = true;
        }
        if (Tap.logLevel >= Tap.LEVEL_FINE) {
            Tap.log.fine("fixed session= " + session);
        }
        this.session = session;
        if (newFile) {
            return;
        }
        this.loadTagFromExistingDicomDir();
        long existingLength = 0L;
        try {
            if (!this.readOnlyArchive && sesFile.canWrite()) {
                this.out = new RandomAccessFile(sesFile.getAbsolutePath(), "rw");
                existingLength = this.out.length() - 8L;
                this.mb = this.out.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.out.length() + 10000000L);
                this.mb.position((int)existingLength);
            } else {
                this.out = new RandomAccessFile(sesFile.getAbsolutePath(), "r");
                existingLength = this.out.length() - 8L;
                this.mb = this.out.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.out.length());
                this.mb.position((int)existingLength);
                this.readOnlyArchive = true;
            }
        }
        catch (IOException ioex) {
            throw new IllegalStateException("Error while opening \"" + sesFile + "\": ", ioex);
        }
        if (this.littleEndian) {
            this.mb.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.mb.order(ByteOrder.BIG_ENDIAN);
        }
        if (this.loadTagFromExistingDicomDirA()) return;
        this.loadProperties();
        this.loadRequiredIETags();
        this.actualFileLength = this.initFileLength;
    }

    private void parseNamedParams(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String param = args[i];
            int ind = param.indexOf("=");
            if (ind == -1) {
                throw new IllegalArgumentException("Wrong parameter syntax: " + param);
            }
            String pname = param.substring(0, ind);
            String pvalue = param.substring(ind + 1);
            this.sessionProps.setProperty(pname, pvalue);
        }
    }

    private void reMapFile(int pos) {
        try {
            this.out = new RandomAccessFile(new File(this.session).getAbsolutePath(), "rw");
            try {
                this.mb = this.out.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.out.length() + 10000000L);
                this.mb.position(pos);
            }
            catch (IOException ex1) {}
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private boolean loadTagFromExistingDicomDirA() {
        ArchiveNode[] ies = new ArchiveNode[4];
        ies[0] = this.readItem(this.initFileLength);
        if (ies[0] == null) {
            return false;
        }
        ies[1] = this.readItem(ies[0].firstChild);
        ies[2] = this.readItem(ies[1].firstChild);
        ies[3] = this.readItem(ies[2].firstChild);
        for (int i = 0; i < ies.length; ++i) {
            tagValue[] values = ies[i].tvs;
            ArrayList<tag> tagVects = new ArrayList<tag>();
            for (int j = 0; j < values.length; ++j) {
                if (values[j].group == 4) continue;
                tagVects.add(new tag((short)values[j].group, (short)values[j].element));
            }
            this.requiredIETags[i] = tagVects.toArray(new tag[tagVects.size()]);
        }
        return true;
    }

    private void loadTagFromExistingDicomDir() {
        this.parser = new dicomParser();
        try {
            this.parser.setFile(this.session);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error while parsing \"" + this.session + "\": ", ex);
        }
        tagValue[] tags = new tagValue[]{new tagValue(2, 16), new tagValue(4, 4608), new tagValue(4, 4610)};
        this.parser.fill(tags);
        this.parser.clearFile();
        this.firstPatientOffset = (int)tags[1].getOffset() + 8;
        this.lastPatientOffset = (int)tags[2].getOffset() + 8;
        this.initFileLength = this.firstPatientOffset == 0 ? ((Long)tags[2].value).intValue() : ((Long)tags[1].value).intValue();
        if (tags[0].value != null) {
            String transferUID = (String)tags[0].value;
            if (transferUID.equals("1.2.840.10008.1.2.2")) {
                this.littleEndian = false;
            } else if (transferUID.equals("1.2.840.10008.1.2.1")) {
                this.littleEndian = true;
            }
        }
    }

    private void loadRequiredIETags() {
        for (int i = 0; i < this.levels.length; ++i) {
            String ieLevel = this.dicomdirProps.getProperty(this.levels[i]);
            this.loadTags(ieLevel, i);
        }
    }

    public void reWriteOffsetPatientOffset(int offset) {
        int curPos = this.mb.position();
        this.mb.position(this.firstPatientOffset);
        this.mb.putInt(offset);
        this.mb.position(curPos);
    }

    public void reWriteOffsetLastPatientOffset(int offset) {
        int curPos = this.mb.position();
        this.mb.position(this.lastPatientOffset);
        this.mb.putInt(offset);
        this.mb.position(curPos);
    }

    private void constructHeader(MappedByteBuffer out) {
        long groupLength = 196L;
        long offsets = 0L;
        int intOff = 0;
        byte[] versionNumber = new byte[]{0, 1};
        try {
            new ArchiveTagValue(2, 0, "UL", groupLength).write(out);
            new ArchiveTagValue(2, 1, "OB", versionNumber).write(out);
            new ArchiveTagValue(2, 2, "UI", "1.2.840.10008.1.3.10").write(out);
            new ArchiveTagValue(2, 3, "UI", UidGenerator.newInstanceUID()).write(out);
            new ArchiveTagValue(2, 16, "UI", "1.2.840.10008.1.2.1").write(out);
            new ArchiveTagValue(2, 18, "UI", "1.2.840.113619.6.311").write(out);
            new ArchiveTagValue(2, 19, "SH", "AW4_1_03_5").write(out);
            new ArchiveTagValue(2, 22, "AE", "napa").write(out);
            new ArchiveTagValue(4, 4400, "CS", "AW4_1_03_5").write(out);
            new ArchiveTagValue(4, 4608, "UL", offsets).write(out);
            this.firstPatientOffset = out.position() - 4;
            new ArchiveTagValue(4, 4610, "UL", offsets).write(out);
            this.lastPatientOffset = out.position() - 4;
            new ArchiveTagValue(4, 4626, "US", intOff).write(out);
            new ArchiveTagValue(4, 4640, "SQ").write(out);
            int currentOffset = out.position();
            out.position(this.firstPatientOffset);
            out.putInt(currentOffset);
            out.position(this.lastPatientOffset);
            out.putInt(this.lastPatientOffset);
            out.position(currentOffset);
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    private void loadTags(String ieLevelTags, int level) {
        StringTokenizer st = new StringTokenizer(ieLevelTags, "+");
        this.requiredIETags[level] = new tag[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            StringTokenizer comma = new StringTokenizer(st.nextToken(), ",");
            this.requiredIETags[level][count] = new tag((short)Integer.parseInt(comma.nextToken()), (short)Integer.parseInt(comma.nextToken()));
            ++count;
        }
    }

    public void findFileEnd() {
        this.mb.position(this.initFileLength);
        int group = this.mb.getShort() & 0xFFFF;
        int element = this.mb.getShort() & 0xFFFF;
        if (group != 65534 || element != 57344) {
            this.changeMBEndian();
            this.mb.position(this.initFileLength);
            group = this.mb.getShort() & 0xFFFF;
            element = this.mb.getShort() & 0xFFFF;
            if (group != 65534 || element != 57344) {
                this.changeMBEndian();
                this.actualFileLength = this.initFileLength;
                return;
            }
        }
        int itemLen = this.mb.getInt();
        group = this.mb.getShort() & 0xFFFF;
        element = this.mb.getShort() & 0xFFFF;
        while (group != 65534 || element != 57565) {
            ArchiveTagValue tv = new ArchiveTagValue(group, element, this.mb);
            if (!this.mb.hasRemaining()) break;
            group = this.mb.getShort() & 0xFFFF;
            element = this.mb.getShort() & 0xFFFF;
        }
        this.actualFileLength = this.mb.hasRemaining() ? (long)(this.mb.position() + 4) : (long)this.mb.position();
    }

    public static String getLevel(String type) {
        String typeuc = type.toUpperCase();
        if (PATIENT_TYPES.contains(typeuc)) {
            return PATIENT;
        }
        if (STUDY_TYPES.contains(typeuc)) {
            return STUDY;
        }
        if (SERIES_TYPES.contains(typeuc)) {
            return SERIES;
        }
        if (IMAGE_TYPES.contains(typeuc)) {
            return IMAGE;
        }
        throw new IllegalArgumentException("Unsupported Directory Record Type: " + type);
    }

    public ArchiveNode getRepChildNode(ArchiveNode parent) {
        if (parent.firstChild > 0L) {
            return this.readItem(parent.firstChild);
        }
        return null;
    }

    public ArchiveNode[] getChildNodes(ArchiveNode parent) {
        ArchiveNode repChild = this.getRepChildNode(parent);
        if (repChild == null) {
            return null;
        }
        ArrayList<ArchiveNode> al = new ArrayList<ArchiveNode>();
        al.add(repChild);
        while (repChild.nextSibling > 0L) {
            repChild = this.readItem(repChild.nextSibling);
            al.add(repChild);
        }
        return al.toArray(new ArchiveNode[al.size()]);
    }

    public ArchiveNode[] getChildNodes(ArchiveNode parent, String level) {
        ArchiveNode[] children = this.getChildNodes(parent);
        while (!children[0].level.equalsIgnoreCase(level)) {
            ArrayList<ArchiveNode> al = new ArrayList<ArchiveNode>();
            for (int i = 0; i < children.length; ++i) {
                ArchiveNode[] th = this.getChildNodes(children[i]);
                for (int j = 0; j < th.length; ++j) {
                    al.add(th[j]);
                }
            }
            children = al.toArray(new ArchiveNode[al.size()]);
        }
        return children;
    }

    public ArchiveNode[] getSiblingNode(ArchiveNode me) {
        ArchiveNode node = me;
        ArrayList<ArchiveNode> al = new ArrayList<ArchiveNode>();
        al.add(node);
        while (node.nextSibling > 0L) {
            node = this.readItem(node.nextSibling);
            al.add(node);
        }
        return al.toArray(new ArchiveNode[al.size()]);
    }

    public ArchiveNode[] getSiblingNodeA(ArchiveNode me) {
        ArchiveNode firstNode = null;
        if (me.level.equalsIgnoreCase(PATIENT)) {
            int pos = this.mb.position();
            this.mb.position(this.firstPatientOffset);
            int firstPatientOffset = this.mb.getInt() & 0xFFFFFFFF;
            firstNode = this.readItem(firstPatientOffset);
            this.mb.position(pos);
        } else {
            if (me.level.equalsIgnoreCase(STUDY)) {
                firstNode = this.getParentNodes(me, PATIENT);
            } else if (me.level.equalsIgnoreCase(SERIES)) {
                firstNode = this.getParentNodes(me, STUDY);
            } else if (me.level.equalsIgnoreCase(IMAGE)) {
                firstNode = this.getParentNodes(me, SERIES);
            }
            if (firstNode == null) {
                return null;
            }
            firstNode = this.readItem(firstNode.firstChild);
        }
        if (firstNode == null) {
            return null;
        }
        ArrayList<ArchiveNode> al = new ArrayList<ArchiveNode>();
        al.add(firstNode);
        while (firstNode.nextSibling > 0L) {
            firstNode = this.readItem(firstNode.nextSibling);
            al.add(firstNode);
        }
        return al.toArray(new ArchiveNode[al.size()]);
    }

    public ArchiveNode getRepImageNode(ArchiveNode node) {
        ArchiveNode parent = node;
        while (!parent.level.equalsIgnoreCase(IMAGE)) {
            parent = this.readItem(parent.firstChild);
        }
        if (parent.level.equalsIgnoreCase(IMAGE)) {
            return parent;
        }
        return null;
    }

    public ArchiveNode getRepImageNodeA(ArchiveNode parent) {
        long offset = parent.firstChild + 30L;
        while (offset > 0L) {
            this.mb.position((int)offset);
            long value = this.mb.getLong();
            offset = value + 30L;
        }
        ArchiveNode node = this.readItem(offset - 30L);
        if (node.level.equalsIgnoreCase(IMAGE)) {
            return parent;
        }
        return null;
    }

    public ArchiveNode[] getAllImageNodes(ArchiveNode parent) {
        ArchiveNode[] children = this.getChildNodes(parent);
        if (children.length > 0) {
            while (!children[0].level.equalsIgnoreCase(IMAGE)) {
                ArrayList<ArchiveNode> al = new ArrayList<ArchiveNode>();
                for (int i = 0; i < children.length; ++i) {
                    ArchiveNode[] th = this.getChildNodes(children[i]);
                    for (int j = 0; j < th.length; ++j) {
                        al.add(th[j]);
                    }
                }
                children = al.toArray(new ArchiveNode[al.size()]);
            }
            return children;
        }
        return null;
    }

    public ArchiveNode getParentNodes(ArchiveNode child, String level) {
        ArchiveNode image = this.getRepImageNode(child);
        if (null == image) {
            return null;
        }
        String imagePath = image.getImagePath();
        int currentPosition = this.mb.position();
        if (this.actualFileLength == 0L) {
            this.findFileEnd();
        }
        this.mb.position((int)this.actualFileLength);
        DicomCompositeArchive df = new DicomCompositeArchive(this, new File(imagePath), this.requiredIETags, this.mb, this.initFileLength);
        this.mb.position(currentPosition);
        long parentOffset = 0L;
        if (level.equalsIgnoreCase(SERIES)) {
            parentOffset = df.getSeriesOffset();
        } else if (level.equalsIgnoreCase(STUDY)) {
            parentOffset = df.getStudyOffset();
        } else if (level.equalsIgnoreCase(PATIENT)) {
            parentOffset = df.getPatientOffset();
        }
        if (parentOffset > 0L) {
            return this.readItem(parentOffset);
        }
        return null;
    }

    private void changeMBEndian() {
        if (this.mb.order() == ByteOrder.BIG_ENDIAN) {
            this.mb.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.mb.order(ByteOrder.BIG_ENDIAN);
        }
    }

    public ArchiveNode readItem(long position) {
        int itemlen;
        int current = this.mb.position();
        this.mb.position((int)position);
        int group = this.mb.getShort() & 0xFFFF;
        int element = this.mb.getShort() & 0xFFFF;
        if (group != 65534 || element != 57344) {
            this.changeMBEndian();
            this.mb.position((int)position);
            group = this.mb.getShort() & 0xFFFF;
            element = this.mb.getShort() & 0xFFFF;
            if (group != 65534 || element != 57344) {
                this.changeMBEndian();
                return null;
            }
        }
        int item_end = (itemlen = this.mb.getInt() & 0xFFFFFFFF) != -1 ? this.mb.position() + itemlen : Integer.MAX_VALUE;
        Vector<ArchiveTagValue> vc = new Vector<ArchiveTagValue>();
        group = this.mb.getShort() & 0xFFFF;
        element = this.mb.getShort() & 0xFFFF;
        if (group == 65534 && element == 57565) {
            return null;
        }
        while (group != 65534 && element != 57357 || group != 65534 && element != 57344) {
            vc.add(new ArchiveTagValue(group, element, this.mb));
            if (!this.mb.hasRemaining()) {
                return new ArchiveNode(position, vc);
            }
            group = this.mb.getShort() & 0xFFFF;
            element = this.mb.getShort() & 0xFFFF;
            if (this.mb.position() <= item_end && group != 0) continue;
        }
        this.mb.getInt();
        this.mb.position(current);
        return new ArchiveNode(position, vc);
    }

    @Override
    public void ClearCache() {
    }

    @Override
    public DMiObject[] getChildren(DMQuery q) {
        return this.getRelated(PATIENT, q);
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q) {
        final ArrayList list = new ArrayList();
        DMiObjectReceiver rcvr = new DMiObjectReceiver(){

            public boolean gotOne(DMiObject ob) {
                list.add(ob);
                return true;
            }
        };
        this.getRelated(ieType, q, rcvr);
        return list.toArray(new DMiObject[0]);
    }

    @Override
    public void getRelated(String ieType, DMQuery q, DMiObjectReceiver cb) {
        ArchiveNode node = this.readItem(this.initFileLength);
        if (node == null) {
            return;
        }
        ArchiveNode[] node1 = this.getSiblingNode(node);
        if (node1 == null) {
            return;
        }
        while (!node1[0].level.equalsIgnoreCase(ieType)) {
            ArrayList<ArchiveNode> al = new ArrayList<ArchiveNode>();
            for (int i = 0; i < node1.length; ++i) {
                ArchiveNode[] th = this.getChildNodes(node1[i]);
                for (int j = 0; j < th.length; ++j) {
                    al.add(th[j]);
                }
            }
            node1 = al.toArray(new ArchiveNode[al.size()]);
        }
        for (int i = 0; i < node1.length; ++i) {
            ArchiveObject obj = new ArchiveObject(ieType, null, this, node1[i].myOffset);
            if (!(q != null ? q.valid(obj) && !cb.gotOne(obj) : !cb.gotOne(obj))) continue;
            return;
        }
    }

    @Override
    public void getChildren(DMQuery q, DMiObjectReceiver cb) {
        this.getRelated(PATIENT, q, cb);
    }

    static void buildCompositeList(ArrayList<File> list, File dir) {
        File[] fd = dir.listFiles();
        for (int i = 0; i < fd.length; ++i) {
            if (!fd[i].isDirectory()) {
                list.add(fd[i]);
                continue;
            }
            ArchiveSession.buildCompositeList(list, fd[i]);
        }
    }

    private void compressImage(InputStream is, FileOutputStream fos) {
        DicomObject dcm = new DicomObject();
        try {
            dcm.read(is);
            Compression compressedDicom = new Compression(dcm);
            if (this.dicomEncodingScheme == 1) {
                compressedDicom.compress(8197);
            }
            compressedDicom.getDicomObject().write((OutputStream)fos, true);
        }
        catch (Exception ex) {
            try {
                dcm.write((OutputStream)fos, true);
            }
            catch (Exception ex1) {
                // empty catch block
            }
        }
    }

    @Override
    public void install(InputStream is) throws IOException {
        File newdir;
        if (this.readOnlyArchive) {
            throw new IllegalStateException("Can't install: READ-ONLY MEDIA");
        }
        if (this.actualFileLength == 0L) {
            this.findFileEnd();
        }
        if (!(newdir = new File(this.dir, NEW_FILES_DIR)).exists()) {
            newdir.mkdir();
        }
        File newFile = File.createTempFile("comp", ".dcm", newdir);
        FileOutputStream fos = new FileOutputStream(newFile);
        if (this.dicomEncodingScheme != 0) {
            this.compressImage(is, fos);
        } else {
            int len = 1;
            while (len != -1) {
                len = is.read(this.bbuff);
                if (len <= 0) continue;
                fos.write(this.bbuff, 0, len);
            }
        }
        fos.close();
        is.close();
        int curPos = this.mb.position();
        this.mb.position((int)this.actualFileLength);
        DicomCompositeArchive df = new DicomCompositeArchive(this, newFile, this.requiredIETags, this.mb, this.initFileLength);
        if (df.getImagePath().endsWith("DICOM")) {
            this.mb.position(curPos);
            newFile.delete();
            return;
        }
        File finalFile = new File(this.mount, df.getImagePath());
        File parentFile = finalFile.getParentFile();
        if (null != parentFile && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        newFile.renameTo(finalFile);
        this.actualFileLength = this.mb.position();
        String msg = finalFile.getAbsolutePath().replace('\\', '/');
        this.sendEvent(1, msg, finalFile.getAbsolutePath());
    }

    private String processValue(String str) {
        int index = str.indexOf(61);
        if (index >= 0) {
            return str.substring(index + 1, str.length());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String[] send(String str) {
        if (str.equalsIgnoreCase("endWrite")) {
            this.close();
            return null;
        }
        if (str.startsWith("Encoding")) {
            String encoding = this.processValue(str);
            if (encoding == null) {
                throw new IllegalArgumentException("Not supported send string: " + str);
            }
            if (encoding.equalsIgnoreCase(JPEG)) {
                this.dicomEncodingScheme = 1;
                return null;
            } else {
                if (!encoding.equalsIgnoreCase("none")) throw new IllegalArgumentException("Compression scheme not supported: " + encoding);
                this.dicomEncodingScheme = 0;
            }
            return null;
        }
        if (str.startsWith("path")) {
            this.path = this.processValue(str);
            return null;
        }
        if (!str.startsWith("makeCD")) return null;
        try {
            String[] devs;
            int position = this.mb.position();
            this.close();
            SimpleUtilities.deleteFilesRecursively(new File(this.dir, NEW_FILES_DIR));
            SimpleUtilities.deleteFilesRecursively(new File(this.dir, REMOVE_FILES_DIR));
            String iso = "archive.iso";
            String mkisofsCmd = "mkisofs -R -o " + iso + "  " + this.dir;
            String cdrecordCmd = "cdrecord dev=1,0,0 ";
            File isoFile = new File(iso);
            if (isoFile.exists()) {
                isoFile.delete();
            }
            if ((devs = ArchiveSession.getCdRom(this.path)) == null || devs.length == 0) {
                this.reMapFile(position);
                throw new IllegalStateException("No CD-ROM drive found");
            }
            if (System.getProperty("os.name").startsWith("Windows")) {
                if (this.path == null) {
                    mkisofsCmd = "mkisofs -R -o " + iso + "  " + this.dir;
                    cdrecordCmd = "cmd.exe /c start cdrecord ";
                } else {
                    mkisofsCmd = this.path + "\\mkisofs -R -o " + iso + "  " + this.dir;
                    cdrecordCmd = "cmd.exe /c start " + this.path + "\\cdrecord ";
                }
                cdrecordCmd = cdrecordCmd + "dev=" + devs[0] + " ";
            } else {
                cdrecordCmd = "cdrecord dev=" + devs[0] + " ";
            }
            Process process = Runtime.getRuntime().exec(mkisofsCmd);
            int t = process.waitFor();
            t = process.exitValue();
            Tap.log.log(Level.INFO, "makeCD: exitValue = {0}" + process.exitValue());
            if (t == 0) {
                process = Runtime.getRuntime().exec(cdrecordCmd + iso);
                t = process.waitFor();
                t = process.exitValue();
                if (Tap.logLevel >= Tap.LEVEL_FINE) {
                    Tap.log.fine("exitValue===" + process.exitValue());
                    Tap.log.fine("position===" + position);
                }
            }
            this.reMapFile(position);
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void devnull(final InputStream is) {
        Thread t = new Thread(){

            public void run() {
                byte[] buff = new byte[2000];
                try {
                    int len;
                    while ((len = is.read(buff)) >= 0) {
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t.setDaemon(true);
        t.setName("devnull");
        t.start();
    }

    public static String[] getCdRom(String path) {
        ArrayList<String> al = new ArrayList<String>(3);
        try {
            String str;
            String scanBus = null;
            scanBus = System.getProperty("os.name").startsWith("Windows") ? (path == null ? "cdrecord -scanbus" : path + "\\cdrecord -scanbus") : "cdrecord -scanbus";
            Process p = Runtime.getRuntime().exec(scanBus);
            ArchiveSession.devnull(p.getErrorStream());
            LineNumberReader l = new LineNumberReader(new InputStreamReader(p.getInputStream()));
            while ((str = l.readLine()) != null) {
                if (str.indexOf("Removable CD-ROM") <= 1) continue;
                StringTokenizer st = new StringTokenizer(str);
                al.add(st.nextToken());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return al.toArray(new String[al.size()]);
    }

    @Override
    public DMiComposite getComposite(String id) {
        File f = new File(id);
        if (f.exists() && !f.isDirectory()) {
            return new ArchiveComposite(f, this);
        }
        return null;
    }

    public void sendEvent(int eventType, String msg, Object source) {
        this.fireEvent(new DMEvent(eventType, msg, source));
    }

    public void fireEvent(DMEvent event) {
        try {
            if (this.listenerList[event.getID()] == null) {
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return;
        }
        Iterator i = this.listenerList[event.getID()].iterator();
        while (i.hasNext()) {
            ((DMEventListener)i.next()).actionPerformed(event);
        }
    }

    @Override
    public DMiComposite[] getComposites() {
        ArchiveNode root = this.readItem(this.initFileLength);
        ArchiveNode[] images = this.getAllImageNodes(root);
        if (null == images) {
            return null;
        }
        ArrayList<DMiComposite> al = new ArrayList<DMiComposite>();
        for (int i = 0; i < images.length; ++i) {
            ArchiveObject obj = new ArchiveObject(IMAGE, null, this, images[i].myOffset);
            DMiComposite[] cmps = obj.getComposites(null);
            if (cmps == null) continue;
            al.add(cmps[0]);
        }
        if (al.size() > 0) {
            return al.toArray(new DMiComposite[al.size()]);
        }
        return null;
    }

    @Override
    public int getNumberOfComposites() {
        DMiComposite[] comps = this.getComposites();
        int num = null == comps ? 0 : comps.length;
        return num;
    }

    @Override
    public void save(DMiObject o, Hashtable prop) {
        DMiComposite[] comps = o.getComposites(null);
        for (int i = 0; i < comps.length; ++i) {
            this.save(comps[i], prop);
        }
    }

    @Override
    public void save(DMiObject[] o, Hashtable prop) {
        for (int i = 0; i < o.length; ++i) {
            this.save(o[i], prop);
        }
    }

    @Override
    public void save(DMiComposite o, Hashtable prop) {
        try {
            InputStream in = o.getInputStream();
            this.install(in);
            in.close();
        }
        catch (Exception ex) {
            throw new DMException(ex);
        }
    }

    @Override
    public void addDMEventListener(int eventType, int freq, DMEventListener listener) {
        if (this.listenerList[eventType] == null) {
            this.listenerList[eventType] = new Vector();
        }
        this.listenerList[eventType].add(listener);
    }

    @Override
    public void removeDMEventListener(DMEventListener l) {
        if (this.listenerList != null) {
            for (int i = 0; i < this.listenerList.length; ++i) {
                if (this.listenerList[i] == null) continue;
                this.listenerList[i].remove(l);
            }
        }
    }

    public void truncateToInitialSize() {
        block4: {
            RandomAccessFile thisFile = null;
            try {
                this.mb.force();
                this.mb = null;
                this.out.close();
                System.gc();
                thisFile = new RandomAccessFile(this.session, "rw");
                thisFile.getChannel().truncate(this.initFileLength);
                thisFile.close();
                this.reMapFile(this.initFileLength);
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
                if (null == thisFile) break block4;
                try {
                    thisFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void close() {
        block6: {
            RandomAccessFile thisFile = null;
            try {
                File newdir;
                this.findFileEnd();
                this.mb.force();
                this.mb = null;
                this.out.close();
                System.gc();
                if (!this.readOnlyArchive) {
                    thisFile = new RandomAccessFile(this.session, "rw");
                    thisFile.getChannel().truncate(this.actualFileLength);
                    thisFile.close();
                }
                if ((newdir = new File(this.dir, NEW_FILES_DIR)).exists()) {
                    newdir.delete();
                }
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
                if (null == thisFile) break block6;
                try {
                    thisFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void installFiles(File[] files, boolean destroy) throws FileNotFoundException, IOException {
        for (int j = 0; j < files.length; ++j) {
            File[] fd = files[j].listFiles();
            ArrayList<File> list = new ArrayList<File>();
            for (int i = 0; i < fd.length; ++i) {
                if (!fd[i].isDirectory()) {
                    list.add(fd[i]);
                    continue;
                }
                ArchiveSession.buildCompositeList(list, fd[i]);
            }
            File[] images = list.toArray(new File[list.size()]);
            for (int i = 0; i < images.length; ++i) {
                FileInputStream instream = new FileInputStream(images[i]);
                this.install(instream);
                instream.close();
            }
        }
    }

    @Override
    public DMiJob asynSend(String str) {
        throw new UnsupportedOperationException("Method asynSend() not yet implemented.");
    }

    @Override
    public DMiObject getDMiObject(String type, String id) {
        ArchiveNode node = this.readItem(Integer.parseInt(id));
        if (node.level.equalsIgnoreCase(type)) {
            return new ArchiveObject(type, null, this, Integer.parseInt(id));
        }
        return null;
    }

    @Override
    public DMiJob[] getJobs() {
        throw new UnsupportedOperationException("Method getJobs() not yet implemented.");
    }

    private void loadProperties() {
        block5: {
            FileInputStream instream = null;
            try {
                this.dicomdirProps.load(this.getClass().getResourceAsStream("dicomDir.properties"));
                String config = System.getProperties().getProperty("DICOMDIR");
                if (config != null) {
                    instream = new FileInputStream(config);
                    this.dicomdirProps.load(instream);
                    instream.close();
                }
            }
            catch (IOException ioex) {
                Tap.log.log(Level.WARNING, "Error loading properties: ", ioex);
                if (null == instream) break block5;
                try {
                    instream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        DMSession sess = new DMSession(new String[]{"pesi", "D:\\dev18\\pesiDB"});
        File dir = new File("c:\\images\\mr");
        File[] fd = dir.listFiles();
        ArrayList<File> a = new ArrayList<File>();
        for (int i = 0; i < fd.length; ++i) {
            if (!fd[i].isDirectory()) {
                a.add(fd[i]);
                continue;
            }
            ArchiveSession.buildCompositeList(a, fd[i]);
        }
        File[] images = a.toArray(new File[a.size()]);
        for (int i = 0; i < images.length; ++i) {
            FileInputStream instream = new FileInputStream(images[i]);
            sess.install(instream);
            instream.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ArchiveNode {
        public String level;
        public String type;
        public tagValue[] tvs;
        public long nextSibling = -1L;
        public long firstChild = -1L;
        public long myOffset = -1L;

        ArchiveNode(long offset, Vector<ArchiveTagValue> vc) {
            this.myOffset = offset;
            this.tvs = new tagValue[vc.size()];
            for (int i = 0; i < vc.size(); ++i) {
                ArchiveTagValue tv = vc.get(i);
                int grp = tv.group;
                int elm = tv.element;
                if (grp == 4 && elm == 5168) {
                    this.type = (String)tv.value;
                    this.level = ArchiveSession.getLevel(this.type);
                } else if (grp == 4 && elm == 5120) {
                    this.nextSibling = (Long)tv.value;
                } else if (grp == 4 && elm == 5152) {
                    this.firstChild = (Long)tv.value;
                }
                tagValue tvv = new tagValue(grp, elm);
                tagValue.copyFillData(tv, tvv);
                this.tvs[i] = tvv;
            }
        }

        public void print() {
            System.err.println("level=" + this.level + ", type=" + this.type + ", nextSib=" + this.nextSibling + ", fistChild=" + this.firstChild + ", myOffset=" + this.myOffset);
        }

        public void writeNextSiblingToDICOMDIR() {
            int curPos = ArchiveSession.this.mb.position();
            ArchiveSession.this.mb.position((int)this.myOffset + 16);
            ArchiveSession.this.mb.putInt((int)this.nextSibling);
            ArchiveSession.this.mb.position(curPos);
        }

        public void writeChildToDICOMDIR() {
            int curPos = ArchiveSession.this.mb.position();
            ArchiveSession.this.mb.position((int)this.myOffset + 38);
            ArchiveSession.this.mb.putInt((int)this.firstChild);
            ArchiveSession.this.mb.position(curPos);
        }

        public String getImagePath() {
            if (this.level.equalsIgnoreCase(ArchiveSession.IMAGE)) {
                for (int i = 0; i < this.tvs.length; ++i) {
                    if (this.tvs[i].group != 4 || this.tvs[i].element != 5376) continue;
                    String fileName = (String)this.tvs[i].value;
                    fileName = System.getProperty("os.name").startsWith("Windows") ? fileName.replace('/', File.separatorChar) : fileName.replace('\\', File.separatorChar);
                    return ArchiveSession.this.mount + File.separator + fileName;
                }
            }
            return null;
        }
    }
}

