/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.archive;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.util.dicom.tagValue;
import com.ge.med.terra.tap.util.dicom.vr;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.util.Iterator;
import java.util.Vector;

public class ArchiveTagValue
extends tagValue {
    public static final ArchiveTagValue itemEnd = new ArchiveTagValue();
    public static final ArchiveTagValue itemStart = new ArchiveTagValue();
    public static final ArchiveTagValue seqEnd = new ArchiveTagValue();
    private final byte[] nullByte = new byte[]{0};
    private final byte[] spaceByte = new byte[]{32};

    public ArchiveTagValue() {
    }

    public ArchiveTagValue(int g, int e, MappedByteBuffer out) {
        super(g, e);
        this.fillInData(out);
    }

    public ArchiveTagValue(int grp, int elem, String vr2, DMObject o) {
        this.copyGEV(grp, elem, vr2);
        Object v = o.getValue(grp, elem);
        String svalue = "";
        if (!(v instanceof String)) {
            return;
        }
        svalue = (String)v;
        if (vr2.equals("DA") && svalue.length() >= 8) {
            this.value = svalue.substring(0, 8);
            this.len = 8;
            return;
        }
        this.len = svalue.length();
        this.value = svalue;
    }

    public ArchiveTagValue(int grp, int elem, String vr2, byte[] value) {
        this.copyGEV(grp, elem, vr2);
        if (vr2.equals("OB") || vr2.equals("OW")) {
            this.len = value.length;
            this.value = value;
        }
    }

    public ArchiveTagValue(int grp, int elem, String vr2, Vector vec) {
        this.copyGEV(grp, elem, vr2);
        if (!vr2.equals("SQ")) {
            throw new Error("value not a SQ");
        }
        this.value = vec;
    }

    public ArchiveTagValue(int grp, int elem, String vr2) {
        this.copyGEV(grp, elem, vr2);
        if (!vr2.equals("SQ")) {
            throw new Error("value not a SQ");
        }
        this.value = null;
    }

    public ArchiveTagValue(int grp, int elem, String vr2, int[] value) {
        this.copyGEV(grp, elem, vr2);
        if (!vr2.equals("SL")) {
            throw new Error("value not a SL");
        }
        this.len = 4 * value.length;
        this.value = value;
    }

    public ArchiveTagValue(int grp, int elem, String vr2, long value) {
        this.copyGEV(grp, elem, vr2);
        if (!vr2.equals("UL")) {
            throw new Error("value not a UL");
        }
        this.len = 4;
        this.value = new Long(value);
    }

    public ArchiveTagValue(int grp, int elem, String vr2, String value) {
        this.copyGEV(grp, elem, vr2);
        if (vr2.equals("DA") && value.length() >= 8) {
            this.value = value.substring(0, 8);
            this.len = 8;
            return;
        }
        this.len = value.length();
        this.value = value;
    }

    public ArchiveTagValue(int grp, int elem, String vr2, int value) {
        this.copyGEV(grp, elem, vr2);
        this.len = vr2.equals("SS") || vr2.equals("US") ? 2 : 4;
        this.value = new Integer(value);
    }

    private void copyGEV(int grp, int elm, String vrr) {
        this.group = grp;
        this.element = elm;
        this.vrep = vr.StringVRint(vrr);
    }

    public static void writeUnsignedShort(int value, MappedByteBuffer out) throws IOException {
        short val = (short)(value & Short.MAX_VALUE);
        if (value > val) {
            val = (short)(val | 0x8000);
        }
        out.putShort(val);
    }

    public static void writeUnsignedInt(long value, MappedByteBuffer out) throws IOException {
        int val = (int)(value & Integer.MAX_VALUE);
        if (value > (long)val) {
            val |= Integer.MIN_VALUE;
        }
        out.putInt(val);
    }

    public void write(MappedByteBuffer out) throws IOException {
        if (itemEnd == this) {
            ArchiveTagValue.writeUnsignedShort(65534, out);
            ArchiveTagValue.writeUnsignedShort(57357, out);
            ArchiveTagValue.writeUnsignedInt(0L, out);
            return;
        }
        if (seqEnd == this) {
            ArchiveTagValue.writeUnsignedShort(65534, out);
            ArchiveTagValue.writeUnsignedShort(57565, out);
            ArchiveTagValue.writeUnsignedInt(0L, out);
            return;
        }
        if (itemStart == this) {
            ArchiveTagValue.writeUnsignedShort(65534, out);
            ArchiveTagValue.writeUnsignedShort(57344, out);
            ArchiveTagValue.writeUnsignedInt(0xFFFFFFFFL, out);
            return;
        }
        ArchiveTagValue.writeUnsignedShort(this.group, out);
        ArchiveTagValue.writeUnsignedShort(this.element, out);
        out.put(vr.toString(this.vrep).getBytes());
        if (vr.toString(this.vrep).equals("SQ")) {
            ArchiveTagValue.writeUnsignedShort(0, out);
            ArchiveTagValue.writeUnsignedInt(0xFFFFFFFFL, out);
            if (this.value != null) {
                Iterator itr = ((Vector)this.value).iterator();
                while (itr.hasNext()) {
                    ((ArchiveTagValue)itr.next()).write(out);
                }
            }
            return;
        }
        if (this.value instanceof String) {
            int len = ((String)this.value).length();
            if ((len & 1) == 0) {
                ArchiveTagValue.writeUnsignedShort(len, out);
                out.put(((String)this.value).getBytes());
            } else {
                ArchiveTagValue.writeUnsignedShort(++len, out);
                out.put(((String)this.value).getBytes());
                if (vr.toString(this.vrep).equals("UI")) {
                    out.put(this.nullByte);
                } else {
                    out.put(this.spaceByte);
                }
            }
            return;
        }
        if (this.value instanceof Integer) {
            Integer ival = (Integer)this.value;
            if (vr.toString(this.vrep).equals("SS")) {
                ArchiveTagValue.writeUnsignedShort(2, out);
                out.putInt(ival);
            } else if (vr.toString(this.vrep).equals("US")) {
                ArchiveTagValue.writeUnsignedShort(2, out);
                ArchiveTagValue.writeUnsignedShort(ival, out);
            } else if (vr.toString(this.vrep).equals("SL")) {
                ArchiveTagValue.writeUnsignedShort(4, out);
                out.putInt(ival);
            } else {
                throw new Error("not supported int & " + vr.toString(this.vrep));
            }
            return;
        }
        if (this.value instanceof Long) {
            long lval = (Long)this.value;
            if (vr.toString(this.vrep).equals("UL")) {
                ArchiveTagValue.writeUnsignedShort(4, out);
                ArchiveTagValue.writeUnsignedInt(lval, out);
                return;
            }
            throw new Error("not supported long & " + vr.toString(this.vrep));
        }
        if (this.value instanceof int[]) {
            int[] ival = (int[])this.value;
            if (vr.toString(this.vrep).equals("SS")) {
                short[] sval = (short[])this.value;
                ArchiveTagValue.writeUnsignedShort(2 * ival.length, out);
                out.asShortBuffer().put(sval);
            } else if (vr.toString(this.vrep).equals("US")) {
                ArchiveTagValue.writeUnsignedShort(2 * ival.length, out);
                for (int i = 0; i < ival.length; ++i) {
                    ArchiveTagValue.writeUnsignedShort(ival[i], out);
                }
            } else if (vr.toString(this.vrep).equals("SL")) {
                ArchiveTagValue.writeUnsignedShort(4 * ival.length, out);
                out.asIntBuffer().put(ival);
            } else {
                throw new Error("not supported int[] & " + vr.toString(this.vrep));
            }
            return;
        }
        if (this.value instanceof byte[]) {
            byte[] ival = (byte[])this.value;
            if (!vr.toString(this.vrep).equals("OB")) {
                throw new Error("not supported " + vr.toString(this.vrep));
            }
            ArchiveTagValue.writeUnsignedShort(0, out);
            ArchiveTagValue.writeUnsignedInt(ival.length, out);
            out.put(ival, 0, ival.length);
            return;
        }
        throw new Error("not supported " + vr.toString(this.vrep));
    }

    private void fillInData(MappedByteBuffer out) {
        this.fileOffset = out.position() - 4;
        if (this.group == 65534) {
            this.len = out.getInt() & 0xFFFFFFFF;
            return;
        }
        this.vrep = this.readVR(out);
        if (this.vrep == 20290 || this.vrep == 20311 || this.vrep == 21329 || this.vrep == 21838 || this.vrep == 21844 || this.vrep == 20294) {
            out.getShort();
            this.len = out.getInt() & 0xFFFFFFFF;
        } else {
            this.len = out.getShort() & 0xFFFF;
        }
        if (this.vrep == 16724) {
            int[] tvalue = new int[this.len / 2];
            out.asIntBuffer().get(tvalue);
            out.position(out.position() + this.len);
            this.value = tvalue.length == 1 ? new Integer(tvalue[0]) : (Object)tvalue;
        } else if (this.vrep == 21836) {
            int[] tvalue = new int[this.len / 4];
            out.asIntBuffer().get(tvalue);
            out.position(out.position() + this.len);
            this.value = tvalue.length == 1 ? new Long(tvalue[0]) : (Object)tvalue;
        } else if (this.vrep == 21324) {
            int[] tvalue = new int[this.len / 4];
            out.asIntBuffer().get(tvalue);
            out.position(out.position() + this.len);
            this.value = tvalue.length == 1 ? new Integer(tvalue[0]) : (Object)tvalue;
        } else if (this.vrep == 21331) {
            short[] tvalue = new short[this.len / 2];
            out.asShortBuffer().get(tvalue);
            out.position(out.position() + this.len);
            this.value = tvalue.length == 1 ? new Integer(tvalue[0]) : (Object)tvalue;
        } else if (this.vrep == 21843) {
            short[] tvalue = new short[this.len / 2];
            out.asShortBuffer().get(tvalue);
            out.position(out.position() + this.len);
            if (tvalue.length == 1) {
                this.value = new Integer(tvalue[0] & 0xFFFF);
            } else {
                for (int i = 0; i < tvalue.length; ++i) {
                    tvalue[i] = (short)(tvalue[i] & 0xFFFF);
                }
                this.value = tvalue;
            }
        } else if (this.vrep == 17996) {
            float[] tvalue = new float[this.len / 4];
            out.asFloatBuffer().get(tvalue);
            out.position(out.position() + this.len);
            this.value = tvalue.length == 1 ? new Float(tvalue[0]) : (Object)tvalue;
        } else if (this.vrep == 17988) {
            double[] tvalue = new double[this.len / 8];
            out.asDoubleBuffer().get(tvalue);
            out.position(out.position() + this.len);
            this.value = tvalue.length == 1 ? new Double(tvalue[0]) : (Object)tvalue;
        } else if (this.len > 0) {
            byte[] str = new byte[this.len];
            out.get(str);
            this.value = new String(str, 0, str.length).trim();
        } else {
            this.value = "";
        }
    }

    private int readVR(MappedByteBuffer out) {
        int t1 = out.get() & 0xFF;
        int t2 = out.get() & 0xFF;
        return t1 << 8 | t2;
    }
}

