/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.base.ROIUtils;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.roi.CvPolygonRoi;
import com.ge.med.cse.cvf.util.CvUtils;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.logging.Level;

public class XpLineROIAction
extends BaseAction {
    protected String getName() {
        return "XP_LINE_ROI";
    }

    public void actionPerformed(ActionEvent e) {
        Point2D[] pts = null;
        String[] params = this.getParams();
        try {
            if (params != null && params.length > 0) {
                pts = this.parseParams(params);
                this.setParams(null);
            } else {
                pts = CvUtils.getROIUtils().getROICoordinates(this.getROICapable(), ROIUtils.ROITYPE.LINE);
            }
            if (pts != null) {
                this.getROICapable().add(new CvPolygonRoi(pts));
            } else {
                this.getLogger().log(Level.WARNING, "Line Points returned NULL.");
            }
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during the line roi add", exp);
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CMD_NOT_SUPPORTED"));
        }
    }

    private Point2D[] parseParams(String[] st) {
        Point2D[] pts = null;
        if (st.length != 4) {
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
            this.getLogger().log(Level.WARNING, "Invalid Line ROI arguments");
        } else {
            try {
                Double[] dpts = new Double[4];
                for (int i = 0; i < st.length; ++i) {
                    dpts[i] = Double.parseDouble(st[i]);
                }
                pts = new Point2D[]{new Point2D.Double(dpts[0], dpts[1]), new Point2D.Double(dpts[2], dpts[3])};
                pts[0] = CvUtils.getValidImagePoint(pts[0], this.getROICapable());
                pts[1] = CvUtils.getValidImagePoint(pts[1], this.getROICapable());
            }
            catch (Exception e) {
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                this.getLogger().log(Level.WARNING, "Invalid argument for Line ROI", e);
            }
        }
        return pts;
    }
}

