/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.base.ROIUtils;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.roi.CvRectangularRoi;
import com.ge.med.cse.cvf.util.CvUtils;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;

public class XpRectangularROIAction
extends BaseAction {
    protected String getName() {
        return "XP_RECTANGULAR_ROI";
    }

    public void actionPerformed(ActionEvent e) {
        Shape roiShape = null;
        String[] params = this.getParams();
        try {
            if (params != null && params.length > 0) {
                roiShape = this.parseParams(params);
                this.setParams(null);
            } else {
                roiShape = CvUtils.getROIUtils().getROIPosition(this.getROICapable(), ROIUtils.ROITYPE.RECTANGLE);
            }
            if (roiShape != null) {
                this.getROICapable().add(new CvRectangularRoi.Rectangle((Rectangle2D)roiShape));
            } else {
                this.getLogger().log(Level.WARNING, "Rectangle Shape returned NULL.");
            }
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during the rectangular roi add", exp);
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CMD_NOT_SUPPORTED"));
        }
    }

    private Shape parseParams(String[] st) {
        Rectangle2D.Double s = null;
        Point2D[] pts = null;
        if (st.length != 8) {
            this.getLogger().log(Level.WARNING, "Invalid Rectangular ROI arguments");
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
        } else {
            try {
                Double[] dpts = new Double[8];
                for (int i = 0; i < st.length; ++i) {
                    dpts[i] = Double.parseDouble(st[i]);
                }
                pts = new Point2D[]{new Point2D.Double(dpts[0], dpts[1]), new Point2D.Double(dpts[2], dpts[3]), new Point2D.Double(dpts[4], dpts[5]), new Point2D.Double(dpts[6], dpts[7])};
                pts[0] = CvUtils.getValidImagePoint(pts[0], this.getROICapable());
                pts[1] = CvUtils.getValidImagePoint(pts[1], this.getROICapable());
                pts[2] = CvUtils.getValidImagePoint(pts[2], this.getROICapable());
                pts[3] = CvUtils.getValidImagePoint(pts[3], this.getROICapable());
                double minX = pts[0].getX();
                double maxX = pts[0].getX();
                double minY = pts[0].getY();
                double maxY = pts[0].getY();
                for (int i = 1; i < 4; ++i) {
                    if (minX > pts[i].getX()) {
                        minX = pts[i].getX();
                    }
                    if (maxX < pts[i].getX()) {
                        maxX = pts[i].getX();
                    }
                    if (minY > pts[i].getY()) {
                        minY = pts[i].getY();
                    }
                    if (!(maxY < pts[i].getY())) continue;
                    maxY = pts[i].getY();
                }
                int width = Math.abs((int)(maxX - minX));
                int height = Math.abs((int)(maxY - minY));
                s = new Rectangle2D.Double(minX, minY, width, height);
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Invalid Rectangular ROI arguments", e);
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
            }
        }
        return s;
    }
}

