/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.cse.cvf.roi.CvContinuousReporter;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnnotationVc;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpMedicalImage2DVc;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpMRCTApdAnnotationConfig;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.capable.InfoLabelReporter;
import com.ge.med.terra.jami.capable.Visible;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import java.awt.Component;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JComponent;

public class XpCvApdAnnotationConfig
extends XpMRCTApdAnnotationConfig {
    private static final int MAX_ROI_RESULTS = 3;
    private static final String[] roiPropName = new String[]{"roiResult3", "roiResult2", "roiResult1"};
    private static final DecimalFormat rasf = new DecimalFormat("###0.00");
    private static final String[] pads = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         "};
    private ArrayList roiInfoList = new ArrayList();
    private LinkedList lastSelectedRois = new LinkedList();
    private int selectedRoi = -1;

    protected void setROIInfo(XpAnnotationVc avc, JComponent jc) {
        int i;
        XpAnnotationModel am = avc.getAnnotationModel();
        if (am == null) {
            return;
        }
        boolean probeQ = DicomUtils.isMRProbeQImage(am.getDicomObject());
        am.setProperty("reportPixel_R", "");
        am.setProperty("reportPixel_A", "");
        am.setProperty("reportPixel_S", "");
        am.setProperty("reportPixel_V", "");
        this.roiInfoList.clear();
        this.selectedRoi = -1;
        int nroi = 0;
        int childCount = jc.getComponentCount();
        for (i = 0; i < childCount; ++i) {
            Component c = jc.getComponent(i);
            if (c instanceof XpImageRoiVc && XpStatisticsRoi.isShowStatistics() || c instanceof InfoLabelReporter) {
                String label = null;
                if (c instanceof XpImageRoiVc) {
                    XpImageRoiVc rvc = (XpImageRoiVc)c;
                    RoiActor ra = rvc.getRoiActor();
                    if (ra instanceof Visible && ((Visible)((Object)ra)).isVisible() && ra instanceof InfoLabelReporter) {
                        InfoLabelReporter ilr = (InfoLabelReporter)((Object)ra);
                        label = ilr.getInfoLabel();
                        if (ra.isSelected()) {
                            this.selectedRoi = nroi;
                        }
                    }
                } else if (c instanceof InfoLabelReporter) {
                    label = ((InfoLabelReporter)((Object)c)).getInfoLabel();
                }
                if (label == null) continue;
                this.roiInfoList.add(nroi, label);
                ++nroi;
                continue;
            }
            if (!(c instanceof CvContinuousReporter)) continue;
            CvContinuousReporter pm = (CvContinuousReporter)c;
            if (pm.isVisible()) {
                CPoint cp = pm.getRAS();
                double value = pm.getValue();
                String R = "R ";
                String A = "A ";
                String S = "S ";
                String V = "V = ";
                double r = cp.x;
                double a = cp.y;
                double s = cp.z;
                if (r < 0.0) {
                    r = -r;
                    R = "L ";
                }
                if (a < 0.0) {
                    a = -a;
                    A = "P ";
                }
                if (s < 0.0) {
                    s = -s;
                    S = "I ";
                }
                R = R + rasf.format(r) + "mm";
                A = A + rasf.format(a) + "mm";
                S = S + rasf.format(s) + "mm";
                V = V + rasf.format(value);
                int rlen = R.length();
                int alen = A.length();
                int slen = S.length();
                int vlen = V.length();
                int max = Math.max(rlen, alen);
                max = Math.max(max, slen);
                if ((max = Math.max(max, vlen)) > rlen) {
                    R = R + pads[max - rlen];
                }
                if (max > alen) {
                    A = A + pads[max - alen];
                }
                if (max > slen) {
                    S = S + pads[max - slen];
                }
                if (max > vlen) {
                    V = V + pads[max - vlen];
                }
                am.setProperty("reportPixel_R", R);
                am.setProperty("reportPixel_A", A);
                am.setProperty("reportPixel_S", S);
                am.setProperty("reportPixel_V", V);
                if (!am.queryAnnotationItem("Graphic_Results")) continue;
                am.setAnnotationItems(new String[]{"Report_Cursor"}, true);
                continue;
            }
            if (probeQ) continue;
            am.setAnnotationItems(new String[]{"Report_Cursor"}, false);
        }
        if (nroi > 0) {
            if (this.selectedRoi == -1) {
                if (this.lastSelectedRois.size() > nroi) {
                    int diff = this.lastSelectedRois.size() - nroi;
                    for (int i2 = 0; i2 < diff; ++i2) {
                        int lastSelectedIdx = Integer.parseInt((String)this.lastSelectedRois.getLast());
                        LinkedList<String> temp = new LinkedList<String>();
                        int nlsr = this.lastSelectedRois.size();
                        for (int j = 0; j < nlsr - 1; ++j) {
                            int index = Integer.parseInt((String)this.lastSelectedRois.get(j));
                            if (index > lastSelectedIdx) {
                                --index;
                            }
                            temp.add("" + index);
                        }
                        this.lastSelectedRois = temp;
                    }
                }
            } else {
                if (this.lastSelectedRois.contains("" + this.selectedRoi)) {
                    this.lastSelectedRois.remove("" + this.selectedRoi);
                }
                this.lastSelectedRois.add("" + this.selectedRoi);
            }
            int noStat = 3;
            int rsIndex = 0;
            if (this.lastSelectedRois.size() < nroi) {
                for (int i3 = 0; i3 < nroi; ++i3) {
                    if (this.lastSelectedRois.contains("" + i3)) continue;
                    this.lastSelectedRois.add("" + i3);
                }
            }
            for (int i4 = nroi - 1; i4 >= 0 && noStat > 0; --i4) {
                int index = Integer.parseInt((String)this.lastSelectedRois.get(i4));
                if (index >= this.roiInfoList.size()) continue;
                am.setProperty(roiPropName[rsIndex], (String)this.roiInfoList.get(index));
                ++rsIndex;
                --noStat;
            }
        } else {
            this.lastSelectedRois.clear();
        }
        for (i = nroi; i < 3; ++i) {
            am.setProperty(roiPropName[i], "");
        }
    }

    public static class PET
    extends XpCvApdAnnotationConfig {
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            XpAnnotationModel am = avc.getAnnotationModel();
            if (am == null) {
                return;
            }
            XpImageRenderAttributesOwner iraOwner = (XpImageRenderAttributesOwner)((Object)jc);
            XpVisualComponent vc = (XpVisualComponent)jc;
            FrameOwner fowner = (FrameOwner)((Object)jc);
            XpDicomElement wwwlUnits = new XpDicomElement(84, 4097);
            XpImage xi = fowner.getFrame();
            XpDicomObject dobj = (XpDicomObject)((Object)xi);
            if (dobj != null) {
                dobj.getValue(wwwlUnits);
            }
            this.setRASCorners(avc, vc);
            if (jc instanceof XpMedicalImage2DVc) {
                XpMedicalImage2DVc mivc = (XpMedicalImage2DVc)jc;
                XpImage2DVc viewport = mivc.getImageVc();
                this.setROIInfo(avc, viewport);
                XpImageRenderAttributes ira = iraOwner.getImageRenderAttributes();
                double wMax = 0.0;
                double wMin = 0.0;
                String windowingUnits = wwwlUnits.getStringValue();
                if (windowingUnits != null && windowingUnits.compareTo("BQML") == 0) {
                    wMax = ira.getWindowMax() / 1000.0;
                    wMin = ira.getWindowMin() / 1000.0;
                } else {
                    wMax = ira.getWindowMax();
                    wMin = ira.getWindowMin();
                }
                double zoom = ira.getZoom();
                if (jc instanceof XpMedicalImage2DVc) {
                    XpMedicalImage2DVc mivc1 = (XpMedicalImage2DVc)jc;
                    XpImageOrientation ior = mivc1.getDisplayOrientation();
                    String iorStr = "" + ior;
                    am.setProperty("currentOrientation", iorStr);
                }
                am.setProperty("windowMin", wMin);
                am.setProperty("windowMax", wMax);
                am.setProperty("zoomFactor", zoom);
            }
        }
    }

    public static class CTScout
    extends XpCvApdAnnotationConfig {
    }

    public static class CT
    extends XpCvApdAnnotationConfig {
    }

    public static class MR
    extends XpCvApdAnnotationConfig {
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            XpAnnotationModel am = avc.getAnnotationModel();
            if (am == null) {
                return;
            }
            super.configAnnotation(avc, jc);
        }
    }
}

