/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.model;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.Preferences;

public class WWWLModel {
    public static final String CONTENT_CHANGED = "WWWLModel_changed";
    private static Preferences cvprefs = CvPropertiesManager.getUserPreferences();
    private static Map<String, WWWLModel> modalityMap = new HashMap<String, WWWLModel>();
    private String myModality = null;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private DecimalFormat format = new DecimalFormat("#0");
    private String defPreset = null;
    private String defKeys = null;
    private String defPresetValue = null;
    private String defPresetTitle = null;
    private static final String supportedMod = CvPropertiesManager.getProperty("cvf.modalities", "");
    private StringBuffer buf = new StringBuffer();

    public static WWWLModel getModel(String modality) {
        if (modality != null) {
            modality = modality.trim().toLowerCase(Locale.ENGLISH);
        }
        if (modality == null || !supportedMod.trim().contains(modality)) {
            modality = "default";
        }
        if (!modalityMap.containsKey(modality)) {
            modalityMap.put(modality, new WWWLModel(modality));
        }
        return modalityMap.get(modality);
    }

    private WWWLModel(String strmod) {
        this.myModality = strmod.trim().toLowerCase(Locale.ENGLISH);
        this.defPreset = CvPropertiesManager.getProperty("cvf.wwwlpresets." + this.myModality);
        if (this.defPreset == null) {
            this.defPreset = CvPropertiesManager.getProperty("cvf.wwwlpresets.default");
            this.defKeys = CvPropertiesManager.getProperty("cvf.wwwlpresets.default.keys");
            this.defPresetTitle = CvPropertiesManager.getProperty("cvf.wwwlpresets.default.title");
            this.defPresetValue = CvPropertiesManager.getProperty("cvf.wwwlpresets.default.value");
        } else {
            this.defPreset = CvPropertiesManager.getProperty("cvf.wwwlpresets." + this.myModality);
            this.defKeys = CvPropertiesManager.getProperty("cvf.wwwlpresets." + this.myModality + ".keys");
            this.defPresetTitle = CvPropertiesManager.getProperty("cvf.wwwlpresets." + this.myModality + ".title");
            this.defPresetValue = CvPropertiesManager.getProperty("cvf.wwwlpresets." + this.myModality + ".value");
        }
    }

    public String[] getPresets() {
        return cvprefs.get(this.myModality + "_presets", this.defPreset).split("#");
    }

    public String getPresetForKey(String strKey) {
        String[] shKeys = cvprefs.get(this.myModality + "_keys", this.defKeys).split("#");
        int count = 0;
        for (String strFnKey : shKeys) {
            if (strFnKey.trim().equalsIgnoreCase(strKey.trim())) break;
            ++count;
        }
        return this.getPresets()[count];
    }

    public double[] getWWWL(String strkey) {
        String[] wwwl = cvprefs.get(this.myModality + "_presets_value", this.defPresetValue).trim().split("#");
        if (this.getIndex(strkey) == -1) {
            return null;
        }
        String[] split = wwwl[this.getIndex(strkey)].split(",");
        double[] toReturn = new double[]{Double.parseDouble(split[0]), Double.parseDouble(split[1])};
        toReturn[0] = Double.parseDouble(this.format.format(toReturn[0]));
        toReturn[1] = Double.parseDouble(this.format.format(toReturn[1]));
        return toReturn;
    }

    public String getShortCutKey(String strKey) {
        String[] Keys = cvprefs.get(this.myModality + "_presets_keys", this.defKeys).split("#");
        return Keys[this.getIndex(strKey)];
    }

    public String getTitle(String strKey) {
        String[] title = cvprefs.get(this.myModality + "_presets_title", this.defPresetTitle).split("#");
        return title[this.getIndex(strKey)];
    }

    public void setTitle(String strKey, String strValue) {
        if (strKey == null || strValue == null) {
            throw new IllegalArgumentException("Null key or value");
        }
        int indexToRep = this.getIndex(strKey);
        String[] title = cvprefs.get(this.myModality + "_presets_title", this.defPresetTitle).split("#");
        String toSet = this.replaceValue(indexToRep, title, strValue);
        cvprefs.put(this.myModality + "_presets_title", toSet);
        this.fireChange();
    }

    public void setWWWL(String strKey, double[] val) {
        if (strKey == null || val == null) {
            throw new IllegalArgumentException("Null key or value");
        }
        int indexToRep = this.getIndex(strKey);
        String[] title = cvprefs.get(this.myModality + "_presets_value", this.defPresetValue).split("#");
        String strValue = val[0] + "," + val[1];
        String toSet = this.replaceValue(indexToRep, title, strValue);
        cvprefs.put(this.myModality + "_presets_value", toSet);
        this.fireChange();
    }

    public void addPropertyChangeListener(PropertyChangeListener list) {
        this.pcs.addPropertyChangeListener(CONTENT_CHANGED, list);
    }

    public void removePropertyChangeListener(PropertyChangeListener list) {
        this.pcs.removePropertyChangeListener(CONTENT_CHANGED, list);
    }

    void fireChange() {
        try {
            cvprefs.sync();
            cvprefs.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pcs.firePropertyChange(CONTENT_CHANGED, null, this);
    }

    private int getIndex(String strKey) {
        String[] presets = this.getPresets();
        for (int i = 0; i < presets.length; ++i) {
            if (!presets[i].trim().equalsIgnoreCase(strKey)) continue;
            return i;
        }
        return -1;
    }

    private String replaceValue(int index, String[] lookup, String strNewValue) {
        this.buf.delete(0, this.buf.length());
        for (int i = 0; i < lookup.length; ++i) {
            if (i == index) {
                this.buf.append(strNewValue.trim());
            } else {
                this.buf.append(lookup[i]);
            }
            if (i == lookup.length - 1) continue;
            this.buf.append("#");
        }
        return this.buf.toString();
    }
}

