/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu;

import java.util.Vector;

public class JnParallelTaskManager {
    public static int NCPUS = 1;
    public Object lock = new Object();
    public int notDone = 0;
    public JnWorker[] workers = null;
    public Object rundata = null;
    private ThreadPool pool = new ThreadPool(NCPUS);

    public final void setWorkers(Worker[] w) {
        this.workers = new JnWorker[w.length];
        for (int i = 0; i < w.length; ++i) {
            this.workers[i] = new JnWorker(this, w[i], i);
        }
    }

    public final void shutdown() {
        this.workers = null;
        this.rundata = null;
    }

    public static int getNumCPU() {
        return NCPUS;
    }

    public void destroy() {
        this.pool.destroy();
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public long launch(Object data) {
        long t0 = System.currentTimeMillis();
        this.rundata = data;
        for (int i = 0; i < this.workers.length - 1; ++i) {
            ++this.notDone;
            this.pool.add(this.workers[i]);
        }
        int last = this.workers.length - 1;
        this.workers[last].work(last, this.workers.length, this.rundata);
        this.pool.waitfordone();
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    static {
        NCPUS = 0;
        try {
            int systemcpus = Runtime.getRuntime().availableProcessors();
            String s_ncpus = System.getProperty("jami.ncpus", "" + systemcpus);
            NCPUS = Integer.parseInt(s_ncpus);
            if (NCPUS <= 0) {
                NCPUS = systemcpus;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (NCPUS <= 0) {
            NCPUS = 2;
        }
    }

    private static class ThreadPool {
        private transient Vector taskList = new Vector();
        transient int runCount = 0;
        Object runCountLock = new Object();
        transient boolean done = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Runnable task) {
            Object object = this.runCountLock;
            synchronized (object) {
                ++this.runCount;
            }
            object = this.taskList;
            synchronized (object) {
                this.taskList.add(task);
                this.taskList.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            this.done = true;
            Vector vector = this.taskList;
            synchronized (vector) {
                this.taskList.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitfordone() {
            Object object = this.runCountLock;
            synchronized (object) {
                while (this.runCount > 0) {
                    try {
                        this.runCountLock.wait();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyRunCount() {
            Object object = this.runCountLock;
            synchronized (object) {
                --this.runCount;
                this.runCountLock.notify();
            }
        }

        public ThreadPool(int threads) {
            for (int i = 0; i < threads; ++i) {
                Thread t = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        while (true) {
                            try {
                                while (true) {
                                    Runnable r = null;
                                    Vector vector = ThreadPool.this.taskList;
                                    synchronized (vector) {
                                        while (ThreadPool.this.taskList.isEmpty()) {
                                            ThreadPool.this.taskList.wait();
                                            if (!ThreadPool.this.done) continue;
                                            return;
                                        }
                                        r = (Runnable)ThreadPool.this.taskList.remove(0);
                                    }
                                    r.run();
                                    ThreadPool.this.notifyRunCount();
                                }
                            }
                            catch (Exception ex) {
                                if (ThreadPool.this.done) {
                                    return;
                                }
                                ex.printStackTrace();
                                ThreadPool.this.notifyRunCount();
                                continue;
                            }
                            break;
                        }
                    }
                };
                t.setDaemon(true);
                t.setName("JAMI ThreadPool Thread" + i);
                t.start();
            }
        }
    }

    private static class JnWorker
    implements Runnable {
        private JnParallelTaskManager ptm = null;
        private Worker worker = null;
        private int workerId = -1;

        public JnWorker(JnParallelTaskManager ptm, Worker worker, int workerId) {
            this.ptm = ptm;
            this.worker = worker;
            this.workerId = workerId;
        }

        public void work(int workerId, int nWorkers, Object data) {
            this.worker.work(workerId, nWorkers, data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            this.worker.work(this.workerId, this.ptm.workers.length, this.ptm.rundata);
            Object object = this.ptm.lock;
            synchronized (object) {
                --this.ptm.notDone;
                this.ptm.lock.notify();
            }
        }
    }

    public static interface Worker {
        public void work(int var1, int var2, Object var3);
    }
}

