/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.shape.EdgeProfileRounded;
import com.ge.med.ptk.shape.NamedShape;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class CuiSpinnerUI
extends BasicSpinnerUI {
    protected static Logger logger_ = Logger.getLogger((class$com$ge$med$ptk$laf$CuiSpinnerUI == null ? (class$com$ge$med$ptk$laf$CuiSpinnerUI = CuiSpinnerUI.class$("com.ge.med.ptk.laf.CuiSpinnerUI")) : class$com$ge$med$ptk$laf$CuiSpinnerUI).getName());
    protected static Object super_nextButtonHandler_;
    protected static Object super_previousButtonHandler_;
    static /* synthetic */ Class class$com$ge$med$ptk$laf$CuiSpinnerUI;
    static /* synthetic */ Class class$javax$swing$plaf$basic$BasicSpinnerUI;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery((String[])argv, (String)"@(#)ptk2 2.7 200609011020 (Sun Microsystems Inc.|1.4.2_05|48.0|Linux|2.6.7-2.2smp|i386|batbuild)");
    }

    public static ComponentUI createUI(JComponent c) {
        return new CuiSpinnerUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.spinner.setOpaque(false);
    }

    public void uninstallUI(JComponent c) {
        try {
            ((MouseListener)super_nextButtonHandler_).mouseReleased(null);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            ((MouseListener)super_previousButtonHandler_).mouseReleased(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.uninstallUI(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension pref = super.getPreferredSize(c);
        Dimension min = (Dimension)UIManager.get("Spinner.minimumSize");
        Dimension max = (Dimension)UIManager.get("Spinner.maximumSize");
        if (max != null) {
            pref.setSize(Math.min(max.width, pref.width), Math.min(max.height, pref.height));
        }
        if (min != null) {
            pref.setSize(Math.max(min.width, pref.width), Math.max(min.height, pref.height));
        }
        return pref;
    }

    protected Component createButton(final String previousOrNext) {
        Border border;
        Insets margin;
        final int direction = previousOrNext.equals("previous") ? 0 : 1;
        JButton button = new JButton(){
            private Icon icon_;
            {
                this.setRequestFocusEnabled(false);
                this.icon_ = new Icon(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    private Dimension getSize() {
                        Insets insets = this.this$1.getInsets();
                        int h = Math.min((this.this$1.getWidth() - (insets.left + insets.right)) / 2, this.this$1.getHeight() - (insets.top + insets.bottom));
                        int w = 2 * h;
                        return new Dimension(w, h);
                    }

                    public int getIconWidth() {
                        return this.getSize().width;
                    }

                    public int getIconHeight() {
                        return this.getSize().height;
                    }

                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        Dimension size = this.getSize();
                        int w = size.width;
                        int h = size.height;
                        if (size.width <= 0 || size.height <= 0) {
                            return;
                        }
                        float[][] p = new float[][]{{0.0f, 0.0f, w, 0.0f, (float)w / 2.0f, h}, {0.0f, h, w, h, (float)w / 2.0f, 0.0f}};
                        int i = 1.access$000(this.this$1);
                        String shapeID = "SpinnerButton[" + i + "," + this.this$1.getWidth() + "x" + this.this$1.getHeight() + "]";
                        Shape shape = (Shape)Utilities.shapeCache_.get(shapeID);
                        if (shape == null) {
                            GeneralPath path = new GeneralPath();
                            path.moveTo(p[i][0], p[i][1]);
                            path.lineTo(p[i][2], p[i][3]);
                            path.lineTo(p[i][4], p[i][5]);
                            path.closePath();
                            shape = new NamedShape(shapeID, path);
                            Utilities.shapeCache_.put(shapeID, shape);
                        }
                        EdgeProfileRounded profile = new EdgeProfileRounded(0.0, 0.0);
                        Color interiorColor = !CuiSpinnerUI.access$200(1.access$100(this.this$1)).isEnabled() ? UIManager.getColor("P4") : (!this.this$1.getModel().isPressed() ? this.this$1.getForeground() : this.this$1.getBackground());
                        Color exteriorColor = new Color(0, true);
                        Rectangle cutout = null;
                        BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(size, shape, profile, interiorColor, exteriorColor, cutout);
                        g.drawImage(renderedShape, x, y, null);
                    }
                };
            }

            public void updateUI() {
                if (this.getClientProperty("Spinner." + previousOrNext + ".uiLock") == null) {
                    super.updateUI();
                }
            }

            public Icon getIcon() {
                return this.icon_;
            }

            public Dimension getPreferredSize() {
                Insets insets = this.getInsets();
                int size = CuiSpinnerUI.this.spinner.getEditor() != null ? ((CuiSpinnerUI)CuiSpinnerUI.this).spinner.getEditor().getPreferredSize().height : 0;
                return new Dimension(Math.max(size, (int)Math.ceil(2.0 * CuiLookAndFeel.getInteriorEdge()) + insets.left + insets.right), Math.max(size, (int)Math.ceil(2.0 * CuiLookAndFeel.getInteriorEdge()) + insets.top + insets.bottom));
            }

            static /* synthetic */ int access$000(1 x0) {
                return x0.direction;
            }

            static /* synthetic */ CuiSpinnerUI access$100(1 x0) {
                return x0.CuiSpinnerUI.this;
            }
        };
        Color color = Utilities.getUIPropertyColor(this.spinner, "Spinner." + previousOrNext + ".background");
        if (color != null) {
            button.setBackground(color);
        }
        if ((color = Utilities.getUIPropertyColor(this.spinner, "Spinner." + previousOrNext + ".foreground")) != null) {
            button.setForeground(color);
        }
        if ((margin = Utilities.getUIPropertyInsets(this.spinner, "Spinner." + previousOrNext + ".margin")) != null) {
            button.setMargin(margin);
        }
        if ((border = Utilities.getUIPropertyBorder(this.spinner, "Spinner." + previousOrNext + ".border")) != null) {
            button.setBorder(border);
        }
        button.putClientProperty("Spinner." + previousOrNext + ".uiLock", Boolean.TRUE);
        if (super_nextButtonHandler_ == null) {
            try {
                Field nextButtonHandler = (class$javax$swing$plaf$basic$BasicSpinnerUI == null ? (class$javax$swing$plaf$basic$BasicSpinnerUI = CuiSpinnerUI.class$("javax.swing.plaf.basic.BasicSpinnerUI")) : class$javax$swing$plaf$basic$BasicSpinnerUI).getDeclaredField("nextButtonHandler");
                nextButtonHandler.setAccessible(true);
                super_nextButtonHandler_ = nextButtonHandler.get(null);
                Field previousButtonHandler = (class$javax$swing$plaf$basic$BasicSpinnerUI == null ? (class$javax$swing$plaf$basic$BasicSpinnerUI = CuiSpinnerUI.class$("javax.swing.plaf.basic.BasicSpinnerUI")) : class$javax$swing$plaf$basic$BasicSpinnerUI).getDeclaredField("previousButtonHandler");
                previousButtonHandler.setAccessible(true);
                super_previousButtonHandler_ = previousButtonHandler.get(null);
            }
            catch (Exception ex) {
                logger_.log(Level.WARNING, "" + ex, ex);
            }
        }
        if (previousOrNext.equals("next") && super_nextButtonHandler_ != null) {
            button.addActionListener((ActionListener)super_nextButtonHandler_);
            button.addMouseListener((MouseListener)super_nextButtonHandler_);
        }
        if (previousOrNext.equals("previous") && super_previousButtonHandler_ != null) {
            button.addActionListener((ActionListener)super_previousButtonHandler_);
            button.addMouseListener((MouseListener)super_previousButtonHandler_);
        }
        this.spinner.putClientProperty("Spinner." + previousOrNext, button);
        return button;
    }

    protected Component createPreviousButton() {
        return this.createButton("previous");
    }

    protected Component createNextButton() {
        return this.createButton("next");
    }

    protected JComponent createEditor() {
        JFormattedTextField text;
        JComponent editor = super.createEditor();
        Border border = Utilities.getUIPropertyBorder(this.spinner, "Spinner.text.border");
        if (editor instanceof JSpinner.DefaultEditor && (text = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
            editor.setBorder(null);
            editor.setBackground(null);
            Insets margin = Utilities.getUIPropertyInsets(this.spinner, "Spinner.text.margin");
            if (margin != null) {
                text.setMargin(margin);
            }
            if (border != null) {
                text.setBorder(border);
            }
            text.setName("SpinnerText");
            this.spinner.putClientProperty("Spinner.text", text);
        } else {
            if (border != null) {
                editor.setBorder(border);
            }
            editor.setName("SpinnerText");
            this.spinner.putClientProperty("Spinner.text", editor);
        }
        return editor;
    }

    protected void replaceEditor(JComponent oldEditor, JComponent editor) {
        JFormattedTextField text;
        super.replaceEditor(oldEditor, editor);
        Border border = Utilities.getUIPropertyBorder(this.spinner, "Spinner.text.border");
        if (editor instanceof JSpinner.DefaultEditor && (text = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
            editor.setBorder(null);
            editor.setBackground(null);
            Insets margin = Utilities.getUIPropertyInsets(this.spinner, "Spinner.text.margin");
            if (margin != null) {
                text.setMargin(margin);
            }
            if (border != null) {
                text.setBorder(border);
            }
            this.spinner.putClientProperty("Spinner.text", text);
        } else {
            if (border != null) {
                editor.setBorder(border);
            }
            editor.setName("SpinnerText");
            this.spinner.putClientProperty("Spinner.text", editor);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ JSpinner access$200(CuiSpinnerUI x0) {
        return x0.spinner;
    }
}

