/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Draw2DUtils {
    private Draw2DUtils() {
    }

    public static void lineFast(int x0, int y0, int x1, int y1, Color color, Raster1D raster) {
        int stepx;
        int stepy;
        int pix = color.getRGB();
        int dy = y1 - y0;
        int dx = x1 - x0;
        int rw = raster.getWidth();
        if (dy < 0) {
            dy = -dy;
            stepy = -rw;
        } else {
            stepy = rw;
        }
        if (dx < 0) {
            dx = -dx;
            stepx = -1;
        } else {
            stepx = 1;
        }
        y1 *= rw;
        raster.setPixel(x0 + (y0 *= rw));
        if ((dx <<= 1) > (dy <<= 1)) {
            int fraction = dy - (dx >> 1);
            while (x0 != x1) {
                if (fraction >= 0) {
                    y0 += stepy;
                    fraction -= dx;
                }
                fraction += dy;
                raster.setPixel((x0 += stepx) + y0);
            }
        } else {
            int fraction = dx - (dy >> 1);
            while (y0 != y1) {
                if (fraction >= 0) {
                    x0 += stepx;
                    fraction -= dy;
                }
                fraction += dx;
                raster.setPixel(x0 + (y0 += stepy));
            }
        }
    }

    public static void lineBresenham(int x0, int y0, int x1, int y1, Color color, Raster2D raster) {
        int stepx;
        int stepy;
        int pix = color.getRGB();
        int dy = y1 - y0;
        int dx = x1 - x0;
        if (dy < 0) {
            dy = -dy;
            stepy = -1;
        } else {
            stepy = 1;
        }
        if (dx < 0) {
            dx = -dx;
            stepx = -1;
        } else {
            stepx = 1;
        }
        raster.setPixel(x0, y0);
        if ((dx <<= 1) > (dy <<= 1)) {
            int fraction = dy - (dx >> 1);
            while (x0 != x1) {
                if (fraction >= 0) {
                    y0 += stepy;
                    fraction -= dx;
                }
                fraction += dy;
                raster.setPixel(x0 += stepx, y0);
            }
        } else {
            int fraction = dx - (dy >> 1);
            while (y0 != y1) {
                if (fraction >= 0) {
                    x0 += stepx;
                    fraction -= dy;
                }
                fraction += dx;
                raster.setPixel(x0, y0 += stepy);
            }
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("LineFast");
        String[] params = null;
        if (args.length > 0) {
            params = new String[]{"file", args[0]};
        }
        ImgPanel jp = new ImgPanel(500, 500);
        frame.setBounds(100, 100, 512, 512);
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(jp);
        frame.setVisible(true);
    }

    private static class ImgPanel
    extends JPanel
    implements Raster1D,
    Raster2D {
        private BufferedImage bi = null;
        private byte[] pixels = null;

        public ImgPanel(int w, int h) {
            this.bi = new BufferedImage(w, h, 10);
            this.pixels = ((DataBufferByte)this.bi.getRaster().getDataBuffer()).getData();
            this.drawLines(w, h, this);
        }

        public void drawLines(int w, int h, Raster2D r) {
            Draw2DUtils.lineBresenham(0, 0, w - 1, h - 1, Color.red, r);
            Draw2DUtils.lineBresenham(w - 1, 0, 0, h - 1, Color.red, r);
            Draw2DUtils.lineBresenham(w / 2, 0, w / 2, h - 1, Color.red, r);
            Draw2DUtils.lineBresenham(0, h / 2, w - 1, h / 2, Color.red, r);
        }

        public int getWidth() {
            return this.bi.getWidth();
        }

        public int getHeight() {
            return this.bi.getHeight();
        }

        public void clear() {
            Arrays.fill(this.pixels, (byte)0);
        }

        public void setPixel(int idx) {
            this.pixels[idx] = 125;
        }

        public void setPixel(int x, int y) {
            this.pixels[y * this.bi.getWidth() + x] = 125;
        }

        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.drawRenderedImage(this.bi, null);
        }
    }

    public static class ImageBuffer
    implements Raster2D {
        private BufferedImage bi = null;
        private int w = 0;
        private int h = 0;
        private byte[] pixels = null;

        public ImageBuffer(int w, int h) {
            this.bi = new BufferedImage(w, h, 10);
            this.pixels = ((DataBufferByte)this.bi.getRaster().getDataBuffer()).getData();
            this.w = w;
            this.h = h;
        }

        public final BufferedImage getImage() {
            return this.bi;
        }

        public int getWidth() {
            return this.bi.getWidth();
        }

        public int getHeight() {
            return this.bi.getHeight();
        }

        public void clear() {
            Arrays.fill(this.pixels, (byte)0);
        }

        public void setPixel(int x, int y) {
            if (x < 0 || x >= this.w || y < 0 || y >= this.h) {
                return;
            }
            this.pixels[y * this.w + x] = 125;
        }
    }

    public static interface Raster2D {
        public int getWidth();

        public int getHeight();

        public void clear();

        public void setPixel(int var1, int var2);
    }

    public static interface Raster1D {
        public int getWidth();

        public int getHeight();

        public void clear();

        public void setPixel(int var1);
    }
}

