/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpComponentSave;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.filter.XpImageOp;
import com.ge.med.terra.jami.image.XpImageData;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpJPipeline;
import com.ge.med.terra.jami.roi.XpImageMatte;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.List;

public class ScreenSave {
    private static final short BG_VAL = 0;
    private int width = 0;
    private int height = 0;
    private XpComponentSave cs = new XpComponentSave();
    private XpDicomElement dobj = new XpDicomElement(40, 259);

    public ScreenSave(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public BufferedImage generate(XpSingularPort vp) {
        XpSingularPort clonevp = (XpSingularPort)vp.clone();
        XpImage img = vp.getFrame();
        RenderedImage rimg = img.getPixelData();
        BufferedImage imgout = null;
        int[] cc = rimg.getColorModel().getComponentSize();
        XpImageRenderAttributes ira = vp.getImageRenderAttributes();
        int nChannels = cc.length;
        int bpp0 = cc[0];
        boolean isLuminance = true;
        IndexColorModel icm = ira.getColormap();
        String icm_name = "" + icm;
        if (nChannels == 1 && ira.getColorOverlay() == null && (icm == null || icm_name.equals("g1") || icm_name.equals("g2") || icm_name.equals("g3"))) {
            BufferedImage renderImg = this.cs.renderOffscreen(clonevp, this.width, this.height, 0);
            AffineTransform at = clonevp.getMedicalImageVc().getImageVc().getAffineTransform();
            imgout = this.renderLuminance(img, ira, at, this.width, this.height);
            short[] imglayer = ((DataBufferUShort)imgout.getRaster().getDataBuffer()).getData();
            this.matteImgLayer(clonevp.getMedicalImageVc(), imglayer, this.width, this.height);
            clonevp.setAnnotationItems(new String[]{"Windowing"}, false);
            clonevp.getMedicalImageVc().getImageVc().disableImageRendering(Color.black);
            BufferedImage overlay0 = this.cs.renderOffscreen(clonevp, this.width, this.height, 1);
            clonevp.getMedicalImageVc().getImageVc().disableImageRendering(Color.white);
            BufferedImage overlay1 = this.cs.renderOffscreen(clonevp, this.width, this.height, 1);
            BufferedImage annotation = new BufferedImage(this.width, this.height, 1);
            Graphics g = annotation.getGraphics();
            clonevp.getMedicalImageVc().getAnnotationVc().paint(g);
            short[] gxlayer = ((DataBufferUShort)overlay0.getRaster().getDataBuffer()).getData();
            short[] gxshadowlayer = ((DataBufferUShort)overlay1.getRaster().getDataBuffer()).getData();
            int[] annotlayer = ((DataBufferInt)annotation.getRaster().getDataBuffer()).getData();
            for (int i = 0; i < imglayer.length; ++i) {
                int v;
                int pixval = gxlayer[i] & 0xFFFF;
                int shadow_pixval = gxshadowlayer[i] & 0xFFFF;
                double w = (double)pixval / 65536.0;
                if (pixval > 0) {
                    imglayer[i] = (short)(w * 2048.0);
                }
                if (shadow_pixval < 5) {
                    imglayer[i] = Short.MIN_VALUE;
                }
                if ((v = annotlayer[i] & 0xFF) <= 0) continue;
                imglayer[i] = Short.MAX_VALUE;
            }
        } else {
            imgout = this.cs.renderOffscreen(clonevp, this.width, this.height, 0);
            isLuminance = false;
        }
        Container container = vp.getContentPane();
        this.generateSubViewports(container, isLuminance, ira, imgout);
        this.generateSubViewports(vp.getMedicalImageVc(), isLuminance, ira, imgout);
        return imgout;
    }

    private void generateSubViewports(Container container, boolean isLuminance, XpImageRenderAttributes ira, BufferedImage imgout) {
        Component[] children = container.getComponents();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                if (children[i] instanceof XpSingularPort) {
                    XpSingularPort subport = (XpSingularPort)children[i];
                    Rectangle r = subport.getBounds();
                    int outw = imgout.getWidth();
                    int outh = imgout.getHeight();
                    int origX = (int)((double)outw * 0.5 - (double)r.width * 0.5);
                    int origY = outh - r.height - 20;
                    if (isLuminance) {
                        double min = ira.getWindowMin();
                        double max = ira.getWindowMax();
                        BufferedImage subimg = new BufferedImage(r.width, r.height, 11);
                        Graphics2D g2 = (Graphics2D)subimg.getGraphics();
                        subport.paint(g2);
                        short[] data = ((DataBufferUShort)imgout.getRaster().getDataBuffer()).getData();
                        short[] subdata = ((DataBufferUShort)subimg.getRaster().getDataBuffer()).getData();
                        double minv = 0.0;
                        double maxv = 65535.0;
                        for (int y = 0; y < r.height; ++y) {
                            int yyoffset = (origY + y) * imgout.getWidth();
                            for (int x = 0; x < r.width; ++x) {
                                int xx = origX + x;
                                int subval = subdata[y * r.width + x] & 0xFFFF;
                                double ww = max - min;
                                double subww = maxv - minv;
                                subval = (short)(((double)subval - minv) / subww * ww + min);
                                data[yyoffset + xx] = (short)subval;
                            }
                        }
                        continue;
                    }
                    XpSingularPort clonesubvp = (XpSingularPort)subport.clone();
                    BufferedImage subimg = this.cs.renderOffscreen(clonesubvp, r.width, r.height, 0);
                    Graphics2D g2 = (Graphics2D)imgout.getGraphics();
                    g2.drawImage((Image)subimg, origX, origY, null);
                    continue;
                }
                if (!(children[i] instanceof Container)) continue;
                this.generateSubViewports((Container)children[i], isLuminance, ira, imgout);
            }
        }
    }

    private void matteImgLayer(Container c, short[] imglayer, int width, int height) {
        int BGVAL = 65535;
        Component[] children = c.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof XpImageRoiVc) {
                int pixval;
                int k;
                XpImageRoiVc roivc = (XpImageRoiVc)children[i];
                RoiActor ra = roivc.getRoiActor();
                if (!(ra instanceof XpImageMatte)) continue;
                BufferedImage img = new BufferedImage(width, height, 11);
                short[] mattelayer = ((DataBufferUShort)img.getRaster().getDataBuffer()).getData();
                Arrays.fill(mattelayer, (short)-1);
                Graphics g = img.getGraphics();
                roivc.paint(g);
                for (k = 0; k < mattelayer.length; ++k) {
                    pixval = mattelayer[k] & 0xFFFF;
                    if (pixval <= 4096) continue;
                    mattelayer[k] = -1;
                }
                for (k = 0; k < imglayer.length; ++k) {
                    pixval = mattelayer[k] & 0xFFFF;
                    if (pixval >= 65535) continue;
                    double w = (double)pixval / 65535.0;
                    imglayer[k] = (short)(w * 2048.0);
                }
                continue;
            }
            if (!(children[i] instanceof Container)) continue;
            this.matteImgLayer((Container)children[i], imglayer, width, height);
        }
    }

    public BufferedImage renderLuminance(XpImage srcimg, XpImageRenderAttributes ira, AffineTransform at, int vpWidth, int vpHeight) {
        int retval;
        RenderedImage srcImage = srcimg.getPixelData();
        double rescaleSlope = srcimg.getRescaleSlope();
        double rescaleIntercept = srcimg.getRescaleIntercept();
        BufferedImage destImage = null;
        short[] shortoutput = null;
        int w = srcImage.getWidth();
        int h = srcImage.getHeight();
        AffineTransform inverse = new AffineTransform();
        double[] itx = new double[6];
        double[] tx = new double[6];
        int[] cc = srcImage.getColorModel().getComponentSize();
        int pixelRepresentation = 1;
        int img_bpp = cc[0];
        if (srcimg instanceof XpDicomObject && (retval = ((XpDicomObject)((Object)srcimg)).getValue(this.dobj)) == 0) {
            pixelRepresentation = Integer.parseInt("" + this.dobj.value);
        }
        XpGeomUtils gu = new XpGeomUtils();
        XpJPipeline.RowBuffer rbuffer = new XpJPipeline.RowBuffer(vpWidth, vpHeight);
        gu.calcInverse(at, inverse);
        inverse.getMatrix(itx);
        at.getMatrix(tx);
        srcImage = this.doImageOperations(srcImage, ira.getImageOperations());
        DataBuffer db = XpImageData.getDataBuffer(srcImage);
        int dataOffset = db.getOffset();
        int dataLength = db.getSize();
        if (img_bpp > 8) {
            boolean zeroFlag;
            short[] in = null;
            in = db instanceof DataBufferUShort ? ((DataBufferUShort)db).getData() : ((DataBufferShort)db).getData();
            destImage = new BufferedImage(vpWidth, vpHeight, 11);
            shortoutput = ((DataBufferUShort)destImage.getRaster().getDataBuffer()).getData();
            double dx = itx[0] * 1.0 + itx[2] * 0.0;
            double dy = itx[1] * 1.0 + itx[3] * 0.0;
            double angle = Math.acos((dx * 1.0 + dy * 0.0) / Math.sqrt(dx * dx + dy * dy));
            double deg = Math.toDegrees(angle) * 10000.0;
            int ideg = (int)deg;
            boolean uprightFlag = false;
            boolean bl = zeroFlag = ideg % 3600000 == 0;
            if (zeroFlag) {
                dx = itx[0] * 1.0 + itx[2] * 1.0;
                dy = itx[1] * 1.0 + itx[3] * 1.0;
                if (dx > 0.0 && dy > 0.0) {
                    uprightFlag = true;
                }
            }
            if (uprightFlag) {
                XpJPipeline.doBilinearShortToShortUpright(tx, itx, in, dataOffset, w, h, pixelRepresentation, img_bpp, shortoutput, vpWidth, vpHeight, (short)0);
            } else {
                XpJPipeline.doBilinearShortToShortBox(tx, itx, in, dataOffset, w, h, pixelRepresentation, img_bpp, shortoutput, vpWidth, vpHeight, rbuffer, (short)0);
            }
        } else if (img_bpp <= 8) {
            // empty if block
        }
        if (shortoutput != null) {
            double ww = ira.getWindowWidth() / rescaleSlope;
            double wl = (ira.getWindowLevel() - rescaleIntercept) / rescaleSlope;
            double min = wl - ww * 0.5;
            double max = wl + ww * 0.5;
            if (ira.isVideoInverted()) {
                for (int i = 0; i < shortoutput.length; ++i) {
                    shortoutput[i] = (short)(max - ((double)shortoutput[i] - min));
                }
            }
        }
        return destImage;
    }

    private RenderedImage doImageOperations(RenderedImage inputImage, List opList) {
        int w = inputImage.getWidth();
        int h = inputImage.getHeight();
        BufferedImage opImg1 = null;
        BufferedImage opImg2 = null;
        int opListLen = opList.size();
        if (opListLen > 0) {
            int oph;
            int opw;
            boolean createOpImage = false;
            if (opImg1 != null) {
                opw = opImg1.getWidth();
                oph = opImg1.getHeight();
                if (opw != w || oph != h) {
                    createOpImage = true;
                }
            } else {
                createOpImage = true;
            }
            if (createOpImage) {
                opImg1 = XpImageData.createCompatibleBufferedImage(inputImage);
            }
            if (opListLen > 1) {
                createOpImage = false;
                if (opImg2 != null) {
                    opw = opImg2.getWidth();
                    oph = opImg2.getHeight();
                    if (opw != w || oph != h) {
                        createOpImage = true;
                    }
                } else {
                    createOpImage = true;
                }
                if (createOpImage) {
                    opImg2 = XpImageData.createCompatibleBufferedImage(inputImage);
                }
            }
            RenderedImage input = inputImage;
            RenderedImage output = opImg1;
            RenderedImage result = input;
            for (int i = 0; i < opListLen; ++i) {
                XpImageOp iop = (XpImageOp)opList.get(i);
                if (iop == null) continue;
                iop.execute(input, output);
                result = output;
                if (i == 0) {
                    input = opImg1;
                    output = opImg2;
                    continue;
                }
                RenderedImage tmp = input;
                input = output;
                output = tmp;
            }
            return result;
        }
        return inputImage;
    }
}

