/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.XpPropertiesManager;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class XpLog {
    private static Logger theLog = null;
    private static Handler handler = null;
    private static String applicationName = "com.ge.med.terra.jami";

    private XpLog() {
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static Level getLevel() {
        return XpLog.logger().getLevel();
    }

    public static void setLevel(Level l) {
        try {
            XpLog.logger().setLevel(l);
            if (handler != null) {
                handler.setLevel(l);
            }
        }
        catch (Exception e) {
            System.err.println("JAMI Environment does not allow setLevel: " + l);
        }
    }

    private static Logger createLogger() {
        String tapLogClass = "com.ge.med.terra.tap.Tap";
        boolean tapHandler = true;
        try {
            Class.forName(tapLogClass);
        }
        catch (Exception ex) {
            tapHandler = false;
        }
        catch (Error err) {
            tapHandler = false;
        }
        Logger newLogger = Logger.getLogger(XpLog.getApplicationName());
        try {
            if (!tapHandler) {
                System.err.println("-- Using Default Console Handler.");
                handler = new ConsoleHandler();
                newLogger.addHandler(handler);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newLogger;
    }

    public static Logger logger() {
        if (theLog == null) {
            theLog = XpLog.createLogger();
        }
        return theLog;
    }

    public static void config(String msg) {
        XpLog.logger().config(msg);
    }

    public static void warning(String msg) {
        XpLog.logger().warning(msg);
    }

    public static void info(String msg) {
        XpLog.logger().info(msg);
    }

    public static void fine(String msg) {
        XpLog.logger().fine(msg);
    }

    public static void severe(String msg) {
        XpLog.logger().severe(msg);
    }

    public static void finer(String msg) {
        XpLog.logger().finer(msg);
    }

    public static void finest(String msg) {
        XpLog.logger().finest(msg);
    }

    static {
        String tlevel = XpPropertiesManager.getProperty("jami.tracelevel", "WARNING");
        if ((tlevel = tlevel.toUpperCase()).equals("WARNING")) {
            XpLog.setLevel(Level.WARNING);
        } else if (tlevel.equals("INFO")) {
            XpLog.setLevel(Level.INFO);
        } else if (tlevel.equals("CONFIG")) {
            XpLog.setLevel(Level.CONFIG);
        } else if (tlevel.equals("FINE")) {
            XpLog.setLevel(Level.FINE);
        } else if (tlevel.equals("SEVERE")) {
            XpLog.setLevel(Level.SEVERE);
        } else if (tlevel.equals("FINER")) {
            XpLog.setLevel(Level.FINER);
        } else if (tlevel.equals("FINEST")) {
            XpLog.setLevel(Level.FINEST);
        } else if (tlevel.equals("ALL")) {
            XpLog.setLevel(Level.ALL);
        }
        XpLog.logger().config("Logging global Trace Level=" + tlevel);
    }
}

