/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.ClipCapable;
import com.ge.med.idc.PaintStatCapable;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.JImage2DVc;
import com.ge.med.terra.jami.XpAnnotationVc;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.annotation.XpAnnotationGenerator;
import com.ge.med.terra.jami.annotation.XpAnnotationManager;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XpMedicalImage2DVc
extends XpVisualComponent
implements XpImageRenderAttributesOwner,
PaintStatCapable,
ClipCapable,
FrameOwner {
    private static boolean openGL = false;
    private XpAnnotationVc annotation = new XpAnnotationVc();
    private XpImage2DVc imageVc = null;
    private XpAnnotationGenerator ag = null;
    private XpDicomObject dicomSource = null;
    private AnnotationState annotState = new AnnotationState();
    private boolean imageDirty = true;

    public XpMedicalImage2DVc(XpImage2DVc ivc) {
        this.imageVc = ivc;
        this.initializeMedicalImageVc();
    }

    public XpMedicalImage2DVc() {
        this.imageVc = openGL ? this.createImage2DVc("com.ge.med.gljami.GLImage2DVc", "") : new JImage2DVc();
        this.initializeMedicalImageVc();
    }

    public XpMedicalImage2DVc(String rendererType) {
        Pattern separator = Pattern.compile(",\\s*");
        String[] args = separator.split(rendererType);
        Pattern imageVcPattern = Pattern.compile("(ImageVc\\s*=\\s*)(\\S+)");
        Pattern rendererPattern = Pattern.compile("(Renderer\\s*=\\s*)(\\S+)");
        String renderer = null;
        String vc = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            Matcher m = imageVcPattern.matcher(args[i]);
            if (m.matches()) {
                vc = m.group(2);
            }
            if (!(m = rendererPattern.matcher(args[i])).matches()) continue;
            renderer = m.group(2);
        }
        this.imageVc = vc == null && renderer == null ? new JImage2DVc(rendererType) : (vc == null && renderer != null ? new JImage2DVc(renderer) : (renderer == null ? (XpImage2DVc)XpPropertiesManager.create(vc) : this.createImage2DVc(vc, renderer)));
        this.initializeMedicalImageVc();
    }

    private XpImage2DVc createImage2DVc(String vc, String renderer) {
        try {
            Class[] paramType;
            Constructor<?> c;
            Class<?> cl = Class.forName(vc);
            if (cl != null && (c = cl.getConstructor(paramType = new Class[]{String.class})) != null) {
                XpImage2DVc imageVc = (XpImage2DVc)c.newInstance(renderer);
                return imageVc;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void initializeMedicalImageVc() {
        this.add(this.imageVc);
        this.add((Component)this.annotation, 0);
        this.ag = XpAnnotationManager.getDefaultGenerator();
    }

    public final XpImage2DVc getImageVc() {
        return this.imageVc;
    }

    public final XpAnnotationVc getAnnotationVc() {
        return this.annotation;
    }

    public final void refreshImage() {
        this.imageVc.refreshImage();
    }

    public final void setAnnotationColor(Color c) {
        this.annotation.setForeground(c);
    }

    public final Color getAnnotationColor() {
        return this.annotation.getForeground();
    }

    public final XpDicomObject getDicomSource() {
        return this.dicomSource;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.imageDirty) {
            if (this.isAnnotationVisible()) {
                this.loadAnnotation(this.imageVc.getFrame(), this.dicomSource);
                this.annotState.applyState(this);
            }
            this.imageDirty = false;
        }
    }

    public final void setMedicalImage(XpImage theImage, XpDicomObject dicomSource) {
        this.dicomSource = dicomSource;
        this.imageDirty = theImage != this.imageVc.getFrame();
        this.imageVc.setImage(theImage);
        if (theImage == null) {
            this.loadAnnotation(null, null);
        }
        this.imageDirty = true;
    }

    public final void setImageLayers(List imgLayers) {
        this.imageVc.setImageLayers(imgLayers);
    }

    public final XpAnnotationModel getAnnotationModel() {
        return this.annotation.getAnnotationModel();
    }

    public void loadAnnotation(XpImage image, XpDicomObject dobj) {
        XpAnnotationModel xam = null;
        if (image != null && dobj != null) {
            xam = this.ag.getAnnotation(image, dobj);
        }
        this.annotation.setAnnotationModel(xam);
    }

    public final CTransform getTransform(byte in, byte out) {
        CTransform t;
        if (in == out) {
            return CTransform.Identity;
        }
        CTransform pre = null;
        CTransform post = null;
        boolean lps2ras = false;
        boolean ras2lps = false;
        XpImage medicalImage = this.imageVc.getFrame();
        if (medicalImage == null) {
            return super.getTransform(in, out);
        }
        if (in == 4) {
            in = (byte)2;
            lps2ras = true;
        }
        if (out == 4) {
            out = (byte)2;
            ras2lps = true;
        }
        if (in == 2) {
            pre = medicalImage.getSlice().getImageToRasTransform().inverse();
            in = 0;
        }
        if (out == 2) {
            post = medicalImage.getSlice().getImageToRasTransform();
            out = 0;
        }
        if ((t = this.imageVc.getTransform(in, out)) != null) {
            if (lps2ras) {
                pre = this.getRAS2LPS().multiplyBy(pre);
            }
            if (pre != null) {
                t = pre.multiplyBy(t);
            }
            if (post != null) {
                t = t.multiplyBy(post);
            }
            if (ras2lps) {
                t = t.multiplyBy(this.getRAS2LPS());
            }
        }
        return t;
    }

    public final void setImageClip(Shape s) {
        this.imageVc.setImageClip(s);
    }

    public final Shape getImageClip() {
        return this.imageVc.getImageClip();
    }

    public XpPixelStatistics getPixelStatistics(int subSampleFactor) {
        XpPixelStatistics pixStats = null;
        XpImage medicalImage = this.imageVc.getFrame();
        if (medicalImage != null) {
            pixStats = XpImageUtils.calcStats(medicalImage, subSampleFactor, null);
        }
        return pixStats;
    }

    public final void setAnnotationGenerator(XpAnnotationGenerator ag) {
        if (this.ag != null) {
            this.ag.reset();
        }
        this.ag = ag;
        XpImage image = this.imageVc.getFrame();
        this.loadAnnotation(image, this.dicomSource);
    }

    public final XpAnnotationGenerator getAnnotationGenerator() {
        return this.ag;
    }

    public final void setAnnotationVisible(boolean annotVisible) {
        if (annotVisible) {
            XpImage img = this.imageVc.getFrame();
            this.loadAnnotation(img, this.dicomSource);
        }
        this.annotation.setVisible(annotVisible);
    }

    public final boolean isAnnotationVisible() {
        return this.annotation.isVisible();
    }

    public String[] getAnnotationGroups() {
        XpAnnotationModel am;
        if (this.annotation != null && (am = this.annotation.getAnnotationModel()) != null) {
            return am.getAnnotationGroups();
        }
        return null;
    }

    public String[] getAnnotationItems() {
        XpAnnotationModel am;
        if (this.annotation != null && (am = this.annotation.getAnnotationModel()) != null) {
            return am.getAnnotationItems();
        }
        return null;
    }

    public void setAnnotationGroup(String agName, boolean activate) {
        XpAnnotationModel am;
        this.annotState.setAnnotationGroup(agName, activate);
        if (this.annotation != null && (am = this.annotation.getAnnotationModel()) != null) {
            am.setAnnotationGroup(agName, activate);
        }
    }

    public void setAnnotationItems(String[] annoItems, boolean activate) {
        XpAnnotationModel am;
        this.annotState.setAnnotationItems(annoItems, activate);
        if (this.annotation != null && (am = this.annotation.getAnnotationModel()) != null) {
            am.setAnnotationItems(annoItems, activate);
        }
    }

    public void queryAnnotationItems(String[] annoItems, boolean[] queryRes) {
        XpAnnotationModel am;
        if (this.annotation != null && (am = this.annotation.getAnnotationModel()) != null) {
            am.queryAnnotationItems(annoItems, queryRes);
        }
    }

    public boolean queryAnnotationItem(String aiName) {
        XpAnnotationModel am;
        if (this.annotation != null && (am = this.annotation.getAnnotationModel()) != null) {
            return am.queryAnnotationItem(aiName);
        }
        return false;
    }

    public String[] getAnnotationItems(String agName) {
        XpAnnotationModel am;
        if (this.annotation != null && (am = this.annotation.getAnnotationModel()) != null) {
            return am.getAnnotationItems(agName);
        }
        return null;
    }

    public long getPaintCount() {
        return this.imageVc.getPaintCount();
    }

    public final XpImage getFrame() {
        return this.imageVc.getFrame();
    }

    public void setImageRenderAttributes(XpImageRenderAttributes ira) {
        this.imageVc.setImageRenderAttributes(ira);
    }

    public XpImageRenderAttributes getImageRenderAttributes() {
        return this.imageVc.getImageRenderAttributes();
    }

    public XpImagePixelAttributes getImagePixelAttributes(int layer) {
        return this.imageVc.getImagePixelAttributes(layer);
    }

    public Shape getClipShape() {
        return this.imageVc.getClipShape();
    }

    public void setClipShape(Shape s) {
        this.imageVc.setClipShape(s);
    }

    public final Object getInterpolationHint() {
        return this.imageVc.getInterpolationHint();
    }

    public final void setInterpolationHint(Object interpolationHint) {
        this.imageVc.setInterpolationHint(interpolationHint);
    }

    public final XpImageOrientation getDisplayOrientation() {
        return this.imageVc.getDisplayOrientation();
    }

    public final void refreshImageRenderAttributes() {
        this.imageVc.refreshImageRenderAttributes();
    }

    static {
        String boolval = XpPropertiesManager.getProperty("jami.render.opengl", "false").toLowerCase();
        if (boolval.equals("true")) {
            try {
                Class<?> glvc = Class.forName("com.ge.med.gljami.GLImage2DVc");
                if (glvc != null) {
                    openGL = true;
                }
            }
            catch (ClassNotFoundException e) {
                openGL = false;
            }
        }
    }

    private static class AnnotationState {
        private String agm = null;
        private Map aim = new HashMap();
        private String[] str = new String[1];

        private AnnotationState() {
        }

        public final void setAnnotationGroup(String agName, boolean activate) {
            if (activate) {
                this.agm = agName;
            }
        }

        public final void setAnnotationItems(String[] annoItems, boolean activate) {
            for (int i = 0; i < annoItems.length; ++i) {
                Boolean b2 = activate ? Boolean.TRUE : Boolean.FALSE;
                this.aim.put(annoItems[i], b2);
            }
        }

        public final void clear() {
            this.agm = null;
            this.aim.clear();
        }

        public final void applyState(XpMedicalImage2DVc mivc) {
            if (mivc == null) {
                return;
            }
            if (this.agm != null) {
                mivc.setAnnotationGroup(this.agm, true);
            }
            for (Map.Entry me : this.aim.entrySet()) {
                this.str[0] = (String)me.getKey();
                Boolean value = (Boolean)me.getValue();
                mivc.setAnnotationItems(this.str, value);
            }
        }
    }
}

