/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class XpSelectionDirector
implements XpViewportDirector,
MouseListener,
HierarchyListener {
    Vector viewports = new Vector();
    Set selection = new HashSet();

    public void connectViewport(XpViewport vp) {
        this.viewports.add(vp);
        this.addListeners(vp);
    }

    void addListeners(Component root) {
        root.addMouseListener(this);
        root.addHierarchyListener(this);
        if (root instanceof Container) {
            Component[] c = ((Container)root).getComponents();
            for (int i = 0; i < c.length; ++i) {
                this.addListeners(c[i]);
            }
        }
    }

    public void hierarchyChanged(HierarchyEvent e) {
    }

    Iterator getSelectedViewports() {
        return this.selection.iterator();
    }

    public void disconnectViewport(XpViewport vp) {
        this.viewports.remove(vp);
        this.selection.remove(vp);
    }

    public void disconnectAllViewports() {
        Iterator i = this.viewports.iterator();
        while (i.hasNext()) {
            this.disconnectViewport((XpViewport)i.next());
        }
    }

    XpViewport viewportOfEvent(MouseEvent e) {
        XpViewport vp = this.findViewportAncestor(e.getComponent());
        if (vp != null) {
            int index = this.viewports.indexOf(vp);
            XpLog.logger().finest("Vp of " + e + " (" + e.getComponent() + ")");
            if (index >= 0) {
                return (XpViewport)this.viewports.get(index);
            }
        }
        return null;
    }

    XpViewport findViewportAncestor(Component c) {
        if (c instanceof XpViewport) {
            return (XpViewport)c;
        }
        Container p = c.getParent();
        if (p != null && p instanceof XpViewport) {
            return this.findViewportAncestor(p);
        }
        return null;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        XpViewport vp = this.viewportOfEvent(e);
        if (vp != null) {
            this.selection.add(vp);
        }
        XpLog.logger().finest("Pressed mouse on " + vp);
    }

    public void mouseReleased(MouseEvent e) {
    }
}

