/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.idc.XjFusionPixelCombiner;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpImageLayer;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.image.XpImageData;
import com.ge.med.terra.jami.render.NearestNeighbor;
import com.ge.med.terra.jami.render.XpColorOverlay;
import com.ge.med.terra.jami.render.XpDrawableFactory;
import com.ge.med.terra.jami.render.XpImage2DRenderer;
import com.ge.med.terra.jami.render.XpImageDrawable;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpJPipeline;
import com.ge.med.terra.jami.render.XpOffscreenRenderer;
import com.ge.med.terra.jami.render.XpPixels;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.util.List;

public class XpPZWRenderer
extends XpImage2DRenderer {
    public static short BG_VAL = 0;
    private static final int TABLE_SIZE = 65536;
    private int[] colorTable = new int[65536];
    private int dataOffset = 0;
    private RenderedImage srcImage = null;
    private boolean computeWWWL = true;
    private boolean computeCTABLE = true;
    private boolean computeAFFINE = true;
    private int vpWidth = 0;
    private int vpHeight = 0;
    private AffineTransform inverse = new AffineTransform();
    private XpGeomUtils gu = new XpGeomUtils();
    private double[] tx = new double[6];
    private double[] itx = new double[6];
    private BufferedImage shortOutput = null;
    private BufferedImage byteOutput = null;
    private byte[] byteoutput = null;
    private short[] shortoutput = null;
    private double currWW;
    private double currWL;
    private XpColorOverlay currOverlay = null;
    private boolean invVideo = false;
    private IndexColorModel colortable = null;
    private double rescaleSlope = 1.0;
    private double rescaleIntercept = 0.0;
    private double currPanX = 0.0;
    private double currPanY = 0.0;
    private double currAngle = 0.0;
    private double currZoom = 1.0;
    private boolean currFlip = false;
    private boolean currFVP;
    private long sum = 0L;
    private int times = 0;
    private XpPixels pixels = new XpPixels();
    private XpImageDrawable drawable = null;
    private int nChannels = 0;
    private XpJPipeline.RowBuffer rbuffer = null;
    private NearestNeighbor nneighbor = new NearestNeighbor();
    private BufferedImage fusedImage = null;
    private XjFusionPixelCombiner cfpc = null;
    private Point2D ul = new Point2D.Double();
    private Point2D ur = new Point2D.Double();
    private Point2D br = new Point2D.Double();
    private CTransform ras2disp = new CTransform();
    private CTransform img2disp = new CTransform();
    private CPoint disp_pt = new CPoint(1);
    private CPoint ras_pt = new CPoint(2);

    public final RenderedImage getSourceImage() {
        return this.srcImage;
    }

    public void newImageCB(RenderedImage image) {
        this.srcImage = image;
        this.loadRenderedImage(this.srcImage);
    }

    private void loadRenderedImage(RenderedImage bi) {
        RenderedImage inputImage = bi;
        this.computeAFFINE = true;
        this.computeWWWL = true;
        int[] cc = inputImage.getColorModel().getComponentSize();
        this.nChannels = cc.length;
        DataBuffer db = null;
        db = inputImage instanceof BufferedImage ? ((BufferedImage)inputImage).getRaster().getDataBuffer() : inputImage.getData().getDataBuffer();
        this.dataOffset = db.getOffset();
        double rs = this.getRescaleSlope();
        double ri = this.getRescaleIntercept();
        if (this.rescaleSlope != rs || this.rescaleIntercept != ri) {
            this.computeCTABLE = true;
            this.computeWWWL = true;
            this.rescaleSlope = rs;
            this.rescaleIntercept = ri;
        }
    }

    public void newImageRenderAttributesCB(XpImageRenderAttributes attr) {
        if (!attr.equalsPixelTransfer(this.currWW, this.currWL, this.invVideo, this.colortable, this.currOverlay)) {
            this.computeWWWL = true;
            this.computeCTABLE = true;
        }
        this.currWW = attr.getWindowWidth();
        this.currWL = attr.getWindowLevel();
        this.invVideo = attr.isVideoInverted();
        this.colortable = attr.getColormap();
        this.currOverlay = attr.getColorOverlay();
        if (this.currPanX != attr.getPanX() || this.currPanY != attr.getPanY() || this.currAngle != attr.getImageOrientation().getAngle() || this.currZoom != attr.getZoom() || this.currFlip != attr.getImageOrientation().getFlip() || this.currFVP != this.getFitToViewport()) {
            this.computeAFFINE = true;
            this.computeWWWL = true;
        }
        this.currPanX = attr.getPanX();
        this.currPanY = attr.getPanY();
        this.currAngle = attr.getImageOrientation().getAngle();
        this.currZoom = attr.getZoom();
        this.currFlip = attr.getImageOrientation().getFlip();
        this.currFVP = this.getFitToViewport();
    }

    private final void computePixelTransfer() {
        XpImageRenderAttributes ira = this.getAttributes();
        this.drawable.pixelTransfer(this.pixels, this.colorTable, ira);
    }

    protected final void setChangeRender() {
        this.computeAFFINE = true;
        this.computeWWWL = true;
    }

    public final void render(Graphics graphics, Rectangle viewport) {
        Graphics2D g2 = (Graphics2D)graphics;
        boolean createOut = false;
        long t1 = System.currentTimeMillis();
        if (this.nChannels <= 1) {
            if (this.vpWidth != viewport.width || this.vpHeight != viewport.height) {
                this.computeAFFINE = true;
                this.computeWWWL = true;
                createOut = true;
            }
            this.vpWidth = viewport.width;
            this.vpHeight = viewport.height;
            int w = this.srcImage.getWidth();
            int h = this.srcImage.getHeight();
            int pixelRepresentation = this.getPixelRepresentation();
            int img_bpp = this.getBitsStored();
            if (this.computeAFFINE) {
                DataBuffer db;
                int dataType;
                AffineTransform at = this.getAffineTransform();
                this.gu.calcInverse(at, this.inverse);
                this.inverse.getMatrix(this.itx);
                at.getMatrix(this.tx);
                if (createOut) {
                    XpDrawableFactory drwFactory = this.getDrawableFactory();
                    this.drawable = drwFactory.createDrawable(img_bpp, this.vpWidth, this.vpHeight);
                    this.rbuffer = new XpJPipeline.RowBuffer(this.vpWidth, this.vpHeight);
                }
                if ((dataType = (db = XpImageData.getDataBuffer(this.srcImage)).getDataType()) == 2 || dataType == 1) {
                    if (createOut || this.shortOutput == null) {
                        this.byteOutput = null;
                        this.shortOutput = new BufferedImage(this.vpWidth, this.vpHeight, 11);
                        this.shortoutput = ((DataBufferUShort)XpImageData.getDataBuffer(this.shortOutput)).getData();
                        this.pixels.setData(this.shortoutput, 2, img_bpp, 0, this.shortoutput.length);
                    }
                    short[] in = null;
                    in = db instanceof DataBufferUShort ? ((DataBufferUShort)db).getData() : ((DataBufferShort)db).getData();
                    Object iHint = this.getInterpolationHint();
                    if (iHint == RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                        this.nneighbor.doINNShortToShort(this.tx, this.itx, in, this.dataOffset, w, h, this.shortoutput, this.vpWidth, this.vpHeight, BG_VAL);
                    } else {
                        boolean zeroFlag;
                        double dx = this.itx[0] * 1.0 + this.itx[2] * 0.0;
                        double dy = this.itx[1] * 1.0 + this.itx[3] * 0.0;
                        double angle = Math.acos((dx * 1.0 + dy * 0.0) / Math.sqrt(dx * dx + dy * dy));
                        double deg = Math.toDegrees(angle) * 10000.0;
                        int ideg = (int)deg;
                        boolean uprightFlag = false;
                        boolean bl = zeroFlag = ideg % 3600000 == 0;
                        if (zeroFlag) {
                            dx = this.itx[0] * 1.0 + this.itx[2] * 1.0;
                            dy = this.itx[1] * 1.0 + this.itx[3] * 1.0;
                            if (dx > 0.0 && dy > 0.0) {
                                uprightFlag = true;
                            }
                        }
                        if (uprightFlag) {
                            XpJPipeline.doBilinearShortToShortUpright(this.tx, this.itx, in, this.dataOffset, w, h, pixelRepresentation, img_bpp, this.shortoutput, this.vpWidth, this.vpHeight, BG_VAL);
                        } else {
                            XpJPipeline.doBilinearShortToShortBox(this.tx, this.itx, in, this.dataOffset, w, h, pixelRepresentation, img_bpp, this.shortoutput, this.vpWidth, this.vpHeight, this.rbuffer, BG_VAL);
                        }
                    }
                    this.byteoutput = null;
                } else if (dataType == 0) {
                    if (createOut || this.byteOutput == null) {
                        this.shortOutput = null;
                        this.byteOutput = new BufferedImage(this.vpWidth, this.vpHeight, 10);
                        this.byteoutput = ((DataBufferByte)XpImageData.getDataBuffer(this.byteOutput)).getData();
                        this.pixels.setData(this.byteoutput, img_bpp, 0, this.byteoutput.length);
                    }
                    byte[] in = ((DataBufferByte)db).getData();
                    XpJPipeline.doBilinearByteToByte(this.itx, in, this.dataOffset, w, h, this.byteoutput, this.vpWidth, this.vpHeight, 0, this.vpWidth - 1, 0, this.vpHeight - 1, (byte)0);
                    this.shortoutput = null;
                }
                this.computeAFFINE = false;
            }
            boolean didPixelTransfer = false;
            if (this.computeWWWL) {
                XpImageRenderAttributes ira = this.getAttributes();
                if (this.computeCTABLE) {
                    this.fillColorTable(ira, this.colorTable);
                    this.computeCTABLE = false;
                }
                this.computePixelTransfer();
                this.computeWWWL = false;
                didPixelTransfer = true;
            }
            BufferedImage blitImage = this.drawable.getBufferedImage();
            blitImage = this.fuseIt(blitImage, didPixelTransfer);
            g2.drawRenderedImage(blitImage, null);
        } else {
            AffineTransform at = this.getAffineTransform();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawRenderedImage(this.srcImage, at);
        }
        long t2 = System.currentTimeMillis();
        this.sum += t2 - t1;
        ++this.times;
    }

    private BufferedImage fuseIt(BufferedImage image, boolean didPixelTransfer) {
        BufferedImage result = image;
        XjFusionPixelCombiner fpc = this.getPixelCombiner();
        if (fpc != null && this.getNumImageLayers() > 1) {
            boolean imgLayerChange = this.isImageLayerRenderChange();
            if (this.cfpc != fpc || didPixelTransfer || imgLayerChange) {
                int w = image.getWidth();
                int h = image.getHeight();
                if (this.fusedImage == null || w != this.fusedImage.getWidth() || h != this.fusedImage.getHeight()) {
                    this.fusedImage = new BufferedImage(w, h, image.getType());
                }
                int[] output = ((DataBufferInt)this.fusedImage.getRaster().getDataBuffer()).getData();
                this.blendImageLayers(image, output);
            }
            result = this.fusedImage;
            this.cfpc = fpc;
        }
        return result;
    }

    protected boolean renderImageLayers() {
        boolean toFuse = false;
        List layers = this.getImageLayers();
        if (layers != null) {
            int len = layers.size();
            for (int i = 0; i < len; ++i) {
                XpImageLayer il = (XpImageLayer)layers.get(i);
                if (il.frame == null) continue;
                il.resizeOffscreenRenderer(this.vpWidth, this.vpHeight);
                XpOffscreenRenderer offscreen = il.getOffscreenRenderer();
                if (offscreen == null) continue;
                this.calcCorners(il.frame.getSlice(), this.ul, this.ur, this.br);
                offscreen.setImage(il.frame, this.ul, this.ur, this.br);
                il.loadImagePixelAttributes();
                offscreen.refresh();
                offscreen.render(this.getInterpolationHint());
                toFuse = true;
            }
        }
        this.setPixelTransferDirty(false);
        return toFuse;
    }

    private void calcCorners(XpSlice slice, Point2D ul, Point2D ur, Point2D br) {
        XpSlice baseSlice = this.getFrame().getSlice();
        int w = slice.width;
        int h = slice.height;
        CPoint bI = new CPoint(baseSlice.I);
        CPoint bJ = new CPoint(baseSlice.J);
        CPoint I = new CPoint(slice.I);
        CPoint J = new CPoint(slice.J);
        bI.scale(baseSlice.pixelSizeX * 0.5);
        bJ.scale(baseSlice.pixelSizeY * 0.5);
        I.scale(slice.pixelSizeX * 0.5);
        J.scale(slice.pixelSizeY * 0.5);
        bI.sub(I);
        bJ.sub(J);
        CTransform img2ras = (CTransform)baseSlice.getImageToRasTransform().clone();
        img2ras.m[3] = img2ras.m[3] + (bI.x + bJ.x);
        img2ras.m[7] = img2ras.m[7] + (bI.y + bJ.y);
        img2ras.m[11] = img2ras.m[11] + (bI.z + bJ.z);
        CTransform txRAS2Image = img2ras.inverse();
        AffineTransform at = this.getAffineTransform();
        this.img2disp.load(at);
        txRAS2Image.leftMultiply(this.img2disp, this.ras2disp);
        this.ras_pt.scaleAdd(-slice.pixelSizeX * 0.5, slice.I, slice.ul);
        this.ras_pt.scaleAdd(-slice.pixelSizeY * 0.5, slice.J, this.ras_pt);
        this.ras2disp.transform(this.ras_pt, this.disp_pt);
        ul.setLocation(this.disp_pt.x, this.disp_pt.y);
        this.ras_pt.scaleAdd(slice.pixelSizeX * (double)w, slice.I, this.ras_pt);
        this.ras2disp.transform(this.ras_pt, this.disp_pt);
        ur.setLocation(this.disp_pt.x, this.disp_pt.y);
        this.ras_pt.scaleAdd(slice.pixelSizeY * (double)h, slice.J, this.ras_pt);
        this.ras2disp.transform(this.ras_pt, this.disp_pt);
        br.setLocation(this.disp_pt.x, this.disp_pt.y);
    }

    public void dispose() {
        this.drawable = null;
    }
}

