/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render.remote;

import com.ge.med.jnu.statistics.JnHistogram;
import com.ge.med.terra.jami.CodecUtils;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.remote.XpRemoteMedicalImage;
import com.ge.med.terra.jami.roi.RoiStatistics;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class RemoteRoiStatistics
implements RoiStatistics {
    private static final byte ROI_RECTANGLE = 0;
    private static final byte ROI_ELLIPSE = 1;
    private static final byte ROI_POLYGON = 2;
    private XpImage img = null;
    private XpPixelStatistics ps = new XpPixelStatistics();
    private int width = 0;
    private int height = 0;
    private double rescaleSlope = 1.0;
    private double rescaleIntercept = 0.0;

    public JnHistogram calcHistogram(Shape s, double angle, JnHistogram histogram) {
        return null;
    }

    public static int encode(Shape s, double angle, byte[] buff, int startOffset) {
        int offset = startOffset;
        if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            buff[offset] = 0;
            CodecUtils.putDouble(buff, ++offset, angle);
            CodecUtils.putDouble(buff, offset += 8, r.getX());
            CodecUtils.putDouble(buff, offset += 8, r.getY());
            CodecUtils.putDouble(buff, offset += 8, r.getWidth());
            CodecUtils.putDouble(buff, offset += 8, r.getHeight());
            offset += 8;
        } else if (s instanceof Ellipse2D) {
            Ellipse2D e = (Ellipse2D)s;
            buff[offset] = 1;
            CodecUtils.putDouble(buff, ++offset, angle);
            CodecUtils.putDouble(buff, offset += 8, e.getX());
            CodecUtils.putDouble(buff, offset += 8, e.getY());
            CodecUtils.putDouble(buff, offset += 8, e.getWidth());
            CodecUtils.putDouble(buff, offset += 8, e.getHeight());
            offset += 8;
        } else if (s instanceof GeneralPath) {
            // empty if block
        }
        return offset;
    }

    public static int decode(byte[] buff, int startOffset, Shape[] shape, double[] angle) {
        int offset = startOffset;
        byte roiType = buff[offset];
        angle[0] = CodecUtils.getDouble(buff, ++offset);
        offset += 8;
        switch (roiType) {
            case 0: {
                double x = CodecUtils.getDouble(buff, offset);
                double y = CodecUtils.getDouble(buff, offset += 8);
                double w = CodecUtils.getDouble(buff, offset += 8);
                double h = CodecUtils.getDouble(buff, offset += 8);
                offset += 8;
                shape[0] = new Rectangle2D.Double(x, y, w, h);
                break;
            }
            case 1: {
                double x = CodecUtils.getDouble(buff, offset);
                double y = CodecUtils.getDouble(buff, offset += 8);
                double w = CodecUtils.getDouble(buff, offset += 8);
                double h = CodecUtils.getDouble(buff, offset += 8);
                offset += 8;
                shape[0] = new Ellipse2D.Double(x, y, w, h);
            }
        }
        return offset;
    }

    public double getArea(Shape s, double angle) {
        if (this.img != null) {
            double[] stats = ((XpRemoteMedicalImage)this.img).getStatistics(s, angle);
            return stats[7];
        }
        return 0.0;
    }

    public double getLength(Shape s, double angle) {
        if (this.img != null) {
            double[] stats = ((XpRemoteMedicalImage)this.img).getStatistics(s, angle);
            return stats[8];
        }
        return -1.0;
    }

    public XpPixelStatistics getPixelStatistics(Shape s, double angle) {
        if (this.img != null) {
            double[] stats = ((XpRemoteMedicalImage)this.img).getStatistics(s, angle);
            this.ps.min = stats[0];
            this.ps.max = stats[1];
            this.ps.sum = stats[2];
            this.ps.sumSq = stats[3];
            this.ps.mean = stats[4];
            this.ps.variance = stats[5];
            this.ps.npixels = (int)stats[6];
        }
        return this.ps;
    }

    public BufferedImage getPixels(Shape s, double angle) {
        return null;
    }

    public void setImage(XpImage img) {
        this.img = img;
        if (img != null) {
            this.width = img.getSlice().width;
            this.height = img.getSlice().height;
            this.rescaleSlope = img.getRescaleSlope();
            this.rescaleIntercept = img.getRescaleIntercept();
        }
    }
}

