/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render.remote;

import com.ge.med.terra.jami.CodecUtils;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.image.XjMedicalImage;
import com.ge.med.terra.jami.remote.RmCommand;
import com.ge.med.terra.jami.remote.RmServerDataManager;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.remote.Rm2DClientServerIF;
import com.ge.med.terra.jami.render.remote.RmServer2DEngine;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Rm2DDispatcher
implements Rm2DClientServerIF {
    private RemoteCaller caller = null;
    private RmServer2DEngine server_engine = null;
    private XpImageRenderAttributes ira = new XpImageRenderAttributes();
    private XpImage[] images = null;
    private int curImgSetID = -1;
    private byte[] rendering_args = new byte[10];
    private byte[] setOutput_args = new byte[9];
    private byte[] clearBuffers_args = new byte[1];
    private byte[] setImage_args = new byte[9];
    private byte[] suppMpass_args = new byte[1];
    private byte[] imgLayer_args = new byte[1];
    private byte[] setFitVp_args = new byte[2];
    private byte[] setClipGraph_args = new byte[2];
    private byte[] setImgLayer_args = new byte[5];
    private byte[] getFitVp_args = new byte[1];
    private byte[] getNumImgLayers_args = new byte[1];
    private byte[] attribute_args = new byte[53];
    private Object[] server_args = new Object[10];
    private byte[] outbuffer = new byte[4096];

    public Rm2DDispatcher(RemoteCaller c) {
        this.caller = c;
    }

    public int createEngine(String rengine) {
        this.server_engine = new RmServer2DEngine();
        return this.server_engine.getServer2DEngineId();
    }

    public ByteBuffer processCommand(byte[] in) {
        byte cmdId = in[0];
        switch (cmdId) {
            case 1: {
                this.server_args[0] = new Integer(CodecUtils.getInt(in, 1));
                this.server_args[1] = new Integer(CodecUtils.getInt(in, 5));
                this.server_args[2] = new Byte(in[9]);
                break;
            }
            case 10: {
                break;
            }
            case 9: {
                int width = CodecUtils.getInt(in, 1);
                int height = CodecUtils.getInt(in, 5);
                this.outbuffer = new byte[width * height * 4];
                this.server_args[0] = new Integer(width);
                this.server_args[1] = new Integer(height);
                break;
            }
            case 11: {
                break;
            }
            case 2: {
                this.server_args[0] = new Boolean(CodecUtils.getBoolean(in, 1));
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                int setId = CodecUtils.getInt(in, 1);
                int id = CodecUtils.getInt(in, 5);
                if (this.images == null || this.curImgSetID != setId) {
                    this.curImgSetID = setId;
                    this.loadImageSet(this.curImgSetID);
                }
                if (this.images == null) break;
                this.server_args[0] = this.images[id];
                break;
            }
            case 5: {
                break;
            }
            case 12: {
                this.server_args[0] = new Integer(CodecUtils.getInt(in, 1));
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                double angle = CodecUtils.getDouble(in, 1);
                double panX = CodecUtils.getDouble(in, 9);
                double panY = CodecUtils.getDouble(in, 17);
                int pSize = CodecUtils.getInt(in, 25);
                double wl = CodecUtils.getDouble(in, 29);
                double ww = CodecUtils.getDouble(in, 37);
                double zoom = CodecUtils.getDouble(in, 45);
                this.ira.setAngle(angle);
                this.ira.setPan(panX, panY);
                this.ira.setPresentationSizeMode(pSize);
                this.ira.setWindowing(ww, wl);
                this.ira.setZoom(zoom);
                this.server_args[0] = this.ira;
                break;
            }
            case 8: {
                this.server_args[0] = new Boolean(CodecUtils.getBoolean(in, 1));
            }
        }
        RmCommand rmcmd = new RmCommand(cmdId, this.server_args);
        Object retval = this.server_engine.executeCommand(rmcmd);
        ByteBuffer xm_retval = null;
        switch (cmdId) {
            case 1: {
                Object[] retvals = (Object[])retval;
                int pblen = (Integer)retvals[0];
                byte[] pbencode = (byte[])retvals[1];
                xm_retval = ByteBuffer.wrap(pbencode, 0, pblen);
                break;
            }
            case 10: {
                String mpass_ret = "";
                Class[] malg = (Class[])retval;
                if (malg == null) break;
                mpass_ret = malg[0].getCanonicalName();
                for (int i = 1; i < malg.length; ++i) {
                    mpass_ret = mpass_ret + "#" + malg[i].getCanonicalName();
                }
                CodecUtils.putString(this.outbuffer, 0, mpass_ret);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 2 * mpass_ret.length() + 2);
                break;
            }
            case 9: {
                break;
            }
            case 11: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                boolean ftvp = (Boolean)retval;
                CodecUtils.putBoolean(this.outbuffer, 0, ftvp);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 1);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                int layer = (Integer)retval;
                CodecUtils.putInt(this.outbuffer, 0, layer);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 4);
                break;
            }
            case 12: {
                break;
            }
            case 6: {
                int layers = (Integer)retval;
                CodecUtils.putInt(this.outbuffer, 0, layers);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 4);
                break;
            }
            case 7: {
                break;
            }
        }
        return xm_retval;
    }

    public Object remoteCommand(RmCommand rmc) {
        byte cmdId = rmc.getCommandId();
        Object[] args = rmc.getArgs();
        byte[] data = null;
        int data_offset = 0;
        int data_len = 0;
        switch (cmdId) {
            case 1: {
                int renderOutputLayer = (Integer)args[0];
                int passno = (Integer)args[1];
                byte renderType = (Byte)args[2];
                CodecUtils.putInt(this.rendering_args, 1, renderOutputLayer);
                CodecUtils.putInt(this.rendering_args, 5, passno);
                this.rendering_args[9] = renderType;
                data = this.rendering_args;
                data_len = data.length;
                break;
            }
            case 10: {
                data = this.suppMpass_args;
                data_len = data.length;
                break;
            }
            case 9: {
                int width = (Integer)args[0];
                int height = (Integer)args[1];
                CodecUtils.putInt(this.setOutput_args, 1, width);
                CodecUtils.putInt(this.setOutput_args, 5, height);
                data = this.setOutput_args;
                data_len = data.length;
                break;
            }
            case 11: {
                data = this.clearBuffers_args;
                data_len = data.length;
                break;
            }
            case 2: {
                boolean fit = (Boolean)args[0];
                CodecUtils.putBoolean(this.setFitVp_args, 1, fit);
                data = this.setFitVp_args;
                data_len = data.length;
                break;
            }
            case 3: {
                data = this.getFitVp_args;
                data_len = data.length;
                break;
            }
            case 4: {
                XpImage image = (XpImage)args[0];
                XjMedicalImage img = (XjMedicalImage)image;
                XpDicomElement de = new XpDicomElement(39321, 0);
                img.getValue(de);
                int id = (Integer)de.value;
                de = new XpDicomElement(39320, 0);
                img.getValue(de);
                int setId = (Integer)de.value;
                CodecUtils.putInt(this.setImage_args, 1, setId);
                CodecUtils.putInt(this.setImage_args, 5, id);
                data = this.setImage_args;
                data_len = data.length;
                break;
            }
            case 5: {
                data = this.imgLayer_args;
                data_len = data.length;
                break;
            }
            case 12: {
                int layer = (Integer)args[0];
                CodecUtils.putInt(this.setImgLayer_args, 1, layer);
                data = this.setImgLayer_args;
                data_len = data.length;
                break;
            }
            case 6: {
                data = this.getNumImgLayers_args;
                data_len = data.length;
                break;
            }
            case 7: {
                XpImageRenderAttributes ira = (XpImageRenderAttributes)args[0];
                double angle = ira.getAngle();
                double panX = ira.getPanX();
                double panY = ira.getPanY();
                int pSize = ira.getPresentationSizeMode();
                double wl = ira.getWindowLevel();
                double ww = ira.getWindowWidth();
                double zoom = ira.getZoom();
                CodecUtils.putDouble(this.attribute_args, 1, angle);
                CodecUtils.putDouble(this.attribute_args, 9, panX);
                CodecUtils.putDouble(this.attribute_args, 17, panY);
                CodecUtils.putInt(this.attribute_args, 25, pSize);
                CodecUtils.putDouble(this.attribute_args, 29, wl);
                CodecUtils.putDouble(this.attribute_args, 37, ww);
                CodecUtils.putDouble(this.attribute_args, 45, zoom);
                data = this.attribute_args;
                data_len = data.length;
                break;
            }
            case 8: {
                boolean graphics = (Boolean)args[0];
                CodecUtils.putBoolean(this.setClipGraph_args, 1, graphics);
                data = this.setClipGraph_args;
                data_len = data.length;
            }
        }
        if (data_len == 0 || data == null) {
            return null;
        }
        data[0] = cmdId;
        byte[] ret = this.caller.call(data, data_offset, data_len);
        Object retval = null;
        switch (cmdId) {
            case 1: {
                retval = ret;
                break;
            }
            case 10: {
                String mpass_alg = CodecUtils.getString(ret, 0);
                StringTokenizer stmp = new StringTokenizer(mpass_alg, "#");
                ArrayList<String> mp_list = new ArrayList<String>();
                while (stmp.hasMoreTokens()) {
                    String mp = stmp.nextToken();
                    mp_list.add(mp);
                }
                Class[] mpass_table = new Class[mp_list.size()];
                for (int i = 0; i < mpass_table.length; ++i) {
                    String clName = (String)mp_list.get(i);
                    try {
                        mpass_table[i] = Class.forName(clName);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("Rm2DDispatcher ERROR: Non-existent class=" + clName);
                    }
                }
                retval = mpass_table;
                break;
            }
            case 9: {
                break;
            }
            case 11: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                boolean ftvp = CodecUtils.getBoolean(ret, 0);
                retval = new Boolean(ftvp);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                int layer = CodecUtils.getInt(ret, 0);
                retval = new Integer(layer);
                break;
            }
            case 12: {
                break;
            }
            case 6: {
                retval = new Integer(CodecUtils.getInt(ret, 0));
                break;
            }
            case 7: {
                break;
            }
        }
        return retval;
    }

    private void loadImageSet(int imageSetID) {
        this.images = (XpImage[])RmServerDataManager.instance().getDataObject(imageSetID);
    }

    public static interface RemoteCaller {
        public byte[] call(byte[] var1, int var2, int var3);
    }
}

