/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi;

import com.ge.med.idc.Selectable;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class RoiShapeModel
implements Selectable,
Serializable {
    public static final String ROI_SHAPE_MODEL = "ROI_SHAPE_MODEL";
    private static int shapeCounter = 1;
    private transient Shape shape = null;
    private double angle = 0.0;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean selected = false;
    private boolean editable = true;
    private int shapeId = 0;
    private String tooltip = null;
    static boolean debug = false;

    public RoiShapeModel(Shape shape) {
        this.shape = shape;
        this.shapeId = shapeCounter++;
        if (debug) {
            new RuntimeException().printStackTrace();
        }
    }

    public final Shape getShape() {
        return this.shape;
    }

    public final int getShapeId() {
        return this.shapeId;
    }

    public final Rectangle getBounds() {
        return this.shape.getBounds();
    }

    public final Rectangle2D getBounds2D() {
        return this.shape.getBounds2D();
    }

    public final boolean contains(double x, double y) {
        return this.shape.contains(x, y);
    }

    public final boolean contains(Point2D p) {
        return this.shape.contains(p);
    }

    public final boolean intersects(double x, double y, double w, double h) {
        return this.shape.intersects(x, y, w, h);
    }

    public final boolean intersects(Rectangle2D r) {
        return this.shape.intersects(r);
    }

    public final boolean contains(double x, double y, double w, double h) {
        return this.shape.contains(x, y, w, h);
    }

    public final boolean contains(Rectangle2D r) {
        return this.shape.contains(r);
    }

    public final PathIterator getPathIterator(AffineTransform at) {
        return this.shape.getPathIterator(at);
    }

    public final PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.shape.getPathIterator(at, flatness);
    }

    public final void setToolTipText(String text) {
        this.tooltip = text;
    }

    public final String getToolTipText() {
        return this.tooltip;
    }

    public final double getAngle() {
        return this.angle;
    }

    public final void syncModel() {
        this.firePropertyChange(ROI_SHAPE_MODEL, this);
    }

    public final void setAngle(double angle) {
        this.angle = angle;
        this.syncModel();
    }

    public final void setSelected(boolean selection) {
        if (selection && !this.editable) {
            return;
        }
        if (this.selected == selection) {
            return;
        }
        this.selected = selection;
        if (this.selected) {
            this.pcs.firePropertyChange("COMPONENT_SELECTED", null, this);
        } else {
            this.pcs.firePropertyChange("COMPONENT_UNSELECTED", null, this);
        }
    }

    public final boolean isSelected() {
        return this.selected;
    }

    public final void setEditable(boolean editable) {
        this.editable = editable;
        if (this.isSelected() && !editable) {
            this.setSelected(false);
        }
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final void removePropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(propName, pcl);
    }

    public final void addPropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(propName, pcl);
    }

    private void firePropertyChange(String property, Object value) {
        PropertyChangeEvent e = new PropertyChangeEvent(this, property, null, value);
        this.pcs.firePropertyChange(e);
    }

    public void getCenter(Point2D center) {
        Rectangle2D bounds = this.shape.getBounds2D();
        double cx = bounds.getX() + bounds.getWidth() / 2.0;
        double cy = bounds.getY() + bounds.getHeight() / 2.0;
        center.setLocation(cx, cy);
    }

    public Object clone() {
        return this;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        try {
            s.defaultWriteObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException {
        try {
            s.defaultReadObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

