/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMObjectReceiver;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peer.DMAuxObject;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectExt1;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.peer.DMiSequence;
import com.ge.med.terra.tap.dm.peerutils.Util;
import java.awt.image.BufferedImage;
import java.util.Properties;

public class DMObject
implements DMTagValueInterface {
    public static final int LOCK_NONE = 0;
    public static final int LOCK_SOME = 1;
    public static final int LOCK_ALL = 2;
    DMiObject peer;
    DMSession session;

    public DMObject(DMiObject peer, DMSession s) {
        this.peer = peer;
        peer.attach();
        this.session = s;
    }

    public String getType() {
        return this.peer.getType();
    }

    public Object getValue(int group, int element) {
        return this.getValue(new DMTag(group, element));
    }

    public Object getValue(int group, int element, String privateCID) {
        return this.getValue(new DMTag(privateCID, group, element));
    }

    public Object getValue(DMTag t) {
        Object o;
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.finest("getValue(" + t + ")");
        }
        if ((o = this.peer.getValue(t)) instanceof DMiSequence) {
            return new DMSequence((DMiSequence)o);
        }
        return o;
    }

    public Object getValue(String tag2) {
        return Util.getValue((DMTagValueInterface)this, (String)tag2);
    }

    public void getValues(DMElement[] elements) {
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.finest("getValues(elements)");
        }
        this.peer.getValues(elements);
        for (int i = 0; i < elements.length; ++i) {
            if (!(elements[i].value instanceof DMiSequence)) continue;
            elements[i].value = new DMSequence((DMiSequence)elements[i].value);
        }
    }

    public DMComposite[] getComposites() {
        DMiComposite[] ci;
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.finest("getComposites()");
        }
        int len = null == (ci = this.peer.getComposites(null)) ? 0 : ci.length;
        DMComposite[] c = new DMComposite[len];
        for (int i = 0; i < c.length; ++i) {
            c[i] = new DMComposite(ci[i], this.session);
        }
        return c;
    }

    public DMObject[] getRelated(String ieType) {
        return this.getRelated(ieType, null);
    }

    public DMObject[] getRelated(String ieType, DMQuery q) {
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.finest("getRelated(" + ieType + "," + q + ")");
        }
        DMiObject[] oi = this.peer.getRelated(ieType, q);
        DMObject[] o = new DMObject[oi.length];
        for (int i = 0; i < o.length; ++i) {
            o[i] = new DMObject(oi[i], this.session);
        }
        return o;
    }

    public void getRelated(String ieType, DMQuery q, DMObjectReceiver cb) {
        this.peer.getRelated(ieType, q, (DMiObjectReceiver)new /* Unavailable Anonymous Inner Class!! */);
    }

    public int getNumberOfRelated(String ieType) {
        return this.peer.getNumberOfRelated(ieType, null);
    }

    public BufferedImage[] getPixelData() {
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.finest("getPixelData()");
        }
        return this.peer.getPixelData(null);
    }

    public BufferedImage[] getPixelData(DMTag[] tags) {
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.finest("getPixelData(tags)");
        }
        return this.peer.getPixelData(tags);
    }

    public DMiObject getPeer() {
        return this.peer;
    }

    public void delete() {
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.fine("delete()");
        }
        this.peer.delete();
    }

    protected void finalize() throws Throwable {
        this.peer.detach();
        super.finalize();
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DMObject) {
            return this.getID().equals(((DMObject)obj).getID());
        }
        return false;
    }

    public void setValues(DMElement[] elements) {
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.finest("setValues(elements)");
        }
        this.peer.setValues(elements);
    }

    public String getID() {
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.finest("getID()");
        }
        return this.peer.getID();
    }

    public DMImage[] getImages(DMTag[] tags) {
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.finest("getImages(tags)");
        }
        DMiImage[] o = this.peer.getImages(tags);
        DMImage[] img = new DMImage[o.length];
        for (int i = 0; i < o.length; ++i) {
            img[i] = new DMImage(o[i], this.session);
        }
        return img;
    }

    public DMSession getSession() {
        return this.session;
    }

    public String toString() {
        int level = 0;
        if (this.getType().equalsIgnoreCase("patient")) {
            level = 1;
        } else if (this.getType().equalsIgnoreCase("study")) {
            level = 2;
        } else if (this.getType().equalsIgnoreCase("series")) {
            level = 3;
        } else if (this.getType().equalsIgnoreCase("image")) {
            level = 4;
        }
        switch (level) {
            case 1: {
                Object pname = this.getValue(16, 16);
                return "" + (pname != null ? pname : "Empty");
            }
            case 2: {
                Object v = this.getValue(32, 16);
                return "Ex: " + (v != null ? v : "Empty");
            }
            case 3: {
                Object snum = this.getValue(32, 17);
                return "Se: " + (snum != null ? snum : "Empty");
            }
            case 4: {
                Object inum = this.getValue(32, 19);
                return "Im: " + (inum != null ? inum : "Empty");
            }
        }
        return "DMObject with unknown level";
    }

    public void setLock(int lockType) {
        this.peer.setLock(lockType);
    }

    public int getLock() {
        return this.peer.getLock();
    }

    public DMAuxObject getAuxObject(String type, Properties info) {
        DMAuxObject obj = null;
        if (this.peer instanceof DMiObjectExt1) {
            obj = ((DMiObjectExt1)this.peer).getAuxObject(type, info);
        }
        if (null == obj) {
            obj = new IconAuxObject(this, type, info);
        }
        return obj;
    }

    public Object send(String[] str) {
        Object obj = null;
        if (this.peer instanceof DMiObjectExt1) {
            obj = ((DMiObjectExt1)this.peer).send(str);
        }
        return obj;
    }
}

