/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer.treetable;

import com.ge.med.ptk.laf.CuiTableCellRenderer;
import com.ge.med.ptk.laf.Utilities;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.plaf.UIResource;

public class TreeTableCellRenderer
extends CuiTableCellRenderer {
    public static ImageIcon lastSubItemIcon;
    public static ImageIcon midSubItemIcon;
    public static Icon sublistClosedIcon;
    public static Icon sublistOpenIcon;

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (column > 0) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (value == null) {
            return this;
        }
        String text = (String)value;
        this.setText("");
        if (text.equals("+")) {
            this.setIcon(sublistClosedIcon);
        } else if (text.equals("-")) {
            this.setIcon(sublistOpenIcon);
        } else if (text.equals("|")) {
            this.setIcon(midSubItemIcon);
        } else if (text.equals("#")) {
            this.setIcon(lastSubItemIcon);
        } else {
            this.setIcon(null);
        }
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else {
            Color foreground = table.getForeground();
            Color background = table.getBackground();
            if (row % 2 == 0) {
                this.setForeground(foreground);
                this.setBackground(background);
            } else {
                Color alternateForeground = foreground instanceof UIResource ? Utilities.getUIPropertyColor(table, "Table.alternateForeground") : null;
                Color alternateBackground = background instanceof UIResource ? Utilities.getUIPropertyColor(table, "Table.alternateBackground") : null;
                this.setForeground(alternateForeground != null ? alternateForeground : foreground);
                this.setBackground(alternateBackground != null ? alternateBackground : background);
            }
        }
        return this;
    }

    static {
        try {
            lastSubItemIcon = new ImageIcon(TreeTableCellRenderer.class.getResource("icons/treeBranchEnd.gif"));
            midSubItemIcon = new ImageIcon(TreeTableCellRenderer.class.getResource("icons/treeBranchBtw.gif"));
            sublistClosedIcon = Utilities.getUIPropertyIcon(null, "Tree.closedIcon");
            if (sublistClosedIcon == null) {
                sublistClosedIcon = new ImageIcon(TreeTableCellRenderer.class.getResource("icons/subList-closed.gif"));
            }
            if ((sublistOpenIcon = Utilities.getUIPropertyIcon(null, "Tree.openIcon")) == null) {
                sublistOpenIcon = new ImageIcon(TreeTableCellRenderer.class.getResource("icons/subList-open.gif"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

