/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.controls;

import com.ge.med.cse.cvf.commands.CommandControl;
import com.ge.med.cse.cvf.controls.CvMouseControlManager;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvResourceBundle;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.CineCapable;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.mouseController.ConfigurableMouseController;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class CvMouseController
extends ConfigurableMouseController {
    private JComponent target;
    public List<Action> actonList = new ArrayList<Action>();
    public Vector<Action> subMenuActionList = new Vector();
    private XPscreen screen = null;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    String modality = "";
    boolean propAdded = false;
    private static int prevMode = 0;
    private static boolean cinePropAdded = false;
    private Properties prop = null;
    private List<Integer> mouseControllerModes = new ArrayList<Integer>();
    private PropertyChangeListener mouseModeChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            int newMode = CvMouseControlManager.getInstance().getMouseMode();
            if (CvMouseController.this.getLeftMouseButtonMode() != newMode) {
                CvMouseController.this.setLeftMouseButtonMode(newMode);
            }
        }
    };
    private AncestorListener alistner = new AncestorListener(){

        public void ancestorAdded(AncestorEvent event) {
            JComponent ancestor = event.getComponent();
            CvMouseController.this.setScreen((XPscreen)SwingUtilities.getAncestorOfClass(XPscreen.class, ancestor));
        }

        public void ancestorMoved(AncestorEvent event) {
        }

        public void ancestorRemoved(AncestorEvent event) {
        }
    };
    PropertyChangeListener cineListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equalsIgnoreCase("Cine")) {
                CvMouseControlManager manager = CvMouseControlManager.getInstance();
                boolean isCineOn = (Boolean)evt.getNewValue();
                String modesOnCine = CvMouseController.this.prop.getProperty("MouseModesEnabledDuringCineOn");
                if (modesOnCine == null) {
                    return;
                }
                String[] modesOnDuringCine = modesOnCine.split(",");
                ArrayList<Integer> modesOnDrngCine = new ArrayList<Integer>();
                for (int i = 0; i < modesOnDuringCine.length; ++i) {
                    modesOnDrngCine.add(Integer.valueOf(modesOnDuringCine[i].trim()));
                }
                if (modesOnDrngCine.size() > 0) {
                    if (isCineOn) {
                        prevMode = manager.getMouseMode();
                        if (!modesOnDrngCine.contains(prevMode)) {
                            CvMouseController.this.setLeftMouseButtonMode(Integer.parseInt(CvMouseController.this.prop.getProperty("DefaultMouseModeDuringCineOn", "3")));
                        }
                    } else {
                        CvMouseController.this.setLeftMouseButtonMode(prevMode);
                    }
                }
            }
        }
    };

    public CvMouseController() {
        this.prop = CvPropertiesManager.getProperties();
    }

    public CvMouseController(Properties properties) {
        this.prop = properties == null ? CvPropertiesManager.getProperties() : properties;
    }

    public void setPropreties(Properties properties) {
        this.prop.clear();
        this.prop.putAll((Map<?, ?>)properties);
    }

    private void updatemenu(String mod) {
        CvMouseControlManager mcManager;
        block28: {
            if (this.target != null) {
                FrameOwner frCap = (FrameOwner)((Object)((Capable)((Object)this.target)).getCapable(FrameOwner.class.getName()));
                if (frCap.getFrame() instanceof XpDicomObject) {
                    XpDicomObject dicomObj = (XpDicomObject)((Object)frCap.getFrame());
                    XpDicomElement elem = new XpDicomElement(8, 96);
                    dicomObj.getValue(elem);
                    if (elem.value != null) {
                        this.modality = elem.value.toString().toLowerCase();
                    }
                } else {
                    this.modality = mod;
                }
            }
            try {
                this.mouseControllerModes.clear();
                String mouseActionCountString = this.prop.getProperty("MouseMenu.Controller.count." + this.modality, this.prop.getProperty("MouseMenu.Controller.count"));
                if (mouseActionCountString != null) {
                    int count = Integer.parseInt(mouseActionCountString);
                    XpMouseController contoller = null;
                    for (int i = 0; i < count; ++i) {
                        String compName = this.prop.getProperty("MouseMenu.Controller." + String.valueOf(i));
                        while (compName == null || compName == "") {
                            ++count;
                            compName = this.prop.getProperty("MouseMenu.Controller." + String.valueOf(++i));
                        }
                        Class<?> compClsass = Class.forName(compName);
                        contoller = (XpMouseController)compClsass.newInstance();
                        String modeString = this.prop.getProperty("MouseMenu.Controller." + String.valueOf(i) + ".mode");
                        int mode = Integer.parseInt(modeString.trim());
                        String overwriteString = this.prop.getProperty("MouseMenu.Controller." + String.valueOf(i) + ".overwrite");
                        boolean isOverwrite = Boolean.valueOf(overwriteString);
                        if (isOverwrite) {
                            String name = this.prop.getProperty("MouseMenu.Controller." + String.valueOf(i) + ".name");
                            String tooltip = CvUtils.getResourceBundle().getString("MouseMenu.Controller." + name + ".tooltip");
                            this.putModeProperty(mode, "name_property", tooltip);
                            String shortDesc = CvUtils.getResourceBundle().getString("MouseMenu.Controller." + name + ".shortdesc");
                            this.putModeProperty(mode, "short_description_property", shortDesc);
                            ImageIcon icon = (ImageIcon)CvUtils.getIcon("MouseMenu.Controller." + name + ".icon");
                            this.putModeProperty(mode, "icon_property", icon);
                            Icon selectedIcon = CvUtils.getIcon("MouseMenu.Controller." + name + ".selectedicon");
                            this.putModeProperty(mode, "selected_icon_property", selectedIcon);
                            Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(icon.getImage(), new Point(icon.getIconWidth() / 2, icon.getIconHeight() / 2), name);
                            this.putModeProperty(mode, "cursor_property", cursor);
                        }
                        this.setMouseControllerModes(mode);
                        this.installController(contoller, mode);
                    }
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Unable to install Mouse Controllers. " + e.getLocalizedMessage());
            }
            mcManager = CvMouseControlManager.getInstance();
            if (mcManager.getMouseMode() != -1) {
                this.setLeftMouseButtonMode(mcManager.getMouseMode());
            } else {
                int defaultSelectionMode = Integer.parseInt(this.prop.getProperty("MouseMenu.Controller.defaultMode"));
                this.setLeftMouseButtonMode(defaultSelectionMode);
                mcManager.setMouseMode(defaultSelectionMode);
            }
            int middleBtnMode = Integer.parseInt(this.prop.getProperty("MouseMiddleButtonMode"));
            this.setMiddleButtonMode(middleBtnMode);
            try {
                String mouseActionCountStirng = this.prop.getProperty("MouseMenu.group.count." + this.modality, this.prop.getProperty("MouseMenu.group.count"));
                if (mouseActionCountStirng == null) break block28;
                int groupCount = Integer.parseInt(mouseActionCountStirng);
                Action act = null;
                Field fd = CvMouseController.class.getSuperclass().getDeclaredField("popup_");
                fd.setAccessible(true);
                JPopupMenu popmenu = (JPopupMenu)fd.get(this);
                for (int i = 0; i < groupCount; ++i) {
                    ArrayList<Action> list = new ArrayList<Action>();
                    int count = Integer.parseInt(this.prop.getProperty("MouseMenu." + String.valueOf(i) + ".count" + "." + this.modality, this.prop.getProperty("MouseMenu." + String.valueOf(i) + ".count")));
                    if (count != 0) {
                        popmenu.addSeparator();
                    }
                    for (int j = 0; j < count; ++j) {
                        String subCountStr = this.prop.getProperty("MouseMenu." + String.valueOf(i) + "." + String.valueOf(j) + ".count." + this.modality, this.prop.getProperty("MouseMenu." + String.valueOf(i) + "." + String.valueOf(j) + ".count"));
                        if (subCountStr != null) {
                            String templabel;
                            int subCount = Integer.parseInt(subCountStr);
                            String label = templabel = this.prop.getProperty("MouseMenu." + String.valueOf(i) + "." + String.valueOf(j) + ".label");
                            CvResourceBundle bundle = new CvResourceBundle();
                            try {
                                label = bundle.getString(templabel);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            JMenu menu = new JMenu(label);
                            for (int k = 0; k < subCount; ++k) {
                                String subSubStr = this.prop.getProperty("MouseMenu." + String.valueOf(i) + "." + String.valueOf(j) + "." + String.valueOf(k) + ".count." + this.modality, this.prop.getProperty("MouseMenu." + String.valueOf(i) + "." + String.valueOf(j) + "." + String.valueOf(k) + ".count"));
                                if (subSubStr != null) {
                                    String tempsubMenuTitile;
                                    int subsubCount = Integer.parseInt(subSubStr);
                                    label = tempsubMenuTitile = this.prop.getProperty("MouseMenu." + String.valueOf(i) + "." + String.valueOf(j) + "." + String.valueOf(k) + ".label");
                                    try {
                                        label = bundle.getString(templabel);
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    JMenu subMenu = new JMenu(label);
                                    menu.add(subMenu);
                                    for (int l = 0; l < subsubCount; ++l) {
                                        String classname = this.prop.getProperty("MouseMenu." + String.valueOf(i) + "." + String.valueOf(j) + "." + String.valueOf(k) + "." + String.valueOf(l));
                                        Action subAct = (Action)Class.forName(classname).newInstance();
                                        String param = this.prop.getProperty("MouseMenu." + String.valueOf(i) + "." + String.valueOf(j) + "." + String.valueOf(k) + "." + String.valueOf(l) + ".param");
                                        if (subAct instanceof CommandControl && param != null) {
                                            CommandControl ctrl = (CommandControl)((Object)subAct);
                                            String[] params = param.split(",");
                                            ctrl.setParams(params);
                                        }
                                        subMenu.add(new JMenuItem(subAct));
                                        this.subMenuActionList.add(subAct);
                                        popmenu.add(menu);
                                    }
                                    continue;
                                }
                                String classname = this.prop.getProperty("MouseMenu." + String.valueOf(i) + "." + String.valueOf(j) + "." + String.valueOf(k));
                                String param = this.prop.getProperty("MouseMenu." + String.valueOf(i) + "." + String.valueOf(j) + "." + String.valueOf(k) + ".param");
                                Action subAct = (Action)Class.forName(classname).newInstance();
                                if (subAct instanceof CommandControl && param != null) {
                                    CommandControl ctrl = (CommandControl)((Object)subAct);
                                    String[] params = param.split(",");
                                    ctrl.setParams(params);
                                }
                                JMenuItem item = new JMenuItem(subAct);
                                menu.add(item);
                                this.subMenuActionList.add(subAct);
                                popmenu.add(menu);
                            }
                            continue;
                        }
                        String compName = this.prop.getProperty("MouseMenu." + String.valueOf(i) + "." + String.valueOf(j));
                        Class<?> compClsass = Class.forName(compName);
                        act = (Action)compClsass.newInstance();
                        list.add(act);
                    }
                    this.addActionGroup(list);
                    this.actonList.addAll(list);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.log(Level.WARNING, "Unable to install Mouse Actions. " + e.getLocalizedMessage());
            }
        }
        if (Boolean.valueOf(this.prop.getProperty("EnableMouseModeSetting", "true")).booleanValue()) {
            mcManager.removePropertyChangeListener(this.mouseModeChangeListener);
            mcManager.addPropertyChangeListener(this.mouseModeChangeListener);
        }
    }

    private void setScreen(XPscreen scr) {
        if (this.screen != scr) {
            this.screen = scr;
        }
        if (this.screen != null) {
            for (int i = 0; i < this.actonList.size(); ++i) {
                Action act = this.actonList.get(i);
                if (!(act instanceof PlasmaControl)) continue;
                ((PlasmaControl)((Object)act)).setCapable(this.screen);
            }
            int submenuActionCount = this.subMenuActionList.size();
            for (int i = 0; i < submenuActionCount; ++i) {
                Action act = this.subMenuActionList.get(i);
                if (!(act instanceof PlasmaControl)) continue;
                ((PlasmaControl)((Object)act)).setCapable(this.screen);
            }
        }
        if (this.screen != null && !this.propAdded) {
            this.propAdded = true;
            this.screen.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equalsIgnoreCase("CONTENT_CHANGED") || evt.getPropertyName().equalsIgnoreCase("data_changed")) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                if (CvMouseController.this.screen != null) {
                                    CvMouseController.this.updatemenu(CvMouseController.this.modality);
                                    CvMouseController.this.setScreen(CvMouseController.this.screen);
                                }
                            }
                        });
                    } else if (evt.getPropertyName().equals("RowColumnProperty")) {
                        CvMouseController.this.updatemenu(CvMouseController.this.modality);
                        CvMouseController.this.setScreen(CvMouseController.this.screen);
                    }
                }
            });
        }
        if (!cinePropAdded && this.screen != null) {
            this.screen.addPropertyChangeListener("Cine", this.cineListener);
            cinePropAdded = true;
        }
    }

    public void addActionGroup(List actions) {
        if (actions.size() == 0) {
            return;
        }
        try {
            Field fd = CvMouseController.class.getSuperclass().getDeclaredField("popup_");
            fd.setAccessible(true);
            JPopupMenu popup_ = (JPopupMenu)fd.get(this);
            ListIterator iter = actions.listIterator();
            while (iter.hasNext()) {
                popup_.add((Action)iter.next());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTarget(JComponent vc) {
        this.screen = (XPscreen)SwingUtilities.getAncestorOfClass(XPscreen.class, vc);
        this.updatemenu(this.modality);
        this.setScreen(this.screen);
        CvMouseControlManager mcManager = CvMouseControlManager.getInstance();
        mcManager.removePropertyChangeListener(this.mouseModeChangeListener);
        if (this.target != null) {
            this.target.removeAncestorListener(this.alistner);
        }
        this.target = vc;
        super.setTarget(vc);
        if (this.target != null) {
            vc.addAncestorListener(this.alistner);
            mcManager.addPropertyChangeListener(this.mouseModeChangeListener);
            if (mcManager.getMouseMode() != -1) {
                this.setLeftMouseButtonMode(mcManager.getMouseMode());
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FrameCapable frcap;
                if (CvMouseController.this.screen != null && CvMouseController.this.screen instanceof FrameCapable && (frcap = (FrameCapable)((Object)CvMouseController.this.screen)).getFrame() instanceof XpDicomObject) {
                    XpDicomObject obj = (XpDicomObject)((Object)frcap.getFrame(0));
                    XpDicomElement elem = new XpDicomElement(8, 96);
                    if (obj != null && elem != null) {
                        obj.getValue(elem);
                        CvMouseController.this.modality = elem.value.toString();
                        CvMouseController.this.updatemenu(CvMouseController.this.modality);
                    }
                    CvMouseController.this.setScreen(CvMouseController.this.screen);
                }
            }
        });
    }

    public void setLeftMouseButtonMode(int mode) {
        if (this.impl_ != null) {
            this.impl_.setTarget(null);
            super.setLeftMouseButtonMode(mode);
            this.impl_.setTarget(this.target);
            CvMouseControlManager.getInstance().setMouseMode(mode);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getModifiersEx() == 1024 || e.getModifiersEx() == 2048 || e.getModifiersEx() == 4096) {
            if (!this.isMouseMenuShown(e)) {
                return;
            }
            super.mousePressed(e);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getModifiersEx() == 1024 || e.getModifiersEx() == 2048 || e.getModifiersEx() == 4096) {
            if (!this.isMouseMenuShown(e)) {
                return;
            }
            super.mouseClicked(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.isMouseMenuShown(e)) {
            return;
        }
        super.mouseReleased(e);
    }

    private void setMouseControllerModes(int mode) {
        if (mode >= 0) {
            this.mouseControllerModes.add(mode);
        }
    }

    public int[] getSupportedModes() {
        int[] res = new int[this.mouseControllerModes.size()];
        if (res.length > 0) {
            int i = 0;
            for (Integer type : this.mouseControllerModes) {
                res[i++] = type;
            }
        }
        return res;
    }

    private boolean isMouseMenuShown(MouseEvent e) {
        if (this.screen != null) {
            CineCapable ccap = (CineCapable)this.screen.getCapable(CineCapable.class.getName());
            return !ccap.getCine() || e.getButton() != 3;
        }
        return true;
    }
}

