/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.roi;

import com.ge.med.cse.cvf.roi.CvPolygonRoi;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DefaultHandleFactory;
import com.ge.med.cse.cvf.util.HandleFactory;
import com.ge.med.idc.ComponentCreator;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.roi.RoiShapeModel;
import com.ge.med.terra.jami.roi.XpRoiHandleContainer;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class CvPolygonRoi
extends XpStatisticsRoi
implements Cloneable,
Serializable {
    private transient GeneralPath polygon = null;
    private transient GeneralPath drawPolygon = new GeneralPath();
    private transient List points = new ArrayList();
    private transient List approxPts = new ArrayList();
    private transient Point2D containsTemp = new Point2D.Double();
    private transient Point2D centroidPt = new Point2D.Double();
    private double minX = 0.0;
    private double maxX = 0.0;
    private double minY = 0.0;
    private double maxY = 0.0;
    private boolean doHandles = true;
    private boolean closed = false;
    private boolean closeable = false;
    private boolean idealMetrics = true;
    private static boolean MOVE_HANDLE_EXIST = false;
    private static int MOVE_HANDLE_IDX = 0;
    private static int LINE_SENSITIVITY = 10;
    private static final double SCOOTCH = 2.5;
    private static Color SELECTED_COLOR = null;
    private static Color UNSELECTED_COLOR = null;
    private static Color HANDLE_COLOR = null;
    private static boolean pointhandlefilled = false;
    protected static Shape CONTAINMENT_SHAPE = null;
    protected static Shape HANDLE_SHAPE = null;
    protected static Cursor RESIZE_CURSOR = null;
    protected static Cursor MOVE_CURSOR = null;
    private static final DecimalFormat dfe = new DecimalFormat("#.0");
    private static final String DEG_SYMBOL = new String(new char[]{'\u00b0'});
    private static String DISTANCE_PREFIX = null;
    private static String ANGLE_PREFIX = null;
    private static String MEAN_PREFIX = null;
    private static String AREA_PREFIX = null;
    private static String SD_PREFIX = null;
    private static String DISTANCE_SUFFIX = null;
    private static String ANGLE_SUFFIX = null;
    private static String MEAN_SUFFIX = null;
    private static String AREA_SUFFIX = null;
    private static String SD_SUFFIX = null;
    private XpGeomUtils util = new XpGeomUtils();
    protected XpHandle moveHandle = null;
    private transient int mousePtx = -1;
    private transient int mousePty = -1;
    private transient boolean showDrawing = false;
    private static boolean SHOW_DRAWING = false;
    private static Color ROILABEL_COLOR = null;
    private static int ROILABEL_X = 0;
    private static int ROILABEL_Y = 0;
    private static Boolean DRAG_BY_ROILABEL = false;
    private boolean cornerPointAvailable = true;
    static final float[] dash1 = new float[]{3.0f};
    static final BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 2.0f, dash1, 1.0f);

    public CvPolygonRoi(Point2D[] pts) {
        this(pts, false, true);
    }

    public CvPolygonRoi(Point2D[] pts, boolean calcPixelStatistics) {
        this(pts, calcPixelStatistics, true);
    }

    public CvPolygonRoi(Point2D[] pts, boolean calcPixelStatistics, boolean doHandles) {
        super(new GeneralPath());
        this.init(pts, calcPixelStatistics, doHandles);
    }

    private void init(Point2D[] pts, boolean calcPixelStatistics, boolean doHandles) {
        this.polygon = (GeneralPath)this.getModelShape();
        this.setCalcPixelStats(calcPixelStatistics);
        this.setDragByRoiLabel(DRAG_BY_ROILABEL);
        this.doHandles = doHandles;
        this.createMoveHandles();
        if (pts != null && pts.length > 0) {
            for (int i = 0; i < pts.length; ++i) {
                this.points.add(pts[i].clone());
                if (!doHandles) continue;
                XpHandle handle = new XpHandle((XpAnchorable)this, this.points.size(), 20);
                handle.setShape(HANDLE_SHAPE, CONTAINMENT_SHAPE);
                handle.setFilled(pointhandlefilled);
                handle.setLocation(pts[i].getX(), pts[i].getY());
                handle.setCursor(RESIZE_CURSOR);
                handle.setVisible(true);
                this.add(handle);
            }
            this.generateModelPolygon();
        }
    }

    private static void setPolygonRoiProperties() {
        String val = CvPropertiesManager.getProperty("cvf.Handle.Factory");
        HandleFactory f = null;
        if (val != null) {
            f = CvUtils.createHandleFactory(val);
            if (f == null) {
                f = new DefaultHandleFactory();
            }
        } else {
            f = new DefaultHandleFactory();
        }
        CONTAINMENT_SHAPE = f.getContainmentShape();
        val = CvPropertiesManager.getProperty("cvf.polygon.pointHandle.Style");
        if (val != null) {
            if (val.toUpperCase().equals("BOX")) {
                HANDLE_SHAPE = f.getMoveHandleShape(HandleFactory.HandleStyle.BOX);
            } else if (val.toUpperCase().equals("CROSSHAIR")) {
                HANDLE_SHAPE = f.getMoveHandleShape(HandleFactory.HandleStyle.CROSSHAIR);
            }
        }
        HANDLE_COLOR = f.getHandleColor();
        SELECTED_COLOR = f.getHandleSelectedColor();
        UNSELECTED_COLOR = f.getHandleUnSelectedColor();
        RESIZE_CURSOR = f.getResizeHandleCursor();
        MOVE_CURSOR = f.getMoveHandleCursor();
        val = CvPropertiesManager.getProperty("cvf.roi.roiLabel.Color");
        ROILABEL_COLOR = val != null ? CvUtils.getColor(val) : HANDLE_COLOR;
        val = CvPropertiesManager.getProperty("cvf.roi.roiLabel.x");
        if (val != null) {
            ROILABEL_X = Integer.parseInt(val);
        }
        if ((val = CvPropertiesManager.getProperty("cvf.roi.roiLabel.y")) != null) {
            ROILABEL_Y = Integer.parseInt(val);
        }
        if ((val = CvPropertiesManager.getProperty("cvf.roi.dragByRoiLabel", "false")) != null) {
            DRAG_BY_ROILABEL = Boolean.valueOf(val);
        }
        if ((val = CvPropertiesManager.getProperty("cvf.polygon.moveHandleExist", "false")) != null) {
            MOVE_HANDLE_EXIST = Boolean.valueOf(val);
        }
        pointhandlefilled = Boolean.valueOf(CvPropertiesManager.getProperty("cvf.polygon.handle.filled", "false").trim());
        SHOW_DRAWING = Boolean.valueOf(CvPropertiesManager.getProperty("cvf.polygon.showdrawing", "false").trim());
    }

    protected void createMoveHandles() {
        this.moveHandle = new XpHandle((XpAnchorable)this, MOVE_HANDLE_IDX, 16);
        this.moveHandle.setShape(XpHandle.HANDLE_CROSSHAIR, CONTAINMENT_SHAPE);
        this.moveHandle.setFilled(false);
        this.moveHandle.setCursor(MOVE_CURSOR);
        this.add(this.moveHandle);
        this.moveHandle.setVisible(false);
    }

    private void generateModelPolygon() {
        this.polygon.reset();
        this.approxPts.clear();
        int nPts = this.points.size();
        if (nPts > 0) {
            Point2D p;
            Point2D prev = p = (Point2D)this.points.get(0);
            this.approxPts.add(p);
            float x = (float)p.getX();
            float y = (float)p.getY();
            this.polygon.moveTo(x, y);
            for (int i = 1; i < nPts; ++i) {
                p = (Point2D)this.points.get(i);
                x = (float)p.getX();
                y = (float)p.getY();
                this.polygon.lineTo(x, y);
                double distance = p.distanceSq(prev);
                if (!(distance > 6.0) && nPts >= 100) continue;
                this.approxPts.add(p);
                prev = p;
            }
            if (this.closed && nPts > 2 && this.closeable) {
                this.polygon.closePath();
                if (MOVE_HANDLE_EXIST) {
                    this.updateMoveHandle();
                }
            }
        }
    }

    public Shape getDrawShape() {
        this.generateDrawPolygon();
        return this.drawPolygon;
    }

    private boolean closeable() {
        int noPts = this.getNumPoints();
        Point2D lastPt = this.getPoint(noPts - 1);
        int x1 = (int)lastPt.getX();
        int y1 = (int)lastPt.getY();
        int x2 = (int)this.getPoint(0).getX();
        int y2 = (int)this.getPoint(0).getY();
        for (int i = 1; i < noPts - 2; ++i) {
            int y4;
            int x4;
            int y3;
            Point2D pt1 = this.getPoint(i);
            Point2D pt2 = this.getPoint(i + 1);
            int x3 = (int)pt1.getX();
            if (!XpGeomUtils.intersects(x1, y1, x2, y2, x3, y3 = (int)pt1.getY(), x4 = (int)pt2.getX(), y4 = (int)pt2.getY())) continue;
            return false;
        }
        return true;
    }

    private void generateDrawPolygon() {
        this.polygon.reset();
        this.drawPolygon.reset();
        int nPts = this.points.size();
        if (nPts > 0) {
            Point2D p = (Point2D)this.points.get(0);
            float x = (float)p.getX();
            float y = (float)p.getY();
            Point2D.Double tmpPoint1 = new Point2D.Double();
            this.getDisplayPoint(p, tmpPoint1);
            float t_x = (float)((Point2D)tmpPoint1).getX();
            float t_y = (float)((Point2D)tmpPoint1).getY();
            this.polygon.moveTo(x, y);
            this.drawPolygon.moveTo(t_x, t_y);
            if (this.doHandles) {
                this.get(1).setLocation(p);
            }
            this.minX = this.maxX = (double)x;
            this.minY = this.maxY = (double)y;
            for (int i = 1; i < nPts; ++i) {
                p = (Point2D)this.points.get(i);
                x = (float)p.getX();
                y = (float)p.getY();
                this.getDisplayPoint(p, tmpPoint1);
                if (this.doHandles) {
                    this.get(i + 1).setLocation(p);
                }
                t_x = (float)((Point2D)tmpPoint1).getX();
                t_y = (float)((Point2D)tmpPoint1).getY();
                this.polygon.lineTo(x, y);
                this.drawPolygon.lineTo(t_x, t_y);
                if ((double)x < this.minX) {
                    this.minX = x;
                }
                if ((double)x > this.maxX) {
                    this.maxX = x;
                }
                if ((double)y < this.minY) {
                    this.minY = y;
                }
                if (!((double)y > this.maxY)) continue;
                this.maxY = y;
            }
            if (this.closed && nPts > 2 && (this.closeable = this.closeable())) {
                this.polygon.closePath();
                this.drawPolygon.closePath();
                if (MOVE_HANDLE_EXIST) {
                    this.centroid(this.points, this.centroidPt);
                    this.updateMoveHandle();
                }
            }
        }
    }

    private double area(List points2) {
        double sum = 0.0;
        int N = this.points.size();
        for (int i = 0; i < N; ++i) {
            int j = (i + 1) % N;
            Point2D ai = (Point2D)this.points.get(i);
            Point2D aj = (Point2D)this.points.get(j);
            sum += ai.getX() * aj.getY();
            sum -= aj.getX() * ai.getY();
        }
        return (sum /= 2.0) < 0.0 ? -sum : sum;
    }

    private void centroid(List points, Point2D result) {
        double cx = 0.0;
        double cy = 0.0;
        int N = points.size();
        for (int i = 0; i < N - 1; ++i) {
            Point2D a0 = (Point2D)points.get(i);
            Point2D a1 = (Point2D)points.get(i + 1);
            cx += (a0.getX() + a1.getX()) * (a0.getX() * a1.getY() - a0.getY() * a1.getX());
            cy += (a0.getY() + a1.getY()) * (a0.getX() * a1.getY() - a0.getY() * a1.getX());
        }
        if (N > 2) {
            Point2D a0 = (Point2D)points.get(N - 1);
            Point2D a1 = (Point2D)points.get(0);
            cx += (a0.getX() + a1.getX()) * (a0.getX() * a1.getY() - a0.getY() * a1.getX());
            cy += (a0.getY() + a1.getY()) * (a0.getX() * a1.getY() - a0.getY() * a1.getX());
        }
        double ar = this.area(points);
        result.setLocation(cx /= 6.0 * ar, cy /= 6.0 * ar);
    }

    protected void updateHandles() {
        this.generateDrawPolygon();
    }

    private void updateMoveHandle() {
        if (this.moveHandle == null) {
            this.createMoveHandles();
        }
        if (this.moveHandle != null) {
            this.moveHandle.setLocation(this.centroidPt.getX(), this.centroidPt.getY());
            this.moveHandle.setVisible(true);
        }
    }

    public void setIdealMetrics(boolean idealMetric) {
        this.idealMetrics = idealMetric;
    }

    public boolean isIdealMetrics() {
        return this.idealMetrics;
    }

    public final Point2D getPoint(int i) {
        return (Point2D)this.points.get(i);
    }

    public final int getNumPoints() {
        return this.points.size();
    }

    public final double getLineAngle() {
        return this.getLineAngle(0);
    }

    public final double getLineAngle(int pairIdx) {
        int len = this.points.size();
        if (pairIdx + 2 < len) {
            Point2D p1 = (Point2D)this.points.get(pairIdx);
            Point2D c = (Point2D)this.points.get(pairIdx + 1);
            Point2D p2 = (Point2D)this.points.get(pairIdx + 2);
            Point2D.Double tmpPoint1 = new Point2D.Double();
            Point2D.Double tmpPoint2 = new Point2D.Double();
            XpGeomUtils.sub(p1, c, tmpPoint1);
            XpGeomUtils.sub(p2, c, tmpPoint2);
            return XpGeomUtils.angle(tmpPoint1, tmpPoint2);
        }
        if (len == 2) {
            Point2D p1 = (Point2D)this.points.get(0);
            Point2D p2 = (Point2D)this.points.get(1);
            double dy = Math.abs(p2.getY() - p1.getY());
            double dx = Math.abs(p2.getX() - p1.getX());
            return Math.atan2(dx, dy);
        }
        return 0.0;
    }

    public final void addPoint(Point2D p) {
        this.addPoint(this.points.size(), p);
    }

    public final void addPoint(int index, Point2D p) {
        this.points.add(index, p.clone());
        if (this.doHandles) {
            int nUI = this.getNumHandles();
            XpHandle handle = new XpHandle((XpAnchorable)this, nUI, 20);
            handle.setShape(HANDLE_SHAPE, CONTAINMENT_SHAPE);
            handle.setFilled(pointhandlefilled);
            handle.setCursor(Cursor.getPredefinedCursor(7));
            handle.setVisible(true);
            this.add(handle);
        }
        this.generateModelPolygon();
        this.syncModel();
        this.setSelected(true);
    }

    public Object clone() {
        Point2D[] pointsToClone = new Point2D[this.points.size()];
        for (int i = 0; i < this.points.size(); ++i) {
            pointsToClone[i] = (Point2D)this.points.get(i);
        }
        CvPolygonRoi ccr = new CvPolygonRoi(pointsToClone, this.isCalcPixelStats(), this.doHandles);
        ccr.setPolyHandlesVisible(true);
        ccr.setDragByRoiLabel(true);
        this.copyObject(ccr);
        return ccr;
    }

    protected void copyObject(Object o) {
        CvPolygonRoi pr = (CvPolygonRoi)o;
        super.copyObject(pr);
        pr.closed = this.closed;
        pr.doHandles = this.doHandles;
        pr.idealMetrics = this.idealMetrics;
    }

    private void setPolyHandlesVisible(boolean isVisible) {
        int nHandles = this.getNumHandles();
        for (int i = 0; i < nHandles; ++i) {
            XpHandle handle = this.get(i);
            handle.setVisible(isVisible);
        }
        this.syncModel();
    }

    public double getArea() {
        if (!this.idealMetrics) {
            return super.getArea();
        }
        XpImage img = this.getImage();
        if (img instanceof XpDicomObject && 0 != ((XpDicomObject)((Object)img)).getValue(new XpDicomElement(32, 50))) {
            this.cornerPointAvailable = false;
        }
        double pdx = img != null ? img.getPixelDimensionX() : 1.0;
        double pdy = img != null ? img.getPixelDimensionY() : 1.0;
        double sum = this.area(this.points);
        return sum * pdx * pdy;
    }

    public double getLength() {
        if (!this.idealMetrics) {
            return super.getLength();
        }
        XpImage img = this.getImage();
        int size = this.points.size();
        double len = 0.0;
        if (img != null) {
            if (img instanceof XpDicomObject && 0 != ((XpDicomObject)((Object)img)).getValue(new XpDicomElement(32, 50))) {
                this.cornerPointAvailable = false;
            }
            double pdx = img.getPixelDimensionX();
            double pdy = img.getPixelDimensionY();
            for (int i = 1; i < size; ++i) {
                Point2D p1 = (Point2D)this.points.get(i);
                Point2D p0 = (Point2D)this.points.get(i - 1);
                double x1 = p1.getX() * pdx;
                double y1 = p1.getY() * pdy;
                double x0 = p0.getX() * pdx;
                double y0 = p0.getY() * pdy;
                double dx = x1 - x0;
                double dy = y1 - y0;
                double l = Math.sqrt(dx * dx + dy * dy);
                len += l;
            }
        }
        return len;
    }

    public final String createRoiStatLabel(XpPixelStatistics ps) {
        if (ps == null) {
            return "";
        }
        double angle = Math.toDegrees(this.getLineAngle());
        double distance = this.getLength();
        double area = 0.0;
        double mean = 0.0;
        double variance = 0.0;
        double stddev = 0.0;
        if (this.closed) {
            area = this.getArea();
            mean = ps.getMean();
            variance = ps.getVariance();
            stddev = Math.sqrt(variance);
        }
        int noOfPts = this.points.size();
        String roiStat = this.getRoiLabel();
        this.setRoiStatProperties();
        if (noOfPts == 2) {
            roiStat = roiStat + DISTANCE_PREFIX + " " + dfe.format(distance) + DISTANCE_SUFFIX + " " + ANGLE_PREFIX + " " + dfe.format(angle) + DEG_SYMBOL + ANGLE_SUFFIX;
        } else if (noOfPts == 3) {
            roiStat = !this.closed ? roiStat + ANGLE_PREFIX + " " + dfe.format(angle) + DEG_SYMBOL + ANGLE_SUFFIX : roiStat + MEAN_PREFIX + " " + dfe.format(mean) + ", " + SD_PREFIX + " " + dfe.format(stddev) + ", " + AREA_PREFIX + " " + dfe.format(area) + AREA_SUFFIX;
        } else if (noOfPts > 3) {
            roiStat = !this.closed ? roiStat + DISTANCE_PREFIX + " " + dfe.format(distance) + DISTANCE_SUFFIX : roiStat + MEAN_PREFIX + " " + dfe.format(mean) + ", " + SD_PREFIX + " " + dfe.format(stddev) + ", " + AREA_PREFIX + " " + dfe.format(area) + " " + AREA_SUFFIX;
        }
        return roiStat;
    }

    private void setRoiStatProperties() {
        XpMedicalImage img = (XpMedicalImage)this.getImage();
        String modality = "";
        if (img instanceof XpDicomObject) {
            XpDicomElement el = new XpDicomElement(8, 96);
            img.getValue(el);
            if (el.getStringValue() != null) {
                modality = el.getStringValue();
            }
        }
        DISTANCE_SUFFIX = CvPropertiesManager.getProperty("cvf.roi.distance.suffix." + modality.toLowerCase(), "mm");
        AREA_SUFFIX = CvPropertiesManager.getProperty("cvf.roi.area.suffix." + modality.toLowerCase(), "mm2");
        ANGLE_SUFFIX = CvPropertiesManager.getProperty("cvf.roi.angle.suffix." + modality.toLowerCase(), "");
        DISTANCE_PREFIX = CvPropertiesManager.getProperty("cvf.roi.distance.prefix." + modality.toLowerCase(), ": distance");
        MEAN_PREFIX = CvPropertiesManager.getProperty("cvf.roi.mean.prefix." + modality.toLowerCase(), ": m");
        AREA_PREFIX = CvPropertiesManager.getProperty("cvf.roi.area.prefix." + modality.toLowerCase(), "a");
        SD_PREFIX = CvPropertiesManager.getProperty("cvf.roi.sd.prefix." + modality.toLowerCase(), "sd");
        ANGLE_PREFIX = CvPropertiesManager.getProperty("cvf.roi.angle.prefix." + modality.toLowerCase(), ": angle");
    }

    public final void render(XpVisualComponent vc, Graphics2D g) {
        super.render(vc, g);
        int leftHandleIndex = 1;
        double minX = 2.147483647E9;
        for (int i = 0; i < this.points.size(); ++i) {
            double X = ((Point2D)this.points.get(i)).getX();
            if (!(minX > X)) continue;
            minX = X;
            leftHandleIndex = i + 1;
        }
        if (this.doHandles) {
            this.drawRoiId(vc, g, this.get(leftHandleIndex));
        } else {
            this.drawRoiId(vc, g, null);
        }
        if (this.showDrawing && !this.closed) {
            Color saveColor = g.getColor();
            g.setColor(XpAppContext.getUnSelectedColor());
            int nop = this.getNumPoints();
            Point2D.Double disPt = new Point2D.Double();
            this.getDisplayPoint(this.getPoint(nop - 1).getX(), this.getPoint(nop - 1).getY(), disPt);
            g.drawLine((int)((Point2D)disPt).getX(), (int)((Point2D)disPt).getY(), this.mousePtx, this.mousePty);
            g.setColor(saveColor);
        }
    }

    protected void drawRoiId(XpVisualComponent vc, Graphics2D g, XpHandle h) {
        double sy;
        double sx;
        Point2D.Double tmpPoint1 = new Point2D.Double();
        if (h != null) {
            h.getDisplayLocation(vc, tmpPoint1);
            sx = ((Point2D)tmpPoint1).getX() - 10.0;
            sy = ((Point2D)tmpPoint1).getY() - 5.0;
        } else {
            Point2D.Double disPt = new Point2D.Double();
            this.getDisplayPoint(this.getPoint(0).getX(), this.getPoint(0).getY(), disPt);
            sx = ((Point2D)disPt).getX();
            sy = ((Point2D)disPt).getY();
        }
        this.drawRoiId(g, sx, sy);
    }

    protected void drawRoiId(Graphics2D g, double x, double y) {
        Color c = g.getColor();
        g.setColor(ROILABEL_COLOR);
        super.drawRoiId(g, x, y);
        g.setColor(c);
    }

    public boolean containsROI(XpVisualComponent vc, int x, int y) {
        Rectangle2D bounds;
        if (this.isDragByRoiLabel() && (bounds = this.getRoiLabelBounds()) != null && bounds.contains(x, y)) {
            return true;
        }
        this.getImagePoint(x, y, this.containsTemp);
        double xx = this.containsTemp.getX();
        double yy = this.containsTemp.getY();
        if (xx > this.minX - 2.5 && xx < this.maxX + 2.5 && yy > this.minY - 2.5 && yy < this.maxY + 2.5) {
            Point2D first;
            Point2D prev = first = (Point2D)this.approxPts.get(0);
            Point2D.Double prevDpt = new Point2D.Double();
            this.getDisplayPoint(prev, prevDpt);
            int len = this.approxPts.size();
            for (int i = 1; i < len; ++i) {
                Point2D p = (Point2D)this.approxPts.get(i);
                Point2D.Double tmp = new Point2D.Double();
                this.getDisplayPoint(p, tmp);
                if (XpGeomUtils.containsCoord(x, y, prevDpt, tmp, LINE_SENSITIVITY)) {
                    return true;
                }
                prevDpt = tmp;
            }
            if (this.closed) {
                Point2D.Double firstDpt = new Point2D.Double();
                this.getDisplayPoint(first, firstDpt);
                if (XpGeomUtils.containsCoord(x, y, prevDpt, firstDpt, LINE_SENSITIVITY)) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public final void setClosed(boolean closed) {
        this.closed = closed;
        if (closed) {
            this.setCalcPixelStats(true);
        }
    }

    public void roiPressed(MouseEvent e) {
        super.roiPressed(e);
        if (this.closed && e.getButton() == 3) {
            Point2D.Float displayPoint = new Point2D.Float();
            Point2D.Double insertPoint = new Point2D.Double();
            displayPoint.setLocation(e.getX(), e.getY());
            this.getImagePoint(displayPoint, insertPoint);
            Point2D.Double p = new Point2D.Double();
            p.setLocation(((Point2D)insertPoint).getX(), ((Point2D)insertPoint).getY());
            int i = this.calculatePointOnPolygon(p);
            this.addPoint(i + 1, p);
            this.generateModelPolygon();
        }
    }

    private int calculatePointOnPolygon(Point2D insertPoint) {
        double min = 2.147483647E9;
        int minIndex = 0;
        for (int i = 0; i < this.getNumPoints(); ++i) {
            double seagmentDistance = i + 1 < this.getNumPoints() ? this.util.distPointToSegment(insertPoint, (Point2D)this.points.get(i), (Point2D)this.points.get(i + 1)) : this.util.distPointToSegment(insertPoint, (Point2D)this.points.get(i), (Point2D)this.points.get(0));
            if (!(seagmentDistance < min)) continue;
            min = seagmentDistance;
            minIndex = i;
        }
        return minIndex;
    }

    public void anchorPressed(MouseEvent me, Object jc) {
        super.anchorPressed(me, jc);
        if (this.closed) {
            if (me.getButton() == 3 && this.points.size() >= 4) {
                XpHandle xph = (XpHandle)jc;
                int hIdx = xph.getAnchorPointIndex();
                this.points.remove(hIdx - 1);
                this.approxPts.remove(hIdx - 1);
                this.remove(this.get(this.getNumHandles() - 1));
                this.syncModel();
            }
            this.setPolyHandlesVisible(true);
        }
    }

    public void anchorReleased(MouseEvent me, Object jc) {
        super.anchorReleased(me, jc);
        if (this.closed) {
            this.setPolyHandlesVisible(true);
        }
    }

    public void anchorDragged(MouseEvent me, CPoint drag, Object jc) {
        super.anchorDragged(me, drag, jc);
        int modifiers = me.getModifiers();
        int mbutton1 = modifiers & 0x10;
        XpHandle xph = (XpHandle)jc;
        int handleIdx = xph.getAnchorPointIndex();
        if (mbutton1 != 0) {
            int width = this.getImage().getSlice().width;
            int height = this.getImage().getSlice().height;
            if (handleIdx == MOVE_HANDLE_IDX) {
                Point2D p;
                int i;
                boolean validPoint = true;
                int len = this.points.size();
                for (i = 0; i < len; ++i) {
                    p = (Point2D)this.points.get(i);
                    Point2D ap = (Point2D)p.clone();
                    ap.setLocation(ap.getX() + drag.x, ap.getY() + drag.y);
                    double x = ap.getX();
                    double y = ap.getY();
                    if (x < 0.0 || x >= (double)width) {
                        validPoint = false;
                    }
                    if (!(y < 0.0) && !(y >= (double)height)) continue;
                    validPoint = false;
                }
                if (validPoint) {
                    for (i = 0; i < len; ++i) {
                        p = (Point2D)this.points.get(i);
                        p.setLocation(p.getX() + drag.x, p.getY() + drag.y);
                    }
                }
            } else {
                Point2D p = (Point2D)this.points.get(handleIdx - 1);
                Point2D ap = (Point2D)p.clone();
                ap.setLocation(ap.getX() + drag.x, ap.getY() + drag.y);
                double x = ap.getX();
                double y = ap.getY();
                if (x < 0.0 || x >= (double)width) {
                    x = p.getX();
                }
                if (y < 0.0 || y >= (double)height) {
                    y = p.getY();
                }
                p.setLocation(x, y);
            }
            this.syncModel();
        }
    }

    private void showDrawing(int x, int y) {
        if (SHOW_DRAWING) {
            this.showDrawing = true;
        }
        this.mousePtx = x;
        this.mousePty = y;
        this.sync();
    }

    public final void dragMouse(CPoint drag) {
        this.translate(drag.x, drag.y);
        this.syncModel();
    }

    private void translate(double tx, double ty) {
        Point2D p;
        int i;
        int width = this.getImage().getSlice().width;
        int height = this.getImage().getSlice().height;
        int len = this.points.size();
        for (i = 0; i < len; ++i) {
            p = (Point2D)this.points.get(i);
            Point2D ap = (Point2D)p.clone();
            ap.setLocation(ap.getX() + tx, ap.getY() + ty);
            double x = ap.getX();
            double y = ap.getY();
            if (x < 0.0 || x >= (double)width) {
                return;
            }
            if (!(y < 0.0) && !(y >= (double)height)) continue;
            return;
        }
        for (i = 0; i < len; ++i) {
            p = (Point2D)this.points.get(i);
            p.setLocation(p.getX() + tx, p.getY() + ty);
        }
    }

    public boolean isValid(Point2D p) {
        int noPts = this.getNumPoints();
        if (noPts > 2) {
            int x1 = (int)p.getX();
            int y1 = (int)p.getY();
            int x2 = (int)this.getPoint(noPts - 1).getX();
            int y2 = (int)this.getPoint(noPts - 1).getY();
            for (int i = 0; i < noPts - 2; ++i) {
                int y4;
                int x4;
                int y3;
                Point2D pt1 = this.getPoint(i);
                Point2D pt2 = this.getPoint(i + 1);
                int x3 = (int)pt1.getX();
                if (!XpGeomUtils.intersects(x1, y1, x2, y2, x3, y3 = (int)pt1.getY(), x4 = (int)pt2.getX(), y4 = (int)pt2.getY())) continue;
                return false;
            }
        }
        return true;
    }

    public GSPSGraphic gspsDescription() {
        int len = this.points.size();
        Point2D[] pts = new Point2D[len];
        for (int i = 0; i < len; ++i) {
            Point2D p = (Point2D)this.points.get(i);
            pts[i] = new Point2D.Double(p.getX(), p.getY());
        }
        XpRoiHandleContainer.GraphicDescriptor description = this.isClosed() ? new XpRoiHandleContainer.GraphicDescriptor("POLYLINE", pts, true) : new XpRoiHandleContainer.GraphicDescriptor("POLYLINE", pts, false);
        return description;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int i;
        s.defaultWriteObject();
        if (this.points != null && this.points.size() > 0) {
            s.writeInt(this.points.size());
            for (i = 0; i < this.points.size(); ++i) {
                s.writeDouble(((Point2D.Double)this.points.get(i)).getX());
                s.writeDouble(((Point2D.Double)this.points.get(i)).getY());
            }
        }
        s.writeInt(this.approxPts.size());
        for (i = 0; i < this.approxPts.size(); ++i) {
            s.writeDouble(((Point2D.Double)this.approxPts.get(i)).getX());
            s.writeDouble(((Point2D.Double)this.approxPts.get(i)).getY());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException {
        try {
            int i;
            s.defaultReadObject();
            int size = s.readInt();
            ArrayList ds_points = new ArrayList();
            ArrayList<Point2D.Double> ds_approxPts = new ArrayList<Point2D.Double>();
            ArrayList ds_txpoints = new ArrayList();
            Point2D[] pts = new Point2D[size];
            for (i = 0; i < size; ++i) {
                double x = s.readDouble();
                double y = s.readDouble();
                pts[i] = new Point2D.Double(x, y);
            }
            size = s.readInt();
            for (i = 0; i < size; ++i) {
                ds_approxPts.add(new Point2D.Double(s.readDouble(), s.readDouble()));
            }
            this.points = ds_points;
            this.approxPts = ds_approxPts;
            this.drawPolygon = new GeneralPath();
            this.containsTemp = new Point2D.Double();
            this.setRoiShapeModel(new RoiShapeModel(new GeneralPath()));
            this.init(pts, true, true);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static ComponentCreator getLineComponentCreator() {
        return new RoiCreator(2);
    }

    public static ComponentCreator getAngleComponentCreator() {
        return new RoiCreator(3);
    }

    public static ComponentCreator getComponentCreator() {
        return new RoiCreator(0);
    }

    static /* synthetic */ void access$000(CvPolygonRoi x0) {
        x0.generateDrawPolygon();
    }

    static /* synthetic */ void access$100(CvPolygonRoi x0, int x1, int x2) {
        x0.showDrawing(x1, x2);
    }

    static /* synthetic */ boolean access$202(CvPolygonRoi x0, boolean x1) {
        x0.closed = x1;
        return x0.closed;
    }

    static /* synthetic */ void access$300(CvPolygonRoi x0, boolean x1) {
        x0.setPolyHandlesVisible(x1);
    }

    static {
        CvPolygonRoi.setPolygonRoiProperties();
        XpHandle.setHandleColor(HANDLE_COLOR);
        XpAppContext.setSelectedColor(SELECTED_COLOR);
        XpAppContext.setUnSelectedColor(UNSELECTED_COLOR);
        XpAppContext.setShadowed(true);
    }
}

