/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.ui;

import com.ge.med.cse.cvf.cpanels.XpCinePanel;
import com.ge.med.cse.cvf.cpanels.XpFilmPanel;
import com.ge.med.cse.cvf.cpanels.XpROIStatisticsPanel;
import com.ge.med.cse.cvf.cpanels.XpTextPagePanel;
import com.ge.med.cse.cvf.crossref.XpReferenceImageApp;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.ptk.PtkBorderFactory;
import com.ge.med.ptk.laf.CuiTabbedPaneUI;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.xpv.autoControls.XPwPalletteComboControl;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPcaPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.base.XpSelector;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeListener;

public class CVFSelector
extends XpSelector
implements PropertyChangeListener {
    private static final String LAST_SELECTED_ITEM = "LAST_SELECTED_ITEM";
    public static final String SEPARATOR = ".";
    public static final String COUNT_PROPERTY = "count";
    public static final String DEFAULT = "default";
    private static final Logger logger = Logger.getLogger(CVFSelector.class.getName());
    String[] applicationTabs;
    JComponent[] applicationTabbedPane;
    Properties prop_;
    HashMap<String, JComponent[]> buttonPanelsMap = new HashMap();
    HashMap panelToggleMap = new HashMap();
    ResourceBundle resBundle = CvUtils.getResourceBundle();
    private List<PlasmaControl> plasmaControls_ = new Vector<PlasmaControl>();
    private HashMap<String, Object> allControls = new HashMap();
    JPanel dummy = new JPanel();
    private XPcaPanel[] ctlPanels_;
    AbstractButton selected;
    ButtonGroup[] bg = null;
    Vector<ActionListener> listeners = new Vector();
    Map<String, XPcaPanel> controlPanelMap = new HashMap<String, XPcaPanel>();
    protected String currentApp = null;
    protected Border panelBorder;
    protected Border buttonBorder = PtkBorderFactory.createButtonBorder(false, false, false, false);
    protected static final String BUTTON_GROUP = "btngrp";
    private XPscreen screen = null;
    protected HashMap<String, Object> panelMap = new HashMap();
    CardLayout applicationTabCards = new CardLayout();
    int count = 0;
    ActionListener al = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            String selectedName = ((AbstractButton)e.getSource()).getName();
            if (e.getSource() instanceof JButton) {
                CVFSelector.this.saveSelectedItem(null);
                CVFSelector.this.setSelectedItem(null);
            } else {
                CVFSelector.this.saveSelectedItem(selectedName);
            }
            CVFSelector.this.fireActionListener(e);
        }
    };
    boolean isColorSet = false;

    public CVFSelector() {
        this((XPcaPanel[])null);
    }

    public CVFSelector(XPcaPanel[] ctlPanels) {
        this.ctlPanels_ = ctlPanels;
        this.setLayout(this.applicationTabCards);
        this.add((Component)this.dummy, "");
    }

    public void setProperties(Properties prop) {
        if (prop.getProperty("PanelBorder") != null) {
            try {
                this.panelBorder = (Border)Class.forName(prop.getProperty("PanelBorder").trim()).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (prop.getProperty("ButtonBorder") != null) {
            try {
                this.buttonBorder = (Border)Class.forName(prop.getProperty("PanelBorder").trim()).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        HashMap<String, XPcaPanel> ctlPanelHash = new HashMap<String, XPcaPanel>();
        if (this.ctlPanels_ != null) {
            int len = this.ctlPanels_.length;
            for (int i = 0; i < len; ++i) {
                if (this.ctlPanels_[i] == null || this.ctlPanels_[i].getClass().getName().contains("DummyXpcaPanel")) continue;
                ctlPanelHash.put(this.ctlPanels_[i].getClass().getName(), this.ctlPanels_[i]);
            }
        }
        this.prop_ = prop;
        String appsString = prop.getProperty("apps");
        this.applicationTabs = appsString.split("\\s*,\\s*");
        this.applicationTabbedPane = new JComponent[this.applicationTabs.length];
        for (int applicationIndex = 0; applicationIndex < this.applicationTabs.length; ++applicationIndex) {
            int numTabs = Integer.parseInt(prop.getProperty(this.applicationTabs[applicationIndex] + SEPARATOR + COUNT_PROPERTY));
            this.bg = new ButtonGroup[numTabs];
            for (int i = 0; i < this.bg.length; ++i) {
                this.bg[i] = new ButtonGroup();
            }
            if (numTabs > 1) {
                String[] selectedPanelforRespectiveTab = new String[numTabs];
                for (int i = 0; i < numTabs; ++i) {
                    selectedPanelforRespectiveTab[i] = prop.getProperty(appsString + SEPARATOR + String.valueOf(i) + SEPARATOR + DEFAULT);
                }
                this.applicationTabbedPane[applicationIndex] = new JTabbedPane();
                this.applicationTabbedPane[applicationIndex].setBackground(UIManager.getColor("P9"));
                this.applicationTabbedPane[applicationIndex].putClientProperty(LAST_SELECTED_ITEM, selectedPanelforRespectiveTab);
                this.applicationTabbedPane[applicationIndex].putClientProperty(BUTTON_GROUP, this.bg);
                ((JTabbedPane)this.applicationTabbedPane[applicationIndex]).setUI(new BorderLessTabUI());
                System.err.println("app " + applicationIndex + "uses tabbed pane");
            } else {
                this.applicationTabbedPane[applicationIndex] = new JPanel(new BorderLayout());
                this.applicationTabbedPane[applicationIndex].putClientProperty(BUTTON_GROUP, this.bg);
                System.err.println("app " + applicationIndex + "uses single panel");
            }
            this.add((Component)this.applicationTabbedPane[applicationIndex], this.applicationTabs[applicationIndex]);
            this.setBackground(UIManager.getColor("P10"));
            this.applicationTabbedPane[applicationIndex].setBackground(null);
            this.applicationTabbedPane[applicationIndex].setOpaque(false);
            JPanel[] buttonPanels = new JPanel[numTabs];
            this.buttonPanelsMap.put(this.applicationTabs[applicationIndex], buttonPanels);
            for (int tabIndex = 0; tabIndex < numTabs; ++tabIndex) {
                String buttonDimString = prop.getProperty(this.applicationTabs[applicationIndex] + SEPARATOR + tabIndex + SEPARATOR + "dimension");
                String[] dims = buttonDimString.trim().split("\\s*x\\s*");
                int dx = Integer.parseInt(dims[0]);
                int dy = Integer.parseInt(dims[1]);
                buttonPanels[tabIndex] = new JPanel(new GridLayout(dy, dx));
                buttonPanels[tabIndex].setBorder(BorderFactory.createEmptyBorder());
                JPanel p = new JPanel(new BorderLayout());
                p.setBackground(null);
                buttonPanels[tabIndex].setBackground(null);
                p.add((Component)buttonPanels[tabIndex], "North");
                if (numTabs > 1) {
                    String orig;
                    JTabbedPane tp = (JTabbedPane)this.applicationTabbedPane[applicationIndex];
                    String strkey = this.applicationTabs[applicationIndex] + SEPARATOR + tabIndex + SEPARATOR + "name";
                    String translated = orig = prop.getProperty(strkey);
                    try {
                        translated = this.resBundle.getString(orig);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    tp.addTab(translated, p);
                    tp.setForegroundAt(tabIndex, UIManager.getColor("P5"));
                    tp.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
                } else {
                    this.applicationTabbedPane[applicationIndex].add(p);
                }
                for (int row = 0; row < dy; ++row) {
                    for (int col = 0; col < dx; ++col) {
                        String prefix = this.applicationTabs[applicationIndex] + SEPARATOR + tabIndex + SEPARATOR + col + SEPARATOR + row;
                        String cellCountString = prop.getProperty(prefix + SEPARATOR + COUNT_PROPERTY);
                        if (cellCountString != null) {
                            int cellCount = Integer.parseInt(cellCountString.trim());
                            Action[] actions = new Action[cellCount];
                            for (int itemIndex = 0; itemIndex < cellCount; ++itemIndex) {
                                String cellComponentString = prop.getProperty(prefix + SEPARATOR + itemIndex);
                                try {
                                    AbstractButton b2;
                                    Object o = Class.forName(cellComponentString).newInstance();
                                    if (o instanceof AbstractAction) {
                                        actions[itemIndex] = (Action)o;
                                        if (o instanceof PlasmaControl) {
                                            this.plasmaControls_.add((PlasmaControl)o);
                                        }
                                    } else if (o instanceof AbstractButton && (b2 = (AbstractButton)o).getAction() != null) {
                                        actions[itemIndex] = b2.getAction();
                                    }
                                    this.allControls.put(cellComponentString, o);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                if (actions[itemIndex] != null) continue;
                                actions[itemIndex] = new /* Unavailable Anonymous Inner Class!! */;
                            }
                            String clsName = prop.getProperty("PalleteCombo");
                            if (clsName == null) {
                                buttonPanels[tabIndex].add(new XPwPalletteComboControl(actions));
                                continue;
                            }
                            try {
                                Constructor<?> constr = Class.forName(clsName).getConstructor(Action[].class);
                                if (constr == null) continue;
                                JComponent toAdd = (JComponent)constr.newInstance(new Object[]{actions});
                                toAdd.setBorder(this.buttonBorder);
                                toAdd.addPropertyChangeListener("ClearPanel", new PropertyChangeListener(){

                                    public void propertyChange(PropertyChangeEvent evt) {
                                        CVFSelector.this.setSelectedItem(null);
                                    }
                                });
                                if (toAdd instanceof AbstractButton) {
                                    ((AbstractButton)toAdd).addActionListener(this.al);
                                }
                                buttonPanels[tabIndex].add(toAdd);
                            }
                            catch (Exception e) {
                                buttonPanels[tabIndex].add(new XPwPalletteComboControl(actions));
                                e.printStackTrace();
                            }
                            continue;
                        }
                        String componentString = prop.getProperty(prefix);
                        if (componentString != null) {
                            try {
                                ArrayList<Object> buttonList;
                                AbstractButton b3;
                                Object o;
                                Object pp = ctlPanelHash.get(componentString);
                                Object object = o = pp != null ? pp : Class.forName(componentString.trim()).newInstance();
                                if (o instanceof AbstractAction) {
                                    b3 = null;
                                    if (prop.getProperty(prefix + ".component") != null) {
                                        String compName = prop.getProperty((prefix + ".component").trim());
                                        Class<?> compClsass = Class.forName(compName.trim());
                                        Constructor<?> ctor = compClsass.getConstructor(Action.class);
                                        b3 = (AbstractButton)ctor.newInstance(o);
                                        b3.setName(o.getClass().getName().trim());
                                    } else {
                                        b3 = new JButton((Action)o){

                                            public Color getBackground() {
                                                return UIManager.getColor("P8");
                                            }

                                            public Color getForeground() {
                                                return UIManager.getColor("P8");
                                            }
                                        };
                                        b3.setName(o.getClass().getName().trim());
                                        b3.putClientProperty("hideActionText", Boolean.TRUE);
                                    }
                                    if (o instanceof PlasmaControl) {
                                        this.plasmaControls_.add((PlasmaControl)o);
                                    }
                                    b3.setText("");
                                    b3.setBorder(this.buttonBorder);
                                    b3.setFocusable(false);
                                    b3.setMargin(new Insets(0, 0, 0, 0));
                                    b3.addActionListener(this.al);
                                    buttonPanels[tabIndex].add(b3);
                                    this.allControls.put(componentString, o);
                                    this.panelToggleMap.put(componentString, b3);
                                    continue;
                                }
                                if (o instanceof AbstractButton) {
                                    b3 = (AbstractButton)o;
                                    if (o instanceof PlasmaControl) {
                                        this.plasmaControls_.add((PlasmaControl)o);
                                    }
                                    b3.setBorder(this.buttonBorder);
                                    b3.setFocusable(false);
                                    b3.setMargin(new Insets(0, 0, 0, 0));
                                    b3.setName(b3.getClass().getName());
                                    buttonPanels[tabIndex].add(b3);
                                    b3.setBackground(UIManager.getColor("P8"));
                                    this.allControls.put(componentString, o);
                                    b3.addActionListener(this.al);
                                    this.panelToggleMap.put(componentString, b3);
                                    continue;
                                }
                                if (!(o instanceof XPcaPanel)) continue;
                                XPcaPanel cap = (XPcaPanel)o;
                                Icon ico = cap.getIcon();
                                String text = cap.getName();
                                JToggleButton trigger = null;
                                trigger = ico != null ? new JToggleButton(cap.getIcon()) : new JToggleButton(text);
                                trigger.setName(componentString);
                                this.panelMap.put(componentString, o);
                                trigger.setBorder(this.buttonBorder);
                                trigger.setFocusable(false);
                                trigger.setMargin(new Insets(0, 0, 0, 0));
                                buttonPanels[tabIndex].add(trigger);
                                trigger.setBackground(UIManager.getColor("P8"));
                                this.bg[tabIndex].add(trigger);
                                this.allControls.put(componentString, trigger);
                                Object value = this.panelToggleMap.get(componentString);
                                if (value == null) {
                                    this.panelToggleMap.put(componentString, trigger);
                                    continue;
                                }
                                if (value instanceof JToggleButton) {
                                    buttonList = new ArrayList<Object>();
                                    buttonList.add(value);
                                    buttonList.add(trigger);
                                    this.panelToggleMap.put(componentString, buttonList);
                                    continue;
                                }
                                buttonList = (ArrayList<Object>)value;
                                buttonList.add(trigger);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                JLabel l = new JLabel();
                                l.setBorder(BorderFactory.createLineBorder(Color.GRAY));
                                buttonPanels[tabIndex].add(l);
                            }
                            continue;
                        }
                        JLabel l = new JLabel();
                        buttonPanels[tabIndex].add(l);
                    }
                }
            }
        }
    }

    public String getSelectedItem() {
        String toReturn = null;
        for (int i = 0; i < this.applicationTabbedPane.length; ++i) {
            if (!this.applicationTabbedPane[i].isVisible()) continue;
            if (this.applicationTabbedPane[i] instanceof JTabbedPane) {
                int selectedIndex = ((JTabbedPane)this.applicationTabbedPane[i]).getSelectedIndex();
                toReturn = ((String[])this.applicationTabbedPane[i].getClientProperty(LAST_SELECTED_ITEM))[selectedIndex];
                break;
            }
            toReturn = (String)this.applicationTabbedPane[i].getClientProperty(LAST_SELECTED_ITEM);
        }
        if (toReturn == null || toReturn.equalsIgnoreCase("null")) {
            return DummyXpcaPanel.class.getName();
        }
        return toReturn;
    }

    private void saveSelectedItem(String selected) {
        for (int i = 0; i < this.applicationTabbedPane.length; ++i) {
            if (!this.applicationTabbedPane[i].isVisible()) continue;
            if (this.applicationTabbedPane[i] instanceof JTabbedPane) {
                int selectedIndex = ((JTabbedPane)this.applicationTabbedPane[i]).getSelectedIndex();
                String[] stored = (String[])this.applicationTabbedPane[i].getClientProperty(LAST_SELECTED_ITEM);
                stored[selectedIndex] = selected;
                this.applicationTabbedPane[i].putClientProperty(LAST_SELECTED_ITEM, stored);
                continue;
            }
            this.applicationTabbedPane[i].putClientProperty(LAST_SELECTED_ITEM, selected);
        }
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.remove(l);
    }

    protected void fireActionListener(ActionEvent ev) {
        for (ActionListener a : this.listeners) {
            try {
                a.actionPerformed(ev);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setSelectedItem(String componentName) {
        Object o = this.panelToggleMap.get(componentName);
        if (o != null) {
            this.performSelection(o instanceof List ? (AbstractButton)((List)o).get(0) : (AbstractButton)o);
        } else {
            for (int i = 0; i < this.applicationTabbedPane.length; ++i) {
                if (this.applicationTabbedPane[i].isVisible()) {
                    if (!(this.applicationTabbedPane[i] instanceof JTabbedPane)) continue;
                    int selectedIndex = ((JTabbedPane)this.applicationTabbedPane[i]).getSelectedIndex();
                    String[] current = (String[])this.applicationTabbedPane[i].getClientProperty(LAST_SELECTED_ITEM);
                    current[selectedIndex] = null;
                    this.applicationTabbedPane[i].putClientProperty(LAST_SELECTED_ITEM, current);
                    final ButtonGroup bg = ((ButtonGroup[])this.applicationTabbedPane[i].getClientProperty(BUTTON_GROUP))[selectedIndex];
                    if (bg == null || bg.getSelection() == null) continue;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JToggleButton but = new JToggleButton();
                            bg.add(but);
                            but.setSelected(true);
                            but.remove(but);
                        }
                    });
                    continue;
                }
                this.applicationTabbedPane[i].putClientProperty(LAST_SELECTED_ITEM, "null");
                ButtonGroup bg = (ButtonGroup)this.applicationTabbedPane[i].getClientProperty(BUTTON_GROUP);
                if (bg == null || bg.getSelection() == null) continue;
                bg.getSelection().setSelected(false);
            }
            this.fireActionListener(new ActionEvent(this, 121, "ShowNoPanel"));
        }
    }

    private void performSelection(AbstractButton button) {
        if (button == null) {
            return;
        }
        JTabbedPane pane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, button);
        if (pane != null) {
            Container toSelect;
            for (toSelect = button; toSelect != null && !(toSelect.getParent() instanceof JTabbedPane); toSelect = toSelect.getParent()) {
            }
            if (toSelect != null) {
                pane.setSelectedComponent(toSelect);
            }
        }
        if (button.isEnabled()) {
            button.doClick();
        } else {
            button.setEnabled(true);
            button.doClick();
            button.setEnabled(false);
        }
    }

    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ((JComponent)CVFSelector.this.getParent()).setBorder(null);
                    ((JComponent)CVFSelector.this.getParent().getParent()).setBorder(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void addElement(XPcaPanel pan, String name, Icon icon, String desc) {
        if (!this.isColorSet) {
            pan.addAncestorListener((AncestorListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.updateBackground(pan, UIManager.getColor("P9"));
        if (this.panelBorder == null && !pan.getTitle().equalsIgnoreCase("NoName")) {
            pan.setBorder(BorderFactory.createTitledBorder(pan.getTitle()));
        } else {
            pan.setBorder(this.panelBorder);
        }
        if (pan.getClass().getName().contains("DummyXpcaPanel")) {
            return;
        }
        this.controlPanelMap.put(pan.getClass().getName(), pan);
        String componentName = pan.getClass().getName();
        Object o = this.panelToggleMap.get(pan.getClass().getName());
        if (o != null) {
            if (o instanceof List) {
                for (AbstractButton element : (List)o) {
                    element.setName(componentName);
                    element.addActionListener(this.al);
                }
            } else {
                ((AbstractButton)o).setName(componentName);
                ((AbstractButton)o).addActionListener(this.al);
                ((AbstractButton)o).setToolTipText(name);
            }
        } else {
            System.err.println("fail to find button for " + componentName);
        }
    }

    private void updateBackground(JPanel pan, Color c) {
        pan.setBackground(c);
        Component[] children = pan.getComponents();
        for (int i = 0; children != null && i < children.length; ++i) {
            if (children[i] instanceof JPanel) {
                this.updateBackground((JPanel)children[i], c);
                continue;
            }
            if (!(children[i] instanceof JSlider)) continue;
            children[i].setBackground(c);
        }
    }

    public void setSelectedApplication(String appName) {
        boolean found = false;
        for (int i = 0; i < this.applicationTabs.length; ++i) {
            if (!this.applicationTabs[i].equals(appName)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Applicaiton " + appName + " not defined.");
        }
        this.applicationTabCards.show(this, appName);
        this.currentApp = appName;
        String componentName = this.prop_.getProperty(appName + ".default");
        String prevUserSelected = this.getSelectedItem();
        String toSelect = componentName != null ? prevUserSelected : componentName;
        this.setSelectedItem(toSelect);
    }

    public void setScreen(XPscreen screen) {
        if (screen != null) {
            String[] propsToAdd;
            this.screen = screen;
            for (String propertyName : propsToAdd = CvPropertiesManager.getProperty("Selector.Modes", "").split(",")) {
                screen.removePropertyChangeListener(propertyName, this);
                screen.addPropertyChangeListener(propertyName, this);
            }
            for (PlasmaControl control : this.plasmaControls_) {
                control.setCapable(screen);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String[] pnls;
        if ("reference_viewport".equals(evt.getPropertyName()) && "false".equals(evt.getNewValue().toString().trim()) && this.screen != null && this.screen.getNumComponents() > 1) {
            for (int i = 0; i < this.screen.getNumComponents(); ++i) {
                if (!(this.screen.getComponent(i) instanceof XpViewport) || XpReferenceImageApp.getRefPortCount((XpViewport)this.screen.getComponent(i)) <= 0) continue;
                return;
            }
        }
        if ((pnls = CvPropertiesManager.getProperty(evt.getPropertyName().trim() + SEPARATOR + evt.getNewValue().toString().trim()).split(",")).length == 1 && (pnls[0].equalsIgnoreCase("all") || pnls[0].equalsIgnoreCase("none"))) {
            this.setEnableAllControls(pnls[0].equalsIgnoreCase("all"));
        } else {
            this.setEnableAllControls(false);
            for (int i = 0; i < pnls.length; ++i) {
                Object tmpObj = this.allControls.get(pnls[i]);
                if (this.screen != null && tmpObj == null && (tmpObj = this.screen.getActionMap().get(pnls[i])) == null && this.screen.getActionMap() != null && this.screen.getActionMap().allKeys() != null) {
                    for (int j = 0; j < this.screen.getActionMap().allKeys().length; ++j) {
                        Action action = this.screen.getActionMap().get(this.screen.getActionMap().allKeys()[j]);
                        if (!pnls[i].equalsIgnoreCase(String.valueOf(action).split("@")[0])) continue;
                        String strActionName = action.getValue("Name") != null ? action.getValue("Name").toString() : action.getClass().getName();
                        tmpObj = this.screen.getActionMap().get(strActionName);
                    }
                }
                if (tmpObj instanceof Action) {
                    ((Action)tmpObj).setEnabled(true);
                    continue;
                }
                if (!(tmpObj instanceof AbstractButton)) continue;
                ((AbstractButton)tmpObj).setEnabled(true);
                String panelClass = ((AbstractButton)tmpObj).getName();
                Object panel = this.panelMap.get(panelClass);
                if (!(panel instanceof XPcaPanel) || panel instanceof XpROIStatisticsPanel || panel instanceof XpCinePanel || panel instanceof XpFilmPanel || panel instanceof XpTextPagePanel) continue;
                CvUtils.setEnabled((XPcaPanel)panel, true);
            }
        }
    }

    protected void setEnableAllControls(boolean disable) {
        for (Object value : this.allControls.values()) {
            if (value instanceof Action) {
                ((Action)value).setEnabled(disable);
                continue;
            }
            if (!(value instanceof AbstractButton)) continue;
            ((AbstractButton)value).setEnabled(disable);
            String panelClass = ((AbstractButton)value).getName();
            Object panel = this.panelMap.get(panelClass);
            if (panel == null || panel instanceof XpROIStatisticsPanel || panel instanceof XpCinePanel || panel instanceof XpFilmPanel || panel instanceof XpTextPagePanel || !(panel instanceof XPcaPanel)) continue;
            CvUtils.setEnabled((XPcaPanel)panel, disable);
        }
        if (this.screen.getActionMap() != null && this.screen.getActionMap().allKeys() != null) {
            for (int i = 0; i < this.screen.getActionMap().allKeys().length; ++i) {
                Action action = this.screen.getActionMap().get(this.screen.getActionMap().allKeys()[i]);
                action.setEnabled(disable);
            }
        }
    }

    public static class DummyXpcaPanel
    extends XPcaPanel {
    }

    class BorderLessTabUI
    extends CuiTabbedPaneUI {
        Border cBorder = new EmptyBorder(0, 0, 0, 0);

        BorderLessTabUI() {
        }

        protected Border getContentBorder() {
            return this.cBorder;
        }
    }
}

