/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.cse.cvf.annotation.XpCVAnnotationGenerator;
import com.ge.med.cse.cvf.crossref.XpReferenceImageApp;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.DicomPrintablePort;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpViewport;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.HashMap;

public class DicomPageablePort
implements Pageable {
    private XpViewport port_ = null;
    private int start_ = 0;
    private int end_ = 0;
    private int interval_ = 1;
    private int numpages = 0;
    private boolean isRefAllOn_ = false;
    private String annotLevel_;
    private int customAnnotMask_;
    private int[] annotkey = null;
    private HashMap<Integer, DicomPrintablePort> cache = new HashMap();

    public DicomPageablePort(XpViewport port, int startindex, int endindex, int interval) {
        if (!(port instanceof FramePositioningCapable)) {
            throw new IllegalArgumentException("Port not FramePositioningCapable !!");
        }
        this.port_ = port;
        this.start_ = startindex < 0 ? 0 : startindex;
        this.end_ = endindex >= ((FramePositioningCapable)((Object)this.port_)).getNumFrames() ? ((FramePositioningCapable)((Object)this.port_)).getNumFrames() - 1 : endindex;
        this.interval_ = interval;
        this.numpages = (this.end_ - this.start_) / this.interval_ + 1;
    }

    public void setReferenceOn(boolean refOn) {
        this.isRefAllOn_ = refOn;
    }

    public void dispose() {
        for (DicomPrintablePort p : this.cache.values()) {
            p.dispose();
        }
        this.cache.clear();
        if (this.isRefAllOn_) {
            XpReferenceImageApp.removeReferenceImage(this.port_, false);
        }
        this.port_.dispose();
        this.port_ = null;
    }

    public void setFilmAnnotationSetting(String annotLevel, int customAnnotMask) {
        this.annotLevel_ = annotLevel;
        this.customAnnotMask_ = customAnnotMask;
    }

    public void setLargeFontKeys(int[] akey) {
        this.annotkey = akey;
    }

    public int getNumberOfPages() {
        return this.numpages;
    }

    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < 0 || pageIndex >= this.numpages) {
            throw new ArrayIndexOutOfBoundsException(pageIndex + " >= " + this.numpages);
        }
        return new PageFormat();
    }

    public void disposePrintable(int pageIndex) {
        DicomPrintablePort p = this.cache.get(new Integer(pageIndex));
        p.dispose();
        this.cache.remove(new Integer(pageIndex));
    }

    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < 0 || pageIndex >= this.numpages) {
            throw new ArrayIndexOutOfBoundsException(pageIndex + " >= " + this.numpages);
        }
        Printable printable = null;
        printable = this.cache.get(new Integer(pageIndex));
        if (printable != null) {
            return printable;
        }
        int frameindex = this.start_ + pageIndex * this.interval_;
        if (frameindex < 0 || frameindex >= ((FramePositioningCapable)((Object)this.port_)).getNumFrames()) {
            throw new ArrayIndexOutOfBoundsException(frameindex + " >= " + ((FramePositioningCapable)((Object)this.port_)).getNumFrames());
        }
        ((FramePositioningCapable)((Object)this.port_)).setFrameIndex(frameindex);
        XpViewport vp = null;
        if (this.port_ instanceof XpCompositePort) {
            vp = (XpViewport)((XpCompositePort)this.port_).getPort(0).clone();
        }
        if (this.isRefAllOn_) {
            XpReferenceImageApp.copyRefPort(this.port_, vp, 0);
            vp.putClientProperty("reference_viewport", "true");
        }
        String annonGenerator = CvPropertiesManager.getProperty("cvf.annotation.generator", XpCVAnnotationGenerator.class.getName());
        try {
            vp.setAnnotationGenerator(Class.forName(annonGenerator, true, this.getClass().getClassLoader()), null);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return printable;
        }
        printable = new DicomPrintablePort(vp);
        ((DicomPrintablePort)printable).setFilmAnnotationItems(this.annotLevel_, this.customAnnotMask_);
        if (this.annotkey != null) {
            ((DicomPrintablePort)printable).setLargeFontAnnotation(this.annotkey);
        }
        this.cache.put(new Integer(pageIndex), (DicomPrintablePort)printable);
        return printable;
    }
}

