/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.Selectable;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpComponentSave;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import com.ge.med.terra.jami.filter.XpImageOp;
import com.ge.med.terra.jami.image.XpImageData;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpJPipeline;
import com.ge.med.terra.jami.roi.XpImageMatte;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.List;

public class ScreenSave {
    private static final short BG_VAL = 0;
    private int width = 0;
    private int height = 0;
    private XpComponentSave cs = new XpComponentSave();
    private XpDicomElement dobj = new XpDicomElement(40, 257);
    private XpDicomElement dobjPixRep = new XpDicomElement(40, 259);

    public ScreenSave(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public boolean isColorImage(XpSingularPort vp) {
        XpImage img = vp.getFrame();
        RenderedImage rimg = img.getPixelData();
        int[] cc = rimg.getColorModel().getComponentSize();
        XpImageRenderAttributes ira = vp.getImageRenderAttributes();
        if (ira == null) {
            return false;
        }
        int nChannels = cc.length;
        System.out.println("ScreenSave.isColorImage() CChanel" + nChannels + "   Colormap=" + ira.getColormap() + "   overlay" + ira.getColorOverlay());
        if (nChannels == 1 && ira.getColormap() == null && ira.getColorOverlay() == null) {
            return false;
        }
        return ira.getColormap() == null || !"g1".equalsIgnoreCase(ira.getColormap().toString()) && !"g2".equalsIgnoreCase(ira.getColormap().toString()) && !"g3".equalsIgnoreCase(ira.getColormap().toString());
    }

    public BufferedImage generate(XpSingularPort vp) {
        int i;
        String annonGenerator = CvPropertiesManager.getProperty("cvf.annotation.generator", "com.ge.med.cse.cvf.annotation.XpApdAnnotationGenerator");
        XpSingularPort clonevp = (XpSingularPort)vp.clone();
        XpImage img = vp.getFrame();
        RenderedImage rimg = img.getPixelData();
        BufferedImage imgout = null;
        XpImageRenderAttributes ira = vp.getImageRenderAttributes();
        String[] annot = null;
        if ("SSAVE".equals(DicomUtils.getImageType((XpMedicalImage)vp.getFrame(), false))) {
            clonevp.setAnnotationVisible(false);
        } else {
            annot = vp.getAnnotationItems();
            if (annot != null) {
                boolean[] state = new boolean[annot.length];
                vp.queryAnnotationItems(annot, state);
                for (i = 0; i < annot.length; ++i) {
                    clonevp.setAnnotationItems(new String[]{annot[i]}, state[i]);
                }
            }
            String mod = this.getModality(clonevp);
            int largefontmask = XPDisplayPrefsUtils.getScreenLargeFontAnnotationLevel();
            if (largefontmask != 0) {
                XpFrameVisualizer fv = null;
                fv = (XpFrameVisualizer)vp;
                int[] annotkey = XPDisplayPrefsUtils.getLargeFontAnnotationKeys(fv, mod, largefontmask);
                try {
                    clonevp.setAnnotationGenerator(Class.forName(annonGenerator, true, this.getClass().getClassLoader()), null);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                XPDisplayPrefsUtils.setLargeFontAnnotation(clonevp, annotkey);
            }
        }
        if (clonevp instanceof ROICapable) {
            List rois = clonevp.getRois();
            for (i = 0; i < rois.size(); ++i) {
                Object ra = rois.get(i);
                if (!(ra instanceof Selectable) || !((Selectable)ra).isSelected()) continue;
                ((Selectable)ra).setSelected(false);
            }
        }
        if (clonevp instanceof UserAnnoCapable) {
            List uas = clonevp.getUserAnnos();
            for (i = 0; i < uas.size(); ++i) {
                Object ua = uas.get(i);
                if (!(ua instanceof Selectable) || !((Selectable)ua).isSelected()) continue;
                ((Selectable)ua).setSelected(false);
            }
        }
        boolean isLuminance = true;
        if (!this.isColorImage(vp)) {
            BufferedImage renderImg = this.cs.renderOffscreen(clonevp, this.width, this.height, 0);
            AffineTransform at = clonevp.getMedicalImageVc().getImageVc().getAffineTransform();
            imgout = this.renderLuminance(img, ira, at, this.width, this.height);
            short[] imglayer = ((DataBufferUShort)imgout.getRaster().getDataBuffer()).getData();
            this.matteImgLayer(clonevp.getMedicalImageVc(), imglayer, this.width, this.height);
            clonevp.setAnnotationItems(new String[]{"Windowing"}, false);
            clonevp.getMedicalImageVc().getImageVc().disableImageRendering(Color.black);
            BufferedImage overlay0 = this.cs.renderOffscreen(clonevp, this.width, this.height, 1);
            clonevp.getMedicalImageVc().getImageVc().disableImageRendering(Color.white);
            BufferedImage overlay1 = this.cs.renderOffscreen(clonevp, this.width, this.height, 1);
            BufferedImage annotation = new BufferedImage(this.width, this.height, 1);
            Graphics g = annotation.getGraphics();
            clonevp.getMedicalImageVc().getAnnotationVc().paint(g);
            short[] gxlayer = ((DataBufferUShort)overlay0.getRaster().getDataBuffer()).getData();
            short[] gxshadowlayer = ((DataBufferUShort)overlay1.getRaster().getDataBuffer()).getData();
            int[] annotlayer = ((DataBufferInt)annotation.getRaster().getDataBuffer()).getData();
            for (int i2 = 0; i2 < imglayer.length; ++i2) {
                int v;
                int pixval = gxlayer[i2] & 0xFFFF;
                int shadow_pixval = gxshadowlayer[i2] & 0xFFFF;
                double w = (double)pixval / 65536.0;
                if (pixval > 0) {
                    imglayer[i2] = (short)(w * 32768.0);
                }
                if (shadow_pixval < 5) {
                    imglayer[i2] = Short.MIN_VALUE;
                }
                if ((v = annotlayer[i2] & 0xFFFF) <= 0) continue;
                imglayer[i2] = Short.MAX_VALUE;
            }
        } else {
            clonevp.setAnnotationItems(new String[]{"Windowing"}, false);
            imgout = this.cs.renderOffscreen(clonevp, this.width, this.height, 0);
            isLuminance = false;
        }
        Container container = (Container)vp.getMedicalImageVc().getComponent(0);
        Component[] children = container.getComponents();
        if (children != null) {
            for (int i3 = 0; i3 < children.length; ++i3) {
                if (!(children[i3] instanceof XpSingularPort)) continue;
                XpSingularPort subport = (XpSingularPort)children[i3];
                Rectangle r = subport.getBounds();
                int rx = (int)(r.getX() + (double)(clonevp.getWidth() - vp.getWidth()));
                int ry = (int)(r.getY() + (double)(clonevp.getHeight() - vp.getHeight()));
                r.setLocation(rx, ry);
                if (isLuminance) {
                    double min = ira.getWindowMin();
                    double max = ira.getWindowMax();
                    BufferedImage subimg = new BufferedImage(r.width, r.height, 11);
                    Graphics2D g2 = (Graphics2D)subimg.getGraphics();
                    subport.paint(g2);
                    short[] data = ((DataBufferUShort)imgout.getRaster().getDataBuffer()).getData();
                    short[] subdata = ((DataBufferUShort)subimg.getRaster().getDataBuffer()).getData();
                    double minv = 0.0;
                    double maxv = 65535.0;
                    for (int y = 0; y < r.height; ++y) {
                        int yyoffset = (r.y + y) * imgout.getWidth();
                        for (int x = 0; x < r.width; ++x) {
                            int xx = r.x + x;
                            int subval = subdata[y * r.width + x] & 0xFFFF;
                            double ww = max - min;
                            double subww = maxv - minv;
                            subval = (short)(((double)subval - minv) / subww * ww + min);
                            data[yyoffset + xx] = (short)subval;
                        }
                    }
                    continue;
                }
                XpSingularPort clonesubvp = (XpSingularPort)subport.clone();
                if (annot != null) {
                    boolean[] state = new boolean[annot.length];
                    vp.queryAnnotationItems(annot, state);
                    for (int j = 0; j < annot.length; ++j) {
                        clonesubvp.setAnnotationItems(new String[]{annot[j]}, state[j]);
                    }
                }
                BufferedImage subimg = this.cs.renderOffscreen(clonesubvp, r.width, r.height, 0);
                Graphics2D g2 = (Graphics2D)imgout.getGraphics();
                g2.drawImage((Image)subimg, r.x, r.y, null);
                CvUtils.dispose(clonesubvp);
            }
        }
        CvUtils.dispose(clonevp);
        return imgout;
    }

    private void matteImgLayer(Container c, short[] imglayer, int width, int height) {
        int BGVAL = 65535;
        Component[] children = c.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof XpImageRoiVc) {
                int pixval;
                int k;
                XpImageRoiVc roivc = (XpImageRoiVc)children[i];
                RoiActor ra = roivc.getRoiActor();
                if (!(ra instanceof XpImageMatte)) continue;
                BufferedImage img = new BufferedImage(width, height, 11);
                short[] mattelayer = ((DataBufferUShort)img.getRaster().getDataBuffer()).getData();
                Arrays.fill(mattelayer, (short)-1);
                Graphics g = img.getGraphics();
                roivc.paint(g);
                for (k = 0; k < mattelayer.length; ++k) {
                    pixval = mattelayer[k] & 0xFFFF;
                    if (pixval <= 4096) continue;
                    mattelayer[k] = -1;
                }
                for (k = 0; k < imglayer.length; ++k) {
                    pixval = mattelayer[k] & 0xFFFF;
                    if (pixval >= 65535) continue;
                    double w = (double)pixval / 65535.0;
                    imglayer[k] = (short)(w * 32768.0);
                }
                continue;
            }
            if (!(children[i] instanceof Container)) continue;
            this.matteImgLayer((Container)children[i], imglayer, width, height);
        }
    }

    private BufferedImage renderLuminance(XpImage srcimg, XpImageRenderAttributes ira, AffineTransform at, int vpWidth, int vpHeight) {
        int retval;
        RenderedImage srcImage = srcimg.getPixelData();
        double rescaleSlope = srcimg.getRescaleSlope();
        double rescaleIntercept = srcimg.getRescaleIntercept();
        BufferedImage destImage = null;
        short[] shortoutput = null;
        int w = srcImage.getWidth();
        int h = srcImage.getHeight();
        AffineTransform inverse = new AffineTransform();
        double[] itx = new double[6];
        double[] tx = new double[6];
        int[] cc = srcImage.getColorModel().getComponentSize();
        int pixelRepresentation = 1;
        int img_bpp = cc[0];
        if (srcimg instanceof XpDicomObject && (retval = ((XpDicomObject)((Object)srcimg)).getValue(this.dobjPixRep)) == 0) {
            pixelRepresentation = Integer.parseInt("" + this.dobjPixRep.value);
        }
        if (srcimg instanceof XpDicomObject && (retval = ((XpDicomObject)((Object)srcimg)).getValue(this.dobj)) == 0) {
            img_bpp = Integer.parseInt("" + this.dobj.value);
        }
        XpGeomUtils gu = new XpGeomUtils();
        XpJPipeline.RowBuffer rbuffer = new XpJPipeline.RowBuffer(vpWidth, vpHeight);
        gu.calcInverse(at, inverse);
        inverse.getMatrix(itx);
        at.getMatrix(tx);
        srcImage = this.doImageOperations(srcImage, ira.getImageOperations());
        if (srcImage == null) {
            return null;
        }
        DataBuffer db = XpImageData.getDataBuffer(srcImage);
        int dataOffset = db.getOffset();
        int dataLength = db.getSize();
        if (img_bpp > 8) {
            boolean zeroFlag;
            short[] in = null;
            in = db instanceof DataBufferUShort ? ((DataBufferUShort)db).getData() : ((DataBufferShort)db).getData();
            destImage = new BufferedImage(vpWidth, vpHeight, 11);
            shortoutput = ((DataBufferUShort)destImage.getRaster().getDataBuffer()).getData();
            double dx = itx[0] * 1.0 + itx[2] * 0.0;
            double dy = itx[1] * 1.0 + itx[3] * 0.0;
            double angle = Math.acos((dx * 1.0 + dy * 0.0) / Math.sqrt(dx * dx + dy * dy));
            double deg = Math.toDegrees(angle) * 10000.0;
            int ideg = (int)deg;
            boolean uprightFlag = false;
            boolean bl = zeroFlag = ideg % 3600000 == 0;
            if (zeroFlag) {
                dx = itx[0] * 1.0 + itx[2] * 1.0;
                dy = itx[1] * 1.0 + itx[3] * 1.0;
                if (dx > 0.0 && dy > 0.0) {
                    uprightFlag = true;
                }
            }
            if (uprightFlag) {
                XpJPipeline.doBilinearShortToShortUpright(tx, itx, in, dataOffset, w, h, pixelRepresentation, img_bpp, shortoutput, vpWidth, vpHeight, (short)0);
            } else {
                XpJPipeline.doBilinearShortToShortBox(tx, itx, in, dataOffset, w, h, pixelRepresentation, img_bpp, shortoutput, vpWidth, vpHeight, rbuffer, (short)0);
            }
        } else if (img_bpp <= 8) {
            // empty if block
        }
        if (shortoutput != null) {
            double ww = ira.getWindowWidth() / rescaleSlope;
            double wl = (ira.getWindowLevel() - rescaleIntercept) / rescaleSlope;
            double min = wl - ww * 0.5;
            double max = wl + ww * 0.5;
            if (ira.isVideoInverted()) {
                for (int i = 0; i < shortoutput.length; ++i) {
                    shortoutput[i] = (short)(max - ((double)shortoutput[i] - min));
                }
            }
        }
        return destImage;
    }

    private RenderedImage doImageOperations(RenderedImage inputImage, List opList) {
        BufferedImage opImg1 = null;
        BufferedImage opImg2 = null;
        int opListLen = opList.size();
        if (opListLen > 0) {
            opImg1 = XpImageData.createCompatibleBufferedImage(inputImage);
            if (opListLen > 1) {
                opImg2 = XpImageData.createCompatibleBufferedImage(inputImage);
            }
            RenderedImage input = inputImage;
            RenderedImage output = opImg1;
            RenderedImage result = input;
            for (int i = 0; i < opListLen; ++i) {
                XpImageOp iop = (XpImageOp)opList.get(i);
                if (iop == null) continue;
                iop.execute(input, output);
                result = output;
                if (i == 0) {
                    input = opImg1;
                    output = opImg2;
                    continue;
                }
                RenderedImage tmp = input;
                input = output;
                output = tmp;
            }
            return result;
        }
        return inputImage;
    }

    public String getModality(XpSingularPort vp) {
        String modality = null;
        XpMedicalImage img = (XpMedicalImage)vp.getFrame();
        if (img != null) {
            modality = DicomUtils.getModality(img);
        }
        return modality;
    }
}

