/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.border;

import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.graphics.StretchedImageIcon;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.shape.EdgeProfile;
import com.ge.med.ptk.shape.EdgeProfileRounded;
import com.ge.med.ptk.shape.RoundCornerRectangle;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class CuiBorder
implements Border {
    protected double interiorEdge_;
    protected double exteriorEdge_;
    protected double[] cornerRadii_;
    protected boolean[] interiorEdgeVisible_;
    protected boolean[] exteriorEdgeVisible_;
    protected Insets minimumMargin_;
    protected int insetRule_;
    public static final int MAXIMIZE_AREA = 0;
    public static final int MAXIMIZE_WIDTH = 1;
    public static final int MAXIMIZE_HEIGHT = 2;
    protected EdgeProfile profileNormal_;
    protected EdgeProfile profilePressed_;
    public Insets hardInsets_;
    protected Insets softInsets_;
    protected int cornerAllowance_;
    protected Insets focusInsets_;
    protected double focusCorner_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery((String[])argv, (String)"@(#)ptk2 2.7 200609011020 (Sun Microsystems Inc.|1.4.2_05|48.0|Linux|2.6.7-2.2smp|i386|batbuild)");
    }

    public double getInteriorEdge() {
        return this.interiorEdge_;
    }

    public double getExteriorEdge() {
        return this.exteriorEdge_;
    }

    public double[] getCornerRadii() {
        return this.cornerRadii_;
    }

    public boolean[] getInteriorEdgeVisible() {
        return this.interiorEdgeVisible_;
    }

    public boolean[] getExteriorEdgeVisible() {
        return this.exteriorEdgeVisible_;
    }

    public Insets getMinimumMargin() {
        return this.minimumMargin_;
    }

    public int getInsetRule() {
        return this.insetRule_;
    }

    public CuiBorder() {
        this(CuiLookAndFeel.getInteriorEdge(), CuiLookAndFeel.getExteriorEdge(), new double[]{CuiLookAndFeel.getCornerRadius(), CuiLookAndFeel.getCornerRadius(), CuiLookAndFeel.getCornerRadius(), CuiLookAndFeel.getCornerRadius()}, new boolean[]{true, true, true, true}, new boolean[]{true, true, true, true}, new Insets(0, 0, 0, 0), 0);
    }

    public CuiBorder(double interiorEdge, double exteriorEdge, double[] cornerRadii, boolean[] interiorEdgeVisible, boolean[] exteriorEdgeVisible, Insets minimumMargin, int insetRule) {
        this.interiorEdge_ = interiorEdge;
        this.exteriorEdge_ = exteriorEdge;
        this.cornerRadii_ = cornerRadii;
        this.interiorEdgeVisible_ = interiorEdgeVisible;
        this.exteriorEdgeVisible_ = exteriorEdgeVisible;
        this.minimumMargin_ = minimumMargin;
        this.insetRule_ = insetRule;
    }

    public Insets getBorderInsets(Component c) {
        if (this.hardInsets_ == null || this.softInsets_ == null) {
            int i;
            int interiorEdge = (int)Math.ceil(this.interiorEdge_);
            int exteriorEdge = (int)Math.ceil(this.exteriorEdge_);
            int[] sides = new int[4];
            int[][] corners = new int[4][2];
            double[][] ruleCoefficients = new double[][]{{0.293, 0.0, 1.0}, {0.293, 1.0, 0.0}};
            for (i = 0; i < 4; ++i) {
                sides[i] = (this.interiorEdgeVisible_[i] ? interiorEdge : 0) + (this.exteriorEdgeVisible_[i] ? exteriorEdge : 0);
                double corner = Math.max(0.0, this.cornerRadii_[i] - this.interiorEdge_);
                corners[i][0] = (int)Math.ceil(corner * ruleCoefficients[0][this.insetRule_]);
                corners[i][1] = (int)Math.ceil(corner * ruleCoefficients[1][this.insetRule_]);
            }
            this.hardInsets_ = new Insets(sides[0], sides[1], sides[2], sides[3]);
            this.softInsets_ = new Insets(Math.max(Math.max(corners[3][1], corners[0][1]), this.minimumMargin_.top), Math.max(Math.max(corners[0][0], corners[1][0]), this.minimumMargin_.left), Math.max(Math.max(corners[1][1], corners[2][1]), this.minimumMargin_.bottom), Math.max(Math.max(corners[2][0], corners[3][0]), this.minimumMargin_.right));
            this.cornerAllowance_ = interiorEdge;
            for (i = 0; i < 4; ++i) {
                this.cornerAllowance_ = Math.max(this.cornerAllowance_, (int)Math.ceil(this.cornerRadii_[i]));
            }
            if (c instanceof AbstractButton) {
                double maxRadius = 0.0;
                for (int i2 = 0; i2 < 4; ++i2) {
                    maxRadius = Math.max(maxRadius, this.cornerRadii_[i2]);
                }
                this.focusCorner_ = Math.max(1.0, (double)((int)Math.ceil(2.0 * (maxRadius - this.interiorEdge_))));
                int focusInset = 0;
                this.focusInsets_ = new Insets(this.hardInsets_.top + focusInset, this.hardInsets_.left + focusInset, this.hardInsets_.bottom + focusInset, this.hardInsets_.right + focusInset);
            }
        }
        Insets margin = null;
        if (c instanceof AbstractButton) {
            margin = ((AbstractButton)c).getMargin();
        } else if (c instanceof JTextComponent) {
            margin = ((JTextComponent)c).getMargin();
        } else if (c instanceof JToolBar) {
            margin = ((JToolBar)c).getMargin();
        }
        if (margin == null) {
            margin = new Insets(0, 0, 0, 0);
        }
        return new Insets(this.hardInsets_.top + Math.max(this.softInsets_.top, margin.top), this.hardInsets_.left + Math.max(this.softInsets_.left, margin.left), this.hardInsets_.bottom + Math.max(this.softInsets_.bottom, margin.bottom), this.hardInsets_.right + Math.max(this.softInsets_.right, margin.right));
    }

    public Insets getSoftInsets(Component c) {
        this.getBorderInsets(c);
        return this.softInsets_;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        Color interiorColor;
        Container parent;
        Container container = parent = c != null ? c.getParent() : null;
        if (parent instanceof CellRendererPane) {
            parent = parent.getParent();
        }
        if (parent instanceof JComboBox || parent instanceof JSpinner) {
            parent = parent.getParent();
        }
        Color exteriorColor = c == null || parent == null || parent.getBackground() == null || !parent.isOpaque() || parent instanceof JComponent && (((JComponent)parent).getClientProperty("picture") != null || ((JComponent)parent).getClientProperty("texture") != null) ? new Color(0, true) : parent.getBackground();
        Color color = interiorColor = c == null || c.getBackground() == null || !c.isEnabled() ? exteriorColor : c.getBackground();
        if (this.profileNormal_ == null) {
            this.profileNormal_ = new EdgeProfileRounded(this.interiorEdge_, this.exteriorEdge_);
        }
        EdgeProfile profile = this.profileNormal_;
        if (c instanceof AbstractButton) {
            boolean checkOrRadio;
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            boolean pressed = model.isPressed();
            boolean selected = model.isSelected();
            boolean bl = checkOrRadio = button instanceof JCheckBox || button instanceof JRadioButton;
            if (this.profilePressed_ == null) {
                this.profilePressed_ = new EdgeProfileRounded(this.interiorEdge_, this.exteriorEdge_){

                    public double getSlope(double distanceFromShape) {
                        double slope = super.getSlope(distanceFromShape);
                        return distanceFromShape > 0.0 ? -slope : slope;
                    }

                    public String toString() {
                        return "Pressed" + super.toString();
                    }
                };
            }
            if (pressed || selected && !checkOrRadio) {
                profile = this.profilePressed_;
            }
            if (!button.isContentAreaFilled()) {
                interiorColor = exteriorColor;
            } else if (c.isEnabled() && (pressed || selected)) {
                String classKey = button.getUIClassID();
                if (classKey.endsWith("UI")) {
                    classKey = classKey.substring(0, classKey.length() - 2);
                }
                interiorColor = Utilities.getUIPropertyColor(button, classKey + (pressed ? ".press" : ".select"), Color.gray);
            }
        } else if (c instanceof JTextComponent) {
            JTextComponent text = (JTextComponent)c;
            if (!text.isEditable()) {
                interiorColor = exteriorColor;
            }
        } else if (c == null) {
            interiorColor = exteriorColor;
        } else if (!c.isOpaque()) {
            if (!(parent instanceof JTabbedPane)) {
                interiorColor = exteriorColor;
            } else {
                interiorColor = (Color)((JTabbedPane)parent).getClientProperty("TabbedPane.selected");
                if (interiorColor == null) {
                    interiorColor = UIManager.getColor("TabbedPane.selected");
                }
                if (interiorColor == null) {
                    interiorColor = exteriorColor;
                }
            }
        }
        if (c instanceof JInternalFrame) {
            exteriorColor = interiorColor;
        }
        Insets cutoutInsets = this.getBorderInsets(c);
        int exteriorEdge = (int)Math.ceil(this.exteriorEdge_);
        int interiorEdge = (int)Math.ceil(this.interiorEdge_);
        int ww = 2 * Math.max(exteriorEdge + this.cornerAllowance_, Math.max(cutoutInsets.left, cutoutInsets.right)) + 1;
        int hh = 2 * Math.max(exteriorEdge + this.cornerAllowance_, Math.max(cutoutInsets.top, cutoutInsets.bottom)) + 1;
        Dimension size = new Dimension(Math.min(w, ww), Math.min(h, hh));
        Rectangle cutout = new Rectangle(cutoutInsets.left, cutoutInsets.top, size.width - (cutoutInsets.left + cutoutInsets.right), size.height - (cutoutInsets.top + cutoutInsets.bottom));
        Insets shapeInsets = new Insets(this.exteriorEdgeVisible_[0] ? exteriorEdge : (this.interiorEdgeVisible_[0] ? 0 : -Math.max(interiorEdge, this.cornerAllowance_)), this.exteriorEdgeVisible_[1] ? exteriorEdge : (this.interiorEdgeVisible_[1] ? 0 : -Math.max(interiorEdge, this.cornerAllowance_)), this.exteriorEdgeVisible_[2] ? exteriorEdge : (this.interiorEdgeVisible_[2] ? 0 : -Math.max(interiorEdge, this.cornerAllowance_)), this.exteriorEdgeVisible_[3] ? exteriorEdge : (this.interiorEdgeVisible_[3] ? 0 : -Math.max(interiorEdge, this.cornerAllowance_)));
        double[] arcDiameters = new double[]{2.0 * this.cornerRadii_[0], 2.0 * this.cornerRadii_[1], 2.0 * this.cornerRadii_[2], 2.0 * this.cornerRadii_[3]};
        RoundCornerRectangle shape = new RoundCornerRectangle((double)shapeInsets.left, (double)shapeInsets.top, (double)(size.width - (shapeInsets.left + shapeInsets.right)), (double)(size.height - (shapeInsets.top + shapeInsets.bottom)), arcDiameters, arcDiameters);
        BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(size, shape, profile, interiorColor, exteriorColor, cutout);
        new StretchedImageIcon(renderedShape, w, h).paintIcon(c, g, x, y);
        if (c instanceof AbstractButton && ((AbstractButton)c).isFocusPainted() && (c.hasFocus() || c.getParent() instanceof JComboBox && ((JComboBox)c.getParent()).hasFocus())) {
            String classKey = ((JComponent)c).getUIClassID();
            if (classKey.endsWith("UI")) {
                classKey = classKey.substring(0, classKey.length() - 2);
            }
            g.setColor(Utilities.getUIPropertyColor((JComponent)c, classKey + (((AbstractButton)c).isSelected() ? ".selectFocus" : ".focus"), Color.white));
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).draw(new RoundRectangle2D.Double((double)(x + this.focusInsets_.left) + 0.5, (double)(y + this.focusInsets_.top) + 0.5, w - (this.focusInsets_.left + this.focusInsets_.right) - 1, h - (this.focusInsets_.top + this.focusInsets_.bottom) - 1, this.focusCorner_, this.focusCorner_));
        }
    }

    public static class UIResource
    extends CuiBorder
    implements javax.swing.plaf.UIResource {
        public UIResource() {
        }

        public UIResource(double interiorEdge, double exteriorEdge, double[] cornerRadii, boolean[] interiorEdgeVisible, boolean[] exteriorEdgeVisible, Insets minimumMargin, int insetRule) {
            super(interiorEdge, exteriorEdge, cornerRadii, interiorEdgeVisible, exteriorEdgeVisible, minimumMargin, insetRule);
        }
    }
}

