/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.Polygon3D;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimplePolygon3D
implements Polygon3D {
    private final List myPoints = new LinkedList();
    private final Collection myChangeListeners = new LinkedList();

    public void addPoint(CPoint point) {
        this.myPoints.add(point);
        this.notifyChangeListeners();
    }

    public int length() {
        return this.myPoints.size();
    }

    public CPoint getPointAt(int index) {
        return (CPoint)this.myPoints.get(index);
    }

    public List getPoints() {
        return new LinkedList(this.myPoints);
    }

    public void removePointAt(int index) {
        this.myPoints.remove(index);
        this.notifyChangeListeners();
    }

    public void removePoint(CPoint point) {
        this.myPoints.remove(point);
        this.notifyChangeListeners();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.myChangeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.myChangeListeners.remove(changeListener);
    }

    public void notifyChangeListeners() {
        Iterator i = this.myChangeListeners.iterator();
        while (i.hasNext()) {
            ((ChangeListener)i.next()).stateChanged(new ChangeEvent(this));
        }
    }
}

