/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.ComponentCapable;
import com.ge.med.idc.ComponentCreationListener;
import com.ge.med.idc.ComponentCreator;
import com.ge.med.idc.T3DCapable;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpVisualComponent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

public abstract class XpComponentCreator
implements ComponentCreator,
MouseListener,
MouseMotionListener {
    private Set l = new HashSet();
    private List notify = new ArrayList();
    private Map m = new HashMap();
    private CPoint disp_pt = new CPoint(1);
    private CPoint img_pt = new CPoint(0);
    private boolean perpetual = false;

    public void addViewport(JComponent rc, JComponent listenTo) {
        listenTo.addMouseListener(this);
        listenTo.addMouseMotionListener(this);
        if (rc instanceof ComponentCapable) {
            this.m.put(listenTo, rc);
        }
    }

    public void removeViewport(JComponent rc, JComponent listenTo) {
        listenTo.removeMouseListener(this);
        listenTo.removeMouseMotionListener(this);
        this.m.remove(listenTo);
    }

    protected final ComponentCapable getComponentCapable(Object listeningSource) {
        return (ComponentCapable)this.m.get(listeningSource);
    }

    protected CPoint getImgPt(XpVisualComponent vc, int x, int y) {
        if (vc instanceof T3DCapable) {
            this.img_pt.x = x;
            this.img_pt.y = y;
            this.img_pt.z = 0.0;
        } else {
            this.disp_pt.setPoint(x, y, 0.0, (byte)1);
            vc.transform(this.disp_pt, this.img_pt, (byte)0);
        }
        return this.img_pt;
    }

    protected void removeFromAll() {
        for (JComponent l : this.m.keySet()) {
            l.removeMouseListener(this);
            l.removeMouseMotionListener(this);
        }
    }

    public void addComponentCreationListener(ComponentCreationListener rcl) {
        this.l.add(rcl);
    }

    public void removeComponentCreationListener(ComponentCreationListener rcl) {
        this.l.remove(rcl);
    }

    protected void notifyCreationListeners(ComponentCapable cc) {
        for (Object o : this.l) {
            this.notify.add(o);
        }
        int len = this.l.size();
        for (int i = 0; i < len; ++i) {
            ComponentCreationListener rcl = (ComponentCreationListener)this.notify.get(i);
            rcl.componentCreationNotification(cc);
        }
        this.notify.clear();
    }

    protected void notifyAdditionListeners(ComponentCapable cc) {
        for (Object o : this.l) {
            this.notify.add(o);
        }
        int len = this.l.size();
        for (int i = 0; i < len; ++i) {
            ComponentCreationListener rcl = (ComponentCreationListener)this.notify.get(i);
            rcl.componentAddedNotification(cc);
        }
        this.notify.clear();
    }

    public void mouseClicked(MouseEvent me) {
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
    }

    public void mouseDragged(MouseEvent me) {
    }

    public void mouseMoved(MouseEvent me) {
    }

    public final void shutdown(ComponentCapable cc) {
        this.notifyCreationListeners(cc);
        this.removeFromAll();
    }

    public final boolean isPerpetual() {
        return this.perpetual;
    }

    public final void setPerpetual(boolean perpetual) {
        this.perpetual = perpetual;
    }
}

