/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import com.ge.med.terra.jami.render.XpOffscreenRenderer;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.List;

public class XpImageLayer {
    private static final int MAX_IMAGE_LAYER_RENDERERS = Integer.parseInt(XpPropertiesManager.getProperty("jami.maximagelayer.renderers", "128"));
    public XpImage frame = null;
    private XpImagePixelAttributes ipa = null;
    private int[] cmapTable = null;
    private XpOffscreenRenderer offscreen = null;
    private long timeStamp = Long.MAX_VALUE;
    private static List<XpImageLayer> items = new ArrayList<XpImageLayer>();

    public XpImageLayer(XpImage frame, XpImagePixelAttributes ipa) {
        this.frame = frame;
        this.ipa = ipa;
    }

    public XpImageLayer(XpImage frame) {
        this.frame = frame;
        this.ipa = new XpImagePixelAttributes();
    }

    private void update() {
        this.timeStamp = System.currentTimeMillis();
    }

    private static int getLeastRecentlyUsed() {
        int idx = -1;
        long currTimeStamp = Long.MAX_VALUE;
        for (int i = 0; i < items.size(); ++i) {
            XpImageLayer layer = items.get(i);
            if (idx != -1 && currTimeStamp <= layer.timeStamp) continue;
            idx = i;
            currTimeStamp = layer.timeStamp;
        }
        return idx;
    }

    public XpOffscreenRenderer getOffscreenRenderer() {
        if (this.offscreen != null) {
            this.update();
        }
        return this.offscreen;
    }

    public void resizeOffscreenRenderer(int w, int h) {
        if (this.offscreen == null || this.offscreen.getWidth() != w || this.offscreen.getHeight() != h) {
            int cleanIdx;
            this.offscreen = new XpOffscreenRenderer.ARGBAffineWWWL(w, h);
            if (items.size() > MAX_IMAGE_LAYER_RENDERERS && (cleanIdx = XpImageLayer.getLeastRecentlyUsed()) >= 0) {
                XpImageLayer toClean = items.get(cleanIdx);
                toClean.offscreen = null;
                items.remove(cleanIdx);
            }
            items.add(this);
            this.update();
        }
    }

    public final XpImagePixelAttributes getImagePixelAttributes() {
        return this.ipa;
    }

    public double getWindowLevel() {
        return this.ipa.getWindowLevel();
    }

    public double getWindowWidth() {
        return this.ipa.getWindowWidth();
    }

    public boolean isVideoInverted() {
        return this.ipa.isVideoInverted();
    }

    public double getWindowMin() {
        return this.ipa.getWindowMin();
    }

    public double getWindowMax() {
        return this.ipa.getWindowMax();
    }

    public IndexColorModel getColorMap() {
        return this.ipa.getColormap();
    }

    public int[] getColorMapTable() {
        return this.cmapTable;
    }

    public void resetWindowing() {
        if (this.frame != null) {
            double ww = this.frame.getDefaultWindowWidth();
            double wl = this.frame.getDefaultWindowLevel();
            this.setWindowing(ww, wl);
            this.setVideoInverted(false);
        }
    }

    public void setWindowing(double ww, double wl) {
        this.ipa.setWindowing(ww, wl);
        if (this.offscreen != null) {
            this.offscreen.setImagePixelAttributes(this.ipa);
        }
    }

    public void setVideoInverted(boolean ivvideo) {
        this.ipa.setVideoInverted(ivvideo);
        if (this.offscreen != null) {
            this.offscreen.setImagePixelAttributes(this.ipa);
        }
    }

    public void setWindowMinMax(double min, double max) {
        this.ipa.setWindowMinMax(min, max);
        if (this.offscreen != null) {
            this.offscreen.setImagePixelAttributes(this.ipa);
        }
    }

    public void setColorMap(int[] cMap) {
        IndexColorModel colorModel = null;
        if (cMap != null) {
            colorModel = new IndexColorModel(16, cMap.length, cMap, 0, false, -1, 1);
        }
        this.cmapTable = cMap;
        this.ipa.setColormap(colorModel);
        if (this.offscreen != null) {
            this.offscreen.setImagePixelAttributes(this.ipa);
        }
    }

    public void loadImagePixelAttributes() {
        if (this.offscreen != null) {
            this.offscreen.setImagePixelAttributes(this.ipa);
        }
    }
}

