/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.XjMultiChannelVolume;
import com.ge.med.idc.XjMultiChannelVolumeInfo;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.JnVector4d;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.j3d.JDataLoader;
import com.ge.med.terra.jami.j3d.XjVolumeUtils;
import com.ge.med.terra.jami.j3d.vr.VrContext;
import com.ge.med.terra.jami.j3d.vr.VrPreset;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class J3DVolumeModel
implements XjVolumeModel,
Replicable,
XpDicomObject,
PropertyChangeListener {
    public XjVolumeInfo xj_vol = null;
    public JVolume.LinearVolume j_vol = null;
    private JVolume.LinearVolume[] aux_j_vols = null;
    public VrContext vr_context = null;
    public Map user_data = new Hashtable(16);
    private JnMatrix4d vox2ras = new JnMatrix4d();
    private JnMatrix4d ras2vox = new JnMatrix4d();
    private boolean initialized = false;
    private Object _voldata = null;
    private List listeners = new ArrayList();
    private Hashtable ht = new Hashtable();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public J3DVolumeModel(XjVolumeInfo xj_vol) {
        this.xj_vol = xj_vol;
        int pixelType = xj_vol.getPixelType();
        int bpp = xj_vol.getBitsPerVoxel();
        this.j_vol = pixelType != 2 && bpp == 8 ? new JVolume.LinearByte(xj_vol) : new JVolume.LinearShort(xj_vol);
        this.j_vol.addPropertyChangeListener("IMAGE_LOADED", this);
        this.vr_context = new VrContext(this.j_vol);
        this.calcVox2RAS();
    }

    public J3DVolumeModel(XjVolumeInfo xj_vol, VrContext vr_context) {
        this.xj_vol = xj_vol;
        this.vr_context = vr_context;
        this.j_vol = vr_context.vol;
        this.j_vol.addPropertyChangeListener("IMAGE_LOADED", this);
        this.calcVox2RAS();
    }

    protected J3DVolumeModel(J3DVolumeModel vm) {
        vm.copyTo(this);
    }

    protected void copyTo(J3DVolumeModel vm) {
        vm._voldata = this._voldata;
        vm.j_vol = this.j_vol;
        vm.xj_vol = this.xj_vol;
        vm.aux_j_vols = this.aux_j_vols;
        vm.ht.putAll(this.ht);
        vm.vox2ras = (JnMatrix4d)this.vox2ras.clone();
        vm.ras2vox = (JnMatrix4d)this.ras2vox.clone();
        vm.initialized = this.initialized;
        vm.vr_context = (VrContext)this.vr_context.clone();
        vm.listeners.clear();
        vm.listeners.addAll(this.listeners);
        vm.user_data.putAll(this.user_data);
    }

    public static J3DVolumeModel createMultiChannelVolumeModel(XjMultiChannelVolumeInfo mvolInfo) {
        int[] channels = new int[mvolInfo.getNumChannels()];
        for (int i = 0; i < channels.length; ++i) {
            channels[i] = i;
        }
        return J3DVolumeModel.createMultiChannelVolumeModel(mvolInfo, channels);
    }

    public static J3DVolumeModel createMultiChannelVolumeModel(XjMultiChannelVolumeInfo mvolInfo, int[] channels) {
        if (mvolInfo instanceof XjMultiChannelVolume) {
            XjMultiChannelVolume mvol = (XjMultiChannelVolume)mvolInfo;
            JDataLoader jdl = new JDataLoader(mvol);
            return jdl.loadMultiChannelVolumeModel(channels);
        }
        return null;
    }

    public void attachAuxiliaryVolumes(JVolume.LinearVolume[] vols) {
        for (int i = 0; i < vols.length; ++i) {
            if (vols[i].dx == this.j_vol.dx && vols[i].dy == this.j_vol.dy && vols[i].dz == this.j_vol.dz) continue;
            throw new RuntimeException("One or more volumes do not have same size dimensions");
        }
        this._voldata = null;
        this.aux_j_vols = vols;
    }

    public int getNumVolumes() {
        if (this.aux_j_vols != null) {
            return this.aux_j_vols.length + 1;
        }
        return 1;
    }

    public JVolume.LinearVolume getJVolume() {
        return this.j_vol;
    }

    public JVolume.LinearVolume getVolume(int idx) {
        if (idx == 0) {
            return this.j_vol;
        }
        return this.aux_j_vols[idx - 1];
    }

    public JVolume.LinearVolume[] getVolumes() {
        JVolume.LinearVolume[] _vols = new JVolume.LinearVolume[this.getNumVolumes()];
        _vols[0] = this.j_vol;
        for (int i = 1; i < _vols.length; ++i) {
            _vols[i] = this.aux_j_vols[i - 1];
        }
        return _vols;
    }

    public Object getVolumeData() {
        block4: {
            if (this._voldata != null) break block4;
            int nvols = this.getNumVolumes();
            if (this.j_vol instanceof JVolume.LinearShort) {
                short[][] data = new short[nvols][];
                this._voldata = data;
                data[0] = ((JVolume.LinearShort)this.j_vol).volume;
                for (int i = 1; i < data.length; ++i) {
                    data[i] = ((JVolume.LinearShort)this.aux_j_vols[i - 1]).volume;
                }
            } else {
                byte[][] data = new byte[nvols][];
                this._voldata = data;
                data[0] = ((JVolume.LinearByte)this.j_vol).volume;
                for (int i = 1; i < data.length; ++i) {
                    data[i] = ((JVolume.LinearByte)this.aux_j_vols[i - 1]).volume;
                }
            }
        }
        return this._voldata;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public XjVolumeInfo getVolume() {
        return this.xj_vol;
    }

    public void setData(String dataName, Object value) {
        if (value != null) {
            this.user_data.put(dataName, value);
        } else {
            this.user_data.remove(dataName);
        }
    }

    public Object getData(String dataName) {
        return this.user_data.get(dataName);
    }

    private void calcVox2RAS() {
        XjVolumeUtils.calculateVoxelRASTransform((XjVolumeGeometry)this.xj_vol, this.vox2ras, this.ras2vox);
    }

    public Object clone() {
        VrContext vrc_copy = (VrContext)this.vr_context.clone();
        J3DVolumeModel newjvm = new J3DVolumeModel(this.xj_vol, vrc_copy);
        return newjvm;
    }

    public XjVolumeModel dupvol() {
        VrContext vrc_copy = (VrContext)this.vr_context.clone();
        vrc_copy.vol = (JVolume.LinearShort)this.vr_context.vol.clone();
        J3DVolumeModel newjvm = new J3DVolumeModel(this.xj_vol, vrc_copy);
        return newjvm;
    }

    public void init() {
        try {
            String modality = this.j_vol.modality;
            InputStream is = null;
            is = modality.toUpperCase().equals("PT") ? VrPreset.class.getResourceAsStream("presets/ABDOMEN/pet.vrp") : VrPreset.class.getResourceAsStream("presets/GENERAL/vr_color.vrp");
            VrPreset preset = new VrPreset(is);
            this.init(preset);
        }
        catch (IOException ex) {
            System.err.println("J3DVolumeModel: Cannot open preset stream.");
        }
    }

    public void init(VrPreset preset) {
        this.vr_context.setPreset(preset);
        this.initialized = true;
        System.err.println("-- J3DVolumeModel: Created volume and setup VR preset.");
    }

    public void initMip() {
        this.vr_context.initMip();
    }

    public void rasToVoxels(double[] lookpt, double[] xdir, double[] ydir, double[] zdir) {
        double[] zero_orig = new double[3];
        JnVector4d temp_v = new JnVector4d();
        JnVector4d zero_tx = new JnVector4d();
        temp_v.set(lookpt);
        this.ras2vox.transform(temp_v);
        temp_v.get(lookpt);
        zero_tx.set(zero_orig);
        this.ras2vox.transform(zero_tx);
        temp_v.set(xdir);
        this.ras2vox.transform(temp_v);
        temp_v.sub(zero_tx);
        temp_v.get(xdir);
        temp_v.set(ydir);
        this.ras2vox.transform(temp_v);
        temp_v.sub(zero_tx);
        temp_v.get(ydir);
        temp_v.set(zdir);
        this.ras2vox.transform(temp_v);
        temp_v.sub(zero_tx);
        temp_v.get(zdir);
    }

    public void voxelToRas(double[] voxCoords, double[] rasCoords) {
        JnVector4d temp_v = new JnVector4d();
        temp_v.set(voxCoords);
        this.vox2ras.transform(temp_v);
        temp_v.get(rasCoords);
    }

    public void rasToVoxels(double[] rasCoords, double[] voxCoords) {
        JnVector4d temp_v = new JnVector4d();
        temp_v.set(rasCoords);
        this.ras2vox.transform(temp_v);
        temp_v.get(voxCoords);
    }

    public JnMatrix4d getVoxel2RASTransform() {
        return this.vox2ras;
    }

    public JnMatrix4d getRAS2VoxelTransform() {
        return this.ras2vox;
    }

    public static double trilineard(double v000, double v100, double v010, double v110, double v001, double v101, double v011, double v111, double fx, double fy, double fz) {
        double px1 = v000 + (v100 - v000) * fx;
        double px2 = v010 + (v110 - v010) * fx;
        double py1 = px1 + (px2 - px1) * fy;
        px1 = v001 + (v101 - v001) * fx;
        px2 = v011 + (v111 - v011) * fx;
        double py2 = px1 + (px2 - px1) * fy;
        return py1 + (py2 - py1) * fz;
    }

    public int getVolumeValue(double x, double y, double z) {
        JVolume.LinearShort jls = (JVolume.LinearShort)this.j_vol;
        int ix = (int)x;
        int iy = (int)y;
        int iz = (int)z;
        double fx = x - (double)ix;
        double fy = y - (double)iy;
        double fz = z - (double)iz;
        int dx = this.j_vol.dx;
        int dy = this.j_vol.dy;
        int dz = this.j_vol.dz;
        if (ix >= 0 && ix < dx - 1 && iy >= 0 && iy < dy - 1 && iz >= 0 && iz < dz - 1) {
            short[] d = jls.volume;
            int psize = dx * dy;
            int zoff0 = psize * iz;
            int zoff1 = zoff0 + psize;
            int yoff0 = dx * iy;
            int yoff1 = yoff0 + dx;
            short v0 = d[zoff0 + yoff0 + ix];
            short v1 = d[zoff0 + yoff0 + ix + 1];
            short v2 = d[zoff0 + yoff1 + ix];
            short v3 = d[zoff0 + yoff1 + ix + 1];
            short v4 = d[zoff1 + yoff0 + ix];
            short v5 = d[zoff1 + yoff0 + ix + 1];
            short v6 = d[zoff1 + yoff1 + ix];
            short v7 = d[zoff1 + yoff1 + ix + 1];
            int val = (int)J3DVolumeModel.trilineard(v0, v1, v2, v3, v4, v5, v6, v7, fx, fy, fz);
            return val;
        }
        return 0;
    }

    public int getValues(XpDicomElement[] values) {
        int notLoaded = 0;
        for (int i = 0; i < values.length; ++i) {
            int result = this.getValue(values[i]);
            if (result != 1) continue;
            ++notLoaded;
        }
        return notLoaded;
    }

    public int getValue(XpDicomElement value) {
        Object val = this.xj_vol.getValue(value.group, value.element);
        if (val != null) {
            value.value = val;
            return 0;
        }
        return 1;
    }

    public final void resetBingrid() {
        this.vr_context.resetBingrid();
        this.notifyChangeListeners();
    }

    public final boolean bingridAnd(byte[] bgrid) {
        boolean ret = this.vr_context.bingridAnd(bgrid);
        this.notifyChangeListeners();
        return ret;
    }

    public final boolean bingridOr(byte[] bgrid) {
        boolean ret = this.vr_context.bingridOr(bgrid);
        this.notifyChangeListeners();
        return ret;
    }

    public final boolean bingridNot() {
        boolean ret = this.vr_context.bingridNot();
        this.notifyChangeListeners();
        return ret;
    }

    public void setPreset(VrPreset preset) {
        this.vr_context.setPreset(preset);
        this.notifyChangeListeners();
    }

    public void voxelsChanged() {
        this.vr_context.reset();
        this.pcs.firePropertyChange("VOXELS_PROPERTY", null, this.j_vol);
    }

    public void addChangeListener(ChangeListener cl) {
        if (!this.listeners.contains(cl)) {
            this.listeners.add(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listeners.remove(cl);
    }

    protected void notifyChangeListeners() {
        int len = this.listeners.size();
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = 0; i < len; ++i) {
            ChangeListener cl = (ChangeListener)this.listeners.get(i);
            cl.stateChanged(ce);
        }
    }

    public void putClientProperty(Object key, Object value) {
        if (value == null) {
            this.ht.remove(key);
        } else {
            this.ht.put(key, value);
        }
    }

    public Object getClientProperty(Object key) {
        return this.ht.get(key);
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propName, oldValue, newValue);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(prop, l);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName.equals("IMAGE_LOADED")) {
            int idx = (Integer)evt.getNewValue();
            if (this.initialized) {
                int[] zpos = new int[]{idx};
                this.vr_context.refreshVrContext(zpos, zpos.length);
            }
            this.pcs.firePropertyChange("VOLUME_SLICE", null, new int[]{idx});
        }
    }
}

